//------------------------------------------------------------------------------
//	File:					vector_2d.cp
//	Date:					9/30/96
//	Author:				Bretton Wade
//
//	Description:	this file contains the methods for a 2d vector_3d
//
//------------------------------------------------------------------------------

#include "precompile.h"
#include "point_2d.h"
#include "vector_2d.h"

//------------------------------------------------------------------------------
//	constructor
//------------------------------------------------------------------------------
vector_2d::vector_2d (real x, real y) : tuple_2d (x, y)													//	constructor from 2 values
{																																								//	begin
}																																								//	end

//------------------------------------------------------------------------------
//	constructor
//------------------------------------------------------------------------------
vector_2d::vector_2d (const vector_2d &v) : tuple_2d (v)												//	copy constructor
{																																								//	begin
}																																								//	end

//------------------------------------------------------------------------------
//	constructor
//------------------------------------------------------------------------------
vector_2d::vector_2d (const point_2d &p) : tuple_2d (p)													//	constructor from a point
{																																								//	begin
}																																								//	end

//------------------------------------------------------------------------------
//	assignment operator
//------------------------------------------------------------------------------
vector_2d	&vector_2d::operator = (const vector_2d &v)														//	assignment operator
{																																								//	begin
	tuple_2d::operator = (v);																											//	parental behavior
	return *this;																																	//	return the reference to this
}																																								//	end

//------------------------------------------------------------------------------
//	multiply a vector_3d by a scalar
//------------------------------------------------------------------------------
vector_2d	vector_2d::operator * (real s) const																	//	scalar multiplication
{																																								//	begin
	return vector_2d (xy[X] * s, xy[Y] * s);																			//	multiply the vector components
}																																								//	end

//------------------------------------------------------------------------------
//	divide a vector_3d by a scalar
//------------------------------------------------------------------------------
vector_2d	vector_2d::operator / (real s) const																	//	scalar division
{																																								//	begin
	return vector_2d (xy[X] * s, xy[Y] * s);																			//	divide the vector components
}																																								//	end

//------------------------------------------------------------------------------
//	add two vectors
//------------------------------------------------------------------------------
vector_2d	vector_2d::operator + (const vector_2d &v) const											//	addition operator
{																																								//	begin
	return vector_2d (xy[X] + v[X], xy[Y] + v[Y]);																//	add the vector components
}																																								//	end

//------------------------------------------------------------------------------
//	subtract two vectors
//------------------------------------------------------------------------------
vector_2d	vector_2d::operator - (const vector_2d &v) const											//	subtraction operator
{																																								//	begin
	return vector_2d (xy[X] - v[X], xy[Y] - v[Y]);																//	subtract the vector components
}																																								//	end

//------------------------------------------------------------------------------
//	compute the length of the vector_3d
//------------------------------------------------------------------------------
real			vector_2d::Norm (void) const																					//	compute the length of the vector_2d
{																																								//	begin
	return sqrt ((xy[X] * xy[X]) + (xy[Y] * xy[Y]));															//	Pythagorean theorem
}																																								//	end

//------------------------------------------------------------------------------
//	normalize the vector_3d
//------------------------------------------------------------------------------
vector_2d	&vector_2d::Normalize (void)																					//	reduce the vector_2d to length 1.0
{																																								//	begin
	real	length = Norm ();																												//	compute the vector length
	xy[X] /= length; xy[Y] /= length;																							//	divide the components by the length
	return *this;																																	//	return the reference to this
}																																								//	end

//------------------------------------------------------------------------------
