#ifdef WIN32

#include "wgltrace.h"
#include "dll.h"

extern void printStat();
int APIENTRY wglChoosePixelFormat(HDC dc, const PIXELFORMATDESCRIPTOR *pPfd)
{
  callEntry();
  stat->wgl[API_wglChoosePixelFormat]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglChoosePixelFormat]);

  return ((int (*)(HDC, const PIXELFORMATDESCRIPTOR *))lib->wglFunc[API_wglChoosePixelFormat])(dc, pPfd);
}

int APIENTRY wglDescribePixelFormat(HDC hdc, int ipfd, UINT cjpfd, PIXELFORMATDESCRIPTOR *ppfd)
{
  callEntry();
  stat->wgl[API_wglDescribePixelFormat]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglDescribePixelFormat]);

  return ((int (*)(HDC, int, UINT, PIXELFORMATDESCRIPTOR *))lib->wglFunc[API_wglDescribePixelFormat])(hdc, ipfd, cjpfd, ppfd);
}

int APIENTRY wglGetPixelFormat(HDC hdc)
{
  callEntry();
  stat->wgl[API_wglGetPixelFormat]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetPixelFormat]);

  return ((int (*)(HDC))lib->wglFunc[API_wglGetPixelFormat])(hdc);
}

BOOL APIENTRY wglSetPixelFormat(HDC hdc, int ipfd, const PIXELFORMATDESCRIPTOR *ppfd)
{
  callEntry();
  stat->wgl[API_wglSetPixelFormat]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglSetPixelFormat]);

  return ((BOOL (*)(HDC, int, const PIXELFORMATDESCRIPTOR *))lib->wglFunc[API_wglSetPixelFormat])(hdc, ipfd, ppfd);
}

BOOL APIENTRY wglSwapBuffers(HDC hdc)
{
  BOOL returnValue;
  
  callEntry();
  stat->wgl[API_wglSwapBuffers]++;

  if (file) {
    fprintf(file, "%s\n",wglNames[API_wglSwapBuffers]);
    fflush(file);
  }
  
  // If tracking statistics and refreshing on swapbuffer calls,
  // print the statistics and reset the counters.
  if (stat->doStat && stat->onSwap) {
    //glFlush();??
    printStat();
    statReset();
  }
  
  returnValue = ((BOOL (*)(HDC))lib->wglFunc[API_wglSwapBuffers])(hdc);

  return returnValue;
}

BOOL APIENTRY wglCopyContext(HGLRC hglrcSrc, HGLRC hglrcDst, UINT mask)
{
  callEntry();
  stat->wgl[API_wglCopyContext]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglCopyContext]);

  return ((BOOL (*)(HGLRC, HGLRC, UINT))lib->wglFunc[API_wglCopyContext])(hglrcSrc, hglrcDst, mask);
}

HGLRC APIENTRY wglCreateContext(HDC dc)
{
  callEntry();
  stat->wgl[API_wglCreateContext]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglCreateContext]);

  return ((HGLRC (*)(HDC))lib->wglFunc[API_wglCreateContext])(dc);
}

HGLRC APIENTRY wglCreateLayerContext(HDC dc, int level)
{
  callEntry();
  stat->wgl[API_wglCreateLayerContext]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglCreateLayerContext]);

  return ((HGLRC (*)(HDC, int))lib->wglFunc[API_wglCreateLayerContext])(dc, level);
}

BOOL APIENTRY wglDeleteContext(HGLRC oldContext)
{
  callEntry();
  stat->wgl[API_wglDeleteContext]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglDeleteContext]);

  return ((BOOL (*)(HGLRC))lib->wglFunc[API_wglDeleteContext])(oldContext);
}

BOOL APIENTRY wglDescribeLayerPlane(HDC dc, int pixelFormat, int layerPlane, UINT nBytes, LPLAYERPLANEDESCRIPTOR plpd)
{
  callEntry();
  stat->wgl[API_wglDescribeLayerPlane]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglDescribeLayerPlane]);

  return ((BOOL (*)(HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR))lib->wglFunc[API_wglDescribeLayerPlane])(dc, pixelFormat, layerPlane, nBytes, plpd);
}

HGLRC APIENTRY wglGetCurrentContext(void)
{
  callEntry();
  stat->wgl[API_wglGetCurrentContext]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetCurrentContext]);

  return ((HGLRC (*)(void))lib->wglFunc[API_wglGetCurrentContext])();
}

HDC APIENTRY wglGetCurrentDC(void)
{
  callEntry();
  stat->wgl[API_wglGetCurrentDC]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetCurrentDC]);

  return ((HDC (*)(void))lib->wglFunc[API_wglGetCurrentDC])();
}

PROC APIENTRY wglGetDefaultProcAddress(LPCSTR lpszProc)
{
  callEntry();
  stat->wgl[API_wglGetDefaultProcAddress]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetDefaultProcAddress]);

  return ((PROC (*)(LPCSTR))lib->wglFunc[API_wglGetDefaultProcAddress])(lpszProc);
}

int APIENTRY wglGetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, COLORREF *pcr)
{
  callEntry();
  stat->wgl[API_wglGetLayerPaletteEntries]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetLayerPaletteEntries]);

  return ((int (*)(HDC, int, int, int, COLORREF *))lib->wglFunc[API_wglGetLayerPaletteEntries])(hdc, iLayerPlane, iStart, cEntries, pcr);
}

PROC APIENTRY wglGetProcAddress(LPCSTR lpszProc)
{
  callEntry();
  stat->wgl[API_wglGetProcAddress]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglGetProcAddress]);

  return ((PROC (*)(LPCSTR))lib->wglFunc[API_wglGetProcAddress])(lpszProc);
}

BOOL APIENTRY wglMakeCurrent(HDC dc, HGLRC newContext)
{
  BOOL result;
  callEntry();
  stat->wgl[API_wglMakeCurrent]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglMakeCurrent]);

  result = ((BOOL (*)(HDC, HGLRC))lib->wglFunc[API_wglMakeCurrent])(dc, newContext);

  return result;
}

BOOL APIENTRY wglRealizeLayerPalette(HDC hdc, int iLayerPlane, BOOL bRealize)
{
  callEntry();
  stat->wgl[API_wglRealizeLayerPalette]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglRealizeLayerPalette]);

  return ((BOOL (*)(HDC, int, BOOL))lib->wglFunc[API_wglRealizeLayerPalette])(hdc, iLayerPlane, bRealize);
}

int APIENTRY wglSetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, const COLORREF *pcr)
{
  callEntry();
  stat->wgl[API_wglSetLayerPaletteEntries]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglSetLayerPaletteEntries]);

  return ((int (*)(HDC, int, int, int, const COLORREF *))lib->wglFunc[API_wglSetLayerPaletteEntries])(hdc, iLayerPlane, iStart, cEntries, pcr);
}

BOOL APIENTRY wglShareLists(HGLRC hrcSrvShare, HGLRC hrcSrvSource)
{
  callEntry();
  stat->wgl[API_wglShareLists]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglShareLists]);

  return ((BOOL (*)(HGLRC, HGLRC))lib->wglFunc[API_wglShareLists])(hrcSrvShare, hrcSrvSource);
}

BOOL APIENTRY wglSwapLayerBuffers(HDC hdc, UINT fuFlags)
{
  callEntry();
  stat->wgl[API_wglSwapLayerBuffers]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglSwapLayerBuffers]);

  return ((BOOL (*)(HDC, UINT))lib->wglFunc[API_wglSwapLayerBuffers])(hdc, fuFlags);
}

BOOL APIENTRY wglUseFontBitmapsA(HDC hDC, DWORD first, DWORD count, DWORD listBase)
{
  callEntry();
  stat->wgl[API_wglUseFontBitmapsA]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglUseFontBitmapsA]);

  return ((BOOL (*)(HDC, DWORD, DWORD, DWORD))lib->wglFunc[API_wglUseFontBitmapsA])(hDC, first, count, listBase);
}

BOOL APIENTRY wglUseFontBitmapsW(HDC hDC, DWORD first, DWORD count, DWORD listBase)
{
  callEntry();
  stat->wgl[API_wglUseFontBitmapsW]++;

  if (file)
    fprintf(file, "%s\n",wglNames[API_wglUseFontBitmapsW]);

  return ((BOOL (*)(HDC, DWORD, DWORD, DWORD))lib->wglFunc[API_wglUseFontBitmapsW])(hDC, first, count, listBase);
}

#endif
