#ifdef WIN32
#include <windows.h>
#endif
#include <GL/gl.h>
#include "ogldebug.h"
#include "total.h"
#include <stdio.h>
#include "state.h"
#include "dll.h"

void printRecord()
{
static int frame = 0;
	int i;

	for (i=0;i<TOTAL_PRIM;i++)
	{
			fprintf(recordStati, "frame %d %s; count %d\tmax %d\tBeginEnd %d\n",frame, primNames[i], stat->Primit.count[i], stat->Primit.maxi[i], stat->Primit.beCount[i]);
	}
    frame++;
}

void printState()
{
	int i;

	printf("Enable/Disable: %d/%d\n",stat->Enable[0], stat->Disable[0]);
	for (i=1;i<TOTAL_STATE;i++)
	{
		if (stat->Enable[i] || stat->Disable[i])
		{
			printf("E/D %s : %d/%d\n",stateNames[i-1], stat->Enable[i] ,stat->Disable[i]);
		}
	}
	for (i=0;i<TOTAL_GL;i++)
	{
		if (stat->gl[i])
		{
			printf("%s %d\n", glNames[i], stat->gl[i]);
		}
	}

}

void printMat()
{
	int i;

	for (i=0;i<TOTAL_MAT;i++)
	{
			printf("%s : back:%d\tfront:%d\tf&b:%d\n",matNames[i-1], stat->Material[i][0], stat->Material[i][1],stat->Material[i][2]);
	}

}

void printPrim()
{
	int i;

	for (i=0;i<TOTAL_PRIM;i++)
	{
		if (stat->Primit.beCount[i])
		{
			printf("%s; count %d\tmax %d\tBeginEnd %d\tave %f\n",primNames[i], stat->Primit.count[i], stat->Primit.maxi[i], stat->Primit.beCount[i],(float)stat->Primit.count[i]/(float)stat->Primit.beCount[i]);
		}
	}
}

void printStat()
{
	if (stat->printMat)
		printMat();
	if (stat->printState)
		printState();
	if (stat->printPrim)
		printPrim();
	if (recordStati)
		printRecord();
}

char *stateClear(char *tmp, GLbitfield mask)
{
	tmp[0] = '\x0';
	if (mask & GL_COLOR_BUFFER_BIT)
		strcat(tmp, "GL_COLOR_BUFFER_BIT ");
	if (mask & GL_DEPTH_BUFFER_BIT)
		strcat(tmp, "GL_DEPTH_BUFFER_BIT ");
	if (mask & GL_ACCUM_BUFFER_BIT)
		strcat(tmp, "GL_ACCUM_BUFFER_BIT ");
	if (mask & GL_STENCIL_BUFFER_BIT)
		strcat(tmp, "GL_STENCIL_BUFFER_BIT");
	return tmp;
}

void primBegin(int mode)
{
		switch (mode)
	{
	case GL_POINTS :
		beginEnd = 0;
		break;
	case GL_LINES :
		beginEnd = 1;
		break;
	case GL_LINE_STRIP:
		beginEnd = 2;
		break;
	case GL_LINE_LOOP:
		beginEnd = 3;
		break;
	case GL_TRIANGLES:
		beginEnd = 4;
		break;
	case GL_TRIANGLE_STRIP:
		beginEnd = 5;
		break;
	case GL_TRIANGLE_FAN:
		beginEnd = 6;
		break;
	case GL_QUADS:
		beginEnd = 7;
		break;
	case GL_QUAD_STRIP:
		beginEnd = 8;
		break;
	case GL_POLYGON:
		beginEnd = 9;
		break;
	}
	stat->Primit.vertexCount = 0;
}

void primEnd()
{
	if (stat->Primit.vertexCount > stat->Primit.maxi[beginEnd])
		stat->Primit.maxi[beginEnd] = stat->Primit.vertexCount;
	stat->Primit.count[beginEnd] += 	stat->Primit.vertexCount;
	stat->Primit.beCount[beginEnd]++;
	stat->Primit.vertexCount = 0;
}

char *stateBegin (int mode)
{
	return primNames[mode];
}

char *stateColorMaterial (char *tmp, GLenum face, GLenum mode)
{
	int f;
	tmp[0] = '\x0';
	switch (face)
	{
	case GL_BACK :
		f = BACK;
		strcat(tmp,"GL_BACK ");
		break;
	case GL_FRONT :
		f = FRONT;
		strcat(tmp,"GL_FRONT ");
		break;
	case GL_FRONT_AND_BACK:
		f = FRONT_AND_BACK;
		strcat(tmp,"GL_FRONT_AND_BACK ");
		break;
	}
	stat->Material[count_mat][f]++;
	switch (mode)
	{
	case  GL_AMBIENT_AND_DIFFUSE:
		stat->Material[AMBIENT_AND_DIFFUSE][f]++;
		strcat(tmp,"GL_AMBIENT_AND_DIFFUSE");
		break;
	case GL_SPECULAR:
		stat->Material[SPECULAR][f]++;
		strcat(tmp,"GL_SPECULAR");
		break;
	case  GL_DIFFUSE:
		stat->Material[DIFFUSE][f]++;
		strcat(tmp,"GL_DIFFUSE");
		break;
	case  GL_AMBIENT:
		stat->Material[AMBIENT][f]++;
		strcat(tmp,"GL_AMBIENT");
		break;
	case GL_EMISSION :
		stat->Material[EMISSION][f]++;
		strcat(tmp,"GL_EMISSION");
		break;
	}
	return tmp;
}
char *stateCullFace (GLenum mode)
{
	switch (mode)
	{
	case GL_FRONT :
		return "GL_FRONT ";
		break;
	case GL_BACK :
		return "GL_BACK ";
		break;
	case GL_FRONT_AND_BACK:
		return "GL_FRONT_AND_BACK ";
		break;
	}
}
char *stateAble (GLenum cap, int *ed)
{
	ed[count_state]++;
	switch (cap)
	{
	case GL_ALPHA_TEST :
		ed[ALPHA_TEST]++;
		return "GL_ALPHA_TEST";
		break;
	case  GL_BLEND:
		ed[BLEND]++;
		return "GL_BLEND";
		break;
	case  GL_COLOR_MATERIAL:
		ed[COLOR_MATERIAL]++;
		return "GL_COLOR_MATERIAL";
		break;
	case  GL_CULL_FACE:
		ed[CULL_FACE]++;
		return "GL_CULL_FACE";
		break;
	case  GL_DEPTH_TEST:
		ed[DEPTH_TEST]++;
		return "GL_DEPTH_TEST";
		break;
	case  GL_DITHER:
		ed[DITHER]++;
		return "GL_DITHER";
		break;
	case  GL_FOG:
		ed[FOG]++;
		return "GL_FOG";
		break;
	case GL_LIGHT0 :
		ed[LIGHT0]++;
		return "GL_LIGHT0";
		break;
	case  GL_LIGHT1:
		ed[LIGHT1]++;
		return "GL_LIGHT1";
		break;
	case  GL_LIGHTING:
		ed[LIGHTING]++;
		return "GL_LIGHTING";
		break;
	case  GL_LINE_SMOOTH:
		ed[LINE_SMOOTH]++;
		return "GL_LINE_SMOOTH";
		break;
	case  GL_LINE_STIPPLE:
		ed[LINE_STIPPLE]++;
		return "GL_LINE_STIPPLE";
		break;
	case  GL_NORMALIZE:
		ed[NORMALIZE]++;
		return "GL_NORMALIZE";
		break;
	case  GL_POINT_SMOOTH:
		ed[POINT_SMOOTH]++;
		return "GL_POINT_SMOOTH";
		break;
	case  GL_POLYGON_STIPPLE:
		ed[POLYGON_STIPPLE]++;
		return "GL_POLYGON_STIPPLE";
		break;
	case GL_STENCIL_TEST :
		ed[STENCIL_TEST]++;
		return "GL_STENCIL_TEST";
		break;
	default:
		ed[UNKNOWN]++;
		return "";
	}
}
char *stateFrontFace (GLenum mode)
{
 	switch (mode)
	{
	case GL_CCW :
		return "GL_CCW ";
		break;
	case GL_CW :
		return "GL_CW ";
		break;
	}
}
char *stateHint (char *tmp, GLenum target, GLenum mode)
{
	tmp[0] = '\x0';
	switch (target)
	{
	case  GL_FOG_HINT:
		strcat(tmp,"GL_FOG_HINT ");
		break;
	case  GL_LINE_SMOOTH_HINT:
		strcat(tmp,"GL_LINE_SMOOTH_HINT ");
		break;
	case GL_PERSPECTIVE_CORRECTION_HINT:
		strcat(tmp,"GL_PERSPECTIVE_CORRECTION_HINT ");
		break;
	case  GL_POINT_SMOOTH_HINT:
		strcat(tmp,"GL_POINT_SMOOTH_HINT ");
		break;
	case  GL_POLYGON_SMOOTH_HINT:
		strcat(tmp,"GL_POLYGON_SMOOTH_HINT ");
		break;
#if 0
	case GL_CLIP_VOLUME_CLIPPING_HINT_EXT:
		strcat(tmp,"GL_CLIP_VOLUME_CLIPPING_HINT_EXT ");
		break;
#endif
	}
	switch (mode)
	{
	case  GL_FASTEST:
		strcat(tmp,"GL_FASTEST");
		break;
	case GL_NICEST:
		strcat(tmp,"GL_NICEST");
		break;
	case GL_DONT_CARE: 
		strcat(tmp,"GL_DONT_CARE");
		break;
	}
	return tmp;
}
char *stateShadeModel (GLenum mode)
{
	if (mode == GL_FLAT)
		return "GL_FLAT";
	else
		return "GL_SMOOTH";
}


