#ifndef __main_h_
#define __main_h_

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "oglstub.h"
#ifdef WIN32
#include <io.h>
#include <fcntl.h>
#include "wglstub.h"
#else
#include <dlfcn.h>
#include "xglstub.h"
#endif

#include "total.h"

#ifdef WIN32
#define DllExport    __declspec( dllexport )
#else
#define DllExport
#endif

#define IO_BUF_SIZE 255

typedef struct LIB_REC {

#ifdef WIN32
    HMODULE glDLL;
    /*
    ** Function pointers to real calls.
    */
    FARPROC glFunc[TOTAL_GL];
    FARPROC wglFunc[TOTAL_WGL];
#else
    void *glDLL;
	void *glCore;

	void *glFunc[TOTAL_GL];
	void *xglFunc[TOTAL_XGL];
#endif
} LIB_REC;

extern void callEntry();
extern void env();
extern struct LIB_REC *lib;
#endif /* __main_h_ */ 
