#include "dll.h"

struct LIB_REC *lib = NULL;

#ifdef linux
extern "C"
void DllMain();

class forceInit {
public:
  forceInit() { DllMain(); }
  ~forceInit() {}
};

static forceInit a;
#endif

//
// Malloc() - Encapsulate differences in malloc between Win32 and Unix.
//
void *Malloc(size_t size)
{
#ifdef WIN32
  return HeapAlloc(GetProcessHeap(), 0, size);
#else 
  return (void*)malloc(size);
#endif 
}

//
// env() - Initialize space for LIB_REC structure.
//
void env()
{
  lib = (LIB_REC *)Malloc(sizeof(LIB_REC));
  lib->glDLL = NULL;
}

#ifndef WIN32
//
// getSymbol() - Helper function for loading OpenGL and GLX
//               function pointers in the case of UNIX.  First
//               look for function in glDLL, then if not 
//               look in glCore DSO.  In the case of linux,
//               all symbols are in libGL.so.
//
void* getSymbol( char*name )
{
  void *p;
    
  p = dlsym( lib->glDLL, name );
  if(!p) {
#ifndef linux
    p = dlsym( lib->glCore, name );
#endif
    if(!p) {
      printf("symbol %s not found\n", name);
      return NULL;
    }
  }
  return p;
}
#endif

//
// callEntry() - Initialize arrays for function pointers to OpenGL
//               WGL and GLX calls by opening the appropriate 
//               shared libraries and get the addresses for each
//               entry point function.
//
void callEntry()
{
  int i;
#ifdef WIN32
  char buf[IO_BUF_SIZE];

  // Win32 case.  Build path to OpenGL DLL, then load it
  // to get a handle to use with GetProcAddress function.
  if (lib->glDLL == NULL) {
    GetSystemDirectory(buf, IO_BUF_SIZE);
    strcat(buf, "\\opengl32.dll");
    if ((lib->glDLL = LoadLibrary(buf)) == NULL) {
      fprintf(stderr, "can t load %s\n",buf);
      exit(EXIT_FAILURE);
    }

    // Initialize function pointers for each OpenGL function. 
    for (i = 0; i < TOTAL_GL; i++) {
      lib->glFunc[i] = GetProcAddress(lib->glDLL, glNames[i]);
    }

    // Initialize function pointers for each WGL function.
    for (i = 0; i < TOTAL_WGL; i++) {
      if ((lib->wglFunc[i] = GetProcAddress(lib->glDLL,
					    wglNames[i])) == NULL) {
	exit(EXIT_FAILURE);
      }
    }
  }
#else
  
  // Unix case.  OpenGL and GLX calls can be in one of two
  // different DSOs.  Load libGL.so and libGLcore.so and
  // and keep a pointer to each.  In the case of linux,
  // there is no libGLcore.so.
  if (lib->glDLL == NULL) {
    lib->glDLL   = dlopen("libGL.so",RTLD_LAZY);
    if (lib->glDLL == NULL ) {
      printf("Error cannot load libGL.so \n");
      exit(EXIT_FAILURE);
    }
#ifndef linux
    lib->glCore   = dlopen("libGLcore.so",RTLD_LAZY);
    if (lib->glCore == NULL ) {
      printf("Error cannot load libGLcore.so \n");
      exit(EXIT_FAILURE);
    }
#endif
  }

  // Initialize function pointers for each OpenGL function.
  for (i = 0; i < TOTAL_GL; i++) {
    lib->glFunc[i] = getSymbol(glNames[i]);
  }

  // Initialize function pointers for each GLX function.	
  for (i = 0; i < TOTAL_XGL; i++) {
    lib->xglFunc[i] = getSymbol(xglNames[i]);
  }
#endif
}

//
// DllMain() - DLL/DSO entry point function.
//
#ifdef WIN32
BOOL APIENTRY DllMain(HMODULE hModule, ULONG reason, LPVOID reserved)
{
  // Win32 case.
  //
  // At DLL_PROCESS_ATTACH, query environment variables and
  // initialize memory.  Setup array of function pointers for
  // OpenGL and WGL function calls.
  switch (reason) {
  case DLL_PROCESS_ATTACH:
    env();
    break;

  case DLL_THREAD_ATTACH:
    break;

  case DLL_PROCESS_DETACH:
    break;

  case DLL_THREAD_DETACH:
    break;
  }
  return TRUE;
}
#else
extern "C"
void DllMain(void)
{
  // UNIX case.
  //
  // Query environment and initialize memory.  Setup array of
  // function pointers for OpenGL and GLX API calls.
  fprintf(stderr,"Inside DllMain\n");
  env();
  callEntry();
}
#endif

