#ifndef __timeit_h__
#define __timeit_h__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef WIN32
#include <windows.h>
#else
#include <sys/time.h>
#include <unistd.h>
#include <malloc.h>
#endif

//
// timeobj - Timer object structure.
//
#ifdef WIN32
typedef struct timeobj
{
  __int64 start;
  __int64 stop;
} timeobj;
#else
typedef struct timeobj
{
  struct timeval start;
  struct timeval stop;

} timeobj;
#endif

//
// timeit_token - Enum to indicates seconds or microseconds.
// 
typedef enum timeit_token
{
  timeit_seconds = 0,
  timeit_useconds

} timeit_token;

// 
// Function declarations.
//
timeobj *   timeit_new();
void        timeit_delete( timeobj * );

void        timeit_start( timeobj * );
void        timeit_stop( timeobj * );

int         timeit_geti( const timeobj *, const timeit_token );
float       timeit_getf( const timeobj *, const timeit_token );

#ifdef __cplusplus
} /* end extern "C" */
#endif /* __cplusplus */

#endif /* __timeit_h__ */
