#include <iostream.h>

#include <unistd.h>
#include <stdlib.h>
#include <timeit.h>

const int arraysize = 8;
const int kilobyte = 1024;
const int megabyte = kilobyte * kilobyte;

typedef struct foo
{
  int id;
  float unused[ arraysize ];
} foo;

void main( void )
{

  long pagesize = sysconf( _SC_PAGESIZE );
  int  intsize  = sizeof( int );
  int  npageints = pagesize/intsize;

  const long npages = 8 * megabyte / pagesize;
  const int ntimes = 10000;
  timeobj *tt = timeit_new();
  int ii, jj;

  /* fill up a bunch of pages */
  int **data = (int**) malloc( npages*sizeof( int * ) );
  for ( ii=0; ii<npages; ii++ )
    {
      data[ ii ] = (int *) malloc( npageints );
    }

  /* time data access across lots of pages */
  timeit_start( tt );
  for( jj=0; jj<ntimes; jj++ )
    {
      for ( ii=0; ii<npages; ii++ )
	{
	  data[ ii ][ 0 ] = random();
	}
    }
  timeit_stop( tt );
  cerr << "data access time: "
    << timeit_getf( tt, timeit_seconds )
    << "s" << endl;

  /* now access data on same page */
  timeit_start( tt );
  for( jj=0; jj<ntimes; jj++ )
    {
      for ( ii=0; ii<npages; ii++ )
	{
	  data[ 0 ][ 0 ] = random();
	}
    }
  timeit_stop( tt );
  cerr << "data access time: "
    << timeit_getf( tt, timeit_seconds )
    << "s" << endl;

  timeit_delete( tt );
}
