{                
 This file contains procedures :

  - Vpoke(Address,Byte);
  - WrtVdp(Register,Byte);
  - Blink(Column,Row,BlinkLen:Byte);
  - ClearBlink(Column,Row,BlinkLen:Byte);
  - ClearAllBlinks;
  - SetBlinkRate(OnTime,OffTime:Byte); Time values 0 - 15
  - SetBlinkColors(ForeGroundColor,BackGroundColor:Byte);

  and function

  - Vpeek(Address):Byte;

   Kari Lammassaari lammassa@on-line.midnight.fi
}

Const Vdp14 = 13; {Blink rate register in vdp}
      Vdp13 = 12; {Blink colors High nibble = foreground}
      ColorTable = 2048; {addr to blink table in VRAM}
      White = 15;
      Grey  = 14;
      Purple  = 13;
      DGreen  = 12;
      LYellow = 11;
      DYellow = 10;
      LRed    = 9;
      Mred    = 8;
      Cyan    = 7;
      DRed    = 6;
      LBlue   = 5;
      DBlue   = 4;
      LGreen  = 3;
      MGreen  = 2;
      Black   = 1;
      Transp  = 0;

      SetB    = True;   {Needed for the operation of Blink and ClearBlink}
      ReSetB  = False;

Procedure Vpoke(Addr,Value:Integer);

Const CalSlt = $001c;
      WrtVrm = $004d;
      ExpTbl = $fcc1;

Begin
    Inline(
           $f3/              {Di}
           $2a/Addr/         {ld hl,(addr)}
           $3a/Value/        {ld a,(value)}
           $fd/$21/$c0/$fc/  {ld iy,(exptbl-1)}
           $dd/$21/$4d/00/   {ld ix,wrtvrm}
           $cd/$1c/00        {call calslt}
           );
End;

Function Vpeek(Addr:Integer):Byte;

Const CalSlt = $001c;
      RdVrm  = $004a;
      ExpTbl = $fcc1;

Var   Value    :Byte;

Begin
    Inline(
           $f3/              {Di}
           $2a/Addr/         {ld hl,(addr)}
           $fd/$21/$c0/$fc/  {ld iy,(exptbl-1)}
           $dd/$21/$4a/00/   {ld ix,rdvrm}
           $cd/$1c/00/       {call calslt}
           $32/Value         {Return value}
           );
    VPeek := Value;
End;

Procedure WrtVdp(Port,Value:Byte);

Begin
   Inline ($F3/$3A/ Value  /$D3/$99/$3A/ Port /$F6/$80/$D3/$99 );
End;

Procedure SetBlinkRate(OnTime,OffTime:Byte);

Begin
     WrtVdp(Vdp14,OnTime*16+OffTime);
End;

Procedure SetBlinkColors(ForegroundColor,BackGroundColor:Byte);

Begin
     WrtVdp(Vdp13,ForegroundColor*16+BackgroundColor);
End;

Procedure SetBit(VramAddr:Integer;Bit:Byte;Operation:Boolean);

Var Byt,i:Byte;
    Mask :Byte;

Begin
     Byt := VPeek(VramAddr);
     If Operation = True Then Mask := 128 Else Mask := 127;

     For i := 1 to Bit Do
        Inline (
                $3A/Mask/ {LD A,(Mask)}
                $0f/     {RRCA}
                $32/Mask  {LD (Mask,A}
               );


     If Operation = True Then Byt := Byt OR Mask Else Byt := Byt AND Mask;
     Vpoke(VramAddr,Byt);

End; {SetBit}

Procedure BlinkChar(Col,Row:Byte;Operation:Boolean);

Var Addr   :Integer;
    Bit    :Byte;

Begin
    Addr := 2048 + ((row-1) * 80 + Col-1) Div 8;
    Bit  := ((Row-1) * 80 + Col-1) Mod 8;
    SetBit(Addr,Bit,Operation);

End; {BlinkChar}

Procedure Blink(Col,Row,Len:Byte);

Var i,c,r :Byte;

Begin
    c := Col;
    r := Row;
    For i:= 1 to Len Do
     Begin
         BlinkChar(c,r,SetB);
         c := c+1;
         If c > 80 Then Begin c := 1; r := r+1;End;
     End;

End; {Blink}

Procedure ClearBlink(Col,Row,Len:Byte);

Var i,c,r :Byte;

Begin
    c := Col;
    r := Row;
    For i:= 1 to Len Do
     Begin
         BlinkChar(c,r,ReSetB);
         c := c+1;
         If c > 80 Then Begin c := 1; r := r+1;End;
     End;

End; {ClearBlink}

Procedure ClearAllBlinks;

Var addr :Integer;

Begin
    For Addr := 2048 To 2048 + 239 Do Vpoke(Addr,0);

End; {ClearAllBlinks}
