;SPECTRAVIDEO CPM V2.2 BOOT SECTOR DISASSEMBLY         Jun 9 2002
;Disassembed and commented by Luis C. Grosso
;3.5" SS DD 80 tracks 9 sectors/track 512 bytes/sector

        ORG    0C000H

        ;crash the system if tried to boot from a PC
LC000:  DEFB    0EBH,0FEH       ;JP LC000 in 8086 asm
        DEFB    90H             ;NOP      in 8086 asm

        DEFB    'ASC  2.2'      ;OEM ID

        DEFB    00H,00H,00H,00H
        DEFB    00H,00H,00H,00H
        DEFB    00H,00H,00H,00H
        DEFB    00H,00H,00H,00H
        DEFB    00H,00H,00H

LC01E:  RET     NC

        ;move this code down to 8000
        LD      HL,LC038X               ;source address
        LD      DE,L8000                ;destination address
        LD      BC,LC059+3-LC038        ;24 hex bytes
        LDIR

        ;define the  and  spanish characters
        LD      HL,LC074        ;table with definition data
        LD      DE,LC084        ;pointer to table with chr def addr in vram
        LD      C,02H           ;two chr to define
        CALL    LC05C           ;define chrs
        JP      L8000           ;continue at 8000H
LC038X  EQU $
        LOC     8000H
        ;load the CPM bios (16 sectors from drive 0 to address 9000, starting
        ;from sector 1)
LC038:  DI
        LD      DE,L9000        ;address to load data
        LD      C,1AH           ;set the transfer address
        CALL    LF37D           ;BDOS
        LD      DE,0001H        ;start at sector 1
        LD      H,10H           ;16 sectors
        LD      L,00H           ;drive 0
        LD      C,2FH           ;load sectors
        CALL    LF37D           ;MSX BDOS

        ;move the data recently loaded to 0E200H and jump to it
        DI                      ;no ints allowed
        LD      HL,L9000        ;start of loaded data
        LD      DE,LE200        ;CPM BIOS address
        LD      BC,L1DD0        ;BIOS length
        LDIR                    ;move the block
LC059:  JP      LE200           ;jump to bios cold start
        ENDLOC

        ;transfer chr definitions from data table to VRAM
LC05C:  LD      A,(DE)          ;get vram lo address byte
        INC     DE              ;increment pointer
        OUT     (99H),A         ;out it to VDP
        LD      A,(DE)          ;get vram hi address byte
        INC     DE              ;increment pointer
        ADD     A,40H           ;set bit 6 (write flag)
        OUT     (99H),A         ;out it to VDP
        LD      B,08H           ;8 bytes each chr definition
LC068:  LD      A,(HL)          ;get byte from data table
        INC     HL              ;increment pointer
        NOP                     ;little
        NOP                     ;time delay
        OUT     (98H),A         ;out to vdp data port
        DJNZ    LC068           ;process next byte
        DEC     C               ;decrement chr counter
        JR      NZ,LC05C        ;jump if more chars to define
        RET                     ;ret

        ;character definition data table
        ;lowercase 
LC074:  DEFB    50H                ;01010000
        DEFB    0A0H               ;10100000
        DEFB    00H                ;00000000
        DEFB    0A0H               ;10100000
        DEFB    0D0H               ;11010000
        DEFB    90H                ;10010000
        DEFB    90H                ;10010000
        DEFB    00H                ;00000000

        ;uppercase 
LC07C:  DEFB    28H                ;00101000
        DEFB    50H                ;01010000
        DEFB    00H                ;00000000
        DEFB    0C8H               ;11001000
        DEFB    0A8H               ;10101000
        DEFB    98H                ;10011000
        DEFB    88H                ;10001000
        DEFB    00H                ;00000000

        ;character definition address table
LC084:  DEFW    0B00H              ; in VRAM
LC086:  DEFW    0BF0H              ; in VRAM

L8000   EQU     8000H
L9000   EQU     9000H
LE200   EQU     0E200H
LF37D   EQU     0F37DH
L1DD0   EQU     1DD0H
LC088   DEFS    375
LC1FF   NOP
        END
