program SplitLongFile;

{    Split long files so that FILECOPY program does
     not destroy them when transferring from MSX-DOS
     to CP/M and vice versa on Spectravideo SVI-738

     H.J.C. Otten april 1987

     Pseudo code

     Open input file
     blockcount := size(infile);
     reset file
     open outfile A
     copy blockcount div 2 blocks from input to outfile A
     close outfile A
     open outfile B
     copy remaining blocks from infile to outfile B
     close outfile B
     close input file

   INSTRUCTIONS
   1.  Compile and run the program using the TURBO.COM compiler.
   2.  Run the program
       This will produce a file A.DAT and B.DAT
       that can be combined again with COMBINE program
}

Const

      recordsize = 128 ;
      buffersize = 100;

Type
      SFileName  = String[14];

Var
      infilename,
      Afilename,
      Bfilename   : SFileName;
      infile,
      Afile,
      Bfile       : file ;
      blockcount  : integer ;
      buffer      : array[1..recordsize,1..buffersize] of Byte;

  Function Open(name: SFilename): boolean;
  begin
    Assign(infile,Name);
    {$I-}
    reset(infile);
    {$I+}
    If IOresult <> 0 then
     begin
      Open := False;
      close(infile);
     end
    else
      Open := True;
  end { Open };

  Procedure OpenInfile;
  begin
    If ParamCount = 0 then
    begin
      Write('Enter filename: ');
      readln(infilename);
    end
    else
    begin
      infilename := ParamStr(1);
    end;
    If Not Open(Infilename) Then
    begin
      Writeln('ERROR -- File not found:  ',infilename);
      Halt;
    end;
  end {Open infile};

procedure OpenA;

  begin

    assign(Afile,'A.DAT');
    {$I-}
    erase(Afile);
    if IOresult = 0
      then
        writeln('First part processed');
    rewrite(Afile);
    {$I+}
    if IOresult <> 0
      then
        begin
          writeln('Fatal error on A outputfile');
          Halt;
        end ;
  end;

procedure OpenB;

  begin

    assign(Bfile,'B.DAT');
    {$I-}
    erase(Bfile);
    if IOresult = 0
      then
        writeln('Second part processed');
    rewrite(Bfile);
    {$I+}
    if IOresult <> 0
      then
        begin
          writeln('Fatal error on B outputfile');
          Halt;
        end ;
  end;

procedure CopyToA ;

  var

    recordcount,
    recordsread  : integer ;

  begin

    recordcount := blockcount div 2 ;
    blockcount := blockcount - recordcount ;
    while recordcount > buffersize do
      begin
        blockread(infile,buffer,buffersize,recordsread);
        blockwrite(Afile,buffer,recordsread);
        recordcount := recordcount - recordsread
      end;
    if recordcount > 0
      then
        begin
          blockread(infile,buffer,recordcount,recordsread);
          blockwrite(Afile,buffer,recordsread);
        end;
  end; { CopyToA }

procedure CopyToB ;

  var

    recordsread  : integer ;

  begin

    while blockcount > 0 do
      begin
        blockread(infile,buffer,buffersize,recordsread);
        blockwrite(Bfile,buffer,recordsread);
        blockcount := blockcount - recordsread
      end;

  end; { CopyToB }

BEGIN
  OpenInfile;
  blockcount := FileSize(infile);
  writeln('File is ',blockcount:4, ' records in size');
  OpenA ;
  CopyToA;
  OpenB ;
  CopyToB ;
  close(infile);
  close(Afile);
  close(Bfile);
  writeln('File split to A.DAT and B.DAT');
END.
