program CombineShortFiles;

{    Combine short files after FILECOPY program has transferred
     them from MSX-DOS to CP/M and vice versa on Spectravideo SVI-738
     To be used with SPLIT to split long files in short files

     H.J.C. Otten april 1987

     Pseudo code

     Open output file
     open infile A
     copy all blocks from A to outfile
     close infile A
     open infile B
     copy all blocks from B to outfile
     close infile B
     close outfile

   INSTRUCTIONS
   1.  Compile and run the program using the TURBO.COM compiler.
   2.  Run the program
       This will require  a file A.DAT and B.DAT
       that are to be combined again with COMBINE program
}

Const

      recordsize = 128 ;
      buffersize = 100;

Type
      SFileName  = String[14];

Var
      outfilename,
      Afilename,
      Bfilename   : SFileName;
      outfile,
      Afile,
      Bfile       : file ;
      blockcount  : integer ;
      buffer      : array[1..recordsize,1..buffersize] of Byte;

  Procedure OpenOutfile;

  var

    YesOrNo : char ;

  begin
    If ParamCount = 0 then
      begin
        Write('Enter filename: ');
        readln(outfilename);
      end
    else
      begin
        outfilename := ParamStr(1);
      end;
    Assign(outfile,outfilename);
    {$I-}
    reset(outfile);
    {$I+}
    if IOresult = 0
      then
        begin
          write('Output file exists, overwrite? ');
          readln(YesOrNo) ;
          if (YesOrNo = 'Y') or (YesOrNo = 'y')
            then
              begin
                close(outfile);
                erase(outfile);
                rewrite(outfile);
              end
            else
              halt ;
        end
      else
        begin
          close(outfile);
          rewrite(outfile)
        end

  end {Open outfile};

procedure OpenA;

  begin

    assign(Afile,'A.DAT');
    {$I-}
    reset(Afile);
    {$I+}
    if IOresult <> 0
      then
        begin
          writeln('File A.DAT missing');
          Halt;
        end ;
  end;

procedure OpenB;

  begin

    assign(Bfile,'B.DAT');
    {$I-}
    reset(Bfile);
    {$I+}
    if IOresult <> 0
      then
        begin
          writeln('File B.DAT missing');
          Halt;
        end ;
  end;

procedure CopyFromA ;

  var

    recordsread  : integer ;

  begin

    repeat
      blockread(Afile,buffer,buffersize,recordsread);
      blockwrite(outfile,buffer,recordsread);
    until recordsread = 0;
    writeln('First part processed');
  end ; { CopyFromA }

procedure CopyFromB ;

  var

    recordsread  : integer ;

  begin

    repeat
      blockread(Bfile,buffer,buffersize,recordsread);
      blockwrite(outfile,buffer,recordsread);
    until recordsread = 0;
    writeln('Second part processed');

  end ; { CopyFromB }

BEGIN
  writeln('Combine started');
  OpenOutfile;
  OpenA ;
  CopyFromA;
  close(Afile);
  OpenB ;
  CopyfromB;
  close(outfile);
  close(Bfile);
  writeln('File combined from A.DAT and B.DAT to ',outfilename);
END.
