{
   XDOS2.INC
}

type
  FileRecord = RECORD
    Name   : Filename;
    Attr   : byte;
    Size   : real;
    Date   : DateStr;
    Time   : TimeStr;
    Nr	   : byte;
    Mark   : char;
    Icon   : string[2];
    end;
  string2  = string[2];
  VNameStr = String[11];

const
  C_Left = #29; C_Right= #28;
  C_Up	 = #30; C_Down = #31;
  BinIcon = #240#241;
  DirIcon = #242#243;
  ComIcon = #244#245;
  FileIcon= #246#247;
  BatIcon = #248#249;
  Tag  = #207; Untag= #32;

VAR
 nfiles,
 FPage,
 SkipFiles,
 ypos,current,
 first,
 i,j,k,l,m    : integer;
 FIB          : FileInfoBlock;
 Files        : array [0..MaxRec] of FileRecord;
 VolumeName   : VNameStr;
 DoNextFiles  : boolean;
 MaxFiles     : boolean;
 Dsize,Dfree,
 BytesUsed,
 TotalBytes,
 TaggedBytes  : real;
 f	      : file;
 Commandkey   : char;
 taggedfiles  : byte;


Procedure Newdrive; FORWARD;


Procedure DisplayMainMenu;
begin
  DoWindow(1); ClrScr;
  writeln('  Attributes  Copy  Directory  Erase  Log  Move  Print  Rename',
          '  Tag  View ');
  write  ('  Files.ext   Sort  ^Edit  ^Print_scr  BS:parent',
          '  Internal  ^Colors  Quit ');
end;


Procedure ReturnMain;
Begin
  DisplayMainMenu;
  DoWindow(2)
end;


Procedure DisplayErrorMsg;
var i: integer;
    c: char;
    EMS: Array[1..64] of char;
Begin
  DoWindow(1);
  inline( $0E/$66/$11/EMS/$3A/DosError/$47/$CD/$05/0);
  Beep;
  gotoxy(1,2);ClrEol;GotoXY(10,2);
  {write('         ');}
  i:= 1;
  HighVideo; write('  ');
  while EMS[i]<> chr(0) do begin
    write(EMS[i]);
    i:=succ(i)
    end;
  write('  '); NormVideo;
  Key_Msg;
  c:=WaitKey
end;


Procedure CheckError;
var c : char;
Begin
  if (DosError>0) then begin
  DisplayErrorMsg;
  ClrScr
  end
end;


Procedure UpdateStatus;
Begin
  DoWindow(3);
  gotoxy( 8,2);  write(VolumeName:11);
  gotoxy(10,3);  write(Dsize:8:0);
  gotoxy(10,4);  write(Dfree:8:0);
  gotoxy(10,5);  write(BytesUsed:8:0);
  gotoxy(12,7);  if (FPage>0) then write('Page',FPage:2) else ClrEol;
  gotoxy(14,8);  if (FPage>1) then write('<') else write(' ');
                 write(nfiles+1:3);
                 if MaxFiles then write('>') else write(' ');
  gotoxy(10,9); write(totalbytes:8:0);
  gotoxy(10,11); write(taggedfiles:8);
  gotoxy(10,12); write(taggedbytes:8:0);
end;


Procedure ClearAllMarks;
var i: byte;
begin
 for i:=0 to MaxRec do files[i].Mark := Untag;
 taggedfiles:=0;
 taggedbytes:=0.0;
 DoWindow(2);
 for i:=1 to 20 do
  begin
    gotoxy(4,i);
    write(' ')
  end;
end;


Procedure PrintFile(m: byte);
begin
  with Files[files[m].Nr] do begin
    write(' ',Mark,' ',Icon,' ',Name);
    gotoxy(22,wherey); write(ExpandFAttr(Attr));
    if (Attr and 16) > 0 then write('  <dir> ')
    else write(Size:8:0);
    write(Date:10,Time:8,' ')
  end
end;


Procedure NewPath;

 function GetDir(drive: byte): PathStr;
 var temp,buffer: PathStr;
 begin
   buffer:='';
   temp:='';
   inline($0E/$59/$21/drive/$46/$11/buffer+1/$CD/$05/0/$32/DosError);
   if DosError = 0 then begin
     i:=1;
     while buffer[i] <> chr(0) do begin
       temp:=temp + buffer[i];
       i:=succ(i)
       end
     end;
   GetDir:=temp
 end;

Begin
  DoWindow(2); wborder;
  gotoxy(3,0); Write(' ',chr(65+ Bdos($19)),':',getdir(0),'\',SearchPath,' (',
                     chr(sortby+$20),')');
end;


Procedure PrintCurrent;
begin
  HighVideo; Gotoxy(3,ypos);printfile(current); NormVideo;
end;


Procedure DisplayFiles;
var i,last: integer;
begin
  DoWindow(2); ClrScr;
  if nfiles > 19 then last:=19 else last:=nfiles;
  for i:=0 to last do begin
    gotoxy(3,i+1); printfile(i);
    end;
  current:= 0; ypos:= 1;
  PrintCurrent
end; { DisplayFiles }


Procedure ReadCurrentDir;
var SearchExt: ExtStr;
    count: integer;
begin
  nfiles:=0;
  totalbytes:=0.0;
  fib[0]:=0;
  FindFirst(SearchPath,SearchAttr,FIB);
  if (DosError=0) and DoNextFiles then
    for count:= 0 to SkipFiles do FindNext(FIB);
  if DosError > 0 then begin
    with Files[nfiles] do begin
      Name:='No Files';
      Attr:= 0;
      Size:= 0;
      Date:= '';
      Time:= '';
      Icon:= '';
      UpdateStatus;
      CheckError
      end;
    exit
    end;
  while (DosError = 0) do begin
    with Files[nfiles] do begin
      Name:= GetFname(fib);
      Attr:= GetFAttr(fib);
      Size:= GetFSize(fib);
      Date:= GetFdate(fib);
      Time:= GetFtime(fib);
      Nr:= nfiles;
      if (Attr and 16) > 0 then Icon:=DirIcon
       else begin
         SearchExt:= GetFext(Name);
         if (SearchExt='COM') or (SearchExt='EXE') or (SearchExt='BAS') or
            (SearchExt='LDR') or (SearchExt='PRG') or (SearchExt='TRB')
          then Icon:=ComIcon
          else if SearchExt='BAT' then Icon:=BatIcon
          else if SearchExt='BIN' then Icon:=BinIcon
          else Icon:=FileIcon
       end;
      totalbytes:= totalbytes + Size;
      nfiles:=succ(nfiles);
      FindNext(FIB);
      if (DosError=0) and (nfiles>MaxRec) then begin
      MaxFiles:= true;
      if FPage=0 then FPage:= succ(FPage);
      DosError:= $DA
      end
      else MaxFiles:= false
    end
  end;
  nfiles:=pred(nfiles);
  ClearAllMarks;
  UpdateStatus;
end;


Procedure VarInit;
type
  characterpattern = string[8];
var
  dummy: integer;
  SetConst: PathStr;
  RetLen  : integer;
 procedure DefCharacter (c: char; pattern: characterpattern);
  var
    i: integer;
    l: byte absolute pattern;
  begin
    while l < 8 do pattern := pattern + #0;
    WriteVRAM (CGPBAS + 8 * ord(c), pattern[1], 8);
  end;

begin
 DefCharacter(chr(240),#0#124#124#64#64#64#124#0); { bin}
 DefCharacter(chr(241),#0#248#248#8#8#8#248#0);
 DefCharacter(chr(242),#$00#$78#$84#$80#$80#$80#$FC#$00); { dir }
 DefCharacter(chr(243),#$00#$00#$FC#$04#$04#$04#$FC#$00);
 DefCharacter(chr(244),#$00#$1F#$20#$20#$20#$7F#$FF#$00); { COM, BAS, EXE }
 DefCharacter(chr(245),#$00#$F8#$18#$18#$18#$FC#$F8#$00);
 DefCharacter(chr(246),#$00#$1F#$20#$20#$10#$10#$3F#$00); { doc,others }
 DefCharacter(chr(247),#$00#$F0#$38#$20#$10#$10#$E0#$00);
 DefCharacter(chr(248),#$00#$7C#$20#$7C#$20#$7C#$20#$00); { BAT }
 DefCharacter(chr(249),#$00#$F8#$10#$F8#$10#$F8#$10#$00);
 totalbytes:=0.0;
 taggedbytes:=0.0;
 SetConst:=GetEnv(Env_Color);
 Retlen:= length(SetConst);
 if Retlen > 0 then begin
   val(SetConst[1]+SetConst[2],Textcolor,dummy);
   val(SetConst[3]+SetConst[4],TextBackground,dummy);
   val(SetConst[5]+SetConst[6],HighColor,dummy);
   val(SetConst[7]+SetConst[8],HighBackground,dummy)
   end else begin
   TextColor := 15;
   TextBackground := 4;
   HighColor := 15;
   HighBackground := 6
   end;
 Color(TextColor,TextBackground,TextBackground);
 Blinkcolor(HighColor,HighBackGround,1,0);
 SetConst:= GetEnv(Env_Save);
 RetLen:= length(SetConst);
 if RetLen > 0 then begin
   SearchAttr:= ord(SetConst[1]);
   sortby    := ord(SetConst[2]);
   SearchPath:= copy(SetConst,3,RetLen-2)
  end
end;


Procedure SortFiles;
var x,z,temp1, temp2: byte;
    flag: boolean;

procedure exchange;
 begin
  files[z].nr:=temp2; files[z+1].nr:= temp1;
  flag:=true
 end;

begin
Wait_Msg;
if (sortby=$55) then for x:= 0 to nfiles do files[x].nr:=x
 else for x:= nfiles-1 downto 0 do begin
   flag:= false;
   for z:= 0 to x do begin
    temp1:= files[z].nr; temp2:= files[z+1].nr;
    case sortby of
    $4E: if files[temp1].name>files[temp2].name then exchange;
    $45: if getfext(files[temp1].name)>getfext(files[temp2].name) then exchange;
    $41: if files[temp1].attr>files[temp2].attr then exchange;
    $53: if files[temp2].size>files[temp1].size then exchange;
    $44: if (files[temp2].date>files[temp1].date) or
            (files[temp2].date=files[temp1].date) and
            (files[temp2].time>files[temp1].time) then exchange;
    end; { case }
   end;
   if flag=false then exit;
  end;
end;


Procedure DrawScreen;
Begin
  Fullwindow; ClrScr;
  DisplayMainMenu;
  DoWindow(4); WriteLogo;
  DoWindow(2); wborder;
  DoWindow(3); Wborder;
  gotoxy(1,1);
  Writeln(' Disk');
  writeln('  Name:');
  writeln('  Size:');
  writeln('  Free:');
  writeln('  Used:');
  writeln;
  writeln(' Entries');
  writeln('  Total :');
  writeln('  Bytes :');
  writeln;
  writeln('  Tagged:');
  writeln('  Bytes :')
end;


Procedure ChangeAttributes( VAR a: byte);
var
  c: char;
  old: byte;

 procedure WYes;
 begin write(' Yes ') end;
 procedure WNo;
 begin write(' No  ') end;

begin
old:=a;
gotoxy(41,1); write('[Dir]  [Sys]  [Hid]  [Read]  [Arch]');
 repeat
   HighVideo;
   gotoxy(41,2); if (a and 16)>0 then WYes else WNo;
   gotoxy(48,2); if (a and 4) >0 then WYes else WNo;
   gotoxy(55,2); if (a and 2) >0 then WYes else WNo;
   gotoxy(62,2); if (a and 1) >0 then WYes else WNo;
   gotoxy(70,2); if (a and 32)>0 then WYes else WNo;
   NormVideo;
   c:= upcase(WaitKey);
   case c of
     #13: exit;
     #27: begin a:=old; exit end;
     'D': if (a and 16) = 0 then a:=a or 16 else a:= a and 47;
     'S': if (a and 4)  = 0 then a:=a or 4  else a:= a and 59;
     'H': if (a and 2)  = 0 then a:=a or 2  else a:= a and 61;
     'R': if (a and 1)  = 0 then a:=a or 1  else a:= a and 62;
     'A': if (a and 32) = 0 then a:=a or 32 else a:= a and 31;
    end;
 until false
end;


Procedure UpdateFileDisplay;
begin
  ReadCurrentDir;
  SortFiles;
  DisplayFiles
end;


Procedure Display_Path;
Begin
  NewPath;
  UpdateFileDisplay
end;


Procedure Reset_Path;
Begin
  MaxFiles:= false;
  DoNextFiles:= false;
  FPage:= 0
end;
