; TeddyWareZ MSX Z80 source file.
;
; Prog: Additional Song edit..
; Code: d-fader^TwZ.
; Date: August 7, 1999
;
; cmnt: Improved SCC Detection routine by BiFi 2002
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

ShowPosition:
; routine : Show position
; in      : (sngpos) - Song Position
; out     : (sngpat) - right pattern.
; cmnt    : none.

	ShowPosNr

	ld a,(SngPos)

	ld e,a
	ld d,0
	ld hl,patterns
	add hl,de

	ld a,(hl)
	ld (SngPat),a

ShowPattern:
; routine : Show pattern of song.
; in      : (SngPat) - pattern number (0..82)
; out     : none.
; cmnt    : none.

	di

	ld a,1
	ld (ChangeEditModeAllowed),a

	ShowPatNr

	ld a,(SngPat)
	inc a

	ld hl,80*5+7
	ld (ShowPatAdrVRam),hl

	ld hl,PatternData-192
	ld de,192

	ld b,a
ShowPatternLoop1:
	add hl,de
	
	djnz ShowPatternLoop1

	ld (ShowPatAdrRam),hl

	ld b,16
ShowPatternLoop5:
	push bc

	ld de,OneRowdata

	ld b,5
ShowPatternLoop3:
	push bc
	push hl

	ld a,(hl)								; get note (or note command)

	ld hl,NoteCommand

	push de

	ld e,a
	ld d,0

	or a
	jp z,EmptyNoteEvent


	ld b,2
ShowPatternLoop4:
	sla e

	jp nc,ShowPatternLoop4Done

	sla d
	inc d
ShowPatternLoop4Done:

	djnz ShowPatternLoop4


	add hl,de

EmptyNoteEvent:
	pop de

	ld bc,3								; Copy data to OneRowData
	ldir

	
	pop hl

	inc hl

	inc de								; Skip the '|'

	ld a,(hl)

	push de
	pop ix								; ix: Address of HexaDecimal Number

	call Calc2HexOwnAdr	

	pop bc

	inc hl

	inc de
	inc de
	inc de

	djnz ShowPatternLoop3

	push hl

	ld a,(hl)

	sla a
	sla a

	ld c,a
	ld b,0
	ld hl,PSGCommandData

	add hl,bc

	ld bc,3
	ldir

	inc de
	inc de

	pop hl

	inc hl

	push de

	ld a,(hl)

	ld hl,CommandData

	or a
	jp z,ShowCommandEmpty

	ld e,a
	ld d,0

	ld b,3
ShowPatternLoop6:
	sla e

	jp nc,ShowPatternLoop6Done

	sla d
	inc d

ShowPatternLoop6Done:
	djnz ShowPatternLoop6

	add hl,de

ShowCommandEmpty:
	pop de

	ld bc,5
	ldir

	xor a
	ld hl,(ShowPatAdrVram)
	call SetVramWrite

	ld hl,OneRowData
	ld bc,$2d98
	otir

	ld hl,(ShowPatAdrVram)
	ld bc,80
	add hl,bc
	ld (ShowPatAdrVram),hl

	ld hl,(ShowPatAdrRam)
	ld bc,12
	add hl,bc
	ld (ShowPatAdrRam),hl

	pop bc

	dec b
	jp nz,ShowPatternLoop5

	ld a,(BlockContinue)
	or a
	jp nz,DoShowBlock

	ld a,(LastPatShowed)
	ld b,a
	ld a,(SngPat)
	cp b
	jp z,DoNotShowBlock

	call ShowBlock
DoNotShowBlock:
	ld a,(SngPat)
	ld (LastPatShowed),a

	xor a
	ld (ChangeEditModeAllowed),a

	ei

	ret

DoShowBlock:
	ld a,(SngPat)
	ld (LastPatShowed),a

	jp MarkBlockEnd2

LastPatShowed:
	.db 255

ChangeEditModeAllowed:
	.db 0

ShowpatAdrRam:
	.dw 0
ShowPatAdrVram:
	.dw 0

OneRowData: 			.equ $d400
NoteCommand:			.equ $d42d
OffEvent:				.equ $d5b1
PSGCommandData:			.equ $d5e9 
CommandData:			.equ $d69d


;OneRowData:
;	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 1
;	.db 22			; |
;
;	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
;	.db 22			; |
;
;	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 2
;	.db 22			; |
;
;	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
;	.db 22			; |
;
;	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 3
;	.db 22			; |
;
;	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
;	.db 22			; |
;
;	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 4 
;	.db 22			; |
;
;	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
;	.db 22			; |
;
;	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 5
;	.db 22			; |
;
;	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
;	.db 22			; |
;
;	.ds 3				; PSG command (number or nothing)
;	.db 22,22			; ||
;
;	.ds 5				; Command (such as Tempo, EndOp, etc.)
;
;					; in total: (5*7) + 5 + 5 = 45 bytes.
;
;NoteCommand:
;	.text " -  "
;		     
;	.text "C 1 C#1 D 1 D#1 E 1 F 1 F#1 G 1 G#1 A 1 A#1 B 1 "				;  1-12
;	.text "C 2 C#2 D 2 D#2 E 2 F 2 F#2 G 2 G#2 A 2 A#2 B 2 "				; 13-24
;	.text "C 3 C#3 D 3 D#3 E 3 F 3 F#3 G 3 G#3 A 3 A#3 B 3 "				; 25-36
;	.text "C 4 C#4 D 4 D#4 E 4 F 4 F#4 G 4 G#4 A 4 A#4 B 4 "				; 37-48
;	.text "C 5 C#5 D 5 D#5 E 5 F 5 F#5 G 5 G#5 A 5 A#5 B 5 "				; 49-60
;	.text "C 6 C#6 D 6 D#6 E 6 F 6 F#6 G 6 G#6 A 6 A#6 B 6 "				; 61-72
;	.text "C 7 C#7 D 7 D#7 E 7 F 7 F#7 G 7 G#7 A 7 A#7 B 7 "				; 73-84
;	.text "C 8 C#8 D 8 D#8 E 8 F 8 F#8 G 8 G#8 A 8 A#8 B 8 "				; 85-96
;
;OffEvent:
;	.text "OFF "											; 97
;
;	.text "Ins "											; 98
;
;	.text "P1+ "											; 99
;	.text "P1- "											; 100
;
;	.text "P2+ "											; 101
;	.text "P2- "											; 102
;
;	.text "M + "											; 103
;	.text "M - "											; 104
;
;	.text "DT+ "											; 105
;	.text "DT- "											; 106
;
;	.text "VS+ "											; 107
;	.text "VS- "											; 108
;
;	.text "AS+ "											; 109
;	.text "AS- "											; 110
;
;PSGCommandData:
;;	.text " -  "
;;	.text "#01 #02 #03 #04 #05 #06 #07 #08 #09 #10 #11 "
;;	.text "#12 #13 #14 #15 #16 #17 #18 #19 #20 #21 #22 "
;;	.text "#23 #24 #25 #26 #27 #28 #29 #30 #31 #32 #33 "
;;	.text "#34 #35 #36 #37 #38 #39 #40 #41 #42 #43 #44 "
;;
;	.text " -  "
;	.text "  1   2   3   4   5   6   7   8   9  10  11 "
;	.text " 12  13  14  15  16  17  18  19  20  21  22 "
;	.text " 23  24  25  26  27  28  29  30  31  32  33 "
;	.text " 34  35  36  37  38  39  40  41  42  43  44 "
;
;CommandData:
;	.text " ---    "								;     00
;	.text "Tmp 1   Tmp 2   Tmp 3   Tmp 4   Tmp 5   "		; 01..05
;	.text "Tmp 6   Tmp 7   Tmp 8   Tmp 9   Tmp10   "		; 06..10
;	.text "Tmp11   Tmp12   Tmp13   Tmp14   Tmp15   "		; 11..15
;	.text "Tmp16   Tmp17   Tmp18   Tmp19   Tmp20   "		; 16..20
;	.text "Tmp21   Tmp22   Tmp23   Tmp24   Tmp25   "		; 21..25
;
;	.text "EndOp   "								;     26
;
;	.text "TRP-6   TRP-5   TRP-4   TRP-3   TRP-2   "		; 27..31
;	.text "TRP-1   TRP+0   TRP+1   TRP+2   TRP+3   "		; 32..36 (0 = 33)
;	.text "TRP+4   TRP+5   TRP+6   "					; 37..39

; Data for frequency of notes:
; stored as follows: c 1  c#1  d 1  e 1  f 1  f#1  g 1  g#1  a 1  a#1  b 1
;                    c 2  c#2  d 2  e 2  f 2  f#2  g 2  g#2  a 2  a#2  b 2
; aso (and so on) (till c 8/b 8)

FreqData:
        .dw 3421,3228,3047,2876,2715,2562,2419,2283,2155,2034,1920,1812
        .dw 1711,1614,1524,1438,1358,1281,1210,1142,1078,1017,0960,0906
        .dw 0855,0807,0762,0719,0679,0641,0605,0569,0539,0509,0480,0453
        .dw 0428,0404,0381,0360,0339,0320,0302,0285,0269,0254,0240,0227
        .dw 0214,0202,0190,0180,0170,0160,0151,0143,0135,0127,0120,0113
        .dw 0107,0101,0095,0090,0085,0080,0076,0071,0067,0064,0060,0057
        .dw 0053,0050,0048,0045,0042,0040,0038,0036,0034,0032,0030,0028
        .dw 0027,0025,0024,0022,0021,0020,0019,0018,0017,0016,0015,0014


ShowLoopPos.2:
	xor a
	ld hl,(LoopPoint)
	call SetVramWrite

	ld a,(LoopPos)
	or a
	jp z,NormalLoopPos

	ld hl,OffEvent
	ld bc,$0398
	otir

	ret

NormalLoopPos:
	ld a,(LoopPos+1)
	call Calc8Dec

	ld hl,Decimal
	ld bc,$0398
	otir

	ret	

ShowInsVol:
	ld a,InsBnk
	out ($fe),a

	ld a,(PatPosMenuOn)
	or a
	jp nz,NoNamesOut

	SetVW(0,13*80+70)

	ld a,(NowIns)
	call Calc8Dec

	ld hl,Decimal
	ld bc,$0398
	otir

	SetVW(0,13*80+75)

	ld a,(NowVol)
	call Calc8Dec

	ld hl,Decimal+1
	ld bc,$0298
	otir

NoNamesOut:
	SetVW(0,80*14+70)

	ld hl,$8000-40

	ld de,40
	ld a,(NowIns)

	inc a

	ld b,a
ShowInsVolLoop1:
	add hl,de

	djnz ShowInsVolLoop1

	ld a,(PatPosMenuOn)
	or a
	jp nz,NoNamesOut.2

	ld bc,$0898
	otir

	jp NoNamesOut.3

NoNamesOut.2:
	ld de,8
	add hl,de

NoNamesOut.3:
	ld de,SaveInstrumentData
	ld bc,32
	ldir

	call SetSCC

	ld hl,SaveInstrumentData
	ld de,$9800
	ld bc,32
	ldir

	call ResetSCC

	ld a,SngBnk
	out ($fe),a

	ret

SaveInstrumentData:
	.ds 32

CalculateNowAddress:
; routine : Calculate current addresses
; in      : none.
; out     : (NowPatAdr) - Address of pattern, (NowRowAdr) - Address of row
;		(NowAddress) - Address of current cell.
; cmnt    : none.

	ld a,(SngPat)
	inc a

	ld b,a

	ld hl,PatternData-192
	ld de,192
CalcNALoop1:
	add hl,de
	
	djnz CalcNALoop1

	ld (NowPatAdr),hl

	ld de,-12
	add hl,de

	ld de,12

	ld a,(NowY)
	sub 5

	ld b,a
CalcNALoop2:
	add hl,de

	djnz CalcNaLoop2

	ld (NowRowAdr),hl

	ld a,(RealX)
	ld e,a
	ld d,0

	add hl,de

	ld (NowAddress),hl

	ret

ResetSong:
	ShowHint(123)

	call YesOrNo
	jp nz,main

	call DeInitSongMenu

	call DoResetSong

	call InitialiseSongEdit3
	
	jp main

DoResetSong:
; routine : Reset song (copy standard song data in song bank)
; in      : none.
; out     : none.
; cmnt    : be sure to already have set the right song page!

	ld hl,$8000
	ld de,$8001
	ld bc,$3fff
	ld (hl),0
	ldir

	ld hl,StandardSongData
	ld de,$8000
	ld bc,EndStandardSongData-StandardSongData
	ldir

	xor a
	ld (SngPos),a
	ld (SngPat),a
	ld (SngRow),a

	ret

NowPatAdr:
	.dw 0
NowRowAdr:
	.dw 0
NowAddress:
	.dw 0

SngPat:
	.db 0

NowIns:
	.db 0

NowVol:
	.db 15

Cursor:
NowY:
	.db 6
NowX:
	.db 8
RealX:
	.db 0

NowChan:
	.db 0						; current channel (0..6) -> for block copy etc.

RealXData:
	.db 8,12,15,19,22,26,29,33,36,40,43,48

EditModes:
	.db "Type"
	.db "1Key"

EqTypes:
	.db "Normal",0,0
	.db "Volume"

CurrentOctaves:
	.db "  1-2-3-4-5-6-7-8  "
	;    0 1 2 3 4 5 6 7 8 

; data to save! (and reload) (settings)

CursorSwitch:
	.db 1
EqType:
	.db 0
EditMode:
	.db 0
CurOct:
	.db 4
NoteAudition:
	.db 0

; till here

MarkBlockDelete:
	xor a
	ld (BlockOn),a

	call ClearBlink

	jp main

SwapContBlock:
	ld a,(BlockContinue)
	xor 1
	ld (BlockContinue),a

SwapContBlock.1:
	ScanKey(key_b)
	jp z,SwapContBlock.1

	jp MarkBlockEnd

BlockContinue:
	.db 0

MarkBlockBegin:
	ld a,(SngPat)
	ld (BlockP_b),a
	ld (BlockP_e),a

	ld a,(RealX)
	ld e,a
	ld d,0
	ld hl,BlockOffsets

	add hl,de

	ld a,(hl)

	ld (BlockX_b),a
	ld (BlockX_e),a
	
	ld a,(NowY)
	sub 6

	ld (BlockY_b),a
	ld (BlockY_e),a

	ld a,1
	ld (BlockOn),a

	jp MarkBlockDone

MarkBlockEnd2:
	ld a,1
	ld (NoJump),a

MarkBlockEnd:
	ld a,(BlockOn)
	or a
	jp z,MarkBlockBegin

	ld a,(SngPat)
	ld (BlockP_e),a

	ld a,(RealX)
	ld e,a
	ld d,0
	ld hl,BlockOffsets

	add hl,de

	ld a,(hl)

	ld (BlockX_e),a
	
	ld a,(NowY)
	sub 6

	ld (BlockY_e),a


	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)
	cp b
	jp nc,BlockChnOk

	ld (BlockX_b),a

	ld a,b
	ld (BlockX_e),a

BlockChnOk:
	ld a,(BlockP_e)
	ld b,a
	ld a,(BlockP_b)
	cp b
	jp c,BlockPatternOk

	ld (BlockP_e),a

	ld a,b
	ld (BlockP_b),a

	ld a,(BlockP_b)
	ld b,a
	ld a,(BlockP_e)
	cp b
	jp nz,BlockRowOk

	ld a,(BlockY_b)
	ld b,a
	ld a,(BlockY_e)
	cp b
	jp nc,BlockRowOk

	ld (BlockY_b),a

	ld a,b
	ld (BlockY_e),a

BlockPatternOk:
BlockRowOk:	
	jp MarkBlockDone
	
MarkBlockDone:
	call ShowBlock
	call CalculateMarkSize

	ld a,(NoJump)
	or a
	jp nz,DoReturn

	jp main

DoReturn:
	xor a
	ld (NoJump),a

	ret

NoJump:
	.db 0

ShowBlock:
	ld a,(BlockOn)
	or a
	ret z

	call ClearBlink

	ld a,(BlockX_b)
	sla a
	ld e,a
	ld d,0
	ld hl,BlockXLen

	add hl,de

	ld a,(hl)

	ld (BeginXposBar),a

	inc hl

	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)
	sub b

	inc a

	ld b,a
	ld c,0
BlockLoop1:
	ld a,(hl)
	add a,c
	ld c,a

	inc hl
	inc hl

	djnz BlockLoop1

	dec a

	ld (LengthXPosBar),a

	ld b,a

	ld a,(BlockX_b)
	cp 6
	jp nz,NotOnlyCMDChan

	ld a,(BlockX_e)
	cp 6
	jp nz,NotOnlyCMDChan

	ld a,b

	dec a

	ld (LengthXPosBar),a
		
	ld a,(BeginXPosBar)
	inc a
	ld (BeginXposBar),a

NotOnlyCMDChan:
	ld a,(BlockP_b)
	ld b,a
	ld a,(BlockP_e)
	cp b
	jp nz,BlockNot1Pat

	ld a,(BlockP_b)
	ld b,a
	ld a,(SngPat)
	cp b
	jp z,Block1Pat

	ret

BlockNot1Pat:
	ld a,(BlockP_b)
	ld b,a
	ld a,(SngPat)
	cp b
	ret c
	jp z,BlockBeginPat

	ld a,(BlockP_e)
	ld b,a
	ld a,(SngPat)
	cp b
	jp z,BlockEndPat
	ret nc

	jp BlockMiddlePat

Block1Pat:
	ld a,(BlockY_b)
	ld b,a
	ld a,(BlockY_e)
	sub b

	inc a

	ld b,a

	ld a,(BlockY_b)
	add a,6
	ld e,a
	ld a,(BeginXPosBar)
	ld d,a

	ld a,(LengthXPosBar)

Block1PatLoop:
	push de
	push bc
	push af

	call DrawBar

	pop af
	pop bc
	pop de

	inc e

	djnz Block1PatLoop

	ret

BlockBeginPat:
	ld a,(BlockY_b)
	ld b,a
	ld a,15
	sub b

	inc a

	ld b,a

	ld a,(BlockY_b)
	add a,6
	ld e,a
	ld a,(BeginXPosBar)
	ld d,a

	ld a,(LengthXPosBar)

BlockBeginPatLoop:
	push de
	push bc
	push af

	call DrawBar

	pop af
	pop bc
	pop de

	inc e

	djnz BlockBeginPatLoop

	ret


BlockMiddlePat:
	ld b,16

	ld e,6
	ld a,(BeginXPosBar)
	ld d,a

	ld a,(LengthXPosBar)

BlockMiddlePatLoop:
	push de
	push bc
	push af

	call DrawBar

	pop af
	pop bc
	pop de

	inc e

	djnz BlockMiddlePatLoop

	ret


BlockEndPat:
	ld a,(BlockY_e)

	inc a

	ld b,a

	ld e,6
	ld a,(BeginXPosBar)
	ld d,a

	ld a,(LengthXPosBar)

BlockEndPatLoop:
	push de
	push bc
	push af

	call DrawBar

	pop af
	pop bc
	pop de

	inc e

	djnz BlockEndPatLoop

	ret

CalculateMarkSize:
	ld a,(BlockP_b)
	inc a
	ld b,a

	ld hl,PatternData-192
	ld de,192
CalcMSizeLoop2.1:
	add hl,de

	djnz CalcMSizeLoop2.1

	ld de,-12
	add hl,de

	ld a,(BlockY_b)
	inc a
	ld b,a

	ld de,12

CalcMSizeLoop2.2:
	add hl,de

	djnz CalcMSizeLoop2.2

	ld a,(BlockX_b)
	ld e,a
	ld d,0

	push hl

	ld hl,BlockXOffset
	add hl,de
	ld e,(hl)

	pop hl

	add hl,de

	ld (BlockStartAdr),hl


	ld hl,BlockSizes

	ld a,(BlockX_b)
	ld e,a
	ld d,0

	add hl,de

	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)

	sub b
	inc a

	ld b,a
	ld c,0
CalcMSizeLoop1:
	ld a,(hl)
	ld d,a

	ld a,c
	add a,d

	ld c,a

	inc hl

	djnz CalcMSizeLoop1

	ld a,c
	ld (BlockXSize),a

	ld a,(BlockP_b)
	ld b,a
	ld a,(BlockP_e)
	cp b
	jp z,BlockYSize1Pat

	sub b

	cp 1
	jp z,BlockYSize2Pat

BlockYSize2MorePat:
	dec a

	ld b,a

	ld hl,0
	ld de,16
BlockYSize2MorePatLoop:
	add hl,de

	djnz BlockYSize2MorePatLoop

	ld a,(BlockY_b)
	ld b,a

	ld a,16
	sub b

	ld e,a
	ld d,0
	add hl,de

	ld a,(BlockY_e)

	inc a
	
	ld e,a
	ld d,0
	add hl,de

	ld (BlockYSize),hl

	ret

BlockYSize2Pat:
	ld hl,0

	ld a,(BlockY_b)

	ld b,a

	ld a,16
	sub b

	ld e,a
	ld d,0
	add hl,de

	ld a,(BlockY_e)

	inc a
	
	ld e,a
	ld d,0
	add hl,de

	ld (BlockYSize),hl

	ret

BlockYSize1Pat:
	ld hl,0

	ld a,(BlockY_b)
	ld b,a

	ld a,(BlockY_e)

	inc a

	sub b

	ld e,a
	ld d,0
	add hl,de

	ld (BlockYSize),hl

	ret


BeginXPosBar:
	.db 0
LengthXPosBar:
	.db 0
BlockP_b:
	.db 0
BlockX_b:
	.db 0
BlockY_b:
	.db 0
BlockP_e:
	.db 0
BlockX_e:
	.db 0
BlockY_e:
	.db 0
BlockOn:
	.db 0

BlockXSize:
	.db 0
BlockYSize:
	.dw 0

BlockStartAdr:
	.dw 0

; Block operations:

CopyBlock:
; routine : Copy block to it's destination.
; in      : none.
; out     : none.
; cmnt    : There will be checked if the copy is possible.

	ld a,(BlockX_e)
	cp 5
	jp c,CopyXMaybePossible

	ld a,(BlockX_b)
	ld b,a

	ld a,(NowChan)
	cp b
	jp nz,CopyImpossible

	jp CopyXPossible

CopyXMayBePossible:
	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)
	sub b

	ld b,a

	ld a,(NowChan)

	add a,b
	cp 5
	jp nc,CopyImpossible

	jp CopyXPossible

CopyXPossible:
	ld a,(sngpat)
	inc a

	ld b,a

	ld hl,-16
	ld de,16
CopyChkYLoop.1:
	add hl,de

	djnz CopyChkYLoop.1

	ld a,(NowY)
	sub 6
	ld e,a
	ld d,0
	add hl,de

	ex de,hl

	ld hl,(BlockYSize)

	add hl,de

	ex de,hl

	ld hl,1328
	or a
	sbc hl,de

	jp c,CopyImpossible

; -- copy block routine --
	ld hl,BlockXOffset

	ld a,(NowChan)
	ld e,a
	ld d,0

	add hl,de

	ld e,(hl)

	ld hl,(NowRowAdr)
	add hl,de

	ld (DestAddress),hl

	ld hl,(BlockYSize)
	ld (Counter),hl

	push hl
	pop bc

	ld hl,-12
	ld de,12
CopyBlock.loop2:
	add hl,de

	dec bc

	ld a,c
	or b

	jp nz,CopyBlock.loop2

	ld a,(BlockXSize)	
	dec a

	ld e,a
	ld d,0
	add hl,de

	ex de,hl

	ld hl,(BlockStartAdr)
	add hl,de
	ld (SrcAddress),hl

	ld hl,(DestAddress)
	add hl,de
	ld (DestAddress),hl

	ld b,0
	ld a,(BlockXSize)
	ld c,a

CopyBlock.loop1:
	ld hl,(DestAddress)
	ex de,hl
	ld hl,(SrcAddress)

	push bc
	lddr
	pop bc

	ld hl,(SrcAddress)
	ld de,-12
	add hl,de
	ld (SrcAddress),hl

	ld hl,(DestAddress)
	add hl,de
	ld (DestAddress),hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ld a,h
	or l

	jp nz,CopyBlock.loop1

	ld a,(BlockX_b)
	cp 5
	jp nc,InsChangeDetected.1

	ld b,a
	ld a,(BlockX_e)
	sub b
	ld b,a

	ld a,(NowChan)
	add a,b
	cp 4
	jp c,InsChangeDetected.1


	ld hl,(NowRowAdr)
	ld de,8
	add hl,de

	push hl

	ld hl,(BlockYSize)
	
	push hl
	pop bc

	pop hl

	ld de,12

CopyBlock.loop4:
	ld a,(hl)
	cp 98
	jp z,InsChangeDetected

	add hl,de

	dec bc

	ld a,b
	or c

	jp nz,CopyBlock.loop4

InsChangeDetected.1:
	call ShowPattern

	jp main

InsChangeDetected:
	ShowHint(82)

	call chget

	jp InsChangeDetected.1

CopyImpossible:
	ShowHint(76)

	call kilbuf
	call chget

	jp main

SrcAddress:
	.dw 0
DestAddress:
	.dw 0
Counter:
	.dw 0

; -- end copy block routine --

DeleteBlock:
	ShowHint(87)

	call YesOrNo
	jp nz,main

	ld hl,(BlockYSize)
	ld (Counter),hl

	ld hl,(BlockStartAdr)

	ld a,(BlockXSize)
	ld b,a
DeleteBlock.1:
	push bc
	push hl

DeleteBlock.2:
	ld (hl),0

	inc hl

	djnz DeleteBlock.2

	pop hl
	pop bc

	ld de,12
	add hl,de

	push hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ex de,hl

	pop hl

	ld a,d
	or e
	jp nz,DeleteBlock.1

	call ShowPattern

	jp main
	
CheckCursor:
; routine : Check if cursor currently is in block.
; in      : none.
; out     : z flag set if cursor is in block, reset if not.
; cmnt    : none.

	ld a,(BlockOn)
	or a
	jp z,CheckCursor_Negative

	ld a,(BlockX_b)
	ld b,a
	ld a,(NowChan)
	cp b
	jp c,CheckCursor_Negative

	ld a,(NowChan)
	ld b,a
	ld a,(BlockX_e)
	cp b
	jp c,CheckCursor_Negative

	ld a,(BlockP_b)
	ld b,a
	ld a,(SngPat)
	cp b
	jp c,CheckCursor_Negative

	jp nz,CheckCursorEndPat

	ld a,(BlockP_b)
	ld b,a
	ld a,(BlockP_e)
	cp b
	jp nz,CheckCursorBeginMore

	ld a,(NowY)
	sub 6
	ld b,a
	ld a,(BlockY_e)
	cp b
	jp c,CheckCursor_Negative

CheckCursorBeginMore:
	ld a,(BlockY_b)
	ld b,a
	ld a,(NowY)
	sub 6

	cp b
	jp c,CheckCursor_Negative

	jp CheckCursor_Positive

CheckCursorEndPat:
	ld a,(BlockP_e)
	ld b,a
	ld a,(SngPat)
	cp b
	jp z,CheckCursor_EndPatMore
	jp nc,CheckCursor_Negative

CheckCursor_EndPatMore:
	ld a,(BlockP_e)
	ld b,a
	ld a,(SngPat)
	cp b
	jp nz,CheckCursor_Positive

	ld a,(NowY)
	sub 6
	ld b,a
	ld a,(BlockY_e)
	cp b
	jp c,CheckCursor_Negative

CheckCursor_Positive:
	xor a
	ret

CheckCursor_Negative:
	ld a,1
	or a
	ret


BlockFill1:
	call CheckBlockFill
	jp c,main

BlockFill.1.0
	push hl

	ld a,(BFXSize)

	ld b,a
BlockFill1.1:
	push bc

	ld a,(hl)
	cp 97
	jp nc,BlockFill1.1.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

BlockFill1.1.done:
	pop bc

	inc hl
	inc hl

	djnz BlockFill1.1

	pop hl

	ld de,12
	add hl,de

	push hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ex de,hl

	pop hl

	ld a,d
	or e

	jp nz,BlockFill.1.0

	call ShowPattern

	jp main


BlockFill2:
	call CheckBlockFill
	jp c,main

BlockFill.2.0
	push hl

	ld a,(BFXSize)

	ld b,a
BlockFill2.1:
	push bc

	ld a,(hl)
	or a
	jp z,BlockFill2.1.done

	cp 97
	jp nc,BlockFill2.1.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

BlockFill2.1.done:
	pop bc

	inc hl
	inc hl

	djnz BlockFill2.1

	pop hl

	ld de,12
	add hl,de

	push hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ex de,hl

	pop hl

	ld a,d
	or e

	jp nz,BlockFill.2.0

	call ShowPattern

	jp main


BlockFill3:
	call CheckBlockFill
	jp c,main

BlockFill.3.0
	push hl

	ld a,(BFXSize)

	ld b,a
BlockFill3.1:
	push bc

	ld a,(hl)
	or a
	jp nz,BlockFill3.1.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

BlockFill3.1.done:
	pop bc

	inc hl
	inc hl

	djnz BlockFill3.1

	pop hl

	ld de,12
	add hl,de

	push hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ex de,hl

	pop hl

	ld a,d
	or e

	jp nz,BlockFill.3.0

	call ShowPattern

	jp main

NoBlockFill:
	scf
	ret

CheckBlockFill:
; routine : Calculate block size. (for fill volume)
; in      : none.
; out     : c if impossible else (counter) - counter y-size, (BFXSize) - counter x-size,
;					   hl - start address.
; cmnt    : 


	ld a,(BlockX_b)
	cp 5
	jp nc,NoBlockFill

	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)
	sub b

	inc a
	ld (BFXSize),a

	ld a,(BlockX_e)
	cp 5
	jp c,NoAdjustBFXSize

	sub 4

	ld b,a
	ld a,(BFXSize)
	sub b
	ld (BFXSize),a

NoAdjustBFXSize:
	ld hl,(BlockYSize)
	ld (Counter),hl

	ld hl,(BlockStartAdr)

	or a
	ret

BFXSize:
	.db 0


; -- Note shift routine --
; in      : (WhatToAdd) - How much to add (1 for half note, 12 for octave)
;           (WhatToDo)  - 0 for addition, 1 for substraction 
; out     : none.
; cmnt    : no one.. (damn d-fader humor..) (y'know.. I really HATE this damn project!!, but hey
;           if chaos says SCC Blaffer NT has to be made, then who am I to disagree??)

BlockShift:
	ld a,(BlockX_b)
	cp 5
	jp nc,main

	ld a,(BlockX_b)
	ld b,a
	ld a,(BlockX_e)
	sub b

	inc a
	ld (NoteShiftXSize),a

	ld a,(BlockX_e)
	cp 5
	jp c,NoAdjustXSize

	sub 4

	ld b,a
	ld a,(NoteShiftXSize)
	sub b
	ld (NoteShiftXSize),a

NoAdjustXSize:
	ld hl,(BlockYSize)
	ld (Counter),hl

	ld hl,(BlockStartAdr)

BlockShift.1:
	push hl

	ld a,(NoteShiftXSize)

	ld b,a
BlockShift.2:
	push bc

	ld a,(WhatToDo)
	or a
	jp z,DoAdjustUp

	call AdjustNoteDown

	jp DoAdjustDone

DoAdjustUp:
	call AdjustNoteUp

DoAdjustDone:
	pop bc

	inc hl
	inc hl

	djnz BlockShift.2

	pop hl

	ld de,12
	add hl,de

	push hl

	ld hl,(Counter)
	dec hl
	ld (Counter),hl

	ex de,hl

	pop hl

	ld a,d
	or e

	jp nz,BlockShift.1

	call ShowPattern

	jp main

AdjustNoteUp:
	ld a,(hl)

	or a
	jp z,AdjustNoteUpDone
	cp 97
	jp nc,AdjustNoteUpDone

	ld b,a
	ld a,(WhatToAdd)

	add a,b

	cp 97
	jp c,AdjustNoteUpDone

	sub 96
AdjustNoteUpDone:
	ld (hl),a

	ret

AdjustNoteDown:
	ld a,(WhatToAdd)

	ld b,a
	ld a,(hl)

	or a
	jp z,AdjustNoteDownDone
	cp 97
	jp nc,AdjustNoteDownDone

	sub b

	ld a,-1

	jp z,DoAdjustDown

	ld a,(hl)
	sub b

	jp nc,AdjustNoteDownDone

	cpl

DoAdjustDown:
	ld b,a

	ld a,95
	sub b
AdjustNoteDownDone:
	ld (hl),a

	ret

NoteShiftXSize:
	.db 0
WhatToAdd:
	.db 0
WhatToDo:
	.db 0

BlockXLen:
; block x positions and lengths stored as follows:
;
; byte 1: X position channel 1
; byte 2: length of channel 1
; etc.

	.db 8,7,15,7,22,7,29,7,36,7,43,4,47,7

BlockOffsets:
	.db 0,0,1,1,2,2,3,3,4,4,5,6

BlockSizes:
	.db 2,2,2,2,2,1,1

BlockXOffset:
	.db 0,2,4,6,8,10,11

Input2Hex:
; routine : Input Hexadecimal number of 2 digits, set number on screen.
; in      : none.
; out     : (a - number and Cy=0) or (Cy=1 if escaped)
; cmnt    : none.

	ld hl,(CurLoc)

	ld a,32
	call chput
	call chput

	ld (CurLoc),hl

	call ChGet

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,InputHexEscaped

	call ScanHexKey
	jp c,Input2Hex

Input2HexDone:
	ld c,a

	ld e,a
	ld d,0
	ld hl,HexxData
	add hl,de

	ld a,(hl)

	call chput

Input1Hex:
; routine : Input Hexadecimal number of 1 digit, set number on screen.
; in      : c - high nibble of byte. 
; out     : a - number
; cmnt    : When ENTER is pressed, the high nibble will be 0, and the low nibble will be
;		What the high nibble was.

	ld hl,(CurLoc)

	ld a,32
	call chput

	ld (CurLoc),hl

Input1HexLoop:
	push hl

	call Kilbuf
	call ChGet

	pop hl

	ld (CurLoc),hl

	cp 27
	jp z,InputHexEscaped

	cp 13
	jp z,Input1HexEnter

	ld b,0

	cp 48
	jp z,InputHexOk
	inc b
	cp 49
	jp z,InputHexOk
	inc b
	cp 50
	jp z,InputHexOk
	inc b
	cp 51
	jp z,InputHexOk
	inc b
	cp 52
	jp z,InputHexOk
	inc b
	cp 53
	jp z,InputHexOk
	inc b
	cp 54
	jp z,InputHexOk
	inc b
	cp 55
	jp z,InputHexOk
	inc b
	cp 56
	jp z,InputHexOk
	inc b
	cp 57
	jp z,InputHexOk
	inc b
	cp 65
	jp z,InputHexOk
	cp 97
	jp z,InputHexOk
	inc b
	cp 66
	jp z,InputHexOk
	cp 98
	jp z,InputHexOk
	inc b
	cp 67
	jp z,InputHexOk
	cp 99
	jp z,InputHexOk
	inc b
	cp 68
	jp z,InputHexOk
	cp 100
	jp z,InputHexOk
	inc b
	cp 69
	jp z,InputHexOk
	cp 101
	jp z,InputHexOk
	inc b
	cp 70
	jp z,InputHexOk
	cp 102
	jp z,InputHexOk

	jp Input1HexLoop

InputHexOk:
	ld e,b
	ld d,0
	ld hl,HexxData
	add hl,de

	ld a,(hl)

	call chput

	ld a,c
	sla a
	sla a
	sla a
	sla a
	add a,e

	ret

Input1HexEnter:
	ld a,c

	or a
	ret	

InputHexEscaped:
	scf

	ret

SearchScc:
; routine : Search for SCC.
; in      : none.
; out     : (scc)/16 = port where SCC is in.
; cmnt    : The search routine works as follows:
;
; First the slot is selected by changing the primairy port selections. After that a zero is
; poked at $9000 (the slot will be from $8000-$bfff). If we read it after that, and it is still
; zero, then NO SCC is found, because the SCC changes the value directly to another value. After
; that, the address $9000 is inversed (one's compliment) and then outted again, if it after that
; contains the same value as the first time that was read, then NO SCC is found. Else an SCC
; is found (because the SCC changes the value again, ofcourse).

	in a,($a8)								; get primair page selections

	push af								; save primair page selections

	and %11001111							; remove page 2 ($8000-$bfff)

	push af								; save that primair selection

	add a,%00010000							; first test in port 1
	call check								; test

	pop af								; get primair selection back

	push af

	add a,%00100000							; then test in port 2 (if none fnd.)
	call check								; test

	pop af

	push af

	add a,%00110000							; finally test in port 3
	call check								; test

	pop af

	pop af								; get original prim. selections back
 
	out ($a8),a								; out that!

	xor a
	ld (scc),a

	scf
	ret

;	Check routine...

check:
	out ($a8),a							; check port
	ld c,a							; save port before

	ld	a,$3f
	ld	($9000),a
	ld	a,($9000)
	cp	$3f
	ret	z

	push	de
	ld	a,($9800)
	ld	e,a
	cpl
	ld	d,a
	ld	($9800),a

	ld	a,($9800)
	cp	d
	jr	nz,noscc

	cpl
	ld	($9800),a
	cp	e
	jr	z,sccfnd

noscc:
	pop	de
	ret

sccfnd:
	pop	de
	ld a,c
	and %00110000
	ld (scc),a

	pop af							; call to check
	pop af							; port-data and $cf
	pop af							; port-data

	out ($a8),a

	or a
	ret

scc:
	.db 0

StSongName:
	.text "Blaffer NT              (C) 1999 TeddyWareZ              Blaffer NT"

;-----------------------------------------------------------------------------------------------
StandardSongData:
;		          1         2         3         4         5         6      6   
;            1234567890123456789012345678901234567890123456789012345678901234567
	.text "Blaffer NT              (C) 1999 TeddyWareZ              Blaffer NT"

;			    1 
;	       12345678901
	.text "BLAF_NT SBK"

	.db 0											; last position
	.db 1,0										; loop position

												; Patterns to play
	.db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15					; 16
	.db 16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31			; 32
	.db 32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47			; 48
	.db 48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63			; 64
	.db 64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79			; 80
	.db 80,81,82,0,0,0,0,0,0,0							; 90

	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 150
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 210
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0			; 256

	.db 21										; Initial tempo

	.db 15,15,15,15,15								; Start volumes

	.db 0,0,0,0										; Start instruments

	.db 128,128,128,128,128								; Detune settings

	.db 16,16,16,16,16								; Auto volume slides

EndStandardSongData:


;-----------------------------------------------------------------------------------------------

; ---- VRAM pointers! ----

VRAM_pointers:
PosPoint:
	.dw 80*5+75
PatPoint:
	.dw 80*6+76
RowPoint:
	.dw 80*7+76
LastPoint:
	.dw 80*9+75
LoopPoint:
	.dw 80*10+75
TempoPoint:
	.dw 80*11+76

SongEdit_pointers:
	.dw 80*5+75
	.dw 80*6+76
	.dw 80*7+76
	.dw 80*9+75
	.dw 80*10+75
	.dw 80*11+76

PatPos_pointers:
	.dw 80*5+76
	.dw 80*7+77
	.dw 80*9+77
	.dw 80*11+76
	.dw 80*13+76
	.dw 80*15+77

;---- End VRAM pointers
.end
; einde
