; TeddyWareZ MSX Z80 source file.
;
; Prog		: SCC Blaffer NT
; Code		: d-fader^TwZ.
; Date		: june 5, 1999
; Last Update	: july 8, 2001
;
; cmnt: 	0        User preferences
;		1          Edit screens
;		2            Sentences
;		3          Character set
;		4       PIE and disk-menus
;		5         Instrument Kit
;		6 Song editor and pat/pos editor
;		7       Instrument selector
;		8 Replayer and info/settings menu
;		9        Instrument editor
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#define BlafBdos(command)					  ld c,command
#defcont								\ call DoBdos

#include "macro's.asm"
#include "sb2rmacr.asm"

	.org $c000-7

	.db $fe
	.dw init_blaffer,end_program,init_blaffer

init_blaffer:
	jp start_program

	.ds 16-3-7

	.text "                "
	.text " SCC BLAFFER NT "
	.text "  (C) 1999 TwZ  "
	.text "                "
	.text "  Environment!  "
	.text "                "

start_program:

;dos2Map:
;	di
;	ld	hl,end_program
;	ld	bc,$ffff-end_program
;dos2map2:     
;	ld	a,$3a
;	cpir
;	jr	nz,dos2MapDone
;	inc	hl
;	ld	a,(hl)
;	cp	$f2
;	jr	nz,dos2map2
;	dec	hl
;	ld	a,(hl)
;	cp	$c8
;	jr	c,dos2map2
;	cp	$cb
;	jr	nc,dos2map2
;	dec	hl
;	ld	(hl),$db
;	inc	hl
;	ld	a,(hl)
;	sub	$c7
;	add	a,$fc
;	ld	(hl),a
;	inc	hl
;	ld	(hl),0
;	jr	dos2map2
;
;dos2MapDone:
;	ei
;
;	ld	a,($2d)
;	cp	3
;	jr	c,noTurboR
;	ld	a,128
;	call	$180
;noTurboR:
;--------------------------------------

	call Initialise

	ld b,$77							; change foreground color 1 itensity
	ld c,$07							;
	ld a,12							; number 12
	call ColorChg						;

	ld b,$00							; change background color 1 itensity
	ld c,$00							;
	ld a,13							; number 13
	call ColorChg						;

	ld b,$70							; change foreground color 1 itensity
	ld c,$07							;
	ld a,14							; number 13
	call ColorChg						;

	ld b,$30							; change foreground color 1 itensity
	ld c,$03							;
	ld a,15							; number 13
	call ColorChg						;

	Color(12,13,0)

	ld a,$ef							; Set blink to color 14,15
	vdp(12)							;

	ld a,$10							; 1/5 seconds on, 0 seconds off
	vdp(13)							;

	ld hl,($f323)
	ld (OriginalErrHand),hl
	
	ld hl,ErrorHandler
	ld ($f323),hl

; --- show loading screen ---

	ld a,2
	out ($fd),a

	Ram2Vram(0,0,$4000,8)

; --- till here ---

	call $44

	ld a,0
	ld hl,LoadSettings
	call LoadFile

; do all preferred settings.

	ld a,(set_intfreq)
	xor 1
	sla a

	ld b,a

	ld a,($ffe8)
	and %11111101
	or b
	ld ($ffe8),a

	vdp(9)		

	ld hl,set_fg1.1
	ld de,FGColor1
	ld bc,8
	ldir

	ld a,(FGColor1)						; change foreground color 1 itensity
	ld b,a							;
	ld a,(FGColor1+1)						;
	ld c,a							;
	ld a,12							; number 12
	call ColorChg						;

	ld a,(BGColor1)						; change background color 1 itensity
	ld b,a							;
	ld a,(BGColor1+1)						;
	ld c,a							;
	ld a,13							; number 13
	call ColorChg						;


	ld a,(FGColor2)						; change foreground color 2 itensity
	ld b,a							;
	ld a,(FGColor2+1)						;
	ld c,a							;
	ld a,14							; number 14
	call ColorChg						;

	ld a,(BGColor2)						; change background color 1 itensity
	ld b,a							;
	ld a,(BGColor2+1)						;
	ld c,a							;
	ld a,15							; number 15
	call ColorChg						;


	Color(12,13,0)						; same as in Basic

	ld a,$ef							; Set blink to color 14,15
	vdp(12)							;

	ld a,$10							; 1/5 seconds on, 0 seconds off
	vdp(13)							;


; --------------------

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c3
	ld hl,main_int

	di
	ld ($fd9f),a
	ld ($fda0),hl
	ei

LoadStart:
	ld a,1
	ld hl,Pictures						; pointer filename to load
	call LoadFile						; load the file

	Ram2Vram(3, $0000, $8000, 64)				; copy to VRAM page 3

	ld a,2
	ld hl,Hints							; pointer filename to load
	call LoadFile						; load the file

	ld a,7
	out ($fd),a

	ld a,2
	ld hl,ActiveHelp
	call LoadFile

	Ram2Vram(4,$0000,$4000,128)

	ld a,3
	ld hl,CharacterSet					; pointer filename to load
	call LoadFile						; load the file

	Ram2Vram(2, $0000, $8000, 64)				; copy to VRAM page 2


	ld a,4
	ld hl,PSG_editor
	call LoadFile

	ld a,5
	ld hl,InsKit
	call LoadFile

	ld hl,FileData.Name
	ld de,LoadedInsKit
	ld bc,11
	ldir

	ld a,6
	ld hl,SongEditor
	call LoadFile

	ld a,7
	ld hl,InsSelector
	call LoadFile

	ld a,8
	ld hl,Replayer
	call LoadFile

	ld a,7
	out ($fd),a

	ld a,9
	ld hl,InsEditor
	call LoadFile

	Ram2Vram(6,$0000,$4000,128)

	ld a,9
	ld hl,InsEditor.2
	call LoadFile

	Ram2Vram(7,$2a00,$4000,5)

	call LoadCharacterSet

	ld hl,(OriginalErrHand)
	ld ($f323),hl

	call ClearBlink

main:
	ld a,2						; Song Edit Menu
	call DoMenu

stop_code:
	call DeInitialise

	ld hl,oldint
	ld de,$fd9f
	ld bc,5
	di
	ldir
	ei

	ret

main_int:
	ScanKey(select)
	jp z,frq_change

	xor a
	ld (sel_key),a

sel_done:

oldint:
	.ds 5

frq_change:
	ld a,(sel_key)
	or a
	jp nz,sel_done

	inc a
	ld (sel_key),a
	
	ld a,($ffe8)
	xor 2
	ld ($ffe8),a
	vdp(9)

	jp sel_done

sel_key:
	.db 0


Initialise:
; routine : set page 1 as memory bank
; in	    : none.
; out     : in (primair) and (secondare) are the slot selections init..
;		in (page1map) is the init of page 1.. In (OrgDrive) is the original drive
; cmnt    : those bytes are to set everythin' normal again.

	ld a,80							; width 80
	ld ($f3ae),a						; 

	xor a								; disable key click
	ld ($f3db),a						;

	call eraFnk							; erase function keys

	ld a,(CurDrive)
	ld (OrgDrive),a

	call ClearBlink						; clear Blink mode

	xor a
	call chgmod

	call disscr							; disable screen
	
	di								; disable interrupts

	in a,($a8)							; get primair slot selections

	ld b,a							; in b

	ld (primair),a						; save primair slot selections

	ld a,($ffff)
	cpl								; inverse (1's compliment)
	ld (secondare),a						; save secondare slot selections

	in a,($fd)							; save page 1
	ld (page1map),a						; 

	in a,($fe)							; save page 2
	ld (page2map),a						;

	ld a,($f342)		
	and %00000011						; get primair selection of page 1 (RAM)
	sla a
	sla a								; rotate it to primair selection.
	ld c,a							; for save keepin'

	ld a,b							; get primair selection again.
	and %11110011						; get rid of primair selection of page 1

	or c								; get our primair selection in it..

	out ($a8),a							; out it!

	ld a,(secondare)						; get secondare slot selection
	and %11110011						; get rid of secondare slot sel. of page 1
	ld b,a							; save it

	ld a,($f342)
	and %00001100						; get secondare selection (page 1)..
	or b								; get our secondare selection in it!
	ld ($ffff),a						; out it!
	
	call ClearBlink

	ei

	ret

LoadCharacterSet:
	ld hl,$3800
	ld (VramSource),hl

	ld hl,$1000
	ld (VramDest),hl

	ld b,8
LoadChrSet.1:
	push bc

	ld a,2
	ld hl,(VramSource)
	call SetVramRead

	ld hl,ChrSetData
	ld bc,$0098
	inir

	xor a
	ld hl,(VramDest)
	call SetVramWrite

	ld hl,ChrSetData
	ld bc,$0098
	otir

	pop bc

	ld hl,(VramSource)
	ld de,256
	add hl,de
	ld (VramSource),hl

	ld hl,(VramDest)
	add hl,de
	ld (VramDest),hl

	djnz LoadChrSet.1

	ret

VramSource:
	.dw 0
VramDest:
	.dw 0

ChrSetData:
	.ds 256

; with port $fd you can change the RAM block..

Pictures:
	.db 6
	.db "BLAF_NT 001"
	.dw $8000
	.db 0

Hints:
	.db 6
	.db "BLAF_NT 002"
	.dw $8000
	.db 0

ActiveHelp:
	.db SngBnk
	.db "BLAF_NT 006"
	.dw $4000
	.db 0

CharacterSet:
	.db 6
	.db "BLAF_NT 003"
	.dw $c000-2048
	.db 7

PSG_editor:
	.db 5
	.db "BLAF_NT 010"						; PSG editor + disk menu
	.dw $8000
	.db 0

SongEditor:
	.db 2
	.db "BLAF_NT 011"						; Song editor + Pattern/Position menu
	.dw $8000
	.db 0

InsSelector:
	.db 6
	.db "BLAF_NT 012"						; Instrument Selector
	.dw $8000
	.db 0

Replayer:
	.db 1
	.db "BLAF_NT 013"
	.dw $8200
	.db 0

InsKit:
	.db InsBnk
	.db "BLAF_NT SBK"
	.dw $8000
	.db 16

LoadSettings:
	.db 1
	.db "BLAF_NT 004"
	.dw PredSettings-16
	.db 0

InsEditor:
	.db SngBnk
	.db "BLAF_NT 022"
	.dw $4000
	.db 7

InsEditor.2:
	.db SngBnk
	.db "BLAF_NT 023"
	.dw $4000
	.db 4

#include "sb2rmain.asm"


DataBeforeDoMenu:
	.ds $cd00-DataBeforeDoMenu

GetRCData:
; routine : Get 4 bytes of RC data, so you can check whether if an ROM is stored.
; in      : a - slot (1 or 2)
; out     : 4 bytes in (RCData), z if it is an RC number, nz if not.
; cmnt    : none.

	sla a
	sla a

	ld b,a

	in a,($a8)

	push af	

	and %11110011
	or b

	out ($a8),a

	ld hl,$4010
	ld de,RCData
	ld bc,4
	ldir

	pop af

	out ($a8),a


	ld a,65
	call CheckRC
	ret z

	ld a,67
	call CheckRC
	ret z

	ld a,69
	call CheckRC
	ret z

	ld a,1
	or a
	ret

CheckRC:
	ld b,a
	ld a,(RCData)
	cp b
	ret nz

	inc b

	ld a,(RCData+1)
	cp b
	ret

RCDataSave:
	.db 0

GetRCDataEnd:

InsertHandler:
	.ds $cd50-GetRCDataEnd



FreeData:
	.ds $cf00-Freedata

_DoMenu:
; routine : Call another menu
; in      : a - menu (see below for numbers)
; out     : none.
; cmnt    : it's a call! (there must be RETted)

	sla a
	sla a
	ld e,a
	ld d,0

	in a,($fd)

	push af

	ld hl,Menus
	add hl,de

	ld a,(hl)
	out ($fd),a

	inc hl

	ld e,(hl)
	inc hl
	ld d,(hl)

	ex de,hl

	ld de,DoMenuDone

	push de
	jp (hl)	

DoMenuDone:
	pop af

	out ($fd),a

	ret

Menus:
; Menu storage: as followed
; 
; byte    1: Bank
; byte 2..3: Address
; byte    4: The Y line where the description stands


; PSG Instrument Menu 			(0)
	.db 5
	.dw $4000
	.db 0

; Disk Menu 				(1)
	.db 5
	.dw $5b00
	.db 0

; Song Edit Menu 				(2)
	.db 2
	.dw $4000
	.db 0

; Instrument Selector Menu 		(3)
	.db 6
	.dw $4000
	.db 0

; Replayer					(4)
	.db 1
	.dw ReplayerAddress
	.db 0

Loading:
	.ds $d000-Loading

LoadFile:
	ld de,FileData.start
	ld bc,FileData.end-FileData.start
	ldir

	ld (DescYBar),a
	call ShowFileBar

	SetVW(0,80*16+28)

	ld a,(FileData.Name+8)
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld a,(FileData.Name+9)
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld a,(FileData.Name+10)
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld a,0
	call ShowStatusBar

LoadFile.1:
	ld hl,clear_fcb
	ld de,clear_fcb+1
	ld bc,24
	ld (hl),0
	ldir

	ld a,(FileData.bank)
	out ($fe),a							; memory bank to store data

	ld hl,FileData.name					; Copy filename to fcb
	ld de,BlafFileName					;
	ld bc,11							;
	ldir								;

	ld a,0
	call ShowActionBar

	ld de,BlafFcb						; open file
	BlafBdos(open)						;
	jp c,Blaf.ErrorFile					;
	or a								;
	jp nz,Blaf.FileNotFound					;

	ld a,1
	call ShowActionBar

	ld a,0							; Alright!
	call ShowStatusBar					;

	ld hl,1							; set record length to 1
	ld (rec_length),hl					;

	ld hl,(file_size)

	ld a,(FileData.Header)
	or a
	jp z,LoadFile.NoHeader

	ld e,a
	ld d,0
	ld hl,(FileData.Pointer)
	ex de,hl
	call LoadFile.read
	jp c,Blaf.ErrorFile

	ld hl,(file_size)
	ld a,(FileData.Header)
	cpl
	inc a
	ld e,a
	ld d,$ff
	add hl,de
LoadFile.NoHeader:
	push hl
	ld hl,(FileData.Pointer)
	push hl
	pop de
	pop hl

	call LoadFile.read
	jp c,Blaf.ErrorFile

	ld a,2
	call ShowActionBar

	ld de,BlafFCB
	BlafBdos(close)							; close file
	jp c,Blaf.ErrorFile

	ei
	halt
	halt
	halt
	halt
	halt
	halt
	halt
	halt
	halt
	halt

	ret

Blaf.ErrorFile:
	ld a,($f414)

	ld c,1

	cp Err_DiskOffline
	jp z,Blaf.ErrorFound

	inc c
Blaf.ErrorFound:
	ld a,c
	call ShowStatusBar

	jp LoadFile.1

Blaf.FileNotFound:
	ld a,3
	call ShowStatusBar

	jp LoadFile.1

LoadFile.read:
; routine : Read (part of) file
; in      : DE - Destination address, HL - Number of records
; out     : none.
; cmnt    : none.

	push hl

	BlafBdos(set_dma)

	pop hl

	ld de,BlafFCB
	BlafBdos(rnd_br)

	ret

LoadFile.write:
; routine : Write data to file
; in      : DE - Source address, HL - Number of records
; out     : none.
; cmnt    : none.

	push hl

	BlafBdos(set_dma)

	pop hl

	ld de,BlafFCB
	BlafBdos(rnd_bw)

	ret

; Load file data's: stored as follows:
; byte 01..11 (....): Filename and extension
; byte     12 (byte): RAM bank to store data in.
; byte 13..14 (word): Address to store data in.
; byte     15 (byte): Header of file

FileData.start:
FileData.bank:
	.db 0
FileData.name:
	.ds 11
FileData.Pointer:
	.dw 0
FileData.Header:
	.db 0
FileData.end:

DescYBar:
	.db 0


;!!!!!!!
BlafFcb:
	.db    0
BlafFilename:
	.db    "???????????"
clear_fcb:
	.db    0,0
rec_length:
	.db    0,0
file_size:
	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0
	.db    0

; till here fcb!!

ShowFileBar:
	ld b,a
	ld a,(FileBar)
	cp b
	ret z
	cp 255
	jp z,FirstFileBar

	push bc

	add a,2
	ld e,a
	ld d,24
	ld a,33
	call DrawBar

	pop bc

FirstFileBar:
	ld a,b

	ld (FileBar),a

	add a,2
	ld e,a
	ld d,24
	ld a,33
	call DrawBar

	ret

ShowActionBar:
	ld b,a

	ld a,(ActionBar)
	cp b
	ret z
	cp 255
	jp z,FirstActionBar

	push bc

	add a,16
	ld e,a
	ld d,34
	ld a,9
	call DrawBar

	pop bc

FirstActionBar:
	ld a,b

	ld (ActionBar),a

	add a,16
	ld e,a
	ld d,34
	ld a,9
	call DrawBar

	ret

ShowStatusBar:
	ld b,a

	ld a,(StatusBar)
	cp b
	ret z
	cp 255
	jp z,FirstStatusBar

	push bc

	add a,15
	cp 15
	jp z,ShowStatusBar.1

	inc a
ShowStatusBar.1:
	ld e,a
	ld d,44
	ld a,16
	call DrawBar

	pop bc

FirstStatusBar:
	ld a,b

	ld (StatusBar),a

	add a,15
	cp 15
	jp z,ShowStatusBar.2

	inc a
ShowStatusBar.2:
	ld e,a
	ld d,44
	ld a,16
	call DrawBar

	ret

FileBar:
	.db 255
ActionBar:
	.db 255
StatusBar:
	.db 255

	.org $d200


SaveSettings:
	ShowHint(152)

	ld hl,($f323)
	ld (OriginalErrHand),hl
	
	ld hl,ErrorHandler
	ld ($f323),hl

	ld hl,clear_fcb
	ld de,clear_fcb+1
	ld bc,24
	ld (hl),0
	ldir

	ld hl,SettingsName					; Copy filename to fcb
	ld de,BlafFileName					;
	ld bc,11							;
	ldir								;

	ld de,BlafFcb						; open file
	BlafBdos(create)						;
	jp c,SSet.ErrorFile					;
	or a								;
	jp nz,SSet.DiskFull					;

	ld hl,1							; set record length to 1
	ld (rec_length),hl					;

	ld de,SettingsHeader
	ld hl,16
	call LoadFile.Write

	jp c,SSet.ErrorFile
	or a
	jp nz,SSet.DiskFull

	ld de,PredSettings
	ld hl,16
	call LoadFile.Write

	jp c,SSet.ErrorFile
	or a
	jp nz,SSet.DiskFull

	ld de,BlafFCB
	BlafBdos(close)							; close file
	jp c,Blaf.ErrorFile
	or a
	jp nz,SSet.DiskFull

SSet.Done:
	ld hl,(OriginalErrHand)
	ld ($f323),hl

	ret

SSet.DiskFull:
	ShowHint(157)

	call kilbuf
	call chget

	jp SSet.Done

SSet.ErrorFile:
	ld a,($f414)

	ld c,153
	cp Err_DiskOffline
	jp z,SSet.ErrorFound

	inc c
	cp Err_DiskIOError
	jp z,SSet.ErrorFound

	inc c
	cp Err_WriteProtect
	jp z,SSet.ErrorFound

	inc c
SSet.ErrorFound:
	ld a,c
	call DoShowHint

	call kilbuf
	call chget

	jp SSet.Done

SettingsName:
	.db "BLAF_NT 004"

SettingsHeader:
	;    1234567890123456
	.db "Blaf NT Settings"

ErrorHandler:
	.dw ErrorHandler.1
ErrorHandler.1:
	ld a,c
	and %00001110

	ld ($f414),a

	ld a,(PrimairPageSave)
	out ($a8),a
	ld a,(SecondarePageSave)
	ld ($ffff),a

	ld sp,(StackSave)

	scf
	ret
EndErrorHandler:

DoBdos:
	in a,($a8)
	ld (PrimairPageSave),a

	ld a,($ffff)
	cpl
	ld (SecondarePageSave),a

	ld (StackSave),sp
	call bdos_call

	or a
	ret

OriginalErrHand:
	.dw 0

extraEmptyData1:
	.ds $d400-extraEmptyData1

OneRowData:
	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 1
	.db 22			; |

	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
	.db 22			; |

	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 2
	.db 22			; |

	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
	.db 22			; |

	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 3
	.db 22			; |

	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
	.db 22			; |

	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 4 
	.db 22			; |

	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
	.db 22			; |

	.ds 3				; Note (or command such as pitch sliding and stuff) Channel 5
	.db 22			; |

	.ds 2				; For note: Volume ($00..$0f) For command: Value of command
	.db 22			; |

	.ds 3				; PSG command (number or nothing)
	.db 22,22			; ||

	.ds 5				; Command (such as Tempo, EndOp, etc.)

					; in total: (5*7) + 5 + 5 = 45 bytes.

NoteCommand:
	.text " -  "
		     
	.text "C 1 C#1 D 1 D#1 E 1 F 1 F#1 G 1 G#1 A 1 A#1 B 1 "				;  1-12
	.text "C 2 C#2 D 2 D#2 E 2 F 2 F#2 G 2 G#2 A 2 A#2 B 2 "				; 13-24
	.text "C 3 C#3 D 3 D#3 E 3 F 3 F#3 G 3 G#3 A 3 A#3 B 3 "				; 25-36
	.text "C 4 C#4 D 4 D#4 E 4 F 4 F#4 G 4 G#4 A 4 A#4 B 4 "				; 37-48
	.text "C 5 C#5 D 5 D#5 E 5 F 5 F#5 G 5 G#5 A 5 A#5 B 5 "				; 49-60
	.text "C 6 C#6 D 6 D#6 E 6 F 6 F#6 G 6 G#6 A 6 A#6 B 6 "				; 61-72
	.text "C 7 C#7 D 7 D#7 E 7 F 7 F#7 G 7 G#7 A 7 A#7 B 7 "				; 73-84
	.text "C 8 C#8 D 8 D#8 E 8 F 8 F#8 G 8 G#8 A 8 A#8 B 8 "				; 85-96

OffEvent:
	.text "OFF "											; 97

	.text "Ins "											; 98

	.text "P1+ "											; 99
	.text "P1- "											; 100

	.text "P2+ "											; 101
	.text "P2- "											; 102

	.text "M + "											; 103
	.text "M - "											; 104

	.text "DT+ "											; 105
	.text "DT- "											; 106

	.text "VS+ "											; 107
	.text "VS- "											; 108

	.text "AS+ "											; 109
	.text "AS- "											; 110

PSGCommandData:
;	.text " -  "
;	.text "#01 #02 #03 #04 #05 #06 #07 #08 #09 #10 #11 "
;	.text "#12 #13 #14 #15 #16 #17 #18 #19 #20 #21 #22 "
;	.text "#23 #24 #25 #26 #27 #28 #29 #30 #31 #32 #33 "
;	.text "#34 #35 #36 #37 #38 #39 #40 #41 #42 #43 #44 "

	.text " -  "
	.text "  1   2   3   4   5   6   7   8   9  10  11 "
	.text " 12  13  14  15  16  17  18  19  20  21  22 "
	.text " 23  24  25  26  27  28  29  30  31  32  33 "
	.text " 34  35  36  37  38  39  40  41  42  43  44 "

CommandData:
	.text " ---    "								;     00
	.text "Tmp 1   Tmp 2   Tmp 3   Tmp 4   Tmp 5   "		; 01..05
	.text "Tmp 6   Tmp 7   Tmp 8   Tmp 9   Tmp10   "		; 06..10
	.text "Tmp11   Tmp12   Tmp13   Tmp14   Tmp15   "		; 11..15
	.text "Tmp16   Tmp17   Tmp18   Tmp19   Tmp20   "		; 16..20
	.text "Tmp21   Tmp22   Tmp23   Tmp24   Tmp25   "		; 21..25

	.text "EndOP   "								;     26

	.text "TRP-6   TRP-5   TRP-4   TRP-3   TRP-2   "		; 27..31
	.text "TRP-1   TRP+0   TRP+1   TRP+2   TRP+3   "		; 32..36 (0 = 33)
	.text "TRP+4   TRP+5   TRP+6   "					; 37..39

	.text "PMV 0   PMV 1   PMV 2   PMV 3   "				; 40..43
	.text "PMV 4   PMV 5   PMV 6   PMV 7   "				; 44..47
	.text "PMV 8   PMV 9   PMV10   PMV11   "				; 48..51
	.text "PMV12   PMV13   PMV14   PMV15   "				; 52..55
end_program:

.end
;
