; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer 2.0 routines.
; Code: d-fader^TwZ.
; Date: june 5, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

; #include "macro's.asm"

ClearBlink:
; routine : Clear on screen blinks
; in      : none.
; out     : none.
; cmnt    : none.

	ld a,0
	ld hl,$800
	call SetVramWrite

	xor a								; clear blink
	ld b,240							; (24*80)/8 = 240 (1 bit per character)
									;
ClearBlinkLoop1:							;
	out ($98),a							;
									;
	ex (sp),hl							; Wait for 'slow' VDP
	ex (sp),hl							;

	djnz ClearBlinkLoop1					;

	ret

FGColor1:
	.db $77, $07						; white
BGColor1:
	.db $00, $00						; black
FGColor2:
	.db $77, $07						; bright yellow
BGColor2:
	.db $56, $00 						; dark yellow

DeInitialise:
; routine : return all memory states as they were.
; in      : none.
; out     : none.
; cmnt    : none.

	ld a,(page1map)
	out ($fd),a

	ld a,(page2map)
	out ($fe),a

	ld a,(secondare)
	ld ($ffff),a

	ld a,(primair)
	out ($a8),a

	ld a,(OrgDrive)
	ld (CurDrive),a

	ret

primair:
	.db 0
secondare:
	.db 0
page1map:
	.db 0
page2map:
	.db 0
OrgDrive:
	.db 0

ColorChg:
; routine : Change the intensity of a specific color.
; in      : A - Color number, B - Red and Blue, C - Green
; out     : none
; cmnt    : none.

	vdp(16)

	ex (sp),hl
	ex (sp),hl

	ld a,b
	out ($9a),a
	ld a,c
	out ($9a),a

	ret

DrawBar:
; routine : Draw highlight bar
; in      : A - length, D - x-pos (1..80), E - y-pos (1..24)
; out     : none.
; cmnt    : XOR routine, so if bar is already on it's turned off.

	
	ex af,af'

	ld hl,$0800-10						; calculate y address
									;
	ld bc,10							;
DrawBarLoop1:							;
	add hl,bc							;
									;
	dec e								;
	jr nz,DrawBarLoop1					;

	dec d								; x from 0 to 79
	ld a,d							; calculate x address (whole)
	and %11111000						;
	srl a								;
	srl a								;
	srl a								;

	add_hl_a							; add the address to the offset

	; HL now had the right offset.

	ld a,d							; get bit offset in a
	and %00000111						;

;		76543210
	ld d,%10000000						; start offset

	or a
	jr z,DrawBarNoOffset


	ld b,a

DrawBarOffsetLoop:
	srl d								; get > bit offset in d

	djnz DrawBarOffsetLoop					; until found.

DrawBarNoOffset:
	ex af,af'							; get length back in a
	ld b,a							; number of times.

	xor a								; the bits to be set

DrawBarNoOffsetLoop1:
	; HL has the right address
	;  D has de right bit offset

	or d								; make bit 1
	srl d								; rotate >
	jr nc,DrawBarNoVRAMOut					; if all bits done, then out byte

	ex af,af'							; save A (all bits set)

	xor a								; page 0
	call SetVramRead						; HL has > offset

	in a,($98)							; get original byte
	ld e,a							; put it in e

	ex af,af'							; get our A back

	xor e								; set and reset bits (swap)

	ex af,af'							; save the new byte

	xor a								; page 0
	call SetVramWrite						; HL has > offset

	ex af,af'							; get new byte back

	out ($98),a							; finally out byte.

	inc hl							; increase pointer

	ld d,%10000000						; start bit set.
	xor a								; a = 0

DrawBarNoVRAMOut:
	djnz DrawBarNoOffsetLoop1

	or a								; check if it's neccesssary to out A
	ret z								; nope, bar is done!

									; out last part (if neccessary)
	ex af,af'							; save A (all bits set)

	xor a								; page 0
	call SetVramRead						; HL has > offset

	in a,($98)							; get original byte
	ld e,a							; put it in e

	ex af,af'							; get our A back

	xor e								; set and reset bits (swap)

	ex af,af'							; save the new byte

	xor a								; page 0
	call SetVramWrite						; HL has > offset

	ex af,af'							; get new byte back

	out ($98),a							; finally out byte.

	ret								; and the Bar is done!

ShowPicture:
; routine : Show picture on screen.
; in      : a - picture number (0..7)
; out     : none.
; cmnt    : Pictures stored in page 3 of VRAM

	ld hl,-(24*80)
	ld de,24*80

	inc a
	ld b,a

ShowPictureLoop1:
	add hl,de
	djnz ShowPictureLoop1

ShowPictureNULL:
	ld de,0

;	HL - offset source (24 * 80 * picture number)
;	DE - offset destination (0)

	ld b,8
ShowPictureLoop2:
	push bc						; save counter

	ld a,3						; Set VRAM pointer to source (page 3)
	call SetVramRead					;

	ld bc,240						; Give HL the new pointer
	add hl,bc						; 


	push hl						; Save source pointer

	ld hl,SaveData					; Move data from VRAM to main RAM
	ld bc,$f098						;
	inir							;

	ex de,hl						; Get Write offset in HL
	xor a							; Page 0
	call SetVramWrite					; Set VRAM pointer

	ld bc,240						; Give DE the new pointer
	add hl,bc						;
	ex de,hl						;

	ld bc,$f098						; Put part of picture on screen.
	ld hl,SaveData					;
	otir							;

	pop hl						; Get Source pointer back
	pop bc						; Get counter back

	djnz ShowPictureLoop2				; continue next part

	ret

SaveData:
	.ds 240

DoShowHint:
; routine : Show a Hint on screen.
; in      : a - hint number
; out     : none.
; cmnt    : Cursor is set after scentence if second byte of scentence <> 0
;
;		build: byte 0     : length in characters
;			 byte 1     : Set cursor pos after scentence?? 1=yes
;			 byte 2..79 : The scentence

	inc a
	ld b,a

	ld hl,-80
	ld de,80
ShowHintLoop1:
	add hl,de

	djnz ShowHintLoop1

	ld a,2
	call SetVramRead

	ld hl,HintData
	ld bc,$5098
	inir

	SetVW(0,22*80+1)

	ld hl,HintScen

	ld a,(HintLength)
	ld b,a
	ld c,$98

	otir

	ld a,(HintLength)
	ld b,a

	ld a,78
	sub b

	ld b,a

	ld a,32
ShowHintLoop2:
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	djnz ShowHintLoop2

	ld a,(HintSetCursor)
	or a
	ret z

	ld a,(HintLength)
	inc a
	inc a

	ld h,a
	ld l,23
	ld (curloc),hl

	ret

HintData:
HintLength:
	.db 0
HintSetCursor:
	.db 0
HintScen:
	.ds 78

ScanHexKey:
	ld c,0

	ld a,($fbe5)
	bit 0,a
	jp z,HexPositive
	
	inc c

	bit 1,a
	jp z,HexPositive
	
	inc c

	bit 2,a
	jp z,HexPositive
	
	inc c

	bit 3,a
	jp z,HexPositive
	
	inc c

	bit 4,a
	jp z,HexPositive
	
	inc c

	bit 5,a
	jp z,HexPositive
	
	inc c

	bit 6,a
	jp z,HexPositive
	
	inc c

	bit 7,a
	jp z,HexPositive
	
	inc c

	ld a,($fbe6)
	bit 0,a
	jp z,HexPositive

	inc c

	bit 1,a
	jp z,HexPositive

	inc c

	ld a,($fbe7)
	bit 6,a
	jp z,HexPositive

	inc c

	bit 7,a
	jp z,HexPositive

	inc c

	ld a,($fbe8)

	bit 0,a
	jp z,HexPositive

	inc c

	bit 1,a
	jp z,HexPositive

	inc c

	bit 2,a
	jp z,HexPositive

	inc c

	bit 3,a
	jp z,HexPositive

	scf
	ret

HexPositive:
	ld a,c
	or a

	ret

ScanDecKey:
	ld c,0

	ld a,($fbe5)
	bit 0,a
	jp z,DecPositive
	
	inc c

	bit 1,a
	jp z,DecPositive
	
	inc c

	bit 2,a
	jp z,DecPositive
	
	inc c

	bit 3,a
	jp z,DecPositive
	
	inc c

	bit 4,a
	jp z,DecPositive
	
	inc c

	bit 5,a
	jp z,DecPositive
	
	inc c

	bit 6,a
	jp z,DecPositive
	
	inc c

	bit 7,a
	jp z,DecPositive
	
	inc c

	ld a,($fbe6)
	bit 0,a
	jp z,DecPositive

	inc c

	bit 1,a
	jp z,DecPositive

	scf
	ret

DecPositive:
	ld a,c
	or a

	ret

YesOrNo:
	ld hl,(curloc)
	call chget
	ld (curloc),hl
	
	ScanKey(key_y)
	ret z

	ScanKey(return)
	ret z

	ScanKey(key_n)
	jp z,YesOrNoDone

	ScanKey(escape)
	jp z,YesOrNoDone

	jp YesOrNo
YesOrNoDone:
	ld a,1
	or a
	ret

Calc16Dec:
; routine : Calculate 16 bits decimal
; in      : hl - number
; out     : decimal: the decimal value (5 bytes)
; cmnt    : none
	ld de,10000
	call Calc16DecLoop
	ld (decimal),a

	ld de,1000
	call Calc16DecLoop
	ld (decimal+1),a

	ld de,100
	call Calc16DecLoop
	ld (decimal+2),a

	ld de,10
	call Calc16DecLoop
	ld (decimal+3),a

	ld de,1
	call Calc16DecLoop
	ld (decimal+4),a

	ret

Calc16DecLoop:
	or a
	ld c,48

Calc16DecLoop1:
	or a

	sbc hl,de
	
	jr c,Calc16DecLoopDone

	inc c

	jr Calc16DecLoop1

Calc16DecLoopDone:
	add hl,de

	ld a,c

	ret

Calc8Dec:
; routine : Calculate 8 bits decimal
; in      : a - number
; out     : decimal: the decimal value (3 bytes)
; cmnt    : none

	ld hl,decimal

Calc8Dec2:
	ld c,48
Calc3DecLoop:
	sub 100

	jr c,Calc3DecDone

	inc c

	jr Calc3DecLoop

Calc3DecDone:
	add a,100

	ld (hl),c
	inc hl

	ld c,48
Calc2DecLoop:
	sub 10

	jr c,Calc2DecDone

	inc c

	jr Calc2DecLoop

Calc2DecDone:
	add a,10

	ld (hl),c
	inc hl


	ld c,48
Calc1DecLoop:
	sub 1

	jr c,Calc1DecDone

	inc c

	jr Calc1DecLoop

Calc1DecDone:
	ld (hl),c

	ret

Calc2Hex:
; routine : Calculate Hexadecimal number
; in      : a - number
; out     : HexaDecimal: hex number (2 bytes)
; cmnt    : When calling to Calc2HexOwnAdr, then IX is the address where to put the number.
;           (in stead of Hexadecimal)


	ld ix,HexaDecimal
Calc2HexOwnAdr:
	push af

	exx

	ld b,a

	and $f0

	srl a
	srl a
	srl a
	srl a

	ld e,a
	ld d,0
	ld hl,HexxData

	add hl,de

	ld a,(hl)
	ld (ix+0),a

	ld a,b

	and $0f

	ld e,a
	ld d,0
	ld hl,HexxData

	add hl,de

	ld a,(hl)
	ld (ix+1),a

	exx 

	pop af

	ret

Calc3Hex:
; routine : Show a 3 digit Hex number
; in      : HL - number
; out     : HexaDecimal: hex number (3 bytes)
; cmnt    : none
	ld b,l

	ld a,h
	and $0f

	ld d,0

	ld e,a
	ld hl,HexxData
	add hl,de

	ld a,(hl)
	ld (HexaDecimal),a

	ld a,b
	and $f0
	srl a
	srl a
	srl a
	srl a
	ld e,a
	ld hl,HexxData
	add hl,de

	ld a,(hl)
	ld (HexaDecimal + 1),a

	ld a,b
	and $0f
	ld e,a

	ld hl,HexxData
	add hl,de

	ld a,(hl)
	ld (HexaDecimal + 2),a

	ret

Decimal: 
	.ds 5
HexaDecimal:
	.ds 4

HexxData:
	.text "0123456789ABCDEF"

CompareStrings:
; routine : Compare 2 strings.
; in      : DE - Pointer to first string, HL - Pointer to second string, A - length of string
; out     : Z if identical, NZ if not.
; cmnt    : none.
	ld b,a

CompareStringsLoop:
	ld a,(de)
	cp (hl)
	ret nz

	inc hl
	inc de

	djnz CompareStringsLoop

	xor a
	ret

input_text:
; routine : input text, with nice bar.
; in      : hl - pointer to information of text, (input_dotstop) - if <> 0 then a dot also stops
; out     : none.
; cmnt    : data must be stored as follows:
;
;		byte    0       : x-pos
;		byte    1       : y-pos
;		byte    2       : maximum length of input
;		byte 3..4       : pointer to text
;		byte    5       : minimum value of each ascii char.
;		byte    6       : maximum value of each ascii char.
;		byte 7..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	
	ld (input_org),hl

	push hl
	pop ix

	ld d,(ix)
	ld e,(ix+1)
	ld a,(ix+2)

	push de

	call DrawBar

	pop hl

	ld (curloc),hl

	ld l,(ix+3)
	ld h,(ix+4)

	ld (input_tp),hl

	ld e,(ix+2)
	dec e
	ld d,0
	add hl,de

	ld b,(ix+2)
input_loop1:
	ld a,(hl)

	cp 32
	jp nz,input_loop1done

	dec hl

	djnz input_loop1

input_loop1done:
	ld a,b
	ld (input_to),a

	ld hl,(curloc)
	ld a,h
	add a,b
	ld h,a
	ld (curloc),hl

	ld hl,(input_tp)
	ld a,(input_to)
	ld e,a
	ld d,0
	add hl,de

input_loop2:
	call kilbuf
	call chget

	cp 8
	jp z,DoBackSpace

	cp 13
	jp z,input_loop2done

	ld b,a

	ld a,(input_dotstop)
	or a
	jp z,NoDotCheck

	ld a,b
	cp 46
	jp z,input_loop2done

NoDotCheck:
	ld a,(input_to)
	cp (ix+2)
	jp z,input_loop2

	ld a,b

	cp (ix+5)
	jp c,input_loop2

	ld b,(ix+6)
	inc b
	cp b
	jp nc,input_loop2

	ld (input_keysave),a

	push ix
	pop hl

	ld de,7
	add hl,de

	ex de,hl

	ld hl,input_keysave

input_chkill_loop:
	ld a,(de)
	or a
	jp z,input_chkill_done

	cp (hl)
	jp z,input_loop2

	inc de

	jp input_chkill_loop

input_chkill_done:
	ld a,(input_keysave)

	push af
	ld hl,(input_tp)
	ld a,(input_to)
	ld e,a
	inc a
	ld (input_to),a
	ld d,0
	add hl,de
	pop af

	ld (hl),a

	call chput

	jp input_loop2

input_keysave:
	.db 0
input_dotstop:
	.db 0

DoBackSpace:
	ld a,(input_to)
	or a
	jp z,input_loop2
	dec a
	ld (input_to),a

	ld hl,(curloc)
	dec h
	ld (curloc),hl

	ld a,32
	call chput

	ld hl,(curloc)
	dec h
	ld (curloc),hl

	ld a,(input_to)
	ld e,a
	ld d,0
	ld hl,(input_tp)
	add hl,de
	ld (hl),32

	jp input_loop2


input_loop2done:
	ld d,(ix)
	ld e,(ix+1)
	ld a,(ix+2)

	call DrawBar

	ret

input_org:
	.dw 0
input_tp:
	.dw 0	
input_to:
	.db 0



OnlyOneKey:
	ld hl,$fbe5
	ld b,11
	ld e,-1
OnlyOneKeyLoop1:
	push bc

	ld a,(hl)
	ld b,8
	ld d,$80
OnlyOneKeyLoop2:
	push af

	and d
	jp nz,OnlyOneKeyLoop2Done

	inc e
OnlyOneKeyLoop2Done:		
	srl d

	pop af

	djnz OnlyOneKeyLoop2

	pop bc

	inc hl

	djnz OnlyOneKeyLoop1

	ld a,e
	or a
	ret

AnyKey:
	ei

	ld bc,$0b00
	ld hl,$fbe5
AnyKeyLoop:
	ld a,(hl)
	cp 255
	jr z,AnyKey1

	ld c,1
AnyKey1:
	inc hl
	djnz AnyKeyLoop

	dec c
	ret z

	jp AnyKey

NoKey:
	ei

	ld bc,$0b01
	ld hl,$fbe5
NoKeyLoop:
	ld a,(hl)
	cp 255
	jr z,NoKey1

	ld c,0
NoKey1:
	inc hl
	djnz NoKeyLoop

	dec c
	ret z

	jp NoKey




CopyRamVram:
; routine : Copy part of RAM to VRAM.
; in      : A - VRAM page, DE - Offset VRAM (destination), HL - Source pointer, B - Number of
;		256 Bytes Blocks
; out     : none.
; cmnt    : none.

	push hl

	ex de,hl

	call SetVramWrite

	pop hl

	ld d,b
	ld c,$98

CopyRamVramLoop1:
	ld b,$00	
	otir

	dec d
	jr nz,CopyRamVramLoop1

	ret

SetVramWrite:
; routine : Set Vram Pointer in write mode.
; in      : A - page, HL - offset
; out     : none.
; cmnt    : none.

	di

	out ($99),a					; out page to register #14 of the VDP
	ld a,14+128					;
	out ($99),a					;

	ld a,l					; Get LSB of offset
	out ($99),a					; out to VDP

	ld a,h					; Get MSB of offset

	and $3f					; clear last two bits
	or $40					; set bit 6 (write)

	out ($99),a					; iut to VDP

	ei

	ret

SetVramRead:
; routine : Set Vram Pointer in write mode.
; in      : A - page, HL - offset
; out     : none.
; cmnt    : none.

	di

	out ($99),a					; out page to register #14 of the VDP
	ld a,14+128					;
	out ($99),a					;

	ld a,l					; Get LSB of offset
	out ($99),a					; out to VDP

	ld a,h					; Get MSB of offset
	out ($99),a					; out to VDP

	ei

	ret

.end

; end
