; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer 2.0 routine macro's
; Code: d-fader^TwZ.
; Date: june 6, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

MainHelpLine		.equ 1
SongEditLine		.equ 106
PatPosEditLine		.equ 407
InsSelectLine		.equ 464
StartMenuLine		.equ 525
InfsMenuLine		.equ 571
ColorLine			.equ 603
PredSetLine			.equ 630
PIEditLine			.equ 659
DiskMenuLine		.equ 791

MaxLine			.equ 851-19

MusicAddress				.equ $8000
SongName					.equ MusicAddress
InsKitName					.equ SongName+67
LastPos					.equ InsKitName+11
LoopPos					.equ LastPos+1
Patterns					.equ LoopPos+2
InitialTempo				.equ Patterns+256
StartVolumes				.equ InitialTempo+1
StartInstruments				.equ StartVolumes+5
DetuneSettings				.equ StartInstruments+4
VolumeSlideSettings			.equ DetuneSettings+5
PatternData					.equ MusicAddress+448

ErrorHandlerAdr:			.equ $ce00
StackSave:				.equ $ce40
PrimairPageSave:			.equ $ce42
SecondarePageSave:		.equ $ce43
SaveFileHeader:			.equ $ce44
InsertDisk				.equ $cd50


LoadedInsKit:		.equ $ce30
SongPatsToSave		.equ LoadedInsKit+11
SongPatAdrToSave		.equ SongPatsToSave+1

; 11 bytes!

DoMenu:			.equ $cf00

sngbnk:			.equ 3
insbnk:			.equ 4
scc_source:			.equ $8000
psg_source:			.equ $a060
empty:			.equ 0

fcb:				.equ $da00
FileName:			.equ fcb+1
FileExt:			.equ FileName+8
CurBlock:			.equ FileExt+3
RecSize:			.equ CurBlock+2
FileSize:			.equ RecSize+2
Date:				.equ FileSize+4
Time:				.equ Date+2
DeviceID:			.equ Time+2
DirLocation:		.equ DeviceId+1
FirstClus:			.equ DirLocation+1
LastClus:			.equ FirstClus+2
CurRec:			.equ LastClus+2
RndRec:			.equ CurRec+1
EndFcb:			.equ RndRec+10

; replayer variables:

ReplayerAddress		.equ $4200
RepInterrupt		.equ $da00				; Replay interrupt Init
RCData			.equ $da00


RepBegin			.equ RndRec+10
MusicPlay			.equ RepBegin			; Is music playing? <>0 if so.
MusicPeak			.equ MusicPlay+1			; Is a new row started??
SccSlot			.equ MusicPeak+1			; Current SCC Slot. (slot * 16)
SngBnkPlay			.equ SccSlot+1			; Song bank
InsBnkPlay			.equ SngBnkPlay+1			; Instrument bank
SngPos			.equ InsBnkPlay+1			; Current song position
SngRow			.equ SngPos+1			; Current song row
SngTmp			.equ SngRow+1			; Current song tempo
SngFreqs			.equ SngTmp+1			; Song Frequencies
SngVolumes			.equ SngFreqs+10			; Song Volumes
RepCommand			.equ SngVolumes+5			; Replayer command
RepData			.equ RepCommand+7			; Data to pass to replayer
RepEnd			.equ Repdata+5

; end


NowInstrument		.equ RepEnd
SaveInsAddress		.equ NowInstrument+1
WhichDiskMenu		.equ SaveInsAddress+2
SCCSwitch			.equ WhichDiskMenu+1
PSGSwitch			.equ SCCSwitch+1
Play.pattern		.equ PSGSwitch+1
ScanSwitch			.equ Play.pattern+1
Play.PatPosEdit		.equ ScanSwitch+1
SongMin			.equ Play.PatPosEdit+1
SongSec			.equ SongMin+1

PredSettings		.equ $cf00-16			; Predefined settings

set_fg1.1:			.equ PredSettings			; Red and Blue foreground 1
set_fg1.2:			.equ set_fg1.1+1			; green foreground 1

set_bg1.1:			.equ set_fg1.2+1			; Red and Blue background 1
set_bg1.2:			.equ set_bg1.1+1			; green background 1

set_fg2.1:			.equ set_bg1.2+1			; Red and Blue foreground 2
set_fg2.2:			.equ set_fg2.1+1			; green foreground 2

set_bg2.1:			.equ set_fg2.2+1			; Red and Blue background 2
set_bg2.2:			.equ set_bg2.1+1			; green background 2

set_intfreq			.equ set_bg2.2+1			; Interrupt frequency
set_setscan			.equ set_intfreq+1		; settings scan
set_noteaud			.equ set_setscan+1		; note audition
set_eqtype			.equ set_noteaud+1		; equalizer type
set_curmode			.equ set_eqtype+1			; cursor mode
set_editmode		.equ set_curmode+1		; edit mode
set_editoct			.equ set_editmode+1		; octaves
set_keybtype		.equ set_editoct+1		; Keyboard type (for playing in ins. menu)

; last = 1 byte

#define	ClearFCB						  ld hl,fcb
#defcont								\ ld de,fcb+1
#defcont								\ ld bc,EndFcb-fcb
#defcont								\ ld (hl),0
#defcont								\ ldir


#define	Ram2Vram(pa,ofs,src,len)			  ld a,pa
#defcont								\ ld de,ofs
#defcont								\ ld hl,src
#defcont								\ ld b,len
#defcont								\ call CopyRamVram

#define	ShowPic(picture)					  ld a,picture
#defcont								\ call ShowPicture

#define	ShowHint(number)					  ld a,number
#defcont								\ call DoShowHint

#define	SetVW(pa,offset)					  ld a,pa
#defcont								\ ld hl,offset
#defcont								\ call SetVramWrite

#define	SetVR(pa,offset)					  ld a,pa
#defcont								\ ld hl,offset
#defcont								\ call SetVramRead

#define	Locate(x_cor,y_cor)				  ld hl,256*x_cor + y_cor
#defcont								\ ld ($f3dc),hl

#define	AdrLoc(adr)						\ ld hl,(adr)
#defcont								\ ld ($f3dc),hl

#define	OutPSG(reg)						\ ld a,reg
#defcont								\ out ($a0),a
#defcont								\ ld a,d
#defcont								\ out ($a1),a

#define	InPSG(reg)						\ ld a,reg
#defcont								\ out ($a0),a
#defcont								\ in a,($a2)

; #defcont								\ 
.end
