; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Song Editor
; Code: d-fader^TwZ.
; Date: july 13, 1999
;
; cmnt: filename of this file: BLAFFER2.011
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#include "macro's.asm"
#include "sb2rmacr.asm"

#define	ShowSongName				  SetVW(0,80*1+12)
#defcont							\ ld hl,SongName
#defcont							\ ld bc,$4398
#defcont							\ otir

#define	ShowPosNr					  ld a,(SngPos)
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(PosPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal
#defcont							\ ld bc,$0398
#defcont							\ otir

#define	ShowPatNr					  ld a,(SngPat)
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(PatPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal+1
#defcont							\ ld bc,$0298
#defcont							\ otir

#define	ShowRowNr					  ld a,(NowY)
#defcont							\ sub 5
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(RowPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal+1
#defcont							\ ld bc,$0298
#defcont							\ otir

#define	ShowLastPos					  ld a,(LastPos)
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(LastPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal
#defcont							\ ld bc,$0398
#defcont							\ otir

#define	ShowTempo					  ld a,(InitialTempo)
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(TempoPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal+1
#defcont							\ ld bc,$0298
#defcont							\ otir

#define	ShowEqType					  SetVW(0,80*16+65)
#defcont							\ 
#defcont							\ ld hl,EqTypes
#defcont							\ ld a,(EqType)
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ 
#defcont							\ ld bc,$0698
#defcont							\ otir

#define	ShowEditMode				  SetVW(0,80*19+74)
#defcont							\ 
#defcont							\ ld hl,EditModes
#defcont							\ ld a,(EditMode)
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ di
#defcont							\ ld bc,$0498
#defcont							\ otir

#define	ShowCurOct					  SetVW(0,80*20+74)
#defcont							\ 
#defcont							\ ld hl,CurrentOctaves
#defcont							\ ld a,(CurOct)
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ 
#defcont							\ ld bc,$0398
#defcont							\ otir

	.org $4000

;SongEditor:
;	jp start_program
;
;	.ds 16-3
;
;	.text "                "
;	.text " SCC BLAFFER NT "
;	.text "  (C) 1999 TwZ  "
;	.text "                "
;	.text "  Song Editor!  "
;	.text "                "

start_program:
	ld a,8
	ld (RepCommand),a

	ld a,4
	call DoMenu

	call InitialiseSongEdit

	ld hl,RepBegin
	ld de,RepBegin+1
	ld bc,RepEnd-RepBegin-1
	ld (hl),0
	ldir

Main:
	ld a,(BlockContinue)
	or a
	jp nz,AutoBlockMarkOn

	ShowHint(Empty)

	jp RealMain

AutoBlockMarkOn:
	ShowHint(75)

RealMain:
	xor a
	ld (ChangeEditModeAllowed),a

	call CalculateNowAddress

	ShowRowNr

	AdrLoc(cursor)

	call kilbuf
	call chget

	ld (CursorSave),a

;--- graph checks ---

	ld a,($fbeb)
	bit 2,a
	jp nz,EndGraphCheck

	ld c,%00010000
	ld a,($fbe5)
	bit 1,a
	jp z,ForceMusic

	sla c
	bit 2,a
	jp z,ForceMusic

	ld a,($fbe7)
	bit 6,a
	jp z,Switch.AllChannels

	bit 7,a
	jp z,SwapContBlock

	ld a,($fbe8)
	bit 2,a
	jp z,ChangeEqType

	bit 6,a
	jp z,ShowKitNames

	ld a,($fbea)
	bit 0,a
	jp z,Switch.SoloChannel

	bit 1,a
	jp z,CalculateSongTime

	ld a,($fbed)
	bit 5,a
	jp z,LastPosUp4

	bit 7,a
	jp z,LastPosUp1

	bit 6,a
	jp z,LastPosDown4

	bit 4,a
	jp z,LastPosDown1

	bit 3,a
	jp z,DeleteRow

EndGraphCheck:
; --- end graph checks ---

; --- Tab Checks ---

	ld a,($fbec)
	bit 3,a
	jp nz,EndTabCheck

	ld a,($fbed)
	bit 5,a
	jp z,Up4Pos

	bit 7,a
	jp z,Up1Pos

	bit 6,a
	jp z,Down4Pos

	bit 4,a
	jp z,Down1Pos

EndTabCheck:
; --- end tab checks ---

;--- control checks ---
	ld a,($fbeb)
	bit 1,a
	jp nz,EndControlCheck

	ld a,($fbe7)
	bit 6,a
	jp z,SwitchNoteAudition

	bit 7,a
	jp z,MarkBlockBegin

	ld a,($fbe8)
	bit 0,a
	jp z,CopyOperation

	bit 1,a
	jp z,MarkBlockDelete

	bit 2,a
	jp z,MarkBlockEnd

	bit 5,a
	jp z,BlafSongHelp

	ld a,($fbe9)
	bit 1,a
	jp z,ChangeLoopPos

	bit 3,a
	jp z,ChangeSongName

	bit 5,a
	jp z,PatternCopy

;	bit 6,a
;	jp z,EndSongEdit

	bit 7,a
	jp z,ReInitSCC

	ld a,($fbea)
	bit 0,a
	jp z,SwapSettingsScan

	bit 1,a
	jp z,ChangeTempo

	bit 5,a
	jp z,SwapCursors

	ld a,($fbed)
	bit 1,a
	jp z,PositionHome2

	bit 3,a
	jp z,DeletePattern

	ld a,($fbed)

	bit 5,a
	jp z,Up4Pats

	bit 7,a
	jp z,Up1Pat

	bit 6,a
	jp z,Down4Pats

	bit 4,a
	jp z,Down1Pat

EndControlCheck:
; --- end control checks ---

; --- shift checks ---

	ld a,($fbeb)
	bit 0,a
	jp nz,EndShiftCheck

	ld c,1

	ld a,($fbe5)
	bit 1,a
	jp z,SE.ChangeSwitch

	sla c

	bit 2,a
	jp z,SE.ChangeSwitch

	sla c

	bit 3,a
	jp z,SE.ChangeSwitch

	sla c

	bit 4,a
	jp z,SE.ChangeSwitch

	sla c

	bit 5,a
	jp z,SE.ChangeSwitch

	sla c

	bit 6,a
	jp z,SE.ChangeSwitch

	ld a,($fbeb)
	bit 5,a
	jp z,DoPatPosMenu

	bit 6,a
	jp z,ResetSong

	bit 7,a
	jp z,DoInfsMenu

	ld a,($fbec)
	bit 0,a
	jp z,DoRamOptions

	bit 1,a
	jp z,BlafMainHelp

	ld a,($fbed)
	bit 1,a
	jp z,CursorHome

	bit 3,a
	jp z,DeleteColumn

	ld a,($fbed)

	bit 5,a
	jp z,InsVolUp1

	bit 6,a
	jp z,InsVolDown1

	bit 7,a
	jp z,InsNrUp1

	bit 4,a
	jp z,InsNrDown1

	ld a,($fbe6)
	bit 5,a
	jp z,CurOctDown

	bit 6,a
	jp z,CurOctUp

EndShiftCheck:
; --- end shift checks ---


; --- end 2 key checks!! ---

	ei

	ld a,($fbe7)
	bit 3,a
	jp z,ShiftUpOperation

	bit 2,a
	jp z,ShiftDownOperation

	ld a,($fbeb)
	bit 5,a
	jp z,PlaySong

	bit 6,a
	jp z,PlayPattern

	bit 7,a
	jp z,DoInsSelector

	ld a,($fbec)
	bit 0,a
	jp z,DoPSGEditor

	bit 1,a
	jp z,DoSongDiskMenu

;	call OnlyOneKey
;	jp nz,NoCursorKeys

	ld a,(CursorSave)

	cp $1e
	jp z,CursorUp

	cp $1c
	jp z,CursorRight

	cp $1f
	jp z,CursorDown

	cp $1d
	jp z,CursorLeft

	call CheckCursor
	jp nz,NoCursorKeys

	ld a,($fbed)
	bit 3,a
	jp z,DeleteBlock

NoCursorKeys:
	ld a,($fbed)

	bit 1,a
	jp z,PositionHome1

	bit 2,a
	jp z,InsertRow

	ld a,($fbe6)

	bit 6,a
	jp z,CursorRight2

	bit 5,a
	jp z,CursorLeft2

	ld a,($fbef)
	bit 7,a
	jp z,CursorRight2

	bit 6,a
	jp z,CursorLeft2

	ld a,(RealX)
	cp 0
	jp z,CheckChannelCmd						; Channel 1 (command)
	cp 1
	jp z,CheckChannelVal						; Channel 1 (value)
	cp 2
	jp z,CheckChannelCmd						; Channel 2 (command)
	cp 3
	jp z,CheckChannelVal						; Channel 2 (Value)
	cp 4
	jp z,CheckChannelCmd						; ..
	cp 5
	jp z,CheckChannelVal						; ..
	cp 6
	jp z,CheckChannelCmd
	cp 7
	jp z,CheckChannelVal
	cp 8
	jp z,CheckChannelCmd						; Channel 5 (command)
	cp 9
	jp z,CheckChannelVal						; Channel 5 (value)

	cp 10
	jp z,CheckPSGChannel						; PSG channel

	cp 11
	jp z,CheckCommandChannel					; Cmd Channel (TMP, ENDOP, TR+/-)

	jp main

CursorSave:
	.db 0

InitialiseSongEdit:
	ld a,$1f
	ld (SCCSwitch),a

	ld a,1
	ld (PSGSwitch),a

	ld a,1
	ld (ChangeEditModeAllowed),a
	ld (ScanSwitch),a

	ld a,SngBnk
	out ($fe),a

	call DoResetSong

	ShowPic(0)

	ShowSongName

	call ShowPosition

	ld a,($f7f8)
	ld (SCC),a

	call ShowInsVol

	ld a,(set_setscan)
	ld (ScanSwitch),a

	ld a,(set_noteaud)
	ld (NoteAudition),a

	ld a,(set_curmode)
	ld (CursorSwitch),a

	ld a,(set_eqtype)
	ld (eqtype),a

	in a,($aa)

	and %10111111

	ld b,a

	ld a,(set_editmode)
	ld (EditMode),a
	xor 1
	sla a
	sla a
	sla a
	sla a
	sla a
	sla a

	or b

	out ($aa),a

	ld a,(EditMode)
	ld b,a
	ld a,0
	sub b
	ld ($fcab),a
	ld (OldCaps),a

	ld a,(set_editoct)
	ld (CurOct),a

FurtherInit:
	call SetSCCEditMode

	ShowRowNr

	ShowLastPos
	call ShowLoopPos.2
	ShowTempo
	ShowEqType
	ShowEditMode
	ShowCurOct

	call ShowOnOffChannels

	ei
	halt
	halt
	halt
	halt
	halt

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	ret

InitialiseSongEdit2:
	ld a,1
	ld (ChangeEditModeAllowed),a

	ShowPic(0)

	ld a,SngBnk
	out ($fe),a

	ShowPosNr

	call ShowPattern

	call ShowInsVol

	ShowSongName

	jp FurtherInit

InitialiseSongEdit3:
	ld a,1
	ld (ChangeEditModeAllowed),a

	ld a,SngBnk
	out ($fe),a

	ShowPosNr

	call ShowPattern

	call ShowInsVol

	ShowSongName

	jp FurtherInit

DeInitSongMenu:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call ClearBlink

	ld a,255
	ld (LastPatShowed),a

	call SetSCCOff

	ret	

NewInt:
	ld a,(SCCVol)
	or a
	jp z,NoSCCAction

	call SetSCC

	ld a,(SCCVol)
	dec a
	ld (SCCVol),a

	ld ($988a),a

	call ResetSCC

NoSCCAction:
	ld a,(ChangeEditModeAllowed)
	or a
	jp nz,NoCaps

	ei

	ld a,(OldCaps)
	ld b,a
	ld a,($fcab)
	cp b
	jp z,NoCaps

	ld (OldCaps),a

	ld a,(EditMode)
	xor 1
	ld (EditMode),a

	di
	ShowEditMode	
	ei

NoCaps:
OldInt:
	.ds 5

OldCaps:
	.db 0

SetSCCOff:
	call SetSCC

	xor a
	ld ($988f),a

	call ResetSCC

	ret

SetSCCEditMode:
	call ShowInsVol

	call SetSCC

	xor a
	ld ($988a),a
	ld ($988b),a
	ld ($988c),a
	ld ($988d),a
	ld ($988e),a

	ld a,%00000001
	ld ($988f),a

	call ResetSCC

	ret

SetSCC:
; routine : Set SCC port on page 2
; in      : none
; out     : (OldPrimair) - original page settings
; cmnt    : none

	in a,($a8)							; Get primair selections
	ld (OldPrimair),a						; save 'em

	and %11001111						; Trash page 2

	ld b,a							; save that

	ld a,(scc)							; Get SCC slot selection in it
	or b								;

	out ($a8),a							; Set SCC.

	ld a,$3f							; Initialise SCC
	ld ($9000),a						;

	xor a								; Has to be 0, else it fucks up all sounds
	ld ($98e0),a						;

	ret

ReSetSCC:
	ld a,(OldPrimair)
	out ($a8),a

	ret

OldPrimair:
	.db 0

SCCVol:
	.db 0
SCCFreq:
	.dw 0

CalculateSongTime:
	ld a,3
	call DoReplayMenu

	jp LastPosDone

DoInfsMenu:
	ld a,7
	call DoReplayMenu

	call SearchSCC

	jp LastPosDone

BlafSongHelp:
	ld hl,SongEditLine
	jp BlafDoHelp

BlafDoHelp:
	ld (RepData),hl

	ld a,9
	call DoReplayMenu

	jp LastPosDone

BlafMainHelp:
	ld hl,MainHelpLine
	jp BlafDoHelp

BlafPatPHelp:
	ld hl,PatPosEditLine
	jp BlafDoHelp

DoRamOptions:
	ShowHint(174)

DRO.Loop:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	cp 27
	jp z,Main

	ld b,5

	ld a,($fbe9)
	bit 1,a
	jp z,DRO.Chosen

	ld b,4

	ld a,($fbea)
	bit 0,a
	jp z,DRO.Chosen

	ld b,6

	bit 4,a
	jp z,DRO.Chosen

	jp DRO.Loop

DRO.Chosen:
	ld a,b
	call DoReplayMenu

	jp LastPosDone

DoReplayMenu:
	ld (RepCommand),a

	ld a,(PatPosMenuOn)
	or a
	call z,DeInitSongMenu

	ld a,4
	call DoMenu

	ld a,(PatPosMenuOn)
	or a
	jp z,InitialiseSongEdit.1

	call InitPatPosMenu

	ret

InitialiseSongEdit.1:
	ld a,(repcommand)
	cp 7
	jp z,ISE.2
	cp 9
	jp z,ISE.2

	call InitialiseSongEdit3

	ret

ISE.2:
	call InitialiseSongEdit2

	ret

DoPSGEditor:
	call DeInitSongMenu

	ld a,0							; PSG Instrument editor
	call DoMenu

	call InitialiseSongEdit2

	call NoKey

	jp main

DoInsSelector:
	call DeInitSongMenu

	ld a,(CurOct)
	ld (RepData),a

	ld a,(NowIns)
	ld b,a
	ld a,(scc)
	ld c,a

	ld a,3							; PSG Instrument editor
	call DoMenu

	ld a,b
	ld (NowIns),a

	ld a,(RepData)
	ld (CurOct),a

	call InitialiseSongEdit2

	call NoKey

	jp main

DoSongDiskMenu:
	call DeInitSongMenu

	ld a,3
	ld (WhichDiskMenu),a					; Song disk menu

	ld a,1							; Disk menu
	call DoMenu

	xor a
	ld (BlockOn),a

	ld a,$1f
	ld (SCCSwitch),a

	ld a,1
	ld (PSGSwitch),a

	ld a,SngBnk
	out ($fe),a

	xor a
	ld (SngPos),a

	call ShowPosition

	call InitialiseSongEdit2

	call NoKey

	ld a,6
	ld (NowY),a

	xor a
	jp CursorLeftRightDone


DoPatPosMenu:
	call DeInitSongMenu

	ld a,(SCCSwitch)
	ld b,a
	ld a,(PSGSwitch)
	ld c,a
	push bc

	ld a,$1f
	ld (SCCSwitch),a
	ld a,1
	ld (PSGSwitch),a
	

	call PatternPositionEditor

	pop bc

	ld a,b
	ld (SCCSwitch),a

	ld a,c
	ld (PSGSwitch),a

	call InitialiseSongEdit2

	call NoKey

	jp main

FillVolume1:
	call CheckCursor
	jp z,BlockFill1

	ld a,(NowChan)
	cp 5
	jp nc,main
	
	ld hl,(NowPatAdr)

	sla a
	ld e,a
	ld d,0
	add hl,de

	ld b,16
FillVolume1.1:
	push hl

	ld a,(hl)
	cp 97
	jp nc,FillVolume.1.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

FillVolume.1.done:
	pop hl

	ld de,12
	add hl,de

	djnz FillVolume1.1

	call ShowPattern

	jp main

FillVolume2:
;	Op alle plaatsen in het block waar een noot staat
;	het huidige volume invullen...

	call CheckCursor
	jp z,BlockFill2

	ld a,(NowChan)
	cp 5
	jp nc,main
	
	ld hl,(NowPatAdr)

	sla a
	ld e,a
	ld d,0
	add hl,de

	ld b,16
FillVolume2.1:
	push hl

	ld a,(hl)
	or a
	jp z,FillVolume.2.done

	cp 97
	jp nc,FillVolume.2.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

FillVolume.2.done:
	pop hl

	ld de,12
	add hl,de

	djnz FillVolume2.1

	call ShowPattern

	jp main

FillVolume3:
; Op alle plaatsen in het block waar geen noot of 
; ander commando staat, het huidige volume 
; invullen...

	call CheckCursor
	jp z,BlockFill3

	ld a,(NowChan)
	cp 5
	jp nc,main
	
	ld hl,(NowPatAdr)

	sla a
	ld e,a
	ld d,0
	add hl,de

	ld b,16
FillVolume3.1:
	push hl

	ld a,(hl)
	or a
	jp nz,FillVolume.3.done

	inc hl
	ld a,(NowVol)
	ld (hl),a
	dec hl

FillVolume.3.done:
	pop hl

	ld de,12
	add hl,de

	djnz FillVolume3.1

	call ShowPattern

	jp main

FillSave:
	.dw 0

SE.ChangeSwitch:
	call ChangeSwitches

	jp main

ChangeSwitches:
	ld a,c
	cp %00100000
	jp z,SwitchPSG

	ld a,(SCCSwitch)
	xor c
	ld (SCCSwitch),a

	jp SwitchDone

SwitchPSG:
	ld a,(PSGSwitch)
	xor 1
	ld (PSGSwitch),a

	jp SwitchDone

Switch.SoloChannel:
	ld a,(NowChan)
	cp 5
	jp z,Switch.SoloPSG
	cp 6
	jp nc,main

	ld e,a
	ld d,0
	ld hl,SCC.SoloChans
	add hl,de

	ld a,(hl)
	ld (SCCSwitch),a

	xor a
	ld (PSGSwitch),a

	jp SwitchDone2

Switch.SoloPSG:
	xor a
	ld (SCCSwitch),a

	ld a,1
	ld (PSGSwitch),a

	jp SwitchDone2

SCC.SoloChans:
	.db %00000001
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000

Switch.AllChannels:
	ld a,$1f
	ld (SCCSwitch),a

	ld a,1
	ld (PSGSwitch),a

	jp SwitchDone2

SwitchDone2:
	call SwitchDone

	jp main

SwitchDone:
ShowOnOffChannels:
	ld hl,4*80+11

	ld d,49
	ld c,1
	ld b,5
SOOC.loop1:
	xor a
	call SetVramWrite

	ld a,(SCCSwitch)
	and c

	ld a,88
	jp z,SOOC.2

	ld a,d
SOOC.2:
	out ($98),a

	push de

	ld de,7
	add hl,de

	pop de

	sla c

	inc d

	djnz SOOC.loop1
	
	ld de,-4
	add hl,de

	xor a
	call SetVRAMWrite

	ld a,(PSGSWitch)
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,SOOC.PSGSwitch

	add hl,de

	ld bc,$0398
	otir

	ret

SOOC.PSGSwitch:
	.db "XXX PSG"

SOOC.SaveVram:
	.dw 0

ShowKitNames:
	ShowHint(89)

	SetVW(0,80*22+31)

	ld a,SngBnk
	out ($fe),a

	ld hl,InsKitName
	ld bc,$0898
	otir

	ex (sp),hl
	ex (sp),hl

	ld a,46
	out ($98),a

	ld bc,$0398
	otir

	SetVW(0,80*22+60)

	ld hl,LoadedInsKit
	ld bc,$0898
	otir

	ex (sp),hl
	ex (sp),hl

	ld a,46
	out ($98),a

	ld bc,$0398
	otir

	call chget

	jp LastPosDone

ChangeSongName:
	ShowHint(88)

	ld hl,SongName
	ld de,StSongname
	ld a,67
	call CompareStrings
	jp nz,NameInputOk

	ld hl,SongName
	ld de,SongName+1
	ld bc,66
	ld (hl),32
	ldir

	ShowSongName

NameInputOk:
	ld hl,SongName_data
	call input_text

	jp main

SongName_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	.db 13,2
	.db 67
	.dw SongName
	.db 32,126
	.db 0

ShiftUpOperation:
	xor a
	ld (WhatToDo),a

	ld a,1
	ld (WhatToAdd),a

	ScanKey(shift)
	jp nz,ShiftOperation.1

	ld a,12
	ld (WhatToAdd),a

ShiftOperation.1:
	call CheckCursor
	jp z,BlockShift

	ld a,(NowChan)
	cp 5
	jp nc,main

	sla a
	ld e,a
	ld d,0
	ld hl,(NowPatAdr)
	add hl,de

	ld b,16
ShiftOperation.2:
	push bc

	ld a,(WhatToDo)
	or a
	jp z,Shift.AdjUp

	call AdjustNoteDown
	jp Shift.done

Shift.AdjUp:
	call AdjustNoteUp

Shift.done:
	ld de,12
	add hl,de

	pop bc

	djnz ShiftOperation.2

	call ShowPattern

	jp main

ShiftDownOperation:
	ld a,1
	ld (WhatToDo),a
	ld (WhatToAdd),a

	ScanKey(shift)
	jp nz,ShiftOperation.1

	ld a,12
	ld (WhatToAdd),a

	jp ShiftOperation.1

PatternCopy:
	ShowHint(83)

	call Input82Dec
	jp c,main

	ld (PatSource),a

	ShowHint(84)

	call Input82Dec
	jp c,main

	ld (PatDest),a

	ShowHint(85)

	ld hl,(CurLoc)

NumberOfPatternsLoop:
	ld (CurLoc),hl

	push hl
	call Input82Dec
	pop hl

	jp c,main

	or a
	jp z,NumberOfPatternsLoop

	ld (PatSize),a
	

	ld a,(PatSource)
	ld b,a
	ld a,(PatSize)
	dec a
	add a,b
	cp 83
	jp nc,PatternCopyImpossible

	ld a,(PatDest)
	ld b,a
	ld a,(PatSize)
	dec a
	add a,b
	cp 83
	jp nc,PatternCopyImpossible

	ld a,(PatSource)
	inc a
	ld b,a

	ld hl,PatternData-192
	ld de,192
PatCopy.1:
	add hl,de

	djnz PatCopy.1

	push hl

	ld a,(PatDest)
	inc a
	ld b,a

	ld hl,PatternData-192
	ld de,192
PatCopy.2:
	add hl,de

	djnz PatCopy.2

	push hl

	ld a,(PatSize)
	ld b,a

	ld hl,0
	ld de,192
PatCopy.3:
	add hl,de

	djnz PatCopy.3

	push hl
	pop bc
	pop de
	pop hl

	ldir

	call ShowPattern

	jp main

PatternCopyImpossible:
	ShowHint(86)

	call chget

	jp main

PatSource:
	.db 0
PatDest:
	.db 0
PatSize:
	.db 0

Input82Dec:
; routine : Input an decimal number from 0 to 82.
; in      : none.
; out     : (a = number and cy = 0) when completed, cy = 1 when escaped.. 
; cmnt    : none.

	ld hl,(CurLoc)
	ld (Save82Dec.1),hl

	push hl
	ld a,32
	call chput
	call chput	
	pop hl

	ld (CurLoc),hl

Dec82.1:
	ld (CurLoc),hl

	call chget

	cp 27
	jp z,Dec82.Esc

	call ScanDecKey
	jp c,Dec82.1

	cp 9
	jp z,Dec82.1Char.2

	ld (Save82Dec.2),a

	add a,48
	call chput

	ld hl,(CurLoc)
Dec82.2:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,Dec82.Esc

	push hl
	ScanKey(return)
	pop hl
	jp z,Dec82.1Char.1

	call ScanDecKey
	jp c,Dec82.2

	push af

	ld a,(Save82Dec.2)
	inc a
	ld b,a

	ld a,-10
Dec82.3:
	add a,10

	djnz Dec82.3

	ld b,a

	pop af

	add a,b

	cp 83
	jp nc,New82DecInput

	or a
	ret

Dec82.Esc:
	scf
	ret

Dec82.1Char.1:
	ld a,(Save82Dec.2)
Dec82.1Char.2:
	or a

	ret



New82DecInput:
	ld hl,(Save82Dec.1)
	ld (CurLoc),hl

	jp Input82Dec

Save82Dec.1:
	.dw 0
Save82Dec.2:
	.db 0

CopyOperation:
	ld a,(BlockOn)
	or a
	jp nz,CopyBlock

	ShowHint(79)

	ld hl,(CurLoc)
CopyOp.1:
	ld (CurLoc),hl
	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,main

	call ScanDecKey
	jp c,CopyOp.1

	or a
	jp z,CopyOp.1

	cp 6
	jp nc,CopyOp.1

	ld (CopySourceChannel),a

	ShowHint(80)

	ld hl,(CurLoc)
CopyOp.2:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,main

	call ScanDecKey
	jp c,CopyOp.2

	or a
	jp z,CopyOp.2

	cp 6
	jp nc,CopyOp.2

	ld (CopyDestinationChannel),a

	ShowHint(81)

	ld hl,(CurLoc)
CopyOp.3:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,main

	call ScanDecKey
	jp c,CopyOp.3

	cp 5
	jp nc,CopyOp.3

	ld (CopyEchoSteps),a

	ld a,(CopySourceChannel)
	dec a

	sla a

	ld e,a
	ld d,0
	ld hl,(NowPatAdr)

	add hl,de

	ld de,15*12
	add hl,de

	ld (CopySrcAdr),hl


	ld a,(CopyDestinationChannel)
	dec a

	sla a
	
	ld e,a
	ld d,0
	ld hl,(NowPatAdr)
	add hl,de

	ld a,(CopyEchoSteps)

	sla a								; * 2
	sla a								; * 4

	ld c,a							; save * 4

	sla a								; *8

	add a,c							; +*4 = *12

	ld e,a
	ld d,0
	add hl,de

	ld de,15*12
	add hl,de

	ld (CopyDstAdr),hl

	ex de,hl
	ld hl,(CopySrcAdr)

	ld b,16
CopyOp.4:
	push bc

	ld bc,2
	ldir

	pop bc
	push bc

	ld bc,-14
	add hl,bc

	ex de,hl

	add hl,bc

	ex de,hl


	pop bc

	djnz CopyOp.4

	call ShowPattern

	jp main

CopySrcAdr:
	.dw 0
CopyDstAdr:
	.dw 0

CopySourceChannel:
	.db 0
CopyDestinationChannel:
	.db 0
CopyEchoSteps:
	.db 0

SwitchNoteAudition:
	ld a,(NoteAudition)
	xor 1
	ld (NoteAudition),a

	add a,73
	call DoShowHint

	call kilbuf
	call chget

	jp main

DeleteColumn:
	ld hl,(NowPatAdr)
	ld a,(RealX)
	and %11111110
	ld (SaveX),a

	ld a,(RealX)
	cp 10
	jp nc,RealXChosen

	and %11111110

RealXChosen:
	ld e,a
	ld d,0
	add hl,de

	ld de,12
	ld b,16
DeleteColumnLoop1:
	push hl

	ld (hl),0

	ld a,(SaveX)
	cp 10
	jp z,DeleteColumnLoop1Done

	inc hl
	ld (hl),0

DeleteColumnLoop1Done:
	pop hl

	add hl,de

	djnz DeleteColumnLoop1

	jp DeleteDone

SaveX:
	.db 0


DeleteRow:
; routine : Delete current row.
; in      : none.
; out     : none.
; cmnt    : none.

	ShowHint(2)

	call YesOrNo
	jp nz,DeleteRowNoShift

	ld a,(NowY)
	ld b,a
	ld a,15+6
	sub b

	jp z,DelLastRow

	ld b,a
	ld hl,0
	ld de,12

DelRowLoop1:
	add hl,de
	djnz DelRowLoop1

	push hl
	pop bc

	ld hl,(NowRowAdr)

	push hl

	ld de,12
	add hl,de

	pop de


	ldir

DelLastRow:
	ld hl,(NowPatAdr)
	ld de,192-12
	add hl,de

	push hl
	pop de

	inc de

	ld bc,11

	ld (hl),0

	ldir

DeleteDone:
	call ShowPattern

	jp main

DeleteRowNoShift:	
	ld hl,(NowRowAdr)
	push hl
	pop de

	inc de

	ld bc,11

	ld (hl),0

	ldir

	jp DeleteDone

DeletePattern:
	ShowHint(3)

	call YesOrNo
	jp nz,main

	ld hl,(NowPatAdr)
	push hl
	pop de

	inc de

	ld bc,191

	ld (hl),0
	ldir

	jp DeleteDone

InsertRow:
; routine : Insert Row at current position
; in      : none.
; out     : none.
; cmnt    : none.

	ld a,(NowY)
	ld b,a
	ld a,15+6
	sub b

	jp z,DelLastRow

	ld b,a
	ld hl,0
	ld de,12

InsRowLoop1:
	add hl,de
	djnz InsRowLoop1

	push hl
	pop bc

	ld hl,(NowPatAdr)
	ld de,192-1
	add hl,de
	push hl

	ld de,-12
	add hl,de

	pop de

; DE - Destination Address (Row 16 last byte)
; HL - Source Address      (Row 15 last byte)
; BC - Length		   (12 * Number of rows) -> 1 row = 12 bytes

	lddr

	ld hl,(NowRowAdr)
	push hl
	pop de
	inc de
	ld bc,11
	ld (hl),0
	ldir

	jp DeleteDone

CursorHome:
	ld a,6
	ld (NowY),a

	xor a
	jp CursorLeftRightDone

PositionHome1:
	xor a
	ld (sngpos),a

PositionHome2:
	call ShowPosition

	jp main

ReInitSCC:
	call SearchSCC
	jp c,ReInitUnsuccesful

	ShowHint(67)

	SetVW(0,80*22+52)

	ld a,(scc)
	srl a
	srl a
	srl a
	srl a

	add a,48
	out ($98),a

ReInitDone:
	call kilbuf
	call chget

	call SetSCCEditMode

	jp LastPosDone

ReInitUnsuccesful:
	ShowHint(68)

	jp ReInitDone

ForceMusic:
	ld a,c
	ld (scc),a

	srl a
	srl a
	srl a
	srl a

	add a,48

	push af

	ShowHint(69)

	SetVW(0,80*22+51)
	
	pop af

	out ($98),a

	jp ReInitDone

CheckChannelCmd:
	Scan2Keys(graph,key_x)
	jp z,FillVolume3

	Scan2Keys(control,key_g)
	jp z,GrapInstrument

	ScanKey(return)
	jp z,DoLastNoteOperation

	ScanKey(Delete)
	jp z,DeleteNoteOperation

	ld a,(EditMode)
	or a
	jp nz,CheckChannelCmd1Key

	ld a,($fbea)
	bit 7,a
	jp z,FillVolume1

	bit 5,a
	jp z,FillVolume2

	Scan2Keys(control,key_i)
	jp z,InsOperation2

	call OnlyOneKey
	jp nz,main

	ScanKey(key_i)
	jp z,InsOperation1

	ScanKey(key_m)
	jp z,ModulateOperation

	ScanKey(key_o)
	jp z,OffOperation

	ScanKey(key_p)
	jp z,PitchOperation

	ScanKey(key_s)
	jp z,AutoSlideOperation

	ScanKey(key_t)
	jp z,DetuneOperation

	ScanKey(key_v)
	jp z,VolumeSlideOperation

	ld c,0

	ScanKey(key_c)
	jp z,NoteChosen

	inc c
	inc c

	ScanKey(key_d)
	jp z,NoteChosen

	inc c
	inc c

	ScanKey(key_e)
	jp z,NoteChosen

	inc c

	ScanKey(key_f)
	jp z,NoteChosen

	inc c
	inc c

	ScanKey(key_g)
	jp z,NoteChosen

	inc c
	inc c

	ScanKey(key_a)
	jp z,NoteChosen

	inc c
	inc c

	ScanKey(key_b)
	jp z,NoteChosen

	jp main

GrapInstrument:
	ld hl,(NowAddress)

	ld a,(hl)

	cp 98
	jp nz,main

	inc hl
	ld a,(hl)

	cp 207
	jp c,GrabInsOk

	ShowHint(175)

	call kilbuf
	call chget

	jp main

GrabInsOk:
	ld (NowIns),a

	call ShowInsVol

	jp main

InsOperation1:
	ld a,(RealX)
	cp 8
	jp z,main

	ld hl,(NowAddress)

	ld (hl),98

	inc hl

	ld a,(NowIns)
	ld (hl),a

	jp NoteOpDone

InsOperation2:
	ld a,(RealX)
	cp 8
	jp z,main

	ld hl,(NowAddress)
	ld a,(hl)
	ld (SaveNowNote),a

	ld (hl),98

	call ShowPattern

	ShowHint(57)

	ld hl,(cursor)

	ld e,0
	ld d,4
	add hl,de

	ld (CurLoc),hl

	call Input2Hex
	jp nc,InsOp2Ok

	ld hl,(NowAddress)

	ld a,(SaveNowNote)
	ld (hl),a

	jp OpEscape

InsOp2Ok:
	ld hl,(NowAddress)
	inc hl
	ld (hl),a

	jp NoteOpdone

OffOperation:
	ld hl,(NowAddress)

	ld a,97
	ld (hl),a

	inc hl

	ld (hl),0

	jp NoteOpDone

PitchOperation:
	ld a,99
	ld (NoteCmdSave),a

	ld a,80
	call chput

	ld hl,(CurLoc)

	ld a,32
	call chput
	call chput

	ld (CurLoc),hl

	ShowHint(58)

PitOpLoop1:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,49
	ld c,0
	ScanKey(key_1)	
	jp z,PitchWayDone

	ld b,50
	ld c,2
	ScanKey(key_2)	
	jp z,PitchWayDone

	jp PitOpLoop1

PitchWayDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ShowHint(59)

PitOpLoop2:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,43
	ld c,0
	ScanKey(equal)	
	jp z,PitchDirDone

	ld b,45
	ld c,1
	ScanKey(minus)
	jp z,PitchDirDone

	jp PitOpLoop2

PitchDirDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ld hl,(CurLoc)

	inc h

	ld (CurLoc),hl

	ShowHint(60)

	call Input2Hex
	jp c,OpEscape

	ld hl,(NowAddress)
	push af
	ld a,(NoteCmdSave)
	ld (hl),a
	pop af

	inc hl
	ld (hl),a

	jp NoteOpDone

ModulateOperation:
	ld a,103
	ld (NoteCmdSave),a

	ld a,77
	call chput
	ld a,32
	call chput

	ld hl,(CurLoc)
	call chput
	ld (CurLoc),hl

	ShowHint(61)

ModOpLoop1:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,43
	ld c,0
	ScanKey(equal)	
	jp z,ModDirDone

	ld b,45
	ld c,1
	ScanKey(minus)
	jp z,ModDirDone

	jp ModOpLoop1

ModDirDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ld hl,(CurLoc)

	inc h

	ld (CurLoc),hl

	ShowHint(62)

	call Input2Hex
	jp c,OpEscape

	ld hl,(NowAddress)
	push af
	ld a,(NoteCmdSave)
	ld (hl),a
	pop af

	inc hl
	ld (hl),a

	jp NoteOpDone

DetuneOperation:
	ld a,105
	ld (NoteCmdSave),a

	ld a,68
	call chput
	ld a,84
	call chput

	ld hl,(CurLoc)
	ld a,32
	call chput
	ld (CurLoc),hl

	ShowHint(63)

DetOpLoop1:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,43
	ld c,0
	ScanKey(equal)	
	jp z,DetDirDone

	ld b,45
	ld c,1
	ScanKey(minus)
	jp z,DetDirDone

	jp DetOpLoop1

DetDirDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ld hl,(CurLoc)

	inc h

	ld (CurLoc),hl

	ShowHint(64)

	call Input2Hex
	jp c,OpEscape

	ld hl,(NowAddress)
	push af
	ld a,(NoteCmdSave)
	ld (hl),a
	pop af

	inc hl
	ld (hl),a

	jp NoteOpDone

VolumeSlideOperation:
	ld a,107
	ld (NoteCmdSave),a

	ld a,86
	call chput
	ld a,83
	call chput

	ld hl,(CurLoc)
	ld a,32
	call chput
	ld (CurLoc),hl

	ShowHint(65)

VSOpLoop1:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,43
	ld c,0
	ScanKey(equal)	
	jp z,VSDirDone

	ld b,45
	ld c,1
	ScanKey(minus)
	jp z,VSDirDone

	jp VSOpLoop1

VSDirDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ld hl,(CurLoc)

	inc h

	ld (CurLoc),hl

	ld a,48
	call chput

	ShowHint(66)

	ld c,0
	call Input1Hex
	jp c,OpEscape

	ld hl,(NowAddress)
	push af
	ld a,(NoteCmdSave)
	ld (hl),a
	pop af

	inc hl
	ld (hl),a

	jp NoteOpDone


AutoSlideOperation:
	ld a,109
	ld (NoteCmdSave),a

	ld a,65
	call chput
	ld a,83
	call chput

	ld hl,(CurLoc)
	ld a,32
	call chput
	ld (CurLoc),hl

	ShowHint(102)

ASOpLoop1:
	ld hl,(CurLoc)

	call chget

	ld (CurLoc),hl

	ScanKey(escape)
	jp z,OpEscape

	ld b,43
	ld c,0
	ScanKey(equal)	
	jp z,ASDirDone

	ld b,45
	ld c,1
	ScanKey(minus)
	jp z,ASDirDone

	jp ASOpLoop1

ASDirDone:
	ld a,(NoteCmdSave)
	add a,c
	ld (NoteCmdSave),a

	ld a,b
	call chput

	ld hl,(CurLoc)

	inc h

	ld (CurLoc),hl

	ld a,48
	call chput

	ShowHint(103)

	ld c,0
	call Input1Hex
	jp c,OpEscape

	ld hl,(NowAddress)
	push af
	ld a,(NoteCmdSave)
	ld (hl),a
	pop af

	inc hl
	ld (hl),a

	jp NoteOpDone

NoteCmdSave:
	.db 0

OpEscape:
	call ShowPattern

	jp main

DoLastNoteOperation:
	ld hl,(NowAddress)

	ld a,(LastNoteTyped)
	ld (hl),a

	push af

	inc hl

	ld a,(LastNoteTyped+1)
	ld (hl),a

	call ShowPattern
	call DownCursor

	pop af

	or a
	jp z,Main

	cp 97
	jp c,SetNoteInSCC

	jp main

DeleteNoteOperation:
	ld hl,(NowAddress)
	ld (hl),0
	inc hl
	ld (hl),0

NoteOpDone:
	ld hl,(NowAddress)

	ld a,(hl)
	ld (LastNoteTyped),a

	inc hl

	ld a,(hl)
	ld (LastNoteTyped+1),a

	call Showpattern
	call DownCursor

	ShowHint(empty)

	jp main

CheckChannelCmd1Key:
	ScanKey(Shift)
	jp z,Chk1KeyOps

	ld c,1

	ScanKey(key_q)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_2)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_w)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_3)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_e)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_r)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_5)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_t)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_6)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_y)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_7)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_u)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_z)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_s)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_x)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_d)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_c)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_v)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_g)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_b)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_h)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_n)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_j)
	jp z,Note1KeyChosen

	inc c

	ScanKey(key_m)
	jp z,Note1KeyChosen

	jp main
	
Note1KeyChosen:
	ld a,(CurOct)

	sla a							; a=a*2
	sla a							; a=a*4

	ld e,a						; e=a

	add a,e						; a=a*8
	add a,e						; a=a*12

	sub 12
	add a,c

	cp 97
	jp nc,main

	jp Note1KeyDone

Chk1KeyOps:
	Scan2Keys(graph,key_x)
	jp z,FillVolume3

	Scan2Keys(control,key_i)
	jp z,InsOperation2

	ld a,($fbe8)
	bit 6,a
	jp z,InsOperation1

	ld a,($fbe9)
	bit 2,a
	jp z,ModulateOperation

	bit 4,a
	jp z,OffOperation

	bit 5,a
	jp z,PitchOperation

	ld a,($fbea)
	bit 0,a
	jp z,AutoSlideOperation

	bit 1,a
	jp z,DetuneOperation

	bit 3,a
	jp z,VolumeSlideOperation

	bit 5,a
	jp z,FillVolume2

	bit 7,a
	jp z,FillVolume1

	jp main

NoteChosen:
	xor a
	ld (BisAllowed),a

	ld a,32
	call chput
	call chput
	call chput

	AdrLoc(Cursor)

	ld e,c
	ld d,0
	ld hl,OneOctave
	add hl,de

	ld a,(hl)
	call chput

	ld a,c
	cp 4
	jp z,NoteNoBis
	cp 11
	jp z,NoteNoBis

NoteContinue:
	call kilbuf
	call chget

	Scan2Keys(shift,key_3)
	jp z,NoteDoBis

	ScanKey(escape)
	jp z,NoteEscape

	ld b,0
	ScanKey(key_1)
	jp z,NoteInputDone

	ld b,12
	ScanKey(key_2)
	jp z,NoteInputDone

	ld b,24
	ScanKey(key_3)
	jp z,NoteInputDone

	ld b,36
	ScanKey(key_4)
	jp z,NoteInputDone

	ld b,48
	ScanKey(key_5)
	jp z,NoteInputDone

	ld b,60
	ScanKey(key_6)
	jp z,NoteInputDone

	ld b,72
	ScanKey(key_7)
	jp z,NoteInputDone

	ld b,84
	ScanKey(key_8)
	jp z,NoteInputDone

	jp NoteContinue

NoteNoBis:
	ld a,1
	ld (BisAllowed),a

	ld a,32
	call chput

	jp NoteContinue

NoteDoBis:
	ld a,(BisAllowed)
	or a
	jp nz,NoteContinue

	inc c

	ld a,35
	call chput

	ld a,1
	ld (BisAllowed),a

	jp NoteContinue

NoteInputDone:
	ld a,b
	add a,c
	inc a

Note1KeyDone:
	ld hl,(NowAddress)
	ld (hl),a

	push af

	ld (LastNoteTyped),a

	ld a,(NowVol)

	inc hl

	ld (hl),a
	ld (LastNoteTyped+1),a

	call ShowPattern

	call DownCursor

	pop af

SetNoteInSCC:	
	ld b,a

	ld a,(NoteAudition)
	or a
	jp nz,NoNoteAudition

	ld a,b

	sla a

	ld e,a
	ld d,0

	ld hl,Freqdata-2
	add hl,de

	ld a,(hl)
	ld (SCCFreq),a

	inc hl

	ld a,(hl)
	ld (SCCFreq+1),a


	call SetSCC

	xor a
	ld ($988a),a

	ld hl,(SccFreq)
	ld ($9880),hl

	call ResetSCC

	ld a,16
	ld (SCCVol),a

NoNoteAudition:
	jp main

LastNoteTyped:
	.dw 0

NoteEscape:
	call ShowPattern

	jp main

BisAllowed:
	.db 0

SaveNowNote:
	.db 0
OneOctave:
	.db "C D EF G A B"

CheckChannelVal:
	ScanKey(Delete)
	jp z,DeleteValue

	ScanKey(return)
	jp z,EnterLastValue

	call ScanHexKey
	jp c,main

	call Input2HexDone
	jp nc,ChkChnValOk

	call Showpattern

	jp main

ChkChnValOk:
	ld hl,(NowAddress)
	ld (hl),a
	ld (LastValue),a

	call ShowPattern
	call DownCursor

	jp main

DeleteValue:
	xor a

	jp ChkChnValOk

EnterLastValue:
	ld a,(LastValue)

	jp ChkChnValOk

LastValue:
	.db 0

CheckPSGChannel:
	ScanKey(delete)
	jp z,DeletePSGCell

	ScanKey(return)
	jp z,DoLastPSGOp

	call ScanDecKey
	jp c,main

	ld c,a

	cp 5
	jp nc,PSG4Bit

	ld a,32					; 35 for '#'
	call chput

	ld a,c
	add a,48
	call chput

	ld hl,(CurLoc)
	ld (SavePSGCur),hl

	ld a,32
	call chput

ChkPSGLoop1:
	ld hl,(SavePSGCur)
	ld (CurLoc),hl

	call ChGet

	ScanKey(return)
	jp z,PSG4Bit

	ScanKey(escape)
	jp z,PSGEscape

	push bc
	call ScanDecKey
	pop bc

	jp c,ChkPSGLoop1

	ld e,a

	ld b,c
	ld a,-10
	inc b
ChkPSGLoop2:
	add a,10
	djnz ChkPSGLoop2

	add a,e

	cp 45
	jp nc,ChkPSGLoop1

	or a
	jp z,ChkPSGLoop1

	ld hl,(NowAddress)
	ld (hl),a

	ld (LastPSGOp),a

	call DownCursor
	call ShowPattern

	jp main

DeletePSGCell:
	xor a
	ld hl,(NowAddress)
	ld (hl),a
	ld (LastPSGOp),a

	call ShowPattern
	call DownCursor

	jp main

DoLastPsgOp:
	ld hl,(NowAddress)

	ld a,(LastPSGOp)
	ld (hl),a

	call ShowPattern
	call DownCursor

	jp main

PSG4bit:
	ld a,c

	or a
	jp z,ChkPSGLoop1

	ld hl,(NowAddress)
	ld (hl),a

	ld (LastPSGop),a

	call Showpattern
	call DownCursor

	jp main

PSGEscape:
	call ShowPattern

	jp main

SavePSGCur:
	.dw 0

LastPSGOp:
	.db 0

CheckCommandChannel:
	ScanKey(return)
	jp z,DoLastCommand

	ScanKey(Delete)
	jp z,DeleteCommand

	ScanKey(key_t)
	jp z,MakeTempoChange

	ScanKey(key_p)
	jp z,MakePMVChange

	ScanKey(key_e)
	jp z,MakeEndOp

	ScanKey(key_r)
	jp z,MakeTranspose

	jp main

MakeTranspose:
	ld a,84
	call chput
	ld a,82
	call chput
	ld a,80
	call chput

	ld hl,(CurLoc)

	ld a,32
	call chput
	call chput

	ld (CurLoc),hl

	ShowHint(71)

	ld hl,(CurLoc)
MakeTrpLoop1:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,CommandChnEscape

	ld b,43
	ld c,6+27

	push hl
	ScanKey(equal)
	pop hl

	jp z,TRPDirChosen

	ld b,45
	ld c,6+27

	push hl
	ScanKey(minus)
	pop hl

	jp z,TRPDirChosen

	jp MakeTrpLoop1

TrpDirChosen:
	ld a,b
	call chput

	ld (TrpDir),a

	ld a,c
	ld (NowTrp),a

	ShowHint(72)

	ld hl,(CurLoc)
MakeTrpLoop2:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,CommandChnEscape

	push hl
	call ScanDecKey
	pop hl

	jp c,MakeTrpLoop2

	cp 7
	jp nc,MakeTrpLoop2

	ld c,a
	ld a,(NowTrp)
	ld b,a

	ld a,(TrpDir)
	cp 43
	jp z,TrpAddition

	ld a,b
	sub c

	ld hl,(NowAddress)
	ld (SaveCmdData),a
	ld (hl),a

	jp CommandChnDone

TrpAddition:
	ld a,b
	add a,c

	ld hl,(NowAddress)
	ld (SaveCmdData),a
	ld (hl),a

	jp CommandChnDone

NowTrp:
	.db 0
TrpDir:
	.db 0

DoLastCommand:
	ld hl,(NowAddress)
	ld a,(SaveCmdData)
	ld (hl),a

	jp CommandChnDone

DeleteCommand:
	ld hl,(NowAddress)

	xor a
	ld (hl),a

	ld (SaveCmdData),a

	jp CommandChnDone

SaveCmdData:
	.db 0

MakeEndOp:
	ld hl,(NowAddress)

	ld a,26
	ld (hl),a
	ld (SaveCmdData),a

	jp CommandChnDone




; Make PSG MAX Volume!

MakePMVChange:	
	ld a,80
	call chput

	ld a,77
	call chput

	ld a,86
	call chput

	ShowHint(177)

MakePMV1.1:	
	ld hl,(CurLoc)
	ld (SavePSGCur),hl

	ld a,32
	call chput
	call chput

MakePMV1.2:
	ld hl,(SavePSGCur)
	ld (CurLoc),hl

	call kilbuf
	call chget

	ScanKey(Escape)
	jp z,CommandChnEscape

	call ScanDecKey
	jp c,MakePMV1.2

	ld (SaveCommand),a


	cp 0
	jp z,PMV1Number

	cp 2
	jp nc,PMV1Number

	push af

	add a,48
	call chput

	pop af

	ld b,a
	inc b
	ld a,-10
MakePMV3:
	add a,10

	djnz MakePMV3

	ld c,a

	ld hl,(CurLoc)
	ld (SavePSGCur),hl

MakePMV2:
	ld hl,(SavePSGCur)
	ld (CurLoc),hl

	call kilbuf
	call chget

	ScanKey(Escape)
	jp z,CommandChnEscape

	ScanKey(Return)
	jp z,PMV1Number

	push bc
	call ScanDecKey
	pop bc

	jp c,MakePMV2
	
	add a,c

	or a
	jp z,PMV1Number

	cp 16
	jp c,Make1PMV.2

MakePMVNotOk:
	ld hl,(SavePSGCur)
	dec h
	ld (CurLoc),hl

	jp MakePMV1.1

Make1PMV.2:
	add a,40

	ld hl,(NowAddress)
	ld (hl),a

	ld (SaveCmdData),a

	jp commandChnDone

PMV1Number:
	ld a,(SaveCommand)
	jp Make1PMV.2

MakeTempoChange:	
	ld a,84
	call chput

	ld a,109
	call chput

	ld a,112
	call chput

	ShowHint(70)

MakeTempoLoop1:	
	ld hl,(CurLoc)
	ld (SavePSGCur),hl

	ld a,32
	call chput
	call chput

MakeTempoLoop1.2:
	ld hl,(SavePSGCur)
	ld (CurLoc),hl

	call kilbuf
	call chget

	ScanKey(Escape)
	jp z,CommandChnEscape

	call ScanDecKey
	jp c,MakeTempoLoop1.2

	ld (SaveCommand),a

	cp 3
	jp nc,Tempo1Number

	push af

	add a,48
	call chput

	pop af

	ld b,a
	inc b
	ld a,-10
MakeTempoLoop3:
	add a,10

	djnz MakeTempoLoop3

	ld c,a

	ld hl,(CurLoc)
	ld (SavePSGCur),hl

MakeTempoLoop2:
	ld hl,(SavePSGCur)
	ld (CurLoc),hl

	call kilbuf
	call chget

	ScanKey(Escape)
	jp z,CommandChnEscape

	ScanKey(Return)
	jp z,Tempo1Number

	push bc
	call ScanDecKey
	pop bc

	jp c,MakeTempoLoop2
	
	add a,c

	or a
	jp z,MakeTempoNotOk

	cp 26
	jp c,Tempo1Number.2

MakeTempoNotOk:
	ld hl,(SavePSGCur)
	dec h
	ld (CurLoc),hl

	jp MakeTempoLoop1

Tempo1Number.2:
	ld hl,(NowAddress)
	ld (hl),a

	ld (SaveCmdData),a

	jp commandChnDone

Tempo1Number:
	ld a,(SaveCommand)
	jp Tempo1Number.2

CommandChnDone:
	call DownCursor

CommandChnEscape:
	call ShowPattern

	jp main

SaveCommand:
	.db 0

ChangeLoopPos:
	ld a,(PatPosMenuOn)
	or a
	jp z,ChangeLoopPos.I1

	ld a,71
	ld (SaveLP),a
	ld d,a

	ld a,14
	ld (SaveLP+1),a
	ld e,a

	ld a,9
	ld (SaveLP+2),a

	call DrawBar

	jp ChangeLoopPos.I2

ChangeLoopPos.I1
	ld a,55
	ld (SaveLP),a
	ld d,a

	ld a,11
	ld (SaveLP+1),a
	ld e,a

	ld a,25
	ld (SaveLP+2),a

	call DrawBar

ChangeLoopPos.I2:
	ShowHint(77)
	
ChangeLoopPos.1.0:
	ld a,25
	ld (CurLoc),a

ChangeLoopPos.1:
	ld hl,(CurLoc)
	call chget
	ld (CurLoc),hl
	
	ScanKey(up)
	jp z,ChangeLoopPos.up.4

	ScanKey(right)
	jp z,ChangeLoopPos.Up

	ScanKey(left)
	jp z,ChangeLoopPos.Down

	ScanKey(down)
	jp z,ChangeLoopPos.down.4

	ScanKey(return)
	jp nz,ChangeLoopPos.1

	ld a,(LoopPos+1)
	ld b,a
	ld a,(LastPos)
	cp b
	jp nc,LoopPos.Ok

	ShowHint(113)

	call kilbuf
	call chget

	ShowHint(77)

	jp ChangeLoopPos.1.0

LoopPos.Ok:
	ld ix,SaveLp

	ld d,(ix+0)
	ld e,(ix+1)
	ld a,(ix+2)

	call DrawBar
	
	jp LastPosDone

SaveLp:
	.ds 3

ChangeLoopPos.Up.4:
	xor a
	ld (LoopPos),a

	ld a,(LoopPos+1)
	add a,4
	jp nc,ChangeUp4Done

	ld a,255
ChangeUp4Done:
	ld (LoopPos+1),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeLoopPos.Down.4:
	ld a,(LoopPos+1)
	sub 4
	jp nc,ChangeDown4Done

	ld a,1
	ld (LoopPos),a

	dec a
ChangeDown4Done:
	ld (LoopPos+1),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeLoopPos.Up:
	ld a,(LoopPos)
	or a
	jp nz,ChangeLoopPos.Up2

	ld a,(LoopPos+1)
	cp 255
	jp z,ChangeLoopPos.1

	inc a
	ld (LoopPos+1),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeLoopPos.Up2:
	xor a
	ld (LoopPos),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeLoopPos.Down:
	ld a,(LoopPos+1)
	or a
	jp z,ChangeLoopPos.Down2

	dec a
	ld (LoopPos+1),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeLoopPos.Down2:
	ld a,1
	ld (LoopPos),a

	call ShowLoopPos.2

	jp ChangeLoopPos.1

ChangeTempo:
	ld a,(PatPosMenuOn)
	or a
	jp z,ChangeTempo.I1

	ld a,71
	ld (SaveLP),a
	ld d,a

	ld a,16
	ld (SaveLP+1),a
	ld e,a

	ld a,9
	ld (SaveLP+2),a

	call DrawBar

	ld a,78
	ld (CurLoc+1),a
	ld a,16
	ld (CurLoc),a

	jp ChangeTempo.I2

ChangeTempo.I1:
	ld a,55
	ld (SaveLP),a
	ld d,a

	ld a,12
	ld (SaveLP+1),a
	ld e,a

	ld a,25
	ld (SaveLP+2),a

	call DrawBar

	ld a,77
	ld (CurLoc+1),a
	ld a,12
	ld (CurLoc),a

ChangeTempo.I2:
	ShowHint(78)

	ld a,(InitialTempo)
	ld (SaveInitTempo),a

	ld hl,(CurLoc)

	push hl
	ld a,32
	call chput
	call chput
	pop hl

ChangeTempo.1:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(escape)
	pop hl

	jp z,ChangeTempoEscape

	call ScanDecKey
	jp c,ChangeTempo.1

	or a
	jp z,No10Check

	cp 3
	jp nc,ChangeTempo1Char

No10Check:
	add a,48
	call chput

	ld a,c
	ld (SaveTempo1Char.2),a

	ld a,-10
	ld b,c
	inc b
ChangeTempo.2:
	add a,10

	djnz ChangeTempo.2

	ld (Save10Tempo),a

	ld hl,(CurLoc)
ChangeTempo.3:
	ld (CurLoc),hl

	call chget

	cp 27
	jp z,ChangeTempoEscape

	cp 13
	jp z,ChangeTempo1Char.2

	sub 48
	cp 10
	jp nc,ChangeTempo.3

	ld b,a
	ld a,(Save10Tempo)

	add a,b

ChangeTempo1Char:
	push af

	ld ix,SaveLP

	ld d,(ix+0)
	ld e,(ix+1)
	ld a,(ix+2)
	call DrawBar

	pop af

	or a
	jp z,ChangeTempo

	cp 26
	jp nc,ChangeTempo

	ld (InitialTempo),a

	ShowTempo

	jp ShowTempoDone

ChangeTempoEscape:
	ld a,(SaveInitTempo)
	ld (InitialTempo),a

	ShowTempo

	ld ix,SaveLP

	ld d,(ix+0)
	ld e,(ix+1)
	ld a,(ix+2)
	call DrawBar

	jp ShowTempoDone

ShowTempoDone:
	jp LastPosDone

ChangeTempo1Char.2:
	ld a,(SaveTempo1Char.2)

	jp ChangeTempo1Char

SaveInitTempo:
	.db 0
Save10Tempo:
	.db 0
SaveTempo1Char.2:
	.db 0

DownCursor:
	ld a,(NowY)
	inc a
	cp 22
	jp nz,DownCursorDone

	ld a,6
DownCursorDone:
	ld (NowY),a

	ret	

ChangeEqType:
	ld a,(EqType)
	xor 1
	ld (EqType),a

	ShowEqType

	jp main

ChangeEditMode:
	ld a,(EditMode)
	xor 1
	ld (EditMode),a

	ShowEditMode

	jp main

InsVolUp1:
	ld a,(NowVol)
	cp 15
	jp z,main

	inc a
	ld (NowVol),a

	call ShowInsVol

	jp main

InsVolDown1:
	ld a,(NowVol)
	or a
	jp z,main

	dec a
	ld (NowVol),a

	call ShowInsVol

	jp main

InsNrUp1:
	ld a,(NowIns)
	cp 206
	jp z,main

	inc a
	ld (NowIns),a

	call ShowInsVol

	jp main

InsNrDown1:
	ld a,(NowIns)
	or a
	jp z,main

	dec a
	ld (NowIns),a

	call ShowInsVol

	jp main

CurOctUp:
	ld a,(CurOct)
	cp 8
	jp z,main

	inc a
	ld (CurOct),a

	ShowCurOct

	jp main

CurOctDown:
	ld a,(CurOct)
	or a
	jp z,main

	dec a
	ld (CurOct),a

	ShowCurOct

	jp main

LastPosUp4:
	ld a,(LastPos)
	add a,4
	jp nc,LastPosUp4Done

	ld a,255
LastPosUp4Done:
	ld (LastPos),a

	ShowLastPos

	jp LastPosDone

LastPosDown4:
	ld a,(LastPos)
	sub 4
	jp nc,LastPosDown4Done

	xor a
LastPosDown4Done:
	ld (LastPos),a

	ShowLastPos

	jp LastPosDone

LastPosUp1:
	ld a,(LastPos)
	cp 255
	jp z,LastPosDone

	inc a
	ld (LastPos),a

	ShowLastPos

	jp LastPosDone

LastPosDown1:
	ld a,(LastPos)
	or a
	jp z,LastPosDone

	dec a
	ld (LastPos),a

	ShowLastPos

	jp LastPosDone

LastPosDone:
	ld a,(PatPosMenuOn)
	or a
	jp z,main

	jp PatPosMain

Up1Pat:
	ld a,(SngPat)
	cp 82
	jp z,main

	inc a
	ld (SngPat),a

	call ShowPattern
 
	jp main

Up4Pats:
	ld a,(sngPat)
	add a,4

	cp 83
	jp c,Up4PatsDone

	ld a,82
Up4PatsDone:
	ld (SngPat),a

	call ShowPattern

	jp main

Down1Pat:
	ld a,(SngPat)
	or a
	jp z,main

	dec a
	ld (SngPat),a

	call ShowPattern
 
	jp main

Down4Pats:
	ld a,(sngPat)
	sub 4

	jp nc,Down4PatsDone

	xor a
Down4PatsDone:
	ld (SngPat),a

	call ShowPattern

	jp main

Up1Pos:
	ld a,(SngPos)
	cp 255
	jp z,main

	inc a
	ld (SngPos),a

	call ShowPosition
 
	jp main

Up4Pos:
	ld a,(SngPos)
	add a,4

	jp nc,Up4PosDone

	ld a,255
Up4PosDone:
	ld (SngPos),a

	call ShowPosition

	jp main

Down1Pos:
	ld a,(SngPos)
	or a
	jp z,main

	dec a
	ld (SngPos),a

	call ShowPosition
 
	jp main

Down4Pos:
	ld a,(SngPos)
	sub 4

	jp nc,Down4PosDone

	xor a
Down4PosDone:
	ld (SngPos),a

	call ShowPosition

	jp main


CursorUp:
	ld a,(NowY)
	dec a
	cp 5
	jp nz,CursorDownDone

	ld a,16+5

	jp CursorDownDone

CursorDown:
	ld a,(NowY)
	inc a
	cp 16+6
	jp nz,CursorDownDone

	ld a,6

CursorDownDone:
	ld (NowY),a

	ld a,(BlockContinue)
	or a
	jp nz,MarkBlockEnd

	jp Main
	
CursorRight:
	ld a,(CursorSwitch)
	or a
	jp nz,DoCRight2

DoCRight:
	ld a,(RealX)
	inc a
	cp 12
	jp nz,CursorLeftRightDone

	xor a

	jp CursorLeftRightDone

CursorLeft:
	ld a,(CursorSwitch)
	or a
	jp nz,DoCLeft2

DoCleft:
	ld a,(RealX)
	dec a
	cp 255
	jp nz,CursorLeftRightDone

	ld a,11

	jp CursorLeftRightDone

CursorLeft2:
	ld a,(CursorSwitch)
	or a
	jp nz,DoCLeft

DoCLeft2:
	ld a,(RealX)
	cp 0
	jp z,DoCLeft
	cp 1
	jp z,DoCLeft
	cp 11
	jp z,DoCLeft

	sub 2
	jp nc,CursorLeftRightDone

	ld a,11
	jp CursorLeftRightDone

CursorRight2:
	ld a,(CursorSwitch)
	or a
	jp nz,DoCRight

DoCRight2:
	ld a,(RealX)
	cp 9
	jp z,DoCRight
	cp 10
	jp z,DoCRight
	cp 11
	jp z,DoCRight

	add a,2

	jp CursorLeftRightDone

CursorLeftRightDone:
	ld (RealX),a

	ld e,a
	ld d,0
	ld hl,RealXdata

	add hl,de

	ld a,(hl)

	ld (NowX),a

	ld a,(RealX)
	ld e,a
	ld d,0
	ld hl,BlockOffsets
	add hl,de

	ld a,(hl)
	ld (NowChan),a

	ld a,(BlockContinue)
	or a
	jp nz,MarkBlockEnd

	jp main

SwapCursors:
	ld a,(CursorSwitch)
	xor 1
	ld (CursorSwitch),a
	xor 1
	add a,55
	call DoShowHint

	call kilbuf
	call chget

	jp main

SwapSettingsScan:
	ld a,(ScanSwitch)
	xor 1
	ld (ScanSwitch),a
	add a,114
	call DoShowHint

	call kilbuf
	call chget

	jp LastPosDone

;EndSongEdit:
;	call DeInitSongMenu
;	ret


#include "sb2-son2.asm"						; additional song edit.
#include "sb2-play.asm"						; play 
#include "sb2-patp.asm"						; Pattern/Position editor!

#include "sb2rmain.asm"

.end

; end
