; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Replay routine
; Code: d-fader^TwZ.
; Date: june 14, 1999
;
; cmnt: filename of this file: BLAF_NT.013
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#include "macro's.asm"
#include "sb2rmacr.asm"

	.org $4200

init_bytes:
	jp start_program

	.ds 16-3

	.text "                "
	.text " SCC BLAFFER NT "
	.text "  (C) 1999 TwZ  "
	.text "                "
	.text " Replay Routine "
	.text "                "

start_program:
	ld a,(RepCommand)
	and $0f

	cp 1
	jp z,StartMusic

	cp 2
	jp z,StopMusic

	cp 3
	jp z,TimeCalculate

	cp 4
	jp z,SaveSongRam

	cp 5
	jp z,LoadSongRam

	cp 6
	jp z,SwapSongRam

	cp 7
	jp z,InfoSettingsMenu

	cp 8
	jp z,getAHData

	cp 9
	jp z,ActiveHelp

	ret

ActiveHelp:
	call ClearBlink

	ShowPic(6)

	ld hl,MaxLine+20
	call Calc16Dec

	SetVW(0,22*80+16)
	ld hl,Decimal+2
	ld bc,$0398
	otir

	ld hl,(RepData)
	ld (AH.NowLine),hl


ActiveMain.1:
	ld hl,(AH.NowLine)
	push hl
	pop bc

	call ShowAHPage
ActiveMain.2:
	Locate(1,25)
	call chget

	ld (CursorSave),a

	Scan2Keys(control,up)
	jp z,AH.PageUp

	Scan2Keys(control,down)
	jp z,AH.PageDown

	ld a,(CursorSave)
	cp $1c
	jp z,AH.PageDown
	cp $1d
	jp z,AH.PageUp
	cp $1e
	jp z,AH.LineUp
	cp $1f
	jp z,AH.LineDown

	cp 27
	ret z

	jp ActiveMain.2

AH.PageUp:
	ld hl,(AH.NowLine)
	ld de,19
	or a
	sbc hl,de
	jp nc,Ah.PageUpOk

	ld hl,1
AH.PageUpOk:
	ld (AH.NowLine),hl

	jp ActiveMain.1

AH.PageDown:
	ld hl,(AH.NowLine)
	ld de,19
	add hl,de

	ld de,MaxLine+2
	or a
	sbc hl,de

	push af

	add hl,de

	pop af

	jp c,Ah.PageDownOk

	ld hl,MaxLine+1
AH.PageDownOk:
	ld (AH.NowLine),hl

	jp ActiveMain.1
	
AH.LineUp:
	ld hl,(AH.NowLine)
	dec hl

	ld a,h
	or l
	jp nz,AH.LineUpOk


	ld hl,1
AH.LineUpOk:
	ld (AH.NowLine),hl

	jp ActiveMain.1

AH.LineDown:
	ld hl,(AH.NowLine)
	inc hl

	ld de,MaxLine+2

	ld a,h
	sub d
	jp nz,AH.LineOk

	ld a,l
	sub e
	jp nz,AH.LineOk

	ld hl,MaxLine+1

AH.LineOk:
	ld (AH.NowLine),hl

	jp ActiveMain.1

AH.NowLine:
	.dw 0

GetAHData:
	ld a,4
	ld hl,0
	call SetVramRead

	ld de,$4000
	ld hl,ActiveHelpOffsets+2

GetAh.1:
	in a,($98)

	inc de

	cp $fe
	jp z,GetAH.done

	cp $ff
	jp nz,GetAH.1

	ld (hl),e
	inc hl
	ld (hl),d
	inc hl

	jp GetAH.1

GetAH.done:
	ret


ActiveHelpOffsets:
	.dw $4000
	.ds 1000*2

ShowAHPage:
; routine : Show active help page.
; in      : BC - start line
; out     : none.
; cmnt    : none.

	ld hl,ActiveHelpOffsets-2

ShowAHPage.1:
	inc hl
	inc hl

	dec bc

	ld a,b
	or c
	jp nz,ShowAHPage.1

	ld e,(hl)
	inc hl
	ld d,(hl)

	ld a,d

	srl a
	srl a
	srl a
	srl a
	srl a
	srl a
	srl a

	add a,4
	ld (AH.SPage),a

	ld a,d
	and %00111111
	ld (AH.SOfs+1),a

	ld a,e
	ld (AH.SOfs),a

	ld hl,81
	ld (AH.DOfs),hl
	
	ld a,(AH.SPage)
	ld hl,(AH.SOfs)
	call SetVramRead

	ld b,8
	ld hl,AH.PageData
AH.Loop2:
	push bc

	ld bc,$c898
	inir

	pop bc

	djnz AH.Loop2

	ld b,20
	ld hl,Ah.Pagedata
AH.Loop3:
	push bc

	ld a,(hl)						; Get number of spaces

	push hl

	ld hl,AH.Line
	ld de,AH.Line+1
	ld bc,77
	ld (hl),32
	ldir

	ld hl,AH.Line
	ld e,a
	ld d,0
	add hl,de						; add spaces

	ex de,hl						; Now line data in DE

	pop hl						; Source in HL

	inc hl						; No Space
	
AH.Loop4:
	ld a,(hl)
	inc hl

	cp $ff
	jp z,Ah.Loop4Done

	ld (de),a
	inc de

	jp AH.Loop4

AH.Loop4Done:
	push hl

	xor a
	ld hl,(AH.DOfs)
	call SetVramWrite

	ld hl,AH.Line
	ld bc,$4e98
	otir

	ld hl,(AH.DOfs)
	ld de,80
	add hl,de
	ld (AH.DOfs),hl

	pop hl

	pop bc

	djnz AH.Loop3

	ld hl,(AH.NowLine)
	call Calc16Dec

	SetVW(0,22*80+8)
	ld hl,Decimal+2
	ld bc,$0398
	otir

	ld hl,(AH.NowLine)
	ld de,19
	add hl,de
	call Calc16Dec

	SetVW(0,22*80+12)
	ld hl,Decimal+2
	ld bc,$0398
	otir

	ret

AH.line:
	.ds 78

AH.DOfs:
	.dw 0

AH.SPage:
	.db 0
AH.SOfs:
	.dw 0

AH.Pagedata:
	.ds 20*80

SaveSongRam:
	ShowHint(119)

	call YesOrNo
	ret nz

	ld a,SngBnk
	out ($fe),a

SaveSongRam.1:
	Ram2Vram(4,$0000,$8000,64)

	ld a,1
	ld (SSR.Stored),a

	ret

LoadSongRam:
	ShowHint(120)

	call YesOrNo
	ret nz

	call CheckIfStored

LoadSongRam.1:
	ld a,SngBnk
	out ($fe),a

	ld a,4
	ld de,$0000
	ld hl,$7fff
	ld b,64
	call CopyVramRam

	ret

SwapSongRam:
	ShowHint(121)

	call YesOrNo
	ret nz

	call CheckIfStored

	ld hl,$8000
	ld (SSR.Adr),hl

	ld b,64
SSR.1:
	push bc

	ld a,SngBnk
	out ($fe),a

	ld hl,(SSR.Adr)
	ld de,RamData
	ld bc,256
	ldir

	ld a,7
	out ($fe),a

	ld hl,(SSR.Adr)
	ld de,RamData

	ex de,hl

	ld bc,256
	ldir

	ld hl,(SSR.Adr)
	ld de,256
	add hl,de
	ld (SSR.Adr),hl

	pop bc

	djnz SSR.1

	call LoadSongRam.1

	ld a,7
	out ($fe),a

	call SaveSongRam.1

	ret

RamData:
	.ds 256

SSR.Adr:
	.dw 0

SSR.stored:
	.db 0

CheckIfStored:
	ld a,(SSR.stored)
	or a
	ret nz

	ShowHint(122)

	call kilbuf
	call chget

	pop hl

	ret

CopyVramRam:
; routine : Copy part of VRAM to RAM.
; in      : A - VRAM page, DE - Offset VRAM (source), HL - Source pointer, B - Number of
;		256 Bytes Blocks
; out     : none.
; cmnt    : none.

	push hl

	ex de,hl

	call SetVramWrite

	pop hl

	ld d,b
	ld c,$98

CopyVramRamLoop1:
	ld b,$00
	inir

	dec d
	jr nz,CopyVramRamLoop1

	ret

InitReplay:
; routine : Initialise memory mapper for replaying
; in      : (RepData) - SCC Slot selection.
; out     : (PrimairPlay) - Primary slot selections, (SecondarePlay) - Secondare slot selections
; cmnt    : In basic replayer: detect SCC here too! (don't forget mister d-fader..)
	
	ld a,SngBnk
	ld (SngBnkPlay),a

	ld a,InsBnk
	ld (InsBnkPlay),a

	ld a,($f342)
	and %00000011

	ld b,a

	sla a
	sla a

	sla b
	sla b
	sla b
	sla b

	or b

	ld b,a

	in a,($a8)
	and %11000011

	or b

	and %11001111
	ld b,a

	ld a,(RepData)								; get SCC Slot
	or b
	ld (SccSlot),a

	
	ret

StartMusic:
; routine : Start music replay
; in      : none.
; out     : none.
; cmnt    : This rout. does it all.. after this you hear music! (after d-fader has coded the
;           routines, ofcourse, but I think he has done it, because else you wouldn't be 
;		reading this, exept if d-fader dies, and somebody (I don't know why though) decides
;		to continue coding this damn project... (Y'know, I type this because of the fact
;		I don't want to start coding the replayer, 'cause it's so damn irritating to code!))
;		(and it's also hard/much... ;))

; --- Remove this in Basic replayer ---

	ld a,255
	ld (OldSCCSwitch),a

; --- Remove till here ---

	call InitReplay

	ld a,255
	ld (NewPSG),a

	ld a,15
	ld (PSGMaxVol),a

	ld a,16
	ld (PSGPlayRow),a

	ld a,(SngBnkPlay)
	out ($fe),a

	ld a,(SngPos)
	dec a
	ld (SngPos),a

	xor a
	ld (LastPosDone),a

	ld a,15
	ld (SngRow),a

	ld a,(InitialTempo)
	ld b,a
	ld a,26
	sub b
	
	ld (SngTmp),a

	xor a
	ld (TmpCount),a

	ld hl,DataBlocks.start
	ld de,DataBlocks.start+1
	ld bc,DataBlocks.end-DataBlocks.start-1
	ld (hl),0
	ldir

	ld hl,SngFreqs	
	ld de,SngFreqs+1
	ld bc,9
	ld (hl),0
	ldir

	call SetSCC

	ld hl,$988a
	ld b,5
volumeOutLoop:
	ld (hl),0

	inc hl

	djnz volumeOutLoop


	ld hl,SngFreqs
	ld de,$9880
	ld bc,10
	ldir	

	ld a,%00011111
	ld ($988f),a

	call ResetSCC

	ld a,3
	ld (Block.Modulate),a

	ld hl,StartInstruments
	ld de,Block.LastInstruments
	ld bc,4
	ldir

	ld hl,StartVolumes
	ld de,SngVolumes
	ld bc,5
	ldir

	ld hl,VolumeSlideSettings
	ld de,Block.AutoSlide
	ld bc,5
	ldir

	ld hl,DetuneSettings
	ld de,Detune
	ld bc,5
	ldir

; --- out all 'start' settings done, so settings scan must be put right here! ---

	call SettingsScan

	ld hl,$9800
	ld (SaveInsAdr),hl

	ld b,4
	ld hl,Block.LastInstruments
StartMusic.1:
	push bc
	push hl

	ld a,(SngBnkPlay)
	out ($fe),a

	ld a,(hl)
	inc a
	ld b,a

	ld hl,$8000-32
	ld de,40
StartMusic.2:
	add hl,de

	djnz StartMusic.2

	ld a,(InsBnkPlay)
	out ($fe),a

	ld de,InstrumentChange
	ld bc,32
	ldir

	call SetSCC

	ld hl,(SaveInsAdr)
	ld de,InstrumentChange

	ex de,hl

	ld bc,32

	ldir

	ex de,hl

	ld (SaveInsAdr),hl

	call ResetSCC

	pop hl
	pop bc
	
	inc hl

	djnz StartMusic.1

	ld a,(SngBnkPlay)
	out ($fe),a




	ld a,1
	ld (MusicPlay),a

	ld hl,$fd9f
	ld de,OldPlayInt
	ld bc,5
	ldir

	ld a,($f342)
	ld (RepInt.slot),a

	ld hl,RepInt.start
	ld de,RepInterrupt
	ld bc,RepInt.end-RepInt.start
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,IntCode+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	ret

TimeCalculate:
; routine : Calculate song time...
; in      : none.
; out     : (SongMin) - Number of minutes, (SongSec) - Number of seconds
; cmnt    : none.

	ShowHint(117)

	xor a
	ld (TC.Min),a
	ld (TC.Sec),a
	ld (TC.Count),a
	ld (TC.Pos),a

	ld a,(InitialTempo)
	ld b,a
	ld a,27
	sub b
	ld (TC.Tempo),a

	ld a,SngBnk
	out ($fe),a

	ld a,(LastPos)
	inc a
	ld b,a
TC.loop1:
	push bc

	call TC.CalcPosAdr

	ld b,16
TC.loop2:
	push bc

	ld hl,(TC.RowAdr)

	ld a,(hl)
	or a
	jp z,TC.loop2.done

	cp 26
	jp c,TC.NewTempo

	cp 26
	jp z,TC.EndOp

TC.loop2.done:
	call TC.AddTime

	pop bc

	ld hl,(TC.RowAdr)
	ld de,12
	add hl,de
	ld (TC.RowAdr),hl

	djnz TC.loop2

TC.EndOpFound:
	pop bc

	ld a,(TC.Pos)
	inc a
	ld (TC.Pos),a

	djnz TC.loop1



	ld a,(TC.Count)
	cp 25
	call nc,TC.IncOneSec

	ShowHint(118)

	SetVW(0,22*80+34)

	ld a,(TC.Min)
	call Calc8Dec

	ld hl,Decimal+1
	ld bc,$0298
	otir
	
	SetVW(0,22*80+37)

	ld a,(TC.Sec)
	call Calc8Dec

	ld hl,Decimal+1
	ld bc,$0298
	otir

	call kilbuf
	call chget

	ret

TC.CalcPosAdr:
	ld a,(TC.pos)
	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(hl)
	inc a
	ld b,a

	ld hl,PatternData-192
	ld de,192
TC.CPA.1:
	add hl,de

	djnz TC.CPA.1

	ld (TC.PosAdr),hl

	ld de,11
	add hl,de

	ld (TC.RowAdr),hl

	ret

TC.NewTempo:
	ld b,a
	ld a,27
	sub b
	ld (TC.Tempo),a

	jp TC.Loop2.done

TC.EndOp:
	call TC.AddTime

	pop bc

	jp TC.EndOpFound

TC.AddTime:
	ld a,(TC.Tempo)
	ld b,a

	ld a,(TC.Count)
	add a,b
	ld (TC.Count),a

	cp 50
	ret c

	sub 50
	ld (TC.Count),a

TC.IncOneSec:
	ld a,(TC.Sec)
	inc a
	ld (TC.Sec),a

	cp 60
	ret nz

	xor a
	ld (TC.Sec),a

	ld a,(TC.Min)
	inc a
	ld (TC.Min),a

	ret

TC.Min:
	.db 0
TC.Sec:
	.db 0
TC.Count:
	.db 0
TC.Tempo:
	.db 0

TC.pos:
	.dw 0
TC.PosAdr:
	.dw 0
TC.RowAdr:
	.dw 0

SettingsScan:
; routine : Scan song for settings.
; in      : none.
; out     : none.
; cmnt    : Setting scan checks on: Auto slides, detunes, instruments, transpose, tempo and
;		maximum PSG Volumes.
;
;		The 'SS' ofcourse stands for Settings Scan, and not for those motherf**kers in the
;		second world war... (I really don't even know what the shortening stands for, and
;		I also *DO NOT* want to know...)

	ld a,(ScanSwitch)					; Check if settings scan should be executed...
	or a
	ret z

	ld a,(SngPos)					; Don't scan if pos. 0
	inc a							;
	ret z							;

	ShowHint(116)

	ld a,SngBnk
	out ($fe),a

	ld a,(SngPos)					; Number of patterns to scan...
	ld (SS.SaveSngPos),a

	inc a
	ld b,a

	xor a
	ld (SngPos),a
SS.Loop1:
	push bc


	ld a,(SngPos)
	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(hl)
	inc a

	ld b,a
	ld hl,PatternData-192
	ld de,192
SS.Loop4:
	add hl,de

	djnz SS.Loop4

	ex de,hl

	push de
	push bc

	call SS.ShowPos

	pop bc
	pop de


	ld b,16						; Number of rows per pattern
SS.Loop3:
	push bc
	push de

	ld b,5						; Number of channels to check
SS.Loop2:
	push de
	push bc

	ld a,(de)

	cp 98
	jp z,SS.InstrumentChange

	cp 105
	jp z,SS.DetuneUp

	cp 106
	jp z,SS.DetuneDown

	cp 109
	jp z,SS.AutoSlide.Up

	cp 110
	jp z,SS.AutoSlide.Down

SS.Done:
	pop bc
	pop de

	inc de
	inc de

	djnz SS.Loop2

	inc de

	; check command channel

	ld a,(de)

	or a
	jp z,SS.ComCDone

	cp 26
	jp c,SS.ChangeTempo	

	cp 26
	jp z,SS.EndOp

	cp 40
	jp c,SS.ChangeTransPose

SS.ChangeMaxPSGVol:
	sub 40

	ld (PSGMaxVol),a

	jp SS.ComCDone

SS.ChangeTransPose:
	sub 33
	ld (Block.Transpose),a

SS.ComCDone:
	pop hl
	pop bc

	ld de,12
	add hl,de
	ex de,hl

	djnz SS.Loop3

SS.EndOpFound:
	pop bc

	ld a,(SngPos)
	inc a
	ld (SngPos),a

	djnz SS.Loop1	

	ld a,(SS.SaveSngPos)
	ld (SngPos),a

	ret

SS.EndOp:
	pop bc
	pop hl

	jp SS.EndOpFound

SS.ChangeTempo:
	ld b,a
	ld a,26
	sub b
	ld (SngTmp),a

	call SS.ShowTempo

	jp SS.ComCDone

SS.InstrumentChange:
	ld a,5
	sub b
	ld hl,Block.LastInstruments
	ld c,a
	ld b,0
	add hl,bc

	inc de
	ld a,(de)

	ld (hl),a

	jp SS.Done

SS.DetuneUp:
	ld a,5
	sub b

	ld c,a
	ld b,0
	ld hl,Detune
	add hl,bc

	inc de
	ld a,(de)

	or 128
	ld (hl),a

	jp SS.Done

SS.DetuneDown:
	ld a,5
	sub b

	ld c,a
	ld b,0
	ld hl,Detune
	add hl,bc

	inc de
	ld a,(de)

	and 127

	ld b,a
	ld a,128
	sub b

	ld (hl),a

	jp SS.Done

SS.AutoSlide.Up:
	ld a,5
	sub b
	ld c,a
	ld b,0
	ld hl,Block.AutoSlide
	add hl,bc

	inc de
	ld a,(de)


	and $0f
	or $10

	ld (hl),a

	jp SS.done

SS.AutoSlide.Down:
	ld a,5
	sub b
	ld c,a
	ld b,0
	ld hl,Block.AutoSlide
	add hl,bc

	inc de
	ld a,(de)

	and $0f

	ld b,a
	ld a,$10

	sub b

	ld (hl),a

	jp SS.Done	

SS.ShowTempo:
	ld hl,80*11+76

	ld a,(Play.PatPosEdit)
	or a
	jp z,SS.ShowTempo.1

	ld hl,80*15+77
SS.ShowTempo.1:
	push hl

	ld a,(SngTmp)
	ld b,a
	ld a,26
	sub b

	call Calc8Dec

	xor a

	pop hl

	call SetVramWrite

	ld hl,Decimal+1
	ld bc,$0298
	otir

	ret

SS.ShowPos:
	ld hl,80*5+75

	ld a,(Play.PatPosEdit)
	or a
	jp z,SS.ShowPos.1

	ld hl,80*5+76
SS.ShowPos.1:
	push hl

	ld a,(SngPos)

	call Calc8Dec

	xor a

	pop hl

	call SetVramWrite

	ld hl,Decimal
	ld bc,$0398
	otir

	ret

SS.SaveSngPos:
	.db 0

StopMusic:
; routine : Stop music
; in      : none.
; out     : none.
; cmnt    : none.
	xor a
	ld (MusicPlay),a

	ld a,$c9
	ld ($fd9f),a

	ld hl,OldPlayInt+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call SetSCC

	xor a
	ld ($988f),a

	call ResetSCC

	call PSG.StopSound

	ret

PSG.StopSound:
	ld a,16
	ld (PSGPlayRow),a

	ld d,%10111111
	OutPSG(7)

	ret

SetScc:
	in a,($a8)
	ld (SaveSetSCC),a

	ld a,(SccSlot)
	out ($a8),a

	ld a,$3f
	ld ($9000),a

	xor a
	ld ($98e0),a

	ret

ResetSCC:
	ld a,(SaveSetSCC)
	out ($a8),a

	ret

SaveSetSCC:
	.db 0

PlayInt:
; --- remove this in BASIC replayer ---

	ld a,(OldSCCSWitch)
	ld b,a
	ld a,(SCCSwitch)
	cp b
	jp z,SCC.NoChange

	call SetSCC

	ld a,(SCCSwitch)
	ld (OldSCCSwitch),a
	ld ($988f),a

	call ResetSCC

	jp SCC.NoChange

OldSCCSwitch:
	.db 0

SCC.NoChange:
; --- remove till here ---

	ld a,(MusicPlay)
	or a
	jp z,NoMusicPlay

	xor a
	ld (MusicPeak),a

	ld a,($ffe8)
	bit 1,a
	jp nz,NoHertzEqualizer

	ld a,(HertzCount)
	or a
	jp nz,NoHertzAdjust

	ld a,5
	ld (HertzCount),a

	jp EndPlayInt

NoHertzAdjust:	
	dec a
	ld (HertzCount),a

NoHertzEqualizer:
	ld a,(TmpCount)
	or a
	jp nz,NoNewRow

; --- new row code ---
NewRow:
	ld a,1
	ld (MusicPeak),a

	ld a,(SngBnkPlay)
	out ($fe),a

	ld a,(SngTmp)
	ld (TmpCount),a

	ld a,(LastRowPlayed)
	or a
	jp nz,NewPosition

	ld a,(SngRow)
	inc a
	cp 16
	jp z,NewPosition

	ld (SngRow),a

	ld hl,(NowAddress)
	ld de,12
	add hl,de
	ld (NowAddress),hl

NewRowDone:
; --- Remove all pitch bend 2 data ---

	ld hl,Block.Pitch
	ld b,5
Clear.Pitch2:
	ld a,(hl)
	bit 2,a
	jp z,Clear.Pitch2.done

	ld (hl),0
Clear.Pitch2.done:
	inc hl
	inc hl

	djnz Clear.Pitch2

	ld hl,(NowAddress)
	ld de,10
	add hl,de

; --- Check PSG channel ---
	ld a,(hl)
	ld (RepCommand+5),a

	or a
	jp z,PSGChannelDone

	dec a
	ld (NewPSG),a
PSGChannelDone:
; --- Check command channel ---

	inc hl

	ld a,(hl)
	ld (RepCommand+6),a

	or a
	jp z,CheckCommandChannelDone

	cp 26
	jp c,ComC.ChangeTempo

	cp 26
	jp z,ComC.EndOfPat

	cp 40
	jp c,ComC.ChangeTransPose

ComC.ChangePMV:
	sub 40

	ld (PSGMaxVol),a

	jp CheckCommandChannelDone

ComC.ChangeTransPose:
	sub 33
	ld (Block.Transpose),a

	jp CheckCommandChannelDone

ComC.EndOfPat:
	ld a,1
	ld (LastRowPlayed),a

	jp CheckCommandChannelDone

ComC.ChangeTempo:
	ld b,a
	ld a,26
	sub b
	ld (SngTmp),a
	ld (TmpCount),a

	jp CheckCommandChannelDone


CheckCommandChannelDone:
; --- Do all Autoslides ---

	ld de,Block.AutoSlide
	ld hl,Block.VolumeSlides

	ld b,5
AS.loop1:
	push bc

	ld a,(de)

	ld c,a

	cp $10
	jp z,AS.NotOn

	set 5,a
AS.NotOn:
	and $f0
	ld (hl),a

	ld a,(SngTmp)
	inc a
	ld b,a

	ld a,c
	and %00011111

	cp $10
	jp nc,AS.Add

	ld c,a
	ld a,$10
	sub c

AS.Add:
	and $0f

; a - correcte slide value (15)
; b - correcte tempo       (16)

	ld c,0
AS.loop2:
	inc c
	sub b
	jp nc,AS.loop2

	add a,b

; a = 15
; c = 1

; a - number of interrupts to do.
; c - number of volume steps per interrupt.

	ld b,a
	ld a,c

	or (hl)					; Add all other shit to value to slide per interrupt
	ld (hl),a					; Set that in HL.

	inc hl

	ld (hl),b					; Set how much interrupts to slide in hl

	pop bc

	inc hl					; Next volume slide channel
	inc de					; Next auto slide channel

	djnz AS.loop1	


; --- alle data die nodig voor een nieuwe row komt hier! ---

	ld ix,SngVolumes
	ld iy,RepCommand

	ld hl,(NowAddress)
	ex de,hl
	ld hl,SngFreqs
	ld b,5
CheckCommand.1:
	push hl
	push bc

	ld a,(de)
	ld (iy),a

	or a
	jp z,CC.OutNewVolume

	cp 97
	jp c,CC.OutNewFreq

	cp 97
	jp z,CC.OffEvent

	cp 98
	jp z,CC.ChangeInstrument

	cp 99
	jp z,CC.Pitch1UpEvent

	cp 100
	jp z,CC.Pitch1DownEvent

	cp 101
	jp z,CC.Pitch2UpEvent

	cp 102
	jp z,CC.Pitch2DownEvent

	cp 103
	jp z,CC.ModulateUpEvent

	cp 104
	jp z,CC.ModulateDownEvent

	cp 105
	jp z,CC.DetuneUp

	cp 106
	jp z,CC.DetuneDown

	cp 107
	jp z,CC.VolSlide.Up

	cp 108
	jp z,CC.VolSlide.Down

	cp 109
	jp z,CC.AutoSlide.Up

	cp 110	
	jp z,CC.AutoSlide.Down

CC.done:
	pop bc
	pop hl

	inc hl
	inc hl

	inc de
	inc de

	inc ix

	inc iy

	djnz CheckCommand.1

	jp PlayContinue

CC.ChangeInstrument:
	ld a,5
	sub b

	cp 4
	jp z,CC.Done

	push af

	sla a
	sla a
	sla a
	sla a
	sla a
	ld c,a
	ld b,0
	ld hl,$9800
	add hl,bc

	ld (SaveInsAdr),hl

;	---- remove!!!! ----
;	pop af
;	jp CC.Done
;	---- remove!!!! ----

	pop af

	ld c,a
	ld b,0
	ld hl,Block.LastInstruments
	add hl,bc

	ld a,(hl)
	ld b,a

	inc de
	ld a,(de)
	dec de

	cp b
	jp z,CC.Done

	cp 207
	jp nc,CC.Done

	ld (hl),a

	inc a
	ld b,a

	push de

	ld hl,$8000-32
	ld de,40
CC.CI.1:
	add hl,de

	djnz CC.CI.1

	ld a,(InsBnkPlay)
	out ($fe),a

	ld de,InstrumentChange
	ld bc,32
	ldir

	call SetSCC

	ld hl,(SaveInsAdr)
	ld de,InstrumentChange
	ex de,hl
	ld bc,32
	ldir

	call ResetSCC

	ld a,(SngBnkPlay)
	out ($fe),a

	pop de

	jp CC.Done

CC.ModulateUpEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.Pitch						; Remove pitch bend data
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.ModulateData
	add hl,bc

	ld (hl),%00000011

	inc de
	ld a,(de)
	dec de

	inc hl

	ld (hl),a

	jp CC.Done

CC.ModulateDownEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.Pitch						; Remove pitch bend data
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.ModulateData
	add hl,bc
	
	ld (hl),%00000010

	inc de
	ld a,(de)
	dec de

	inc hl

	ld (hl),a

	jp CC.Done


CC.Pitch2UpEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.ModulateData				; Remove modulate
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.Pitch
	add hl,bc
	
	ld (hl),%00000111						; pitch 2, pitch on, pitch up

	jp CC.Pitch2.Calculate

CC.Pitch2DownEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.ModulateData				; Remove modulate
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.Pitch
	add hl,bc
	
	ld (hl),%00000110						; pitch 2, pitch on, pitch down

	jp CC.Pitch2.Calculate

CC.Pitch2.Calculate:
	inc hl

	ld a,(SngTmp)
	inc a
	ld b,a
	ld c,0

	inc de
	ld a,(de)
	dec de

CC.P2.calc.1:
	sub b

	inc c

	jp nc,CC.P2.calc.1

	dec c

	ld (hl),c

	jp CC.Done



CC.Pitch1UpEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.ModulateData				; Remove modulate
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.Pitch
	add hl,bc
	
	ld (hl),%00000011						; pitch 1 pitch on, pitch up

	inc hl

	inc de
	ld a,(de)
	dec de

	or a
	jp z,CC.Pitch1Off

	ld (hl),a

	jp CC.Done

CC.Pitch1Off:
	dec hl
	ld (hl),0

	jp cc.done

CC.Pitch1DownEvent:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.ModulateData				; Remove modulate
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.Pitch
	add hl,bc

	ld (hl),%00000010						; pitch 1, pitch on, pitch down

	inc hl

	inc de
	ld a,(de)
	dec de

	ld (hl),a

	jp CC.Done

CC.DetuneUp:
	ld a,5
	sub b

	ld c,a
	ld b,0
	ld hl,Detune
	add hl,bc

	inc de
	ld a,(de)
	dec de

	or 128
	ld (hl),a

	jp CC.Done

CC.DetuneDown:
	ld a,5
	sub b

	ld c,a
	ld b,0
	ld hl,Detune
	add hl,bc

	inc de
	ld a,(de)
	dec de

	and 127

	ld b,a
	ld a,128
	sub b

	ld (hl),a

	jp CC.Done


CC.VolSlide.Up:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0
	ld hl,Block.VolumeSlides
	add hl,bc

	ld a,%00110000
	;     76543210

	jp CC.CreateVolSlide

CC.VolSlide.Down:
	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0
	ld hl,Block.VolumeSlides
	add hl,bc

	ld a,%00100000

CC.CreateVolSlide:
	ld (hl),a

	ld a,(SngTmp)
	inc a
	ld b,a

	inc de
	ld a,(de)
	dec de
	and $0f	


; a - correcte slide value (15)
; b - correcte tempo       (16)

	ld c,0
VS.loop2:
	inc c
	sub b
	jp nc,VS.loop2

	add a,b

; a - number of interrupts to do.
; c - number of volume steps per interrupt.

	ld b,a
	ld a,c

	or (hl)					; Add all other shit to value to slide per interrupt
	ld (hl),a					; Set that in HL.

	inc hl

	ld (hl),b					; Set how much interrupts to slide in hl

	jp CC.Done

CC.AutoSlide.Up:
	ld a,5
	sub b
	ld c,a
	ld b,0
	ld hl,Block.AutoSlide
	add hl,bc

	inc de

	ld a,(de)

	dec de

	and $0f
	or $10

	ld (hl),a

	jp CC.done

CC.AutoSlide.Down:
	ld a,5
	sub b
	ld c,a
	ld b,0
	ld hl,Block.AutoSlide
	add hl,bc

	inc de

	ld a,(de)

	dec de

	and $0f

	ld b,a
	ld a,$10

	sub b

	ld (hl),a

	jp CC.Done	

CC.OffEvent:
	ld (hl),0
	inc hl
	ld (hl),0

	ld a,5
	sub b

	sla a

	ld c,a
	ld b,0

	ld hl,Block.Pitch						; Remove pitch bend
	add hl,bc							;
	ld (hl),0							;

	ld hl,Block.ModulateData				; Remove modulate
	add hl,bc							;
	ld (hl),0							;


	jp cc.done


CC.OutNewVolume:
	inc de
	ld a,(de)
	dec de
	and $0f
	jp z,CC.Done

	ld (ix),a

	jp CC.Done

CC.OutNewFreq:
	push af

	ld a,b

	exx

	ld b,a
	ld a,5
	sub b
	ld e,a
	ld d,0
	ld hl,Detune
	add hl,de

	ld a,(hl)	
	ld (NowDetune),a

	exx 

	inc de
	ld a,(de)
	dec de
	
	exx 

	and $f0
	jp nz,CC.NoPitchRemove

	ld hl,Block.Pitch						; Remove pitch bend
	sla e								;
	add hl,de							;
	ld (hl),0							;

	ld hl,Block.ModulateData				; Remove modulate
	add hl,de							;
	ld (hl),0							;

CC.NoPitchRemove:
	exx

	pop af

	ld b,a

	ld a,(Block.Transpose)
	add a,b
	ld b,a

	cp 97
	jp c,TransposeOk

	ld b,96
TransposeOk:
	inc de

	ld a,(de)
	and $0f
	ld (ix),a

	dec de

	ld a,b

	or a
	jp z,cc.done

	exx

	dec a
	sla a
	ld e,a
	ld d,0
	ld hl,FreqData.start
	add hl,de

	ld c,(hl)
	inc hl
	ld b,(hl)

	ld l,c
	ld h,b

	ld de,0

	ld a,(NowDetune)
	cp 128
	jp z,DetuneSelected

	ld d,255

	and $7f

	cpl
	inc a

	ld e,a

	ld a,(NowDetune)

	bit 7,a
	jp nz,DetuneSelected	

	ld b,a

	ld d,0
	ld a,128
	sub b
	ld e,a
DetuneSelected:
	add hl,de

	ld c,l
	ld b,h

	push bc

	exx

	pop bc

	ld (hl),c
	inc hl
	ld (hl),b

	jp CC.done

NowDetune:
	.db 0

NewPosition:
; --- remove this in basic replayer!! ---
	ld a,(play.pattern)
	cp 255
	jp z,NewPosition.NotPattern

	inc a
	ld (play.pattern),a

	cp 2
	jp z,PlayPattern.stop

NewPosition.NotPattern:

; --- remove basic till here ---

	xor a
	ld (LastRowPlayed),a

	ld a,(LastPosDone)
	or a
	jp nz,DoLoopSong

	ld a,(SngPos)
	inc a
	ld b,a
	ld a,(LastPos)
	cp b
	jp nz,NotLastPos

	ld a,1
	ld (LastPosDone),a

NotLastPos:
	xor a
	ld (SngRow),a

	ld a,b
	ld (SngPos),a

	ld hl,Patterns
	ld e,a
	ld d,0
	add hl,de

	ld b,(hl)

	inc b

	ld hl,Patterndata-192
	ld de,192
NewPosition.1:
	add hl,de

	djnz NewPosition.1

	ld (NowAddress),hl

	jp NewRowDone

DoLoopSong:
	xor a
	ld (LastPosDone),a

	ld a,(LoopPos)
	or a
	jp z,DoLoopSong.1

PlayPattern.stop:
	xor a
	ld (MusicPlay),a

	jp PlayIntDone

DoLoopSong.1:
	ld a,(LoopPos+1)

	dec a
	ld (SngPos),a

	jp NewPosition


NoNewRow:
	dec a
	ld (TmpCount),a
	
PlayContinue:
; --- continue player ongein ---


; --- out all volume slides ---

;	ld a,(MusicPeak)
;	or a
;	jp nz,PC.NoVolumeSlide

	ld hl,Block.VolumeSlides
	ld de,SngVolumes
	ld b,5
OVS.loop1:
	push hl
	push bc

	inc hl

	ld a,(hl)
	or a
	jp z,OVS.loop1.done

	dec (hl)

	dec hl

	ld a,(hl)
	bit 5,a
	jp z,OVS.loop1.done 

	bit 4,a
	jp z,OVS.SlideDown

OVS.SlideUp:
	and $0f
	inc a

	ld b,a

	ld a,(de)
	add a,b

	cp 15
	jp z,OVS.NoAdjustUp
	jp c,OVS.NoAdjustUp

	ld a,15
OVS.NoAdjustUp:
	ld (de),a

	jp OVS.loop1.done

OVS.SlideDown:
	and $0f
	inc a

	ld b,a

	ld a,(de)
	sub b

	jp nc,OVS.NoAdjustDown

	xor a
OVS.NoAdjustDown:
	ld (de),a

OVS.loop1.done:
	pop bc
	pop hl

	inc hl
	inc hl

	inc de

	djnz OVS.loop1


PC.NoVolumeSlide:

; --- Pitch slide 1 and 2 ---

	ld de,Block.Pitch
	ld hl,SngFreqs
	ld b,5
Pitch.1:
	push bc
	push de
	push hl

	ld a,(de)
	bit 1,a
	jp z,Pitch.ChanDone

	ex af,af'

	inc de
	ld a,(de)

	ld b,255

	cpl
	inc a
	ld c,a

	ex af,af'

	bit 0,a
	jp nz,Pitch.Selected

	ld a,(de)
	ld c,a
	ld b,0
Pitch.Selected:
	ld e,(hl)
	inc hl
	ld d,(hl)

	ex de,hl

	add hl,bc

	ex de,hl

	ld (hl),d
	dec hl
	ld (hl),e

Pitch.ChanDone:
	pop hl
	pop de
	pop bc

	inc hl
	inc hl

	inc de
	inc de

	djnz Pitch.1

; --- Modulate ---
	ld a,(Block.Modulate)
	dec a
	ld (Block.Modulate),a

	jp nz,NoModulateExecution

	ld a,3
	ld (Block.Modulate),a

	ld de,Block.ModulateData
	ld hl,SngFreqs
	ld b,5
PC.Modulate.1:
	push bc
	push de

	ld a,(de)
	bit 1,a
	jp z,PC.Modulate.1.NoMod

	push hl

	ld c,(hl)
	inc hl
	ld b,(hl)

	ld l,c
	ld h,b

	bit 0,a
	jp z,PC.Modulate.1.Subst

	xor 1
	ld (de),a

	inc de
	ld a,(de)

	ld e,a
	ld d,0

	or a
	sbc hl,de
PC.Modulate.1.Done:
	ld c,l
	ld b,h

	pop hl

	ld (hl),c
	inc hl
	ld (hl),b
	dec hl
PC.Modulate.1.NoMod:
	pop de
	pop bc

	inc de
	inc de

	inc hl
	inc hl

	djnz PC.Modulate.1

	jp NoModulateExecution

PC.Modulate.1.Subst:
	xor 1
	ld (de),a

	inc de
	ld a,(de)

	ld e,a
	ld d,0

	add hl,de

	jp PC.Modulate.1.Done
	

NoModulateExecution:
; --- all of the replaying done, so out all volumes and frequencies to the SCC ---

	call SetSCC

	ld de,SngFreqs
	ld hl,Block.LastFreqs
	ld ix,$9880
	ld b,5
OutFreqSCC.1:
	ld a,(de)
	cp (hl)
	jp nz,OutFreqSCC.2

	inc de
	ld a,(de)
	dec de

	inc hl
	cp (hl)
	dec hl

	jp nz,OutFreqSCC.2

OutFreqSCC.3:
	inc de
	inc de

	inc hl
	inc hl

	inc ix
	inc ix

	djnz OutFreqSCC.1

	ld de,SngVolumes
	ld hl,Block.LastVolumes
	ld ix,$988a
	ld b,5
OutVolSCC.1:
	ld a,(de)
	cp (hl)
	jp z,OutVolSCC.2

	ld (hl),a
	ld (ix+0),a

OutVolSCC.2:
	inc de

	inc hl

	inc ix

	djnz OutVolSCC.1

	call ResetSCC

EndPlayInt:
	ld a,(InsBnkPlay)
	out ($fe),a

	call DoPSG

PlayIntDone:
	ret

OutFreqSCC.2:
	ld a,(de)
	ld (hl),a
	ld (ix+0),a

	inc de
	ld a,(de)

	ld (ix+1),a

	inc hl
	ld (hl),a
	dec hl

	dec de	

	jp OutFreqSCC.3

NoMusicPlay:
	call SetSCC

	xor a
	ld ($988f),a

	call ResetSCC

	jp PlayIntDone

;--- replayer data blocks ---

PitchSave:
	.db 0
HertzCount:
	.db 0
TmpCount:
	.db 0
NowAddress:
	.dw 0
Detune:								; current detune settings
	.ds 5
LastPosDone:
	.db 0

InstrumentChange:
	.ds 32
SaveInsAdr:
	.dw 0

; --- these need to be behind eachother!!! ---

DataBlocks.start:

LastRowPlayed:
	.db 0

Block.Transpose:
	.db 0

Block.LastFreqs:
	.ds 10

Block.LastVolumes:
	.ds 5

Block.LastInstruments:
	.ds 4

Block.Pitch:
; byte 1:	bit 2: Which pitch slide?? 0 = Pitch slide 1, 1 = Pitch Slide 2
;		bit 1: Pitch slide ? on (1) or off (0)
;		bit 0: How to slide: up (1) or down (0)
;
; byte 2:	How much to slide per interrupt ($01-$ff)

	.ds 10

Block.ModulateData:
; byte 1:	bit 1: Modulate ? on (1) or off (0)
;		bit 0: How to modulate: up (1) or down (0)
;
; byte 2:	How much to slide per 3 interrupts

	.ds 10

Block.Modulate:
	.db 0				; modulate is executed once per 3 interrupts.

Block.VolumeSlides:
; byte 1:	bit   5: Volume slide on (1) or off (0)			(channel 1)
;      	bit   4: How to slide: up (1) or down (0)			(channel 1)
;		bit 3-0: How much to slide per interrupt			(channel 1)
;
; byte 2:	counter: How much interrupts have to be slided?		(channel 1)
;
; byte 3:   see byte 1								(channel 2)
; byte 4:	see byte 2								(channel 2)
;
; etc. (in total 10 bytes)

	.ds 10

Block.Autoslide:
; These are slightly different then the normal VolumeSlides. Autoslides will be executed (if set
; on, that is) every row by copying these Autoslides to the normal slide block. If (after that)
; a norml slide (VS) may occur, then that slide is done. So, the Autoslides have less influence
; on the playing routine as the normal Volume slides.

	.ds 5

DataBlocks.end:

; --- till here ---

FreqData.start:
        .dw 3421,3228,3047,2876,2715,2562,2419,2283,2155,2034,1920,1812		; c 1 - b 1
        .dw 1711,1614,1524,1438,1358,1281,1210,1142,1078,1017,0960,0906		; c 2 - b 2
        .dw 0855,0807,0762,0719,0679,0641,0605,0569,0539,0509,0480,0453		; c 3 - b 3
        .dw 0428,0404,0381,0360,0339,0320,0302,0285,0269,0254,0240,0227		; c 4 - b 4
        .dw 0214,0202,0190,0180,0170,0160,0151,0143,0135,0127,0120,0113		; c 5 - b 5
        .dw 0107,0101,0095,0090,0085,0080,0076,0071,0067,0064,0060,0057		; c 6 - b 6
        .dw 0053,0050,0048,0045,0042,0040,0038,0036,0034,0032,0030,0028		; c 7 - b 7
        .dw 0027,0025,0024,0022,0021,0020,0019,0018,0017,0016,0015,0014		; c 8 - b 8
FreqData.end:

;--------- PSG Replay Routine ---------

DoPSG:
; --- Remove this in basic replayer --- 
	ld a,(PSGSwitch)
	or a
	jp nz,DoPSG.1

	ld d,%10111111
	OutPSG(7)

	ret

DoPSG.1:
; --- Remove till here ---

	ld a,(NewPSG)
	inc a
	jp z,NoNewPSG

	ld b,a
	ld hl,psg_source-176
	ld de,184
NewPSGLoop1:
	add hl,de
	djnz NewPSGLoop1

	ld d,%10111111
	OutPSG(7)

	ld (PSGPlayAddress),hl

	ld a,15
	ld (PSGVolume),a
	ld (PSGVolume+1),a
	ld (PSGVolume+2),a

	ld (PSGPlayTempo),a

	xor a
	ld (PSGPlayRow),a
	ld (PSGPlayTempoCount),a
	ld (PSGWait),a
	ld (PSGPointRow),a

	dec a
	ld (NumberOfReps),a

	ld hl,0
	ld (PSGPointAddress),hl	

	ld a,255
	ld (NewPSG),a

NoNewPSG:
	ld a,(PSGPlayTempoCount)
	or a
	jp z,NewPSGPlayTempo

	dec a
	ld (PSGPlayTempoCount),a

	ret

NewPSGPlayTempo:
	ld a,(PSGWait)
	or a
	jp z,NoPSGWait

	dec a
	ld (PSGWait),a

	ret

NoPSGWait:
	ld a,(PSGPlayTempo)
	ld b,a

	ld a,15
	sub b

	ld (PSGPlayTempoCount),a


StartPSGRowCode:
; Check if instrument has reached it's end.

	ld a,(PSGPlayRow)
	cp 16
	ret z

; Check command

	ld hl,(PSGPlayAddress)

	ld a,(hl)
	or a
	jp z,PSGNoCommand

	cp 16
	jp c,PSGMakeRep

	cp 16
	jp z,PSGMakeDoRep

	cp 26
	jp c,PSGMakeWait

	cp 26
	jp z,PSGMakePoint

	cp 27
	jp z,PSGMakeGotoPoint

	cp 28
	jp z,PSGMakeEndPattern

	cp 45
	jp c,PSGMakeNewTempo

PSGNoCommand:
	inc hl									; Set HL to PSG frequencies

	ld b,3									; 3 PSG channels to out to.
	ld c,0									; First PSG register
	ld e,1									; For tones to be set off
PSGOutFreqLoop1:
	ld d,(hl)									; check if Freq = 0
											;
	inc hl									;
											;
	ld a,(hl)									;
											;
	or d										; if freq = 0 then
	jp z,NoPSGFreqChange							; jump to ..


	ld a,(hl)

	dec hl									; Set HL to original address

	bit 5,a
	jp nz,PSGOutFreqDown

	bit 6,a
	jp nz,PSGOutFreqUp

	ld a,c									; Out register to PSG
	out ($a0),a									;

	ld a,(hl)									; Out LSByte to PSG
	out ($a1),a									;

	inc hl									; increase address
	inc c										; increase PSG reg.

	ld a,(hl)									; Get MSByte of freq

	bit 4,a									; check if it is OFF
	jp z,PSGOutFreqNotOff							; nope.

	InPSG(7)									; Get reg. 7
	or e										; set channel off

	ld d,a									;
	OutPSG(7)									; Set reg. 7

	jp PSGFreqDone								; all done, next PSG

PSGOutFreqNotOff:
	ld a,e
	cpl
	ld e,a

	InPSG(7)
	and e
	ld d,a
	OutPSG(7)
	
	ld a,e
	cpl
	ld e,a

	ld a,c									; Out register to PSG
	out ($a0),a									;

	ld a,(hl)									; Out MSByte to PSG
	out ($a1),a									;

PSGFreqDone:
	sla e
	inc hl
	inc c

	djnz PSGOutFreqLoop1	

	ld ix,PSGvolume

	InPSG(7)
	or %00111000
	ld d,a

	ld bc,$0308^255
PSGVolNoiceLoop1:
	ld a,(hl)									; Get first volume and noice

	bit 6,a
	jp z,NoNoiceChange

	ld a,d
	and c
	ld d,a

	ld a,(hl)
NoNoiceChange:
	and %00111111
	jp z,NoVolumeChange

	bit 4,a
	jp nz,PSGVolumeUp

	bit 5,a
	jp nz,PSGVolumeDown

	and $0f
NoiceVolumeDone:
	ld (ix),a

NoVolumeChange:
	inc hl
	inc ix

	ld a,c

	sla a
	or 1

	ld c,a

	djnz PSGVolNoiceLoop1

	OutPSG(7)

	ld a,(hl)
	bit 5,a
	jp nz,NoiceFreqDown
	bit 6,a
	jp nz,NoiceFreqUp

	or a
	jp z,NoNoiceFreqChange

NoiceFreqChangeDone:
	ld d,a
	OutPSG(6)

NoNoiceFreqChange:
	ld a,(PSGMaxVol)

	ld hl,PSGVolume
	ld b,3
ChkMaxPSG.1:
	ld c,(hl)

	cp c
	jp nc,ChkMaxPSG.done

	ld (hl),a
ChkMaxPSG.Done:
	inc hl

	djnz ChkMaxPSG.1

	ld a,(PSGVolume+0)
	ld d,a
	OutPSG(8)

	ld a,(PSGVolume+1)
	ld d,a
	OutPSG(9)

	ld a,(PSGVolume+2)
	ld d,a
	OutPSG(10)

	jp PSGAllDone

NoiceFreqDown:
	and %00011111
	ld b,a

	InPSG(6)

	sub b

	and %00011111


NoiceFreqUp:
	and %00011111
	ld b,a

	InPSG(6)

	add a,b

	and %00011111

	jp NoiceFreqChangeDone

PSGOutFreqDown:
	push de

	ld a,c

	out ($a0),a
	in a,($a2)

	ld e,a

	ld a,c
	inc a

	out ($a0),a
	in a,($a2)

	ld d,a

	ld a,(hl)

	push hl

	ld l,a
	ld h,0

	ex de,hl

	or a
	sbc hl,de

	ld a,c
	out ($a0),a

	ld a,l
	out ($a1),a

	inc c

	ld a,c
	out ($a0),a

	ld a,h
	out ($a1),a

	pop hl
	pop de

	inc hl

	jp PSGFreqDone

PSGOutFreqUp:
	push de

	ld a,c

	out ($a0),a
	in a,($a2)

	ld e,a

	ld a,c
	inc a

	out ($a0),a
	in a,($a2)

	ld d,a

	ld a,(hl)

	push hl

	ld l,a
	ld h,0

	add hl,de

	ld a,c
	out ($a0),a

	ld a,l
	out ($a1),a

	inc c

	ld a,c
	out ($a0),a

	ld a,h
	out ($a1),a

	pop hl
	pop de

	inc hl

	jp PSGFreqDone

PSGVolumeUp:
	push bc

	and $0f
	ld b,a

	ld a,(ix)
	add a,b

	pop bc

	cp 16
	jp c,NoiceVolumeDone

	ld a,15
	jp NoiceVolumeDone

PSGVolumeDown:
	push bc

	and $0f
	ld b,a

	ld a,(ix)
	sub b

	pop bc

	jp nc,NoiceVolumeDone

	xor a
	jp NoiceVolumeDone

PSGAllDone:
	ld a,(PSGPlayRow)
	inc a
	ld (PSGPlayRow),a

	ld hl,(PSGPlayAddress)
	ld de,11
	add hl,de
	ld (PSGPlayAddress),hl

	ret

NoPSGFreqChange:
	inc c

	jp PSGFreqDone

PSGMakeNewTempo:
	sub 29

	ld (PSGPlayTempo),a

	ld b,a

	ld a,15
	sub b

	ld (PSGPlayTempoCount),a

	jp PSGNoCommand

PSGMakeRep:
	ld b,a

	ld a,(NumberOfReps)
	cp 255
	jp nz,PSGNoCommand

	ld a,b

	ld (NumberOfReps),a
	ld (RepPointerAddress),hl

	ld a,(PSGPlayRow)
	ld (RepPointerRow),a

	jp PSGNoCommand

PSGMakeDoRep:
	ld a,(NumberOfReps)
	cp 255
	jp z,PSGNoCommand

	dec a
	ld (NumberOfReps),a

	cp 255
	jp z,PSGNoCommand

	ld a,(RepPointerRow)
	ld (PSGPlayRow),a

	ld hl,(RepPointerAddress)
	ld (PSGPlayAddress),hl

	jp StartPSGRowCode

PSGMakeWait:
	sub 16
	ld (PSGWait),a

	jp PSGNoCommand

PSGMakePoint:
	ld (PSGPointAddress),hl

	ld a,(PSGPlayRow)
	ld (PSGPointRow),a

	jp PSGNoCommand

PSGMakeGotoPoint:	
	ld a,(PSGPlayRow)
	ld b,a
	ld a,(PSGPointRow)
	cp b
	jp z,PSGNoCommand

	ld (PSGPlayRow),a

	ld hl,(PSGPointAddress)
	ld (PSGPlayAddress),hl

	jp StartPSGRowCode

PSGMakeEndPattern:
	ld a,15
	ld (PSGPlayRow),a

	jp PSGNoCommand

NewPSG:
	.db 0

PSGPlayRow:
	.db 16
PSGPlayAddress:
	.dw 0
PSGPlayTempo:
	.db 0
PSGPlayTempoCount:
	.db 0

NumberOfReps:
	.db 255
RepPointerRow:
	.db 0
RepPointerAddress:
	.dw 0
PSGWait:
	.db 0
PSGPointRow:
	.db 0
PSGPointAddress
	.dw 0

PSGVolume:
	.db 0,0,0

PSGMaxVol:
	.db 0

RepInt.start:
	in a,($fd)
	push af

	in a,($fe)
	push af

	ld a,1
	out ($fd),a

	rst 30h
RepInt.slot:
	.db 0
	.dw PlayInt

	pop af
	out ($fe),a

	pop af
	out ($fd),a

OldPlayInt:
	.ds 5

RepInt.end:

IntCode:
	jp RepInterrupt

	.ds 2


#include "sb2-infs.asm"
#include "sb2rmain.asm"

end_program:

.end

; end of prg
