; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - PSG editor
; Code: d-fader^TwZ.
; Date: june 14, 1999
;
; cmnt: filename of this file: BLAFFER2.010
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#include "macro's.asm"
#include "sb2rmacr.asm"

	.org $4000

init_bytes:
	jp start_program

	.ds 16-3

	.text "                "
	.text " SCC BLAFFER NT "
	.text "  (C) 1999 TwZ  "
	.text "                "
	.text "   PSG-EDITOR   "
	.text "                "

start_program:
	ld d,%10111111
	OutPSG(7)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	ShowPic(1)							; PSG edit screen

	ld a,insbnk							; instrument bank
	out ($fe),a							;

	call ShowPattern

main:
	ShowHint(empty)

	call CalculateNowAddress

	AdrLoc(cursor)
	call chget
	ld (keypressed),a

	ScanKey(escape)
	jp z,QuitPIE

	ScanKey(tab)
	jp z,SelectOctave

	ScanKey(control)
	jp z,HandleControl

	Scan2Keys(shift,delete)
	jp z,DeleteColumn

	Scan2Keys(graph,delete)
	jp z,DeleteRow

	ScanKey(shift)
	jp z,CheckOtherInput

	ScanKey(f1)
	jp z,PlayInstrument

	ScanKey(f5)
	jp z,DoDiskMenu

	ScanKey(Insert)
	jp z,InsertRow

;	call OnlyOneKey
;	jp nz,main

;	ScanKey(escape)
;	jp z,EndPSGEdit

	ld a,(keypressed)

	cp $1c	
	jp z,CursorXright

	cp $1d
	jp z,CursorXleft

	cp $1e
	jp z,CursorXup

	cp $1f
	jp z,CursorXdown

CheckOtherInput:
	ld a,(real_cx)

	or a
	jp z,CheckCommand

	cp 4
	jp c,CheckFrequency

	cp 7
	jp c,CheckRustle

	cp 7
	jp z,CheckRstFreq

	jp CheckVolume

EndPSGEdit:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call StopSound

	ret

SelectOctave:
	ShowHint(53)

	SetVW(0,80*22+26)

	ld a,(CurrentPSGOctave)
	add a,48
	out ($98),a

SelectOctaveLoop:
	ei

	ScanKey(tab)
	jp nz,SelectOctaveDone

	ScanKey(right)
	jp z,SelectOctaveUp

	ScanKey(left)
	jp z,SelectOctaveDown

	jp SelectOctaveLoop

SelectOctaveUp:
	ld a,(CurrentPSGOctave)
	cp 8
	jp z,SelectOctaveLoop

	inc a
	ld (CurrentPSGOctave),a

	SetVW(0,80*22+26)

	ld a,(CurrentPSGOctave)
	add a,48
	out ($98),a

SelOctWaitUp:
	ScanKey(Right)
	jp z,SelOctWaitUp

	jp SelectOctaveLoop

SelectOctaveDown:
	ld a,(CurrentPSGOctave)
	cp 1
	jp z,SelectOctaveLoop

	dec a
	ld (CurrentPSGOctave),a

	SetVW(0,80*22+26)

	ld a,(CurrentPSGOctave)
	add a,48
	out ($98),a

SelOctWaitDown:
	ScanKey(Left)
	jp z,SelOctWaitDown

	jp SelectOctaveLoop

CurrentPSGOctave:
	.db 4


SelectOctaveDone:
	ld b,4
SelectOctaveDoneLoop1:
	push bc

	ShowHint(Empty)

	ei
	halt
	halt
	halt

	ShowHint(53)

	SetVW(0,80*22+26)

	ld a,(CurrentPSGOctave)
	add a,48
	out ($98),a

	ei
	halt
	halt
	halt

	pop bc

	djnz SelectOctaveDoneLoop1

	ShowHint(empty)

	jp main


StopSound:
	ld a,16
	ld (PSGPlayRow),a

	ld d,%10111111
	OutPSG(7)

	ret

NewInt:
	ScanKey(Stop)	
	call z,StopSound

	call DoPSG

oldint:
	.ds 5

PlayInstrument:
	ld a,(PsgPat)
	ld (NewPSG),a

	jp main

CheckCommand:
	ScanKey(return)
	jp z,EnterCommand

	ScanKey(delete)
	jp z,DeleteCommand

	ScanKey(key_r)
	jp z,MakeRepeat

	ScanKey(key_t)
	jp z,MakeTempo

	ScanKey(key_d)
	jp z,MakeDoRepeat

	ScanKey(key_w)
	jp z,MakeWait

	ScanKey(key_p)
	jp z,MakePoint

	ScanKey(key_g)
	jp z,MakeGotoP

	ScanKey(key_e)
	jp z,MakeEnd

	jp main

EnterCommand:
	ld a,(EnterCommandData)
	ld hl,(NowAddress)
	ld (hl),a

	call ShowPattern

	call DownCursor

	jp main
	
QuitPIE:
	ShowHint(101)

	call YesOrNo
	jp nz,main

	jp EndPSGEdit

HandleControl:
	ScanKey(delete)
	jp z,DeletePattern

	ScanKey(right)
	jp z,inc_psgpat
	
	ScanKey(left)
	jp z,dec_psgpat

	ScanKey(up)
	jp z,inc4_psgpat
	
	ScanKey(down)
	jp z,dec4_psgpat

	ScanKey(key_h)
	jp z,PSGHelp

	ScanKey(key_n)
	jp z,ChangeInsName

	jp main

PSGHelp:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call StopSound

	ld hl,PIEditLine
	ld (RepData),hl

	ld a,9
	ld (RepCommand),a

	ld a,4
	call DoMenu

	ShowPic(1)							; PSG edit screen
	call ShowPattern

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	jp main

InsertRow:
; routine : Insert Row at current position
; in      : none.
; out     : none.
; cmnt    : none.

	ld a,(Now_cy)
	ld b,a
	ld a,15+6
	sub b

	jp z,DelLastRow

	ld b,a
	ld hl,0
	ld de,11

InsRowLoop1:
	add hl,de
	djnz InsRowLoop1

	push hl
	pop bc

	ld hl,(StartPatAdr)
	ld de,184-1
	add hl,de
	push hl

	ld de,-11
	add hl,de

	pop de

; DE - Destination Address (Row 16 last byte)
; HL - Source Address      (Row 15 last byte)
; BC - Length

	lddr

	ld hl,(NowRowAdr)
	push hl
	pop de
	inc de
	ld bc,10
	ld (hl),0
	ldir

	jp DeleteRowDone

DeleteRow:
; routine : Delete current row.
; in      : none.
; out     : none.
; cmnt    : none.

	ShowHint(2)

	call YesOrNo
	jp nz,DelRowNoShift

	ld a,(Now_cy)
	ld b,a
	ld a,15+6
	sub b

	jp z,DelLastRow

	ld b,a
	ld hl,0
	ld de,11

DelRowLoop1:
	add hl,de
	djnz DelRowLoop1

	push hl
	pop bc

	ld hl,(NowRowAdr)

	push hl

	ld de,11
	add hl,de

	pop de

	ldir

DelLastRow:
	ld hl,(StartPatAdr)
	ld de,184-11
	add hl,de
	push hl
	pop de
	inc de

	ld bc,10
	ld (hl),0
	ldir

	jp DeleteRowDone

DelRowNoShift:
	ld hl,(NowRowAdr)
	ld de,(NowRowAdr)
	inc de
	ld bc,10
	ld (hl),0
	ldir

DeleteRowDone:
	call ShowPattern

	ShowHint(empty)

	jp main

DeleteColumn:
	ld hl,AdrOfs
	ld a,(real_cx)
	ld e,a
	ld d,0
	add hl,de
	ld e,(hl)
	ld d,0
	ld hl,(NowPatAdr)
	add hl,de

	ld a,(real_cx)
	cp 0
	jp z,DeleteCmdNfrq

	cp 1
	jp z,DeleteFreq
	cp 2
	jp z,DeleteFreq
	cp 3
	jp z,DeleteFreq


	cp 4
	jp z,DeleteNoice
	cp 5
	jp z,DeleteNoice
	cp 6
	jp z,DeleteNoice
	
	jp DeleteVolume


DeleteCmdNFrq:
	ld b,16
	ld de,11
DeleteCmdNFrqLoop:
	ld (hl),0
	add hl,de
	djnz DeleteCmdNFrqLoop

	jp DeleteColumnDone

DeleteFreq:
	push hl
	pop ix

	ld b,16
	ld de,11
DeleteFreqLoop:
	ld (ix+0),0
	ld (ix+1),0
	add ix,de
	djnz DeleteFreqLoop

	jp DeleteColumnDone

DeleteNoice:
	ld b,16
	ld de,11
DeleteNoiceLoop:
	ld a,(hl)
	and %00111111
	ld (hl),a
	add hl,de
	djnz DeleteNoiceLoop

	jp DeleteColumnDone

DeleteVolume:
	ld b,16
	ld de,11
DeleteVolumeLoop:
	ld a,(hl)
	and %01000000
	ld (hl),a
	add hl,de
	djnz DeleteVolumeLoop

	jp DeleteColumnDone

DeleteColumnDone:
	call ShowPattern

	jp main

DeletePattern:
	ShowHint(3)

	call YesOrNo
	push af
	ShowHint(empty)
	pop af
	jp nz,main

	ld hl,(StartPatAdr)
	push hl
	pop de
	inc de
	ld bc,183
	ld (hl),0
	ldir

	ld hl,(StartPatAdr)
	ex de,hl
	ld hl,DefaultText
	ld bc,8
	ldir

	call ShowPattern

	jp main
DefaultText:
	.text "Default "

EnterFreq:
	ld hl,(NowAddress)
	ld a,(EnterPSGFreqData)
	ld (hl),a
	inc hl

	ld a,(EnterPSGFreqData+1)
	ld (hl),a

	call ShowPattern

	call DownCursor

	jp main

FrequencyUp:
	ShowHint(98)

	ld a,43
	call chput

	push af
	ld hl,(CurLoc)
	ld a,32
	call chput
	call chput
	ld (CurLoc),hl
	pop af

	ld h,$20
	jp FrequencyLoop1

FrequencyDown:
	ShowHint(99)

	ld a,45
	call chput

	push af
	ld hl,(CurLoc)
	ld a,32
	call chput
	call chput
	ld (CurLoc),hl
	pop af

	ld h,$40
	jp FrequencyLoop1

CheckFrequency:
	xor a
	ld (escaped),a

	ScanKey(equal)
	jp z,FrequencyUp

	ScanKey(shift)
	jp z,DoNoteInput

	ScanKey(return)
	jp z,EnterFreq

	ScanKey(delete)
	jp z,DeleteFrequency

	ScanKey(key_o)
	jp z,FrequencyOff

	ScanKey(minus)
	jp z,FrequencyDown

	call ScanHexKey
	jp c,main


	push af
	ld hl,(CurLoc)
	ld a,32
	call chput
	call chput
	call chput
	ld (CurLoc),hl
	pop af


	ld h,a

	call chput_hex

FrequencyLoop1:
	push hl
	call kilbuf
	pop hl

	call chget

	cp 27
	jp z,FrequencyEsc

	cp 13
	jp z,FrequencyOneChar

	call ScanHexKey
	jp c,FrequencyLoop1
	
	ld b,a

	sla a
	sla a
	sla a
	sla a

	ld l,a

	ld a,b

	call chput_hex

FrequencyLoop2:
	push hl
	call kilbuf
	pop hl

	call chget

	cp 27
	jp z,FrequencyEsc

	cp 13
	jp z,FrequencyTwoChar

	call ScanHexKey
	jp c,FrequencyLoop2
	
	ld b,a
	ld a,l
	or b
	ld l,a

	ex de,hl

	ld hl,(NowAddress)
	ld (hl),e
	inc hl
	ld (hl),d

	jp FrequencyDone

FrequencyOneChar:
	ld a,h
	and $0f
	jp z,FrequencyLoop1

	ld e,h
	ld d,0

	ld hl,(NowAddress)
	ld (hl),e
	inc hl
	ld (hl),d

	jp FrequencyDone

FrequencyTwoChar:
	ld a,h
	and $0f
	jp nz,FrequencyTwoCharNormal

	srl l
	srl l
	srl l
	srl l

	ex de,hl

	jp FrequencyTwoCharDone

FrequencyTwoCharNormal:
	srl l
	srl l
	srl l
	srl l

	sla h
	sla h
	sla h
	sla h

	ld a,h
	or l

	ld l,a

	ex de,hl

	ld d,0

FrequencyTwoCharDone:
	ld hl,(NowAddress)
	ld (hl),e
	inc hl
	ld (hl),d

	jp FrequencyDone
	
FrequencyOff:
	ld hl,(NowAddress)
	ld (hl),0
	inc hl
	ld (hl),$10

	jp FrequencyDone

DeleteFrequency:
	ld hl,(NowAddress)
	ld (hl),0
	inc hl
	ld (hl),0

	jp FrequencyDone

FrequencyEsc:
	ld a,1
	ld (escaped),a

FrequencyDone:
	ld hl,(NowAddress)
	ld a,(hl)
	ld (EnterPSGFreqData),a
	inc hl
	ld a,(hl)
	ld (EnterPSGFreqData+1),a

	call ShowPattern

	ld a,(escaped)
	or a
	jp nz,main

	call DownCursor

	jp main


;----------------------------
	ld a,(now_cy)

	ld hl,-80
	ld de,80

	ld b,a
FrequencyCalcV1:
	add hl,de
	djnz FrequencyCalcV1

	ld a,(now_cx)
	dec a
	ld e,a
	ld d,0
	add hl,de

	xor a
	call SetVramWrite

	ld hl,(NowAddress)

	inc hl
	ld a,(hl)
	and $f0
	jp z,CheckFreq000

	push hl
	push bc

	ld hl,off_event
	ld bc,$0398
	otir

	pop bc
	pop hl

	jp FrequencyCleared

CheckFreq000:
	dec hl


	ld e,(hl)
	inc hl
	ld a,(hl)
	dec hl
	or e
	jp nz,FrequencyOk

	ld a,32
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld a,45
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld a,32
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	jp FrequencyCleared

FrequencyOk:
	push hl

	inc hl
	ld a,(hl)

	and $0f

	call OutputHexxDigit

	pop hl
	
	ld a,(hl)

	ld b,a

	and $f0
	srl a
	srl a
	srl a
	srl a

	call OutPutHexxDigit

	ld a,b
	and $0f
	call OutPutHexxDigit

FrequencyCleared:
	ld a,(escaped)
	or a
	jp nz,main

	call DownCursor

	jp main
;---------------------------------------

DoNoteInput:
	ld c,0

	ScanKey(key_z)
	jp z,Input_done

	inc c
	
	ScanKey(key_s)
	jp z,Input_done

	inc c

	ScanKey(key_x)
	jp z,Input_done

	inc c

	ScanKey(key_d)
	jp z,Input_done

	inc c

	ScanKey(key_c)
	jp z,Input_done

	inc c

	ScanKey(key_v)
	jp z,Input_done

	inc c

	ScanKey(key_g)
	jp z,Input_done

	inc c

	ScanKey(key_b)
	jp z,Input_done

	inc c

	ScanKey(key_h)
	jp z,Input_done

	inc c

	ScanKey(key_n)
	jp z,Input_done

	inc c

	ScanKey(key_j)
	jp z,Input_done

	inc c

	ScanKey(key_m)
	jp z,Input_done

	jp main

Input_done:
	ld hl,freq_data-24
	ld de,24

	ld a,(CurrentPSGOctave)
	ld b,a
Input_doneLoop1:
	add hl,de

	djnz Input_doneLoop1

	ld a,c
	sla a

	ld e,a
	ld d,0

	add hl,de

	ex de,hl

	ld hl,(NowAddress)

	ld a,(de)
	ld (hl),a

	inc hl
	inc de

	ld a,(de)
	ld (hl),a

	jp FrequencyDone

chput_hex:
	push hl

	ld e,a
	ld d,0

	ld hl,HexxData

	add hl,de
	ld a,(hl)

	call chput

	pop hl

	ret


OutputHexxDigit:
	ld e,a
	ld d,0

	ld hl,HexxData

	add hl,de
	ld a,(hl)
	out ($98),a

	ret

MakeTempo:
	ShowHint(93)

	xor a
	ld (escaped),a

	ld a,(now_cy)

	ld hl,-80
	ld de,80

	ld b,a
MakeTempoCalcV1:
	add hl,de
	djnz MakeTempoCalcV1

	ld a,(now_cx)
	dec a
	ld e,a
	ld d,0
	add hl,de

	xor a
	call SetVramWrite

	ld hl,TempoText
	ld bc,$0698
	otir

	ld a,(now_cy)
	ld l,a
	ld a,(now_cx)
	add a,4
	ld h,a
	ld ($f3dc),hl

MakeTempoLoop1:
	call kilbuf
	call chget

	cp 27
	jp z,MakeTempoEscape	
	
	ld b,a

	cp 48
	jp z,MakeTempoOneChr

	cp 49
	jp c,MakeTempoLoop1

	cp 58
	jp nc,MakeTempoLoop1

	ld b,a

	cp 50
	jp nc,MakeTempoOneChr

	call chput

MakeTempoLoop2:
	call kilbuf
	call chget

	cp 27
	jp z,MakeTempoEscape

	cp 13
	jp z,MakeTempoOneChr

	cp 47
	jp c,MakeTempoLoop2

	cp 54
	jp nc,MakeTempoLoop2

	sub 9									; right command number

	jp MakeRepeatComp

MakeTempoEscape:
	ld a,1
	ld (escaped),a

	jp MakeRepeatDone

MakeTempoOneChr:
	ld a,b
	sub 19

	jp MakeRepeatComp

MakeRepeat:
	ShowHint(91)

	xor a
	ld (escaped),a

	ld a,(now_cy)

	ld hl,-80
	ld de,80

	ld b,a
MakeRepeatCalcV1:
	add hl,de
	djnz MakeRepeatCalcV1

	ld a,(now_cx)
	dec a
	ld e,a
	ld d,0
	add hl,de

	xor a
	call SetVramWrite

	ld hl,RepeatText
	ld bc,$0698
	otir

	ld a,(now_cy)
	ld l,a
	ld a,(now_cx)
	add a,4
	ld h,a
	ld ($f3dc),hl

MakeRepeatLoop1:
	call kilbuf
	call chget

	cp 27
	jp z,MakeRepeatEscape	
	
	cp 49
	jp c,MakeRepeatLoop1

	cp 58
	jp nc,MakeRepeatLoop1

	ld b,a

	cp 50
	jp nc,MakeRepeatOneChr

	call chput

MakeRepeatLoop2:
	call kilbuf
	call chget

	cp 27
	jp z,MakeRepeatEscape

	cp 13
	jp z,MakeRepeatOneChr

	cp 48
	jp c,MakeRepeatLoop2

	cp 54
	jp nc,MakeRepeatLoop2

	sub 38								; right command number

	jp MakeRepeatComp

MakeRepeatEscape:
	ld a,1
	ld (escaped),a

	jp MakeRepeatDone

MakeRepeatOneChr:
	ld a,b
	sub 48

MakeRepeatComp:
	ld hl,(NowAddress)

	ld (hl),a
	ld (EnterCommandData),a

MakeRepeatDone:
	ld a,(now_cy)

	ld hl,-80
	ld de,80

	ld b,a
MakeRepeatCalcV2:
	add hl,de
	djnz MakeRepeatCalcV2

	ld a,(now_cx)
	dec a
	ld e,a
	ld d,0
	add hl,de

	xor a
	call SetVramWrite

	ld hl,(NowAddress)

	ld a,(hl)
	inc a

	ld hl,command-6
	ld de,6

	ld b,a
MakeRepeatDoneLoop1:
	add hl,de
	djnz MakeRepeatDoneLoop1

	ld bc,$0698
	otir

	ld a,(escaped)
	or a
	jp nz,main

	call DownCursor

	jp main

DeleteCommand:
	ld hl,(NowAddress)
	ld (hl),0
	ld (EnterCommandData),a

	jp MakeRepeatDone

Escaped:
	.db 0


MakeDoRepeat:
	ld a,16
	ld hl,(NowAddress)
	ld (hl),a
	ld (EnterCommandData),a

	call LocCur

	ld hl,DoRepText
	ld bc,$0698
	otir

	call DownCursor

	jp main	

LocCur:
	ld a,(now_cy)

	ld hl,-80
	ld de,80

	ld b,a
LocCurCalcV1:
	add hl,de
	djnz LocCurCalcV1

	ld a,(now_cx)
	dec a
	ld e,a
	ld d,0
	add hl,de

	xor a
	call SetVramWrite

	ret

MakeWait:
	ShowHint(92)

	call LocCur

	ld hl,WaitText
	ld bc,$0698
	otir

	ld a,(now_cx)
	add a,5
	ld (now_cx),a

	AdrLoc(cursor)

	ld a,(now_cx)
	sub 5
	ld (now_cx),a

MakeWaitLoop:
	call kilbuf
	call chget

	cp 27
	jp z,MakeWaitEsc

	cp 49
	jp c,MakeWaitLoop

	cp 58
	jp nc,MakeWaitLoop

	call chput

	sub 32

	ld hl,(NowAddress)
	ld (hl),a
	ld (EnterCommandData),a

	call DownCursor

	jp main

MakeWaitEsc:
	call LocCur

	ld hl,(NowAddress)

	ld a,(hl)
	inc a

	ld hl,command-6
	ld de,6

	ld b,a
MakeWaitEscLoop1:
	add hl,de

	djnz MakeWaitEscLoop1

	ld bc,$0698
	otir

	jp main

MakePoint:
	ld a,26
	ld hl,(NowAddress)
	ld (hl),a
	ld (EnterCommandData),a

	call LocCur

	ld hl,PointText
	ld bc,$0698
	otir

	call DownCursor

	jp main	

MakeGotoP:
	ld a,27
	ld hl,(NowAddress)
	ld (hl),a
	ld (EnterCommandData),a

	call LocCur

	ld hl,GotoPText
	ld bc,$0698
	otir

	call DownCursor

	jp main	


MakeEnd:
	ld a,28
	ld hl,(NowAddress)
	ld (hl),a
	ld (EnterCommandData),a

	call LocCur

	ld hl,EndText
	ld bc,$0698
	otir

	call DownCursor

	jp main	

CheckRustle:
	ScanKey(space)
	jp nz,main

	ld hl,(NowAddress)
	ld a,(hl)
	and %01111111
	xor %01000000
	ld (hl),a

	push af
	call LocCur
	pop af

	and %01000000

	srl a
	srl a
	srl a
	srl a

	ld e,a
	ld d,0
	ld hl,Rustle
	add hl,de

	ld bc,$0498
	otir

	jp main

CheckRstFreq:
	xor a
	ld (escaped),a

	ScanKey(key_u)
	jp z,EnterRstFreqUp

	ScanKey(key_d)
	jp z,EnterRstFreqDown

	ScanKey(return)
	jp z,EnterRstFreq

	ScanKey(delete)
	jp z,RstFreqDelete

	ScanKey(shift)
	jp nz,main

	ScanKey(right)
	jp z,FreqUp1

	ScanKey(left)
	jp z,FreqDown1

	ScanKey(up)
	jp z,FreqUp4

	ScanKey(down)
	jp z,FreqDown4

	jp main

EnterRstFreqUp:
	ShowHint(94)

	ld a,117
	call DoEnterRstFreq

	jp main

EnterRstFreqDown:
	ShowHint(95)

	ld a,100
	call DoEnterRstFreq

	jp main

DoEnterRstFreq:
	push af
	push af

	ld hl,(CurLoc)

	ld a,32
	ld b,7
InitRstFreq.1:
	call chput

	djnz InitRstFreq.1
	
	inc h

	pop af

	ld (CurLoc),hl

	call chput

	ld a,58
	call chput

	pop af

	ld b,%00100000
	cp 117
	jp z,InitRst.2

	sla b
InitRst.2:
	ld a,b
	ld (StandardRst),a

	ld hl,(CurLoc)
DoRst.1:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,DoRstEscaped

	push hl
	call ScanDecKey
	pop hl
	jp c,DoRst.1

	cp 4
	jp nc,DoRstComplete	

	ld (DoRst.data1),a

	add a,48
	call chput

	ld hl,(CurLoc)
DoRst.2:
	ld (CurLoc),hl

	call chget

	push hl
	ScanKey(Escape)
	pop hl
	jp z,DoRstEscaped

	push hl
	ScanKey(return)
	pop hl
	jp z,DoRst1Char

	push hl
	call ScanDecKey
	pop hl
	jp c,DoRst.2

	ld c,a

	ld a,(DoRst.data1)
	inc a
	ld b,a

	ld a,-10
DoRst.3:
	add a,10
	djnz DoRst.3

	add a,c

	cp 32
	jp nc,DoRst.2

DoRstComplete:
	ld b,a
	ld a,(StandardRst)
	add a,b

	ld (EnterNoiceFreqData),a
	ld hl,(NowAddress)
	ld (hl),a

	call DownCursor

DoRstEscaped:
	call ShowPattern

	ret

DoRst1Char:
	ld a,(DoRst.data1)

	jp DoRstComplete

StandardRst:
	.db 0

DoRst.data1:
	.db 0

EnterRstFreq:
	ld a,(EnterNoiceFreqData)
	ld hl,(NowAddress)
	ld (hl),a

	call ShowPattern
	call DownCursor

	jp main

FreqUp1:
	ld hl,(NowAddress)
	ld a,(hl)
	dec a

	jp FreqDone	

FreqDown1:
	ld hl,(NowAddress)
	ld a,(hl)
	inc a

	jp FreqDone	

FreqUp4:
	ld hl,(NowAddress)
	ld a,(hl)
	sub 4

	jp FreqDone	

FreqDown4:
	ld hl,(NowAddress)
	ld a,(hl)
	add a,4

FreqDone:
	and %00011111

	ld (hl),a

	ld (EnterNoiceFreqData),a

	push af
	call LocCur
	pop af

	ld hl,rst_freq-7
	ld de,7

	inc a
	ld b,a
FreqDoneLoop1:
	add hl,de

	djnz FreqDoneLoop1

	ld bc,$0798
	otir
	
	ld a,(escaped)
	or a
	call nz,DownCursor

	jp main

RstFreqDelete:
	ld a,1
	ld (escaped),a

	xor a
	ld hl,(NowAddress)

	jp FreqDone

CheckVolume:
	xor a
	ld (WhatToAdd),a
	ld (escaped),a

	ScanKey(return)
	jp z,EnterVolume

	ScanKey(delete)
	jp z,CheckVolumeDelete

;	ScanKey(key_o)
;	jp z,CheckVolumeOff

	ScanKey(key_d)
	jp z,CheckVolumeDown

	ScanKey(key_u)
	jp z,CheckVolumeUp

	call ScanDecKey
	jp c,main

	or a
	jp z,main	

	push af

	call LocCur

	ld hl,spaces
	ld bc,$0498
	otir

	ld a,(now_cx)
	inc a
	ld (now_cx),a

	AdrLoc(cursor)

	ld a,(now_cx)
	dec a
	ld (now_cx),a

	pop af

VolumeUpDownComp:
	cp 1
	jp nz,OneChrVol	

	add a,48
	call chput

CheckVolumeLoop1:
	call kilbuf
	call chget

	cp 13
	jp z,CheckVolumeInput1

	cp 27
	jp z,CheckVolumeEsc

	cp 48
	jp c,CheckVolumeLoop1

	cp 54
	jp nc,CheckVolumeLoop1

	sub 38

	ld b,a
	ld a,(WhatToAdd)
	add a,b
	ld b,a

	ld hl,(NowAddress)

	ld a,(hl)
	and %01000000
	or b	
	ld (hl),a

	and %00111111

	jp CheckVolumeDone

EnterVolume:
	ld a,(EnterVolumeData)
	and %00111111
	ld b,a

	ld hl,(NowAddress)
	ld a,(hl)
	and %01000000

	or b
	ld (hl),a

	call ShowPattern
	call DownCursor

	jp main

CheckVolumeInput1:
	ld a,1
OneChrVol:
	ld b,a
	ld a,(WhatToAdd)
	add a,b

	ld b,a

	ld hl,(NowAddress)
	ld a,(hl)
	and %11000000
	or b
	ld (hl),a

	jp CheckVolumeDone

CheckVolumeEsc:
	ld a,1
	ld (escaped),a

CheckVolumeDone:
	ld hl,(NowAddress)
	ld a,(hl)
	ld (EnterVolumeData),a

	and %00111111

	inc a

	ld hl,Volume-4
	ld de,4

	ld b,a
CheckVolumeLoop2:
	add hl,de
	djnz CheckVolumeLoop2

	push hl
	call LocCur
	pop hl

	ld bc,$0498
	otir

	ld a,(escaped)
	or a
	jp nz,main

	call DownCursor

	jp main

;CheckVolumeOff:
	ld hl,(NowAddress)
	ld a,(hl)
	and %01000000
	or 48
	ld (hl),a

	jp CheckVolumeDone


CheckVolumeDelete:
	ld hl,(NowAddress)
	ld a,(hl)
	and %01000000
	ld (hl),a

	jp CheckVolumeDone

CheckVolumeUp:
	ShowHint(96)

	ld hl,VolUpSign
	ld a,%00010000
	ld (WhatToAdd),a

	jp VolUpDownDone

CheckVolumeDown:
	ShowHint(97)

	ld hl,VolDownSign
	ld a,%00100000
	ld (WhatToAdd),a

	jp VolUpDownDone

VolUpDownDone:
	push hl
	call LocCur
	pop hl

	ld bc,$0498
	otir

	ld a,(now_cx)
	add a,2
	ld (now_cx),a

	AdrLoc(cursor)

	ld a,(now_cx)	
	sub 2
	ld (now_cx),a

VolumeUpDownDoneLoop:
	call kilbuf
	call chget

	cp 27
	jp z,CheckVolumeEsc

	cp 48
	jp c,VolumeUpDownDoneLoop

	cp 58
	jp nc,VolumeUpDownDoneLoop

	sub 48

	jp VolumeUpDownComp

WhatToAdd:
	.db 0

VolUpSign:
	.db "u:  "
VolDownSign:
	.db "d:  "

spaces:
	.text "    "

keypressed:

	.db 0

ChangeInsName:
	ShowHint(1)

	ld hl,(StartPatAdr)
	ld (PsgName_data+3),hl

	ld hl,PsgName_data
	call input_text

	ShowHint(Empty)

	jp main


cursor:
now_cy:
	.db 6
now_cx:
	.db 2

real_cx:
	.db 0

cursor_xpos:
	.db 2,9,13,17,21,26,31,36,44,49,54


CursorXright:
	ld a,(real_cx)
	inc a
	cp 11
	jr nz,CursorXright1

	xor a
CursorXright1:
	ld (real_cx),a

	jp cx_done

CursorXleft:
	ld a,(real_cx)
	dec a
	cp 255
	jr nz,CursorXleft1

	ld a,10
CursorXleft1:
	ld (real_cx),a

cx_done:
	ld hl,cursor_xpos
	ld e,a
	ld d,0
	add hl,de
	ld a,(hl)
	
	ld (now_cx),a

	jp main

CursorXup:
	ld a,(now_cy)
	dec a
	cp 5
	jr nz,CursorXup1

	ld a,21
CursorXup1:
	ld (now_cy),a

	jp main

CursorXdown:
	call DownCursor

	jp main

DownCursor:
	ld a,(now_cy)
	inc a
	cp 22
	jr nz,CursorXdown1

	ld a,6

CursorXdown1:
	ld (now_cy),a

	ret

inc_psgpat:
	ld a,(psgpat)
	cp 43
	jp z,main
	inc a
	ld (psgpat),a

	call ShowPattern

	jp main
	
dec_psgpat:
	ld a,(psgpat)
	or a
	jp z,main
	dec a
	ld (psgpat),a

	call ShowPattern

	jp main

inc4_psgpat:
	ld a,(psgpat)
	add a,4

	cp 44
	jr c,NoPatAdjust
	
	ld a,43
	jr NoPatAdjust

dec4_psgpat:
	ld a,(psgpat)
	sub 4

	jr nc,NoPatAdjust
	
	xor a
NoPatAdjust:
	ld (psgpat),a

	call ShowPattern

	jp main

CalculateNowAddress:
	ld hl,$a060-187
	ld de,184

	ld a,(psgpat)
	inc a

	ld b,a
CalcNAloop1:
	add hl,de
	djnz CalcNAloop1

	push hl

	inc hl
	inc hl
	inc hl

	ld (StartPatAdr),hl

	pop hl

	push hl

	ld de,11
	add hl,de
	ld (NowPatAdr),hl

	pop hl

	ld de,11

	ld a,(now_cy)
	sub 5

	ld b,a
CalcNAloop2:
	add hl,de
	djnz CalcNAloop2

	ld (NowRowAdr),hl

	push hl

	ld hl,Adrofs
	ld a,(real_cx)

	ld e,a
	ld d,0

	add hl,de

	ld a,(hl)
	ld e,a

	pop hl

	add hl,de

	ld (NowAddress),hl

	ret

AdrOfs:
	.db 0,1,3,5,7,8,9,10,7,8,9

NowPatAdr:
	.dw 0
NowRowAdr:
	.dw 0
NowAddress:
	.dw 0
StartPatAdr:
	.dw 0

ShowPattern:
; routine : Show PSG pattern on screen
; in      : (psgpat) - pattern number
; out     : none.
; cmnt    : none.

	di

	ld a,(psgpat)						; calculate 8-bits number
	inc a
	call Calc8Dec						; (of pattern)

	SetVW(0,80*2+77)						; set VRAM ready

	ld hl,decimal+1						; write number on screen
	ld bc,$0298							;
	otir								;

	SetVW(0,80*3+71)						; Set VRAM ready on name

	ld hl,$a060-184						; Calculate > pattern address
	ld de,184							; 1 pattern is 184 bytes

	ld a,(psgpat)						; at least 1 pattern
	inc a								;
	ld b,a							;

ShowPatternLoop1:
	add hl,de							; get > pattern

	djnz ShowPatternLoop1					

	ld bc,$0898							; out name
	otir								;

;-----
	ld (PatAdrRam),hl						; > address ram

	ld hl,5*80+1						; > address vram
	ld (PatAdrVram),hl					;

	ld b,16							; 16 rows in 1 pattern
ShowPatternLoop2:
	push bc

	ld hl,(PatAdrRam)						; < address ram

	ld a,(hl)							; get command

	inc a
	ld b,a							; at least 1

	ld hl,command-6
	ld de,6
ShowPatternLoop3:
	add hl,de

	djnz ShowPatternLoop3
	
	ld de,OneRowData
	ld bc,6
	ldir

	inc de

	ld hl,(PatAdrRam)
	inc hl

	ld b,3
ShowPatternLoop4:
	push bc
	push de

	ld c,e						; get DE in BC
	ld b,d						;

	ld e,(hl)						; get frequency in DE
	inc hl						;
	ld d,(hl)						;
	inc hl						;

	push hl						; Save frequency address
	push bc						; 

	ex de,hl						; get frequency in HL

	bit 4,h						; Check if off event is set.
	jp nz,FrequencyOffEvent				; if not, check if note is empty

	bit 5,h
	jp nz,FrequencyUpEvent				

	bit 6,h
	jp nz,FrequencyDownEvent

	jp FrequencyNotOff


FrequencyUpEvent:
	call Calc3Hex

	ld a,43
	ld (HexaDecimal),a

	jp NonZero

FrequencyDownEvent:	
	call Calc3Hex

	ld a,45
	ld (Hexadecimal),a

	jp NonZero

FrequencyOffEvent:
	push hl						; save all regs
	push de						;
	push bc						;

	ld hl,off_event					; copy off-event to HexaDecimal
	ld de,HexaDecimal					;
	ld bc,3						;
	ldir							;

	pop bc						; Get all regs back!
	pop de						;
	pop hl						;

	jp NonZero

FrequencyNotOff:
	call Calc3Hex

	ld a,(HexaDecimal+0)
	cp 48
	jr nz,NonZero
	
	ld a,(HexaDecimal+1)
	cp 48
	jr nz,NonZero

	ld a,(HexaDecimal+2)
	cp 48
	jr nz,NonZero

	ld a,32
	ld (HexaDecimal+0),a
	ld a,45
	ld (HexaDecimal+1),a
	ld a,32
	ld (HexaDecimal+2),a


NonZero:
	pop de

	ld hl,HexaDecimal
	ld bc,3
	ldir

	pop hl
	pop de

	inc de
	inc de
	inc de
	inc de

	pop bc

	djnz ShowPatternLoop4


	ld b,3

	ld (SaveVolRam),hl

ShowPatternLoop5:
	push bc
	push hl
	push de

	ld a,(hl)
	and %01000000
	srl a
	srl a
	srl a
	srl a

	ld e,a
	ld d,0

	ld hl,rustle
	add hl,de

	pop de

	ld bc,4
	ldir

	pop hl

	inc hl

	inc de

	pop bc

	djnz ShowPatternLoop5

	push hl
	push de

	ld a,(hl)
	inc a
	ld b,a

	ld hl,rst_freq - 7
	ld de,7
ShowPatternLoop6:
	add hl,de

	djnz ShowPatternLoop6

	pop de

	ld bc,7
	ldir

	inc de

	pop hl

	ld hl,(SaveVolRam)

	ld b,3
ShowPatternLoop7:
	push bc
	push hl
	push de

	ld a,(hl)
	and $3f
	sla a
	sla a

	ld hl,volume
	ld e,a
	ld d,0

	add hl,de

	pop de

	ld bc,4
	ldir

	inc de

	pop hl

	inc hl

	pop bc

	djnz ShowPatternLoop7



	ld hl,(PatAdrVram)
	xor a
	call SetVramWrite

	ld hl,OneRowData
	ld bc,$3998
	otir

	ld hl,(PatAdrVram)
	ld de,80
	add hl,de
	ld (PatAdrVram),hl

	ld hl,(PatAdrRam)
	ld de,11
	add hl,de
	ld (PatAdrRam),hl

	pop bc

	dec b
	jp nz,ShowPatternLoop2

	ei

	ret

DoDiskMenu:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call StopSound

	ld a,(psgpat)
	inc a
	ld (NowInstrument),a

	ld hl,(StartPatAdr)
	ld (SaveInsAddress),hl

	ld a,0							; PSG Instrument (disk) menu
	ld (WhichDiskMenu),a

	ld a,1							; DiskMenu
	call DoMenu

	ShowPic(1)							; PSG edit screen
	call ShowPattern

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	jp main


SaveVolRam:
	.dw 0

PatAdrRam:
	.dw 0
PatAdrVram:
	.dw 0

psgpat:
	.db 0

OneRowData:
	.ds 6				; command
	.db 22

	.ds 3				; freq 1
	.db 22

	.ds 3				; freq 2
	.db 22
	
	.ds 3				; freq 3
	.db 22

	.ds 4				; rustle 1
	.db 22

	.ds 4				; rustle 2
	.db 22
	
	.ds 4				; rustle 3
	.db 22

	.ds 7				; noice frequency
	.db 22

	.ds 4				; volume 1
	.db 22

	.ds 4				; volume 2
	.db 22
	
	.ds 4				; volume 3
	.db 22
	

RepeatText:
	.text "Rep:  "
DoRepText:
	.text "DoRep "
WaitText:
	.text "Wait: "
PointText:
	.text "Point "
GotoPText:
	.text "Goto P"
EndText:
	.text "EndOp "
TempoText:
	.text "Tmp:  "


command:
	; commands.
	; all 6 bytes

	;      123456
	.text "  --  "

	.text "Rep: 1"
	.text "Rep: 2"
	.text "Rep: 3"
	.text "Rep: 4"
	.text "Rep: 5"
	.text "Rep: 6"
	.text "Rep: 7"
	.text "Rep: 8"
	.text "Rep: 9"
	.text "Rep:10"
	.text "Rep:11"
	.text "Rep:12"
	.text "Rep:13"
	.text "Rep:14"
	.text "Rep:15"

	.text "DoRep "

	.text "Wait:1"
	.text "Wait:2"
	.text "Wait:3"
	.text "Wait:4"
	.text "Wait:5"
	.text "Wait:6"
	.text "Wait:7"
	.text "Wait:8"
	.text "Wait:9"

	.text "Point "
	.text "Goto P"

	.text "EndOp "
	
	.text "Tmp: 0"
	.text "Tmp: 1"
	.text "Tmp: 2"
	.text "Tmp: 3"
	.text "Tmp: 4"
	.text "Tmp: 5"
	.text "Tmp: 6"
	.text "Tmp: 7"
	.text "Tmp: 8"
	.text "Tmp: 9"
	.text "Tmp:10"
	.text "Tmp:11"
	.text "Tmp:12"
	.text "Tmp:13"
	.text "Tmp:14"
	.text "Tmp:15"

rustle:
	; rustle.
	; all 4 bytes

	.text " -- "
	.text " ON "

rst_freq:
	; rustle frequency
	; all 7 bytes

	;      1234567
	.text "  ---  "
	.text "111860H"
	.text "55930Hz"
	.text "37286Hz"
	.text "27965Hz"
	.text "22372Hz"
	.text "18643Hz"
	.text "15980Hz"
	.text "13982Hz"
	.text "12428Hz"
	.text "11186Hz"
	.text "10169Hz"
	.text " 9321Hz"
	.text " 8604Hz"
	.text " 7990Hz"
	.text " 7457Hz"
	.text " 6991Hz"
	.text " 6580Hz"
	.text " 6214Hz"
	.text " 5887Hz"
	.text " 5593Hz"
	.text " 5326Hz"
	.text " 5084Hz"
	.text " 4863Hz"
	.text " 4660Hz"
	.text " 4474Hz"
	.text " 4302Hz"
	.text " 4142Hz"
	.text " 3995Hz"
	.text " 3857Hz"
	.text " 3728Hz"
	.text " 3608Hz" 

	.text " u:00  " ; 32..63
	.text " u:01  " ;
	.text " u:02  " ;
	.text " u:03  " ;
	.text " u:04  " ;
	.text " u:05  " ;
	.text " u:06  " ;
	.text " u:07  " ;
	.text " u:08  " ;
	.text " u:09  " ;
	.text " u:10  " ;
	.text " u:11  " ;
	.text " u:12  " ;
	.text " u:13  " ;
	.text " u:14  " ;
	.text " u:15  " ;
	.text " u:16  " ;
	.text " u:17  " ;
	.text " u:18  " ;
	.text " u:19  " ;
	.text " u:20  " ;
	.text " u:21  " ;
	.text " u:22  " ;
	.text " u:23  " ;
	.text " u:24  " ;
	.text " u:25  " ;
	.text " u:26  " ;
	.text " u:27  " ;
	.text " u:28  " ;
	.text " u:29  " ;
	.text " u:30  " ;
	.text " u:31  " ;

	.text " d:00  " ; 64..95
	.text " d:01  " ;
	.text " d:02  " ;
	.text " d:03  " ;
	.text " d:04  " ;
	.text " d:05  " ;
	.text " d:06  " ;
	.text " d:07  " ;
	.text " d:08  " ;
	.text " d:09  " ;
	.text " d:10  " ;
	.text " d:11  " ;
	.text " d:12  " ;
	.text " d:13  " ;
	.text " d:14  " ;
	.text " d:15  " ;
	.text " d:16  " ;
	.text " d:17  " ;
	.text " d:18  " ;
	.text " d:19  " ;
	.text " d:20  " ;
	.text " d:21  " ;
	.text " d:22  " ;
	.text " d:23  " ;
	.text " d:24  " ;
	.text " d:25  " ;
	.text " d:26  " ;
	.text " d:27  " ;
	.text " d:28  " ;
	.text " d:29  " ;
	.text " d:30  " ;
	.text " d:31  " ;

volume:
	.text " -- " ; 0..15
	.text " 01 " ;
	.text " 02 " ;
	.text " 03 " ;
	.text " 04 " ;
	.text " 05 " ;
	.text " 06 " ;
	.text " 07 " ;
	.text " 08 " ;
	.text " 09 " ;
	.text " 10 " ;
	.text " 11 " ;
	.text " 12 " ;
	.text " 13 " ;
	.text " 14 " ;
	.text " 15 " ;

	.text "u:00" ; 16..31
	.text "u:01" ;
	.text "u:02" ;
	.text "u:03" ;
	.text "u:04" ;
	.text "u:05" ;
	.text "u:06" ;
	.text "u:07" ;
	.text "u:08" ;
	.text "u:09" ;
	.text "u:10" ;
	.text "u:11" ;
	.text "u:12" ;
	.text "u:13" ;
	.text "u:14" ;
	.text "u:15" ;

	.text "d:00" ; 32..47
	.text "d:01" ;
	.text "d:02" ;
	.text "d:03" ;
	.text "d:04" ;
	.text "d:05" ;
	.text "d:06" ;
	.text "d:07" ;
	.text "d:08" ;
	.text "d:09" ;
	.text "d:10" ;
	.text "d:11" ;
	.text "d:12" ;
	.text "d:13" ;
	.text "d:14" ;
	.text "d:15" ;

off_event:
	.text "OFF " ; 48

EnterCommandData:
	.db 0
EnterPSGFreqData:
	.dw 0
EnterNoiceFreqData:
	.db 0
EnterVolumeData:
	.db 0

PsgName_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	.db 72,4
	.db 8
	.dw 0
	.db 32,126
	.db 0

;--------- PSG Replay Routine ---------

DoPSG:
	ld a,(NewPSG)
	inc a
	jp z,NoNewPSG

	ld b,a
	ld hl,psg_source-176
	ld de,184
NewPSGLoop1:
	add hl,de
	djnz NewPSGLoop1

	ld d,%10111111
	OutPSG(7)

	ld (PSGPlayAddress),hl

	ld a,15
	ld (PSGVolume),a
	ld (PSGVolume+1),a
	ld (PSGVolume+2),a

	ld (PSGPlayTempo),a

	xor a
	ld (PSGPlayRow),a
	ld (PSGPlayTempoCount),a
	ld (PSGWait),a
	ld (PSGPointRow),a

	dec a
	ld (NumberOfReps),a

	ld hl,0
	ld (PSGPointAddress),hl	

	ld a,255
	ld (NewPSG),a

NoNewPSG:
	ld a,(PSGPlayTempoCount)
	or a
	jp z,NewPSGPlayTempo

	dec a
	ld (PSGPlayTempoCount),a

	ret

NewPSGPlayTempo:
	ld a,(PSGWait)
	or a
	jp z,NoPSGWait

	dec a
	ld (PSGWait),a

	ret

NoPSGWait:
	ld a,(PSGPlayTempo)
	ld b,a

	ld a,15
	sub b

	ld (PSGPlayTempoCount),a


StartPSGRowCode:
; Check if instrument has reached it's end.

	ld a,(PSGPlayRow)
	cp 16
	ret z

; Check command

	ld hl,(PSGPlayAddress)

	ld a,(hl)
	or a
	jp z,PSGNoCommand

	cp 16
	jp c,PSGMakeRep

	cp 16
	jp z,PSGMakeDoRep

	cp 26
	jp c,PSGMakeWait

	cp 26
	jp z,PSGMakePoint

	cp 27
	jp z,PSGMakeGotoPoint

	cp 28
	jp z,PSGMakeEndPattern

	cp 45
	jp c,PSGMakeNewTempo

PSGNoCommand:
	inc hl									; Set HL to PSG frequencies

	ld b,3									; 3 PSG channels to out to.
	ld c,0									; First PSG register
	ld e,1									; For tones to be set off
PSGOutFreqLoop1:
	ld d,(hl)									; check if Freq = 0
											;
	inc hl									;
											;
	ld a,(hl)									;
											;
	or d										; if freq = 0 then
	jp z,NoPSGFreqChange							; jump to ..


	ld a,(hl)

	dec hl									; Set HL to original address

	bit 5,a
	jp nz,PSGOutFreqDown

	bit 6,a
	jp nz,PSGOutFreqUp

	ld a,c									; Out register to PSG
	out ($a0),a									;

	ld a,(hl)									; Out LSByte to PSG
	out ($a1),a									;

	inc hl									; increase address
	inc c										; increase PSG reg.

	ld a,(hl)									; Get MSByte of freq

	bit 4,a									; check if it is OFF
	jp z,PSGOutFreqNotOff							; nope.

	InPSG(7)									; Get reg. 7
	or e										; set channel off

	ld d,a									;
	OutPSG(7)									; Set reg. 7

	jp PSGFreqDone								; all done, next PSG

PSGOutFreqNotOff:
	ld a,e
	cpl
	ld e,a

	InPSG(7)
	and e
	ld d,a
	OutPSG(7)
	
	ld a,e
	cpl
	ld e,a

	ld a,c									; Out register to PSG
	out ($a0),a									;

	ld a,(hl)									; Out MSByte to PSG
	out ($a1),a									;

PSGFreqDone:
	sla e
	inc hl
	inc c

	djnz PSGOutFreqLoop1	

	ld ix,PSGvolume

	InPSG(7)
	or %00111000
	ld d,a

	ld bc,$0308^255
PSGVolNoiceLoop1:
	ld a,(hl)									; Get first volume and noice

	bit 6,a
	jp z,NoNoiceChange

	ld a,d
	and c
	ld d,a

	ld a,(hl)
NoNoiceChange:
	and %00111111
	jp z,NoVolumeChange

	bit 4,a
	jp nz,PSGVolumeUp

	bit 5,a
	jp nz,PSGVolumeDown

	and $0f
NoiceVolumeDone:
	ld (ix),a

NoVolumeChange:
	inc hl
	inc ix

	ld a,c

	sla a
	or 1

	ld c,a

	djnz PSGVolNoiceLoop1

	OutPSG(7)

	ld a,(hl)
	bit 5,a
	jp nz,NoiceFreqDown
	bit 6,a
	jp nz,NoiceFreqUp

	or a
	jp z,NoNoiceFreqChange

NoiceFreqChangeDone:
	ld d,a
	OutPSG(6)

NoNoiceFreqChange:
	ld a,(PSGVolume+0)
	ld d,a
	OutPSG(8)

	ld a,(PSGVolume+1)
	ld d,a
	OutPSG(9)

	ld a,(PSGVolume+2)
	ld d,a
	OutPSG(10)

	jp PSGAllDone

NoiceFreqDown:
	and %00011111
	ld b,a

	InPSG(6)

	sub b

	and %00011111

	jp NoiceFreqChangeDone

NoiceFreqUp:
	and %00011111
	ld b,a

	InPSG(6)

	add a,b

	and %00011111

	jp NoiceFreqChangeDone

PSGOutFreqDown:
	push de

	ld a,c

	out ($a0),a
	in a,($a2)

	ld e,a

	ld a,c
	inc a

	out ($a0),a
	in a,($a2)

	ld d,a

	ld a,(hl)

	push hl

	ld l,a
	ld h,0

	ex de,hl

	or a
	sbc hl,de

	ld a,c
	out ($a0),a

	ld a,l
	out ($a1),a

	inc c

	ld a,c
	out ($a0),a

	ld a,h
	out ($a1),a

	pop hl
	pop de

	inc hl

	jp PSGFreqDone

PSGOutFreqUp:
	push de

	ld a,c

	out ($a0),a
	in a,($a2)

	ld e,a

	ld a,c
	inc a

	out ($a0),a
	in a,($a2)

	ld d,a

	ld a,(hl)

	push hl

	ld l,a
	ld h,0

	add hl,de

	ld a,c
	out ($a0),a

	ld a,l
	out ($a1),a

	inc c

	ld a,c
	out ($a0),a

	ld a,h
	out ($a1),a

	pop hl
	pop de

	inc hl

	jp PSGFreqDone

PSGVolumeUp:
	push bc

	and $0f
	ld b,a

	ld a,(ix)
	add a,b

	pop bc

	cp 16
	jp c,NoiceVolumeDone

	ld a,15
	jp NoiceVolumeDone

PSGVolumeDown:
	push bc

	and $0f
	ld b,a

	ld a,(ix)
	sub b

	pop bc

	jp nc,NoiceVolumeDone

	xor a
	jp NoiceVolumeDone

PSGAllDone:
	ld a,(PSGPlayRow)
	inc a
	ld (PSGPlayRow),a

	ld hl,(PSGPlayAddress)
	ld de,11
	add hl,de
	ld (PSGPlayAddress),hl

	ret

NoPSGFreqChange:
	inc c

	jp PSGFreqDone

PSGMakeNewTempo:
	sub 29

	ld (PSGPlayTempo),a

	ld b,a

	ld a,15
	sub b

	ld (PSGPlayTempoCount),a

	jp PSGNoCommand

PSGMakeRep:
	ld b,a

	ld a,(NumberOfReps)
	cp 255
	jp nz,PSGNoCommand

	ld a,b

	ld (NumberOfReps),a
	ld (RepPointerAddress),hl

	ld a,(PSGPlayRow)
	ld (RepPointerRow),a

	jp PSGNoCommand

PSGMakeDoRep:
	ld a,(NumberOfReps)
	cp 255
	jp z,PSGNoCommand

	dec a
	ld (NumberOfReps),a

	cp 255
	jp z,PSGNoCommand

	ld a,(RepPointerRow)
	ld (PSGPlayRow),a

	ld hl,(RepPointerAddress)
	ld (PSGPlayAddress),hl

	jp StartPSGRowCode

PSGMakeWait:
	sub 16
	ld (PSGWait),a

	jp PSGNoCommand

PSGMakePoint:
	ld (PSGPointAddress),hl

	ld a,(PSGPlayRow)
	ld (PSGPointRow),a

	jp PSGNoCommand

PSGMakeGotoPoint:	
	ld a,(PSGPlayRow)
	ld b,a
	ld a,(PSGPointRow)
	cp b
	jp z,PSGNoCommand

	ld (PSGPlayRow),a

	ld hl,(PSGPointAddress)
	ld (PSGPlayAddress),hl

	jp StartPSGRowCode

PSGMakeEndPattern:
	ld a,15
	ld (PSGPlayRow),a

	jp PSGNoCommand

NewPSG:
	.db 0

PSGPlayRow:
	.db 16
PSGPlayAddress:
	.dw 0
PSGPlayTempo:
	.db 0
PSGPlayTempoCount:
	.db 0

NumberOfReps:
	.db 255
RepPointerRow:
	.db 0
RepPointerAddress:
	.dw 0
PSGWait:
	.db 0
PSGPointRow:
	.db 0
PSGPointAddress
	.dw 0

PSGVolume:
	.db 0,0,0


; Data for frequency of notes:
; stored as follows: c 1  c#1  d 1  e 1  f 1  f#1  g 1  g#1  a 1  a#1  b 1
;                    c 2  c#2  d 2  e 2  f 2  f#2  g 2  g#2  a 2  a#2  b 2
; aso (and so on) (till c 8/b 8)

freq_data:
        .dw 3421,3228,3047,2876,2715,2562,2419,2283,2155,2034,1920,1812
        .dw 1711,1614,1524,1438,1358,1281,1210,1142,1078,1017,0960,0906
        .dw 0855,0807,0762,0719,0679,0641,0605,0569,0539,0509,0480,0453
        .dw 0428,0404,0381,0360,0339,0320,0302,0285,0269,0254,0240,0227
        .dw 0214,0202,0190,0180,0170,0160,0151,0143,0135,0127,0120,0113
        .dw 0107,0101,0095,0090,0085,0080,0076,0071,0067,0064,0060,0057
        .dw 0053,0050,0048,0045,0042,0040,0038,0036,0034,0032,0030,0028
        .dw 0027,0025,0024,0022,0021,0020,0019,0018,0017,0016,0015,0014
freq_data_end:


PSGEditEnd:
	.ds $5b00-PSGEditEnd

#include "sb2-disk.asm"

#include "sb2rmain.asm"

end_program:


.end

; end of prg.
