; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Player
; Code: d-fader^TwZ.
; Date: August 3, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#define	ShowPlayRowNr				  ld a,(SngRow)
#defcont							\ inc a
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(RowPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal+1
#defcont							\ ld bc,$0298
#defcont							\ otir

#define	ShowPlayTempo				  ld a,(SngTmp)
#defcont							\ ld b,a
#defcont							\ ld a,26
#defcont							\ sub b
#defcont							\ call Calc8Dec
#defcont							\ xor a
#defcont							\ ld hl,(TempoPoint)
#defcont							\ call SetVramWrite
#defcont							\ ld hl,Decimal+1
#defcont							\ ld bc,$0298
#defcont							\ otir

PlayPattern:
	ld a,(SngPos)
	ld b,a
	ld a,(LastPos)
	cp b
	jp nc,PlayPattern.PosOk

	ShowHint(112)

	call kilbuf
	call chget

	ld a,(PatPosMenuOn)
	or a
	ret nz

	jp main

PlayPattern.PosOk:
	xor a
	ld (play.pattern),a

	ld a,(SngPos)
	ld (SaveSngPos),a
	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(hl)
	ld (SaveSngPat2),a

	ld a,(SngPat)
	ld (SaveSngPat),a
	ld (hl),a

	jp PlaySong.continue

PlaySong:
	ld a,(SngPos)
	ld b,a
	ld a,(LastPos)
	cp b
	jp nc,PlaySong.PosOk

	ShowHint(109)

	call kilbuf
	call chget

	ld a,(PatPosMenuOn)
	or a
	ret nz

	jp main

PlaySong.PosOk:
	ld a,255
	ld (Play.pattern),a

	ld a,(SngPos)
	ld (SaveSngPos),a

	ld a,(SngPat)
	ld (SaveSngPat),a

PlaySong.continue:
	ld a,(PatPosMenuOn)
	or a
	call z,DeInitSongMenu

	ld hl,EqValues
	ld de,EqValues+1
	ld bc,5
	ld (hl),0
	ldir

	ld hl,Normal.Eq
	ld de,Equalizers
	ld bc,7*2
	ldir

	ld a,(PatPosMenuOn)
	ld (Play.PatPosEdit),a

	ld a,(BlockOn)

	push af

	xor a
	ld (BlockOn),a

	xor a
	ld (SngRow),a
	ld (Play.BarOnScreen),a
	cpl
	ld (Play.LastRowShowed),a

	ld a,(SngPos)
	cpl
	ld (Play.LastPosShowed),a

	ld a,255
	ld (Play.LastTmpShowed),a

	ld a,1
	ld (RepCommand),a

	ld a,(scc)
	ld (Repdata),a

; --- start playing song from here ---

	ld a,4
	call DoMenu

	ld a,(play.pattern)
	add a,111
	call DoShowHint

PlaySong.1:
	ld a,(SngRow)
	cp 15
	jp z,PlaySong.1

	ld a,(PatPosMenuOn)
	or a
	jp nz,PP.SongLoop

	jp PlaySongLoop

PP.SongLoop:
	call Play.DoEqualizer

	ld a,(MusicPeak)
	or a
	jp z,PP.NoNewPos2

	ld a,(Play.LastTmpShowed)
	ld b,a
	ld a,(SngTmp)
	cp b
	jp z,PP.SongLoop.1

	ld (Play.LastTmpShowed),a

	ShowPlayTempo

PP.SongLoop.1:
	ld a,(Play.LastPosShowed)
	ld b,a
	ld a,(SngPos)
	cp b
	jp z,PP.NoNewPos1

	ld (Play.LastPosShowed),a

	call ShowHighLight

	jp PP.NoNewPos2

PP.NoNewPos1:
	ld a,(Play.LastRowShowed)
	ld b,a
	ld a,(SngRow)
	cp b
	jp z,PP.NoNewPos2

	ShowPlayRowNr

PP.NoNewPos2:
	ld a,($fbeb)
	bit 2,a
	jp nz,PP.GraphDone

	ld a,($fbe8)
	bit 2,a
	jp z,PP.ChangeEqType

PP.GraphDone:
	ld a,(MusicPlay)
	or a
	jp z,EndPlaySong

	xor a
	ld (KeyPress),a

PP.KeyPressDone
	ld a,($fbec)
	bit 2,a
	jp z,EndPlaySong
	bit 4,a
	jp z,StopPlaySong

	ld a,($fbed)
	bit 0,a
	jp z,EndPlaySong

	ei
	halt

	jp PP.SongLoop

PP.ChangeEqType:
	ld a,(KeyPress)
	or a
	jp nz,PP.KeyPressDone

	inc a
	ld (KeyPress),a

	ld a,(EqType)
	xor 1
	ld (EqType),a

	jp PP.KeyPressDone

PlaySongLoop:
	call Play.DoEqualizer

	ld a,(MusicPeak)
	or a
	jp z,Play.NoNewPos2

	ld a,(Play.LastTmpShowed)
	ld b,a
	ld a,(SngTmp)
	cp b
	jp z,PlaySongLoop.1

	ld (Play.LastTmpShowed),a

	ShowPlayTempo

PlaySongLoop.1:
	ld a,(Play.LastPosShowed)
	ld b,a
	ld a,(SngPos)
	cp b
	jp z,Play.NoNewPos1

	ld (Play.LastPosShowed),a

	call ShowPosition
	call ShowSongBar

	jp Play.NoNewPos2

ShowSongBar:
	ld a,(Play.LastRowShowed)
	ld b,a
	ld a,(SngRow)
	cp b
	ret z

	ld a,(play.BarOnScreen)
	or a
	jp z,ShowSongbar.1

	ld a,(Play.LastRowShowed)
	add a,6

	ld e,a
	ld d,2
	ld a,51
	call DrawBar

ShowSongBar.1:
	ld a,1
	ld (play.BarOnScreen),a

	ld a,(SngRow)
	ld (Play.LastRowShowed),a

	add a,6

	ld e,a
	ld d,2
	ld a,51
	call DrawBar

	ShowPlayRowNr

	ret

Play.BarOnScreen:
	.db 0

Play.NoNewPos1:
	ld a,(Play.LastRowShowed)
	ld b,a
	ld a,(SngRow)
	cp b
	jp z,Play.NoNewPos2

	call ShowSongBar

Play.NoNewPos2:
	ld a,(MusicPlay)
	or a
	jp z,EndPlaySong

	ScanKey(graph)
	jp z,GraphKeyChange

	ScanKey(shift)
	jp nz,NoKeyPress

	ld c,1

	ScanKey(key_1)
	jp z,Play.SwitchChannel

	sla c

	ScanKey(key_2)
	jp z,Play.SwitchChannel

	sla c

	ScanKey(key_3)
	jp z,Play.SwitchChannel

	sla c

	ScanKey(key_4)
	jp z,Play.SwitchChannel

	sla c

	ScanKey(key_5)
	jp z,Play.SwitchChannel

	sla c

	ScanKey(key_6)
	jp z,Play.SwitchChannel


	jp NoKeyPress

Play.SwitchChannel:
	ld a,(KeyPress)
	or a
	jp nz,KeyPressDone

	ld a,c
	cp %00100000
	jp z,Play.SwitchPSG

	ld a,(SCCSwitch)
	xor c
	ld (SCCSwitch),a

	call ShowOnOffChannels

	jp KeyPressDone.1

Play.SwitchPSG:
	ld a,(PSGSwitch)
	xor 1
	ld (PSGSwitch),a

	call ShowOnOffChannels

	jp KeyPressDone.1
	
GraphKeyChange:
	ScanKey(key_e)
	jp z,Play.EqType

	ScanKey(key_a)
	jp z,Play.AllChanOn

	ld c,1

	ScanKey(key_1)
	jp z,Play.SoloChannel

	sla c

	ScanKey(key_2)
	jp z,Play.SoloChannel

	sla c

	ScanKey(key_3)
	jp z,Play.SoloChannel

	sla c

	ScanKey(key_4)
	jp z,Play.SoloChannel

	sla c

	ScanKey(key_5)
	jp z,Play.SoloChannel

	sla c

	ScanKey(key_6)
	jp z,Play.SoloChannel

	jp NoKeyPress

Play.AllChanOn:
	ld a,(KeyPress)
	or a
	jp nz,KeyPressDone

	ld a,$1f
	ld (SCCSwitch),a

	ld a,1
	ld (PSGSwitch),a

	call ShowOnOffChannels

	jp KeyPressDone.1


Play.SoloChannel:
	ld a,(KeyPress)
	or a
	jp nz,KeyPressDone

	ld a,c
	cp %00100000
	jp z,Play.SoloPSG

	ld (SCCSwitch),a

	xor a
	ld (PSGSwitch),a

	call ShowOnOffChannels

	jp KeyPressDone.1

Play.SoloPSG:
	ld a,1
	ld (PSGSwitch),a

	xor a
	ld (SCCSwitch),a

	call ShowOnOffChannels

	jp KeyPressDone.1

Play.EqType:
	ld a,(KeyPress)
	or a
	jp nz,KeyPressDone

	ld a,(EqType)
	xor 1
	ld (EqType),a

	ShowEqType

	jp KeyPressDone.1

KeyPressDone.1:
	ld a,1
	ld (KeyPress),a

	jp KeyPressDone

NoKeyPress:
	xor a
	ld (KeyPress),a

KeyPressDone:
	ld a,($fbec)
	bit 2,a
	jp z,EndPlaySong
	bit 4,a
	jp z,StopPlaySong

	ld a,($fbed)
	bit 0,a
	jp z,EndPlaySong

	ei
	halt

	jp PlaySongLoop

KeyPress:
	.db 0

StopPlaySong:
	ld a,(play.pattern)
	cp 255
	jp nz,EndPlaySong

	ld a,SngBnk
	out ($fe),a

	ld a,(SngPos)
	ld (SaveSngPos),a

	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(hl)
	ld (SaveSngPat),a
	
EndPlaySong:
	ld a,SngBnk
	out ($fe),a

	ShowHint(empty)

	ld hl,Normal.Eq
	ld de,Equalizers
	ld bc,7*2
	ldir

	call Play.ShowEqualizer

	ld a,(SaveSngPos)
	ld (SngPos),a

	ld a,(SaveSngPat)
	ld (SngPat),a

	ld a,(SngRow)
	add a,6
	ld (NowY),a

	ld a,(play.pattern)
	cp 255
	jp z,EndPlaySong.1

	ld a,(SngPos)
	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(SaveSngPat2)
	ld (hl),a

EndPlaySong.1:
	pop af

	ld (BlockOn),a

	ld a,(SngPat)
	cpl
	ld (LastPatShowed),a

	ld a,2
	ld (RepCommand),a

	ld a,4
	call DoMenu

	call ClearBlink

	ld a,(PatPosMenuOn)
	or a
	ret nz

	call InitialiseSongEdit3

	call nokey

	jp main

SaveSngPos:
	.db 0
SaveSngPat:
	.db 0
SaveSngPat2:
	.db 0

Play.LastPosShowed:
	.db 0

Play.LastRowShowed:
	.db 0

Play.LastTmpShowed:
	.db 0

Play.DoEqualizer:
	ld a,(EqType)
	or a
	jp nz,Play.DoVolumeEq

	ld a,(MusicPeak)
	or a
	jp z,Play.EqCalc.Done

	ld hl,RepCommand
	ld de,EqValues
	ld ix,SngVolumes

	ld b,5
Play.normal.1:
	push hl
	push de

	push hl
	push de

	ld e,b
	ld d,0
	ld hl,EQCheck-1
	add hl,de

	ld a,(hl)
	ld c,a

	pop de
	pop hl

	ld a,(SCCSwitch)
	and c
	or a
	jp z,Play.Normal.1.Done

	ld a,(hl)
	or a
	jp z,Play.normal.1.done
	cp 97
	jp nc,Play.normal.1.done

	ld a,(ix)
	inc a
	ld (de),a

Play.normal.1.done:
	pop de
	pop hl

	inc de
	inc hl
	inc ix

	djnz Play.normal.1

	ld a,(RepCommand+5)
	or a
	jp z,Play.EqCalc.done

	push de

	call Play.GetPSGVolume

	pop de

	inc a
	ld (de),a

Play.EqCalc.done:
	ld hl,EqValues
	ld ix,Equalizers
	ld b,6
Play.EqCalc.1:
	ld a,(EqType)
	or a
	jp nz,NoDecrease

	ld a,(hl)
	or a
	jp z,Play.EqCalc.1.done

	dec a
	ld (hl),a

NoDecrease:
	ld a,(hl)

	push hl

	sla a

	ld e,a
	ld d,0
	ld hl,EqOutValues
	add hl,de

	ld a,(hl)
	ld (ix+0),a

	inc hl

	ld a,(hl)
	ld (ix+7),a

	pop hl

Play.EqCalc.1.done:
	inc hl

	ld a,b
	cp 2
	jp nz,Play.EqCalc.1.done2

	inc ix

Play.EqCalc.1.done2:
	inc ix

	djnz Play.EqCalc.1

Play.ShowEqualizer:
	SetVW(0,16*80+72)

	ld a,(PatPosMenuOn)
	or a
	jp z,Play.SE.1
	
	SetVW(0,19*80+71)

Play.SE.1:
	ld hl,Equalizers
	ld bc,$0798
	otir

	SetVW(0,17*80+72)

	ld a,(PatPosMenuOn)
	or a
	jp z,Play.SE.2
	
	SetVW(0,20*80+71)

Play.SE.2:
	ld hl,Equalizers+7
	ld bc,$0798
	otir
	
	ret

Play.DoVolumeEq:
	ld ix,SngFreqs
	ld hl,SngVolumes
	ld de,EqValues

	ld b,5
Play.DVE.1:
	ld a,(ix+0)
	or a
	jp nz,Play.DVE.2

	cp (ix+1)
	jp nz,Play.DVE.2

	ld a,(de)
	or a
	jp z,Play.DVE.3

	dec a

	jp Play.DVE.3
	
Play.DVE.2:
	push hl
	push de

	ld e,b
	ld d,0
	ld hl,EQCheck-1
	add hl,de

	ld a,(hl)
	ld c,a

	pop de
	pop hl

	ld a,(SCCSwitch)
	and c
	or a

	ld a,(de)

	jp z,Play.DVE.Decrease

	ld a,(de)

	cp (hl)
	jp z,Play.DVE.NoChange

	jp nc,Play.DVE.Decrease

	inc a
	inc a
Play.DVE.Decrease:
	dec a

Play.DVE.3:
	cp 255
	jp nz,Play.DVE.3.1

	inc a

PLay.DVE.3.1:
	ld (de),a

Play.DVE.NoChange:
	inc hl
	inc de

	inc ix
	inc ix

	djnz PLay.DVE.1

	push de
	call Play.GetPSGVolume
	pop de

	ld b,a
	ld a,(de)
	cp b
	jp z,Play.EqCalc.done

	jp nc,Play.DVEP.Decrease

	inc a
	inc a
Play.DVEP.Decrease:
	dec a
	ld (de),a

	jp Play.EqCalc.done

Play.GetPSGVolume:
	ld a,(PSGSWitch)
	or a
	ret z


	InPSG(8)
	and $0f
	ld (PSGVolumes+0),a

	InPSG(9)
	and $0f
	ld (PSGVolumes+1),a


	InPSG(10)
	and $0f
	ld (PSGVolumes+2),a


	ld h,0
	ld d,0

	InPSG(7)

	ld b,a

	ld a,(PSGVolumes+0)
	ld e,a

	ld a,b
	and %00000001
	jp z,Channel1On

	ld a,b
	and %00001000
	jp nz,Channel1Off

Channel1On:
	ld a,d

	add a,e

	ld d,a
	inc h

Channel1Off:
	ld a,(PSGVolumes+1)
	ld e,a

	ld a,b
	and %00000010
	jp z,Channel2On

	ld a,b
	and %00010000
	jp nz,Channel2Off

Channel2On:
	ld a,d

	add a,e

	ld d,a
	inc h
Channel2Off:
	ld a,(PSGVolumes+2)
	ld e,a

	ld a,b
	and %00000100
	jp z,Channel3On

	ld a,b
	and %00010000
	jp nz,Channel3Off

Channel3On:
	ld a,d

	add a,e

	ld d,a
	inc h

Channel3Off:
	ld a,h
	or a
	ret z

	ld a,d
	ld c,255
Play.GPV.1:
	sub h

	inc c

	jp nc,Play.GPV.1

	ld a,c

	ret


PSGVolumes:
	.ds 3

EqValues:
	.db 0,0,0,0,0,0

Equalizers:
	.db 0,0,0,0,0,32,0
	.db 0,0,0,0,0,32,0

Normal.Eq:
	.db 0,0,0,0,0,32,0
	.db 0,0,0,0,0,32,0


EqOutValues:
	.db 128+8,128+8
	.db 128+8,128+7
	.db 128+8,128+6
	.db 128+8,128+5
	.db 128+8,128+4
	.db 128+8,128+3
	.db 128+8,128+2
	.db 128+8,128+1
	.db 128+8,128+0
	.db 128+7,128+0
	.db 128+6,128+0
	.db 128+5,128+0
	.db 128+4,128+0
	.db 128+3,128+0
	.db 128+2,128+0
	.db 128+1,128+0

EQCheck:
	.db %0010000
	.db %0001000
	.db %0000100
	.db %0000010
	.db %0000001

.end
