; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Pattern/Position editor
; Code: d-fader^TwZ.
; Date: july 24, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

PatternPositionEditor:
;	jp StartPatPosEdit
;
;	.ds 16-3
;
;	.text " PAT/POS Editor "

StartPatPosEdit:
	call InitPatPosMenu

PatPosMain.Init:
	ld a,($fbeb)
	bit 5,a
	jp z,PatPosMain.Init

PatPosMain:
	ShowHint(Empty)

	Locate(1,25)

	call chget
	ld (CursorSave),a

	ld a,($fbeb)
	bit 1,a
	jp nz,PPContDone

	ld a,($fbe7)
	bit 7,a
	jp z,PatPos.MarkBegin

	ld a,($fbe8)
	bit 0,a
	jp z,PP.CopyBlock

	bit 1,a
	jp z,PatPos.UnmarkBlock

	bit 2,a
	jp z,PatPos.MarkEnd

	bit 4,a
	jp z,GrabLastPos

	bit 5,a
	jp z,BlafPatpHelp

	ld a,($fbe9)
	bit 1,a
	jp z,ChangeLoopPos

	bit 7,a
	jp z,ReInitSCC

	ld a,($fbea)
	bit 0,a
	jp z,SwapSettingsScan

	bit 1,a
	jp z,ChangeTempo

PPContDone:
	ld a,($fbeb)
	bit 2,a
	jp nz,PPGraphDone

	ld c,%00010000
	ld a,($fbe5)
	bit 1,a
	jp z,ForceMusic

	sla c
	bit 2,a
	jp z,ForceMusic

	ld a,($fbe8)
	bit 4,a
	jp z,GrabLoopPos

	bit 6,a
	jp z,ShowKitNames

	ld a,($fbea)
	bit 1,a
	jp z,CalculateSongTime

	ld a,($fbed)
	bit 5,a
	jp z,LastPosUp4

	bit 7,a
	jp z,LastPosUp1

	bit 6,a
	jp z,LastPosDown4

	bit 4,a
	jp z,LastPosDown1

PPGraphDone:
	ld a,($fbeb)
	bit 5,a
	jp z,PP.PlaySong

	bit 6,a
	jp z,PP.PlayPattern

	ld a,($fbed)
	bit 1,a
	jp z,PositionHome

	bit 3,a
	jp z,DeletePosition

	bit 2,a
	jp z,InsertPosition

	bit 0,a
	jp z,EnterPatNr

	ld a,($fbec)
	bit 7,a
	jp z,EnterPatNr

	bit 2,a
	jp z,PatPosEnd

	ld a,(CursorSave)

	cp $1c
	jp z,HLUp1

	cp $1d
	jp z,HLDown1

	cp $1e
	jp z,HLDown16

	cp $1f
	jp z,HLUp16

	jp PatPosMain

PatPos.MarkBegin:
	ld a,(SngPos)
	ld (Pat.Block.s),a
	ld (Pat.Block.e),a

	ld a,1
	ld (Pat.Block),a

	jp PatPos.MarkOk

PatPos.MarkEnd:
	ld a,(Pat.Block)
	or a
	jp z,PatPos.MarkBegin

	ld a,(SngPos)
	ld (Pat.Block.e),a

	ld b,a
	ld a,(Pat.Block.s)
	cp b
	jp c,PatPos.MarkOk

	ld (Pat.Block.e),a
	ld a,b
	ld (Pat.Block.s),a
PatPos.MarkOk:
	call ShowAllPats

	jp PatPosMain

PatPos.UnmarkBlock:
	xor a
	ld (Pat.Block),a

	jp PatPos.MarkOk


PP.CopyBlock:
	ld a,(Pat.Block)
	or a
	jp nz,PP.CB.1

	ShowHint(171)

	call kilbuf
	call chget

	jp PatPosMain

PP.CB.1:
	ld a,(Pat.Block.s)
	ld b,a
	ld a,(Pat.Block.e)
	sub b
	ld b,a

	ld a,(SngPos)
	add a,b
	jp c,PP.CB.3
	add a,1
	jp nc,PP.Cb.2

PP.CB.3:
	ShowHint(176)

	call kilbuf
	call chget

	jp PatPosMain

PP.CB.2:
	ld a,SngBnk
	out ($fe),a

	ld hl,patterns

	ld a,(Pat.Block.e)
	ld e,a
	ld d,0
	add hl,de

	push hl

	ld hl,patterns

	ld a,(SngPos)
	ld e,a
	ld d,0
	add hl,de

	ld e,b
	add hl,de

	push hl
	pop de

	pop hl

	inc b
	ld c,b
	ld b,0

	lddr

	jp PatPos.MarkOk

PatPosEnd:
	call DeInitPatPosMenu

	ret

PP.PlaySong:
	call PlaySong

	call nokey

PP.PlayDone:
	ld a,6
	ld (NowY),a

	ShowPosNr
	ShowPatNr
	ShowRowNr

	call ShowHighLight

	ShowTempo

	jp PatPosMain

PP.PlayPattern:
	call PlayPattern

	call nokey

	jp PP.PlayDone

Pat.Block:
	.db 0
Pat.Block.s:
	.db 0
Pat.Block.e:
	.db 0
Pat.Block.Pos:
	.db 0

CheckPatPosBlock:
	ld a,(Pat.Block)
	or a
	jp z,PP.BlockOff

	ld a,(Pat.Block.Pos)
	ld b,a

	ld a,(Pat.Block.s)
	cp b
	jp z,PP.BlockOn
	jp nc,PP.BlockOff

	ld a,(Pat.Block.e)
	cp b
	jp c,PP.BlockOff

PP.Blockon
	ld a,91
	ld (ShowAllPats.data1),a

	ld a,93
	ld (ShowAllPats.data1+3),a

	jp PP.Block.Done

PP.BlockOff:
	ld a,32
	ld (ShowAllPats.data1),a
	ld (ShowAllPats.data1+3),a

PP.Block.Done:
	ld a,(Pat.Block.Pos)
	inc a
	ld (Pat.Block.Pos),a

	ret

ShowAllpats:
	xor a
	ld (Pat.Block.Pos),a

	ld hl,80*4+5
	ld de,Patterns

	ld b,16

ShowAllPats.3:
	push bc
ShowAllPats.1:
	xor a
	call SetVramWrite

	push hl

	ld b,16
ShowAllPats.2:
	push bc
	push de

	ld hl,ShowAllPats.data1
	ld a,(de)
	call Calc8Dec2

	pop de
	push de

	call CheckPatPosBlock

	ld hl,ShowAllPats.data1
	ld bc,$0498
	otir

	pop de
	pop bc

	inc de

	djnz ShowAllPats.2

	pop hl

	ld bc,80
	add hl,bc

	pop bc

	djnz ShowAllPats.3

	ret

ShowAllPats.data1:
	.db " 00 "

PositionHome:
	xor a
	ld (SngPos),a

	call ShowHighLight

	jp PatPosMain

HLUp1:
	ld a,(SngPos)
	and $0f
	inc a
	and $0f
	ld b,a
	ld a,(SngPos)
	and $f0
	add a,b
	ld (SngPos),a

	call ShowHighLight

	jp PatposMain

HLUp16:
	ld a,(SngPos)
	add a,16
	ld (SngPos),a

	call ShowHighLight

	jp PatposMain

HLDown1:
	ld a,(SngPos)
	and $0f
	dec a
	and $0f
	ld b,a
	ld a,(SngPos)
	and $f0
	add a,b
	ld (SngPos),a

	call ShowHighLight

	jp PatposMain

HLDown16:
	ld a,(SngPos)
	sub 16
	ld (SngPos),a

	call ShowHighLight

	jp PatposMain

ShowHighLight:
	call ClearBlink

	ld a,(SngPos)
	srl a
	srl a
	srl a
	srl a
	add a,5
	ld e,a

	ld a,(SngPos)
	and $0f
	sla a
	sla a
	add a,6

	ld d,a

	ld a,4

	call DrawBar

	ShowPosNr

	ld a,(SngPos)
	ld e,a
	ld d,0
	ld hl,Patterns
	add hl,de

	ld a,(hl)
	ld (SngPat),a

	ShowPatNr

	ret

EnterPatNr:
	ShowHint(90)

	ld a,(SngPos)
	srl a
	srl a
	srl a
	srl a
	add a,5
	ld l,a

	ld a,(SngPos)
	and $0f
	sla a
	sla a
	add a,7

	ld h,a

	ld (CurLoc),hl

	call Input82Dec
	jp c,EnterPatEscaped

	ld b,a

	ld hl,Patterns
	ld a,(SngPos)
	ld e,a
	ld d,0
	add hl,de

	ld (hl),b

EnterPatEscaped:
	call ShowAllPats
	call ShowHighLight

	jp PatPosMain

DeletePosition:
	ld a,(SngPos)
	cp 255
	jp z,DeleteOnlyLast

	ld hl,Patterns
	ld e,a
	ld d,0
	
	add hl,de

	push hl
	pop de

	inc hl

	ld a,(SngPos)
	cpl

	ld c,a
	ld b,0

	ldir
DeleteOnlyLast:
	xor a
	ld (Patterns+255),a

	call ShowAllPats
	call ShowHighLight

	ld a,(SngPos)
	ld b,a
	ld a,(LastPos)
	cp b
	jp nc,LastPosDown1

	jp PatPosMain

InsertPosition:
	ld hl,Patterns+255
	ld a,(SngPos)
	cp 255
	jp z,InsertOnlyLastPos

	ld hl,Patterns+254
	ld de,Patterns+255

	ld a,(SngPos)
	cpl

	ld c,a
	ld b,0

	lddr

	inc hl
	ld (hl),0

	call ShowAllPats

	inc hl
InsertOnlyLastPos:
	ld (hl),0

	ld a,(SngPos)
	ld b,a
	ld a,(LastPos)
	cp b
	jp c,NoLastPosChange

	ld a,(LastPos)
	cp 255
	jp z,NoLastPosChange

	inc a
	ld (LastPos),a

	ShowLastPos

NoLastPosChange:
	jp EnterPatNr	

GrabLoopPos:
	xor a
	ld (LoopPos),a

	ld a,(SngPos)
	ld (LoopPos+1),a

	ld b,a
	ld a,(LastPos)
	sub b
	jp nc,GrabLoopPos.done

	ld a,(LoopPos+1)
	ld (LastPos),a

GrabLoopPos.done:
	call ShowLoopPos.2
	ShowLastPos

	jp PatPosMain

GrabLastPos:
	ld a,(SngPos)
	ld (LastPos),a

	ShowLastPos

	ld a,(LoopPos)
	or a
	jp nz,PatPosMain

	ld a,(LoopPos+1)
	ld b,a
	ld a,(LastPos)
	cp b
	jp nc,PatPosMain

	ld a,(LastPos)
	ld (LoopPos+1),a

	call ShowLoopPos.2

	jp PatPosMain

InitPatPosMenu:
	ld a,(NowY)
	ld (SaveRowNr),a

	ld a,6
	ld (NowY),a

	ld hl,PatPos_pointers
	ld de,VRAM_pointers
	ld bc,12
	ldir
	
	ShowPic(3)

	ShowPosNr
	ShowPatNr
	ShowRowNr

	ShowLastPos
	call ShowLoopPos.2

	call ShowAllPats

	call ShowHighLight

	ShowTempo

	ld a,1
	ld (PatPosMenuOn),a

	ret

DeInitPatPosMenu:
	ld a,(SaveRowNr)
	ld (NowY),a

	ld hl,SongEdit_pointers
	ld de,VRAM_pointers
	ld bc,12
	ldir

	call ClearBlink

	xor a
	ld (PatPosMenuOn),a

	ret

SaveRowNr:
	.db 0

PatPosMenuOn:
	.db 0

.end

; end of file aka [EOF]
