; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Instrument Selector
; Code: d-fader^TwZ.
; Date: july 28, 1999
;
; cmnt: filename of this file: BLAF_NT.012
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#include "macro's.asm"

	.org $4000

#include "macro's.asm"
#include "sb2rmacr.asm"

#define	ShowCurKeyb					  SetVW(0,80*23+19)
#defcont							\ 
#defcont							\ ld hl,Keyboards
#defcont							\ ld a,(CurKeyb)
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ 
#defcont							\ ld bc,$0798
#defcont							\ otir

#define	ShowCurOct					  SetVW(0,80*23+42)
#defcont							\ 
#defcont							\ ld hl,CurrentOctaves
#defcont							\ ld a,(CurOct)
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ 
#defcont							\ ld bc,$0398
#defcont							\ otir

InstrumentSelector:
	jp start_program

	.ds 16-3

	.text "                "
	.text " SCC BLAFFER NT "
	.text "  (C) 1999 TwZ  "
	.text "                "
	.text "  Ins. Select!  "
	.text "                "

start_program:
	ld a,(Repdata)
	ld (CurOct),a

	ld a,(KeyBDone)
	or a
	jp nz,Main.Init2

	inc a
	ld (KeyBDone),a

	ld a,(Set_KeybType)
	ld (CurKeyb),a

Main.Init2:
	call InitInsSel

Main.Init:
	ld hl,LastNotes
	ld de,LastNotes+1
	ld bc,4
	ld (hl),0
	ldir

	ei

	ld b,35
Main.Init3:
	halt
	djnz Main.Init3

	xor a
	ld (ChanOutAllowed),a

Main.Init.3:
	ld a,($fbeb)
	bit 7,a
	jp z,Main.Init.3


;	ld a,(InsOffset)
;	ld b,a
;	ld a,(CurIns)
;	add a,b
;	ld (NowIns),a

	jp ChangeInsDone

KeyBDone:
	.db 0

Main:
	ShowHint(108)

	ld a,(InsOffset)
	ld b,a
	ld a,(CurIns)
	add a,b
	ld (NowIns),a

	Locate(1,25)

	di
	StatReg(2)
Main.Init.2:
	in a,($99)
	bit 0,a
	jp nz,Main.Init.2

	StatReg(0)
	ei

	xor a
	ld (ChanOutAllowed),a

	call chget

	ld (SaveKey),a

	ld a,1
	ld (ChanOutAllowed),a

	ScanKey(control)
	jp nz,NoControlPressed

	ScanKey(key_n)
	jp z,ChangeInsName

	ScanKey(key_h)
	jp z,InsHelp1

NoControlPressed:
	Scan2Keys(shift,f1)
	jp z,DoInsEditor

	Scan2Keys(shift,f2)
	jp z,ChangeKeyB

	ld c,0

	ScanKey(f1)
	jp z,StartInsChosen
	inc c

	ScanKey(f2)
	jp z,StartInsChosen
	inc c

	ScanKey(f3)
	jp z,StartInsChosen
	inc c

	ScanKey(f4)
	jp z,StartInsChosen

	ScanKey(f5)
	jp z,DoInsDiskMenu

	ScanKey(Tab)
	jp z,DoStartMenu

;NoControlPressed:
	ScanKey(left_brk)
	jp z,OctaveDown

	ScanKey(right_brk)
	jp z,OctaveUp

	ScanKey(insert)
	jp z,InsertInstrument

	ScanKey(delete)
	jp z,DeleteInstrument

	ScanKey(escape)
	jp z,DeInitInsSel

	ScanKey(space)
	jp z,DeInitInsSel

	ScanKey(return)
	jp z,DeInitInsSel

	ld a,(SaveKey)

	cp $1c
	jp z,IncIns13

	cp $1d
	jp z,DecIns13

	cp $1e
	jp z,DecIns

	cp $1f
	jp z,IncIns

	jp main

SaveKey:
	.db 0

DoInsEditor:
	ld a,1
	ld (ShowChannelWay),a
	ld (ChanOutAllowed),a

	call InstrumentEditor
	call InitInsSel.3
	call LoadCharacterSet

	xor a
	ld (ShowChannelWay),a

	inc a
	ld (ChanOutAllowed),a

	jp main

ShowChannelWay:
	.db 0

DoInsDiskMenu:
	call DeInitInsSel

	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b

	ld (NowInstrument),a

	inc a
	ld b,a

	ld hl,$8000-40

	ld de,40
DoInsDiskMenu.1:
	add hl,de

	djnz DoInsDiskMenu.1

	ld (SaveInsAddress),hl

	ld a,1							; SCC Instrument (disk) menu
	ld (WhichDiskMenu),a

	ld a,1							; DiskMenu
	call DoMenu

	call InitInsSel.2

	jp ChangeInsDone

InsHelp1:
	ld hl,InsSelectLine
	call InsHelp.Cont

	call EnaScr

	jp ChangeInsDone

InsHelp2:
	ld hl,StartMenuLine
	call InsHelp.Cont

	call ClearBlink

	call EnaScr

	jp DoStartMenu

InsHelp.Cont:
	ld a,9
	ld (RepCommand),a

	push hl

	call DeInitInsSel

	pop hl

	ld (RepData),hl

	ld a,4							; DiskMenu
	call DoMenu

	call DisScr

	call InitInsSel.2

	ret

ChangeKeyB:
	ld a,(CurKeyb)
	inc a

	cp 3
	jp c,NoKeyBReset

	xor a
NoKeyBReset:
	ld (CurKeyb),a

	ShowCurKeyb

	call KilBuf

	jp main

CurKeyb:
	.db 0
	

DeleteInstrument:
	ShowHint(172)

	xor a
	ld (ChanOutAllowed),a

	call nokey

	call YesOrNo
	jp nz,main

	ld a,1
	ld (ChanOutAllowed),a

	ld a,(NowIns)
	cp 255
	jp z,DeleteOnlyLast

	ld hl,$8000-40
	ld de,40

	inc a
	ld b,a
DelIns.1:
	add hl,de

	djnz DelIns.1
	
	push hl

	ld de,40
	add hl,de

	push hl

	ld a,(NowIns)
	add a,49

	cpl

	ld hl,0
	ld de,40

	ld b,a
DelIns.2:
	add hl,de
	djnz DelIns.2

	push hl
	pop bc

	pop hl
	pop de

	ldir
DeleteOnlyLast:
	ld hl,DefaultIns
	ld de,40*206+$8000
	ld bc,40
	ldir

	call ShowAllIns
	call ShowAllStart

	jp ChangeInsDone

InsertInstrument:
	ShowHint(173)

	xor a
	ld (ChanOutAllowed),a

	call nokey

	call YesOrNo
	jp nz,main

	ld a,1
	ld (ChanOutAllowed),a

	ld a,InsBnk
	out ($fe),a
	
	ld hl,206*40+$8000

	ld a,(NowIns)
	cp 206
	jp z,InsertOnlyLastIns

	ld a,(NowIns)
	add a,49

	cpl

	ld hl,0
	ld de,40

	ld b,a
InsIns.1:
	add hl,de
	djnz InsIns.1

	push hl
	pop bc

	ld hl,205*40+$8000
	ld de,206*40+$8000

	lddr

	ld de,40
	add hl,de
InsertOnlyLastIns:
	ex de,hl

	ld hl,DefaultIns
	ld bc,40
	ldir

	call ShowAllIns
	call ShowAllStart

	jp ChangeInsDone

DefaultIns:
	.text "Default "
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

ChangeInsName:
	ld a,(NowIns)

	inc a
	ld b,a

	ld hl,$8000-40
	ld de,40
ChangeInsName.1:
	add hl,de

	djnz ChangeInsName.1

	ld (InsPoint),hl

	call ClearBlink

	ld hl,InsName_data
	call input_text

	call ShowAllStart
	call ShowInsBar

	jp main

InsName_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

InsX:
	.db 0
InsY:
	.db 0

	.db 8

InsPoint:
	.dw 0

	.db 32,126
	.db 0



StartInsChosen:
	ld a,SngBnk
	out ($fe),a
	
	ld hl,StartInstruments
	ld e,c
	ld d,0
	add hl,de

	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b

	ld (hl),a

	call ShowAllStart

	ld a,InsBnk
	out ($fe),a

	jp main

OctaveDown:
	ld a,(CurOct)
	or a
	jp z,main

	dec a
	ld (CurOct),a

	jp OctaveDone

OctaveUp:
	ld a,(CurOct)
	cp 8
	jp z,main

	inc a
	ld (CurOct),a

	jp OctaveDone

OctaveDone:
	ld a,(ShowChannelWay)
	or a
	jp nz,gfx.ShowCurOct

	ShowCurOct

	jp main

gfx.ShowCurOct:
	call ShowCurOct_gfx

	jp IE.Main

OctaveUp.2:
	ld a,(CurOct)
	cp 8
	jp z,DoStartMain

	inc a
	ld (CurOct),a

	ShowCurOct

	jp DoStartMain

OctaveDown.2:
	ld a,(CurOct)
	or a
	jp z,DoStartMain

	dec a
	ld (CurOct),a

	ShowCurOct

	jp DoStartMain

IncIns13:
	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b

	cp 206-12
	jp nc,SetlastIns

	ld a,(CurIns)
	cp 52
	jp nc,IncIns13.1

	add a,13
	ld (CurIns),a

	call ShowInsBar

	jp ChangeInsDone

SetLastIns:
	ld a,(InsOffset)
	ld b,a
	ld a,206
	sub b
	ld (CurIns),a

	cp 65
	jp c,SetLastInsDone

	ld a,142
	ld (InsOffset),a

	ld a,64
	ld (CurIns),a

	call ShowAllIns

SetLastInsDone:
	call ShowInsBar

	jp main

IncIns13.1:
	ld a,(InsOffSet)
	add a,13
	ld (InsOffset),a

	cp 207
	jp c,Ins13.done

ClipCurIns:
	ld a,(InsOffset)	
	ld b,a
	ld a,206

	sub b

	ld (CurIns),a

	call ShowInsBar
Ins13.done
	call ShowAllIns


	jp ChangeInsDone
	


DecIns13:
	ld a,(CurIns)
	cp 13
	jp c,DecIns13.1

	sub 13
	ld (CurIns),a

	call ShowInsBar

	jp ChangeInsDone

DecIns13.1:
	ld a,(InsOffset)
	sub 13
	ld (InsOffset),a
	jp nc,DecIns13.done

	xor a
	ld (InsOffset),a
	ld (CurIns),a

	call ShowInsBar
DecIns13.done:
	call ShowAllIns	

	jp ChangeInsDone

DecIns:
	ld a,(CurIns)
	or a
	jp z,DecScreenIns

	dec a
	ld (CurIns),a

	call ShowInsBar

	jp ChangeInsDone

DecScreenIns:
	ld a,(InsOffset)
	or a
	jp z,main

	dec a
	ld (InsOffset),a

	call ShowAllIns

	jp ChangeInsDone

IncIns:
	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b
	cp 206
	jp z,main

	ld a,(CurIns)
	cp 64
	jp z,IncScreenIns

	inc a
	ld (CurIns),a

	call ShowInsBar

	jp ChangeInsDone
	

IncScreenIns:
	ld a,(InsOffset)
	cp 142
	jp z,main

	inc a
	ld (InsOffset),a

	call ShowAllIns

	jp ChangeInsDone

ChangeInsDone:
	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b

	inc a
	ld b,a

	ld hl,$8000-32
	ld de,40
ChangeInsDone.1:
	add hl,de

	djnz ChangeInsDone.1

	ld de,InsDataStorage
	ld bc,32
	ldir

	call SetSCC

	ld b,4
	ld de,$9800
ChangeInsDone.2
	push bc
	ld hl,InsDataStorage
	ld bc,32
	ldir
	pop bc

	djnz ChangeInsDone.2

	call ResetSCC

	jp main

InsDataStorage:
	.ds 32

ShowAllIns:
	ld a,(InsOffset)
	inc a
	ld b,a

	ld hl,$8000-40
	ld de,40
ShowAllIns.1:
	add hl,de

	djnz ShowAllIns.1

	ld (InsNowAdr),hl

	ld hl,80*1+3
	ld (ScrStartAdr),hl
	ld (ScrNowAdr),hl

	ld a,(InsOffset)
	ld (OutNowIns),a


	ld b,5
ShowAllIns.3:
	push bc

	ld b,13

	ld hl,(ScrNowAdr)
ShowAllIns.2:
	push bc

	xor a
	call SetVRAMWrite

	ld hl,OutToScreenEmpty

	ld a,(OutNowIns)
	cp 207
	jp nc,OutEmptyIns
	inc a
	ld b,a
	ld a,(InsOffset)
	cp b
	jp nc,OutEmptyIns

	ld hl,OutToScreen

	ld a,(OutNowIns)
	call Calc8Dec2

	ld hl,(InsNowAdr)
	ld de,OutToScreen+5
	ld bc,8
	ldir

	ld hl,OutToScreen

OutEmptyIns:
	ld bc,$0d98
	otir

	ld hl,(InsNowAdr)
	ld de,40
	add hl,de
	ld (InsNowAdr),hl

	ld hl,(ScrNowAdr)
	ld de,80
	add hl,de
	ld (ScrNowAdr),hl

	ld a,(OutNowIns)
	inc a
	ld (OutNowIns),a

	pop bc

	djnz ShowAllIns.2
	
	ld hl,(ScrStartAdr)
	ld de,15
	add hl,de
	ld (ScrStartAdr),hl
	ld (ScrNowAdr),hl

	pop bc

	djnz ShowAllIns.3

	ei
	halt
	halt

	ret

InsOffset:
	.db 0
InsNowAdr:
	.dw 0
ScrStartAdr:
	.dw 0
ScrNowAdr:
	.dw 0
OutNowIns:
	.db 0

ShowInsBar:
	ld a,(CurIns)
	ld c,-1

ShowInsBar.1:
	sub 13
	inc c
	jp nc,ShowInsBar.1

	add a,15

	ld (InsY),a

	ld e,a

	ld b,0

	ld hl,CurInsXOffset
	add hl,bc
	ld a,(hl)

	ld d,a

	add a,5
	ld (InsX),a

	ld a,14

	push af
	push de
	call ClearBlink
	pop de
	pop af

	call DrawBar

	ret

CurInsXOffset:
	.db 4+00,4+15,4+30,4+45,4+60

CurIns:
	.db 0

NowIns:
	.db 0

DoStartMenu:
	call OutStartIns
	call ShowStartBar

DoStartMain:
	xor a
	ld (ChanOutAllowed),a

	call chget
	ld (SaveKey),a

	ld a,1
	ld (ChanOutAllowed),a

	Scan2Keys(control,key_h)
	jp z,InsHelp2

	ScanKey(left_brk)
	jp z,OctaveDown.2

	ScanKey(right_brk)
	jp z,OctaveUp.2

	ScanKey(tab)
	jp z,EndStartEdit	

	ScanKey(escape)
	jp z,DeInitInsSel

	ld a,(SaveKey)
	
	cp $1c
	jp z,CurXUp

	cp $1d
	jp z,CurXDown

	cp $1e
	jp z,CurYDown

	cp $1f
	jp z,CurYUp

	jp DoStartMain

CurXUp:
	ScanKey(control)
	jp z,CheckUpValues

	ScanKey(Shift)
	jp z,CheckUpValues

	ld a,(StartCurX)
	cp 3
	jp z,DoStartMain

	inc a
	ld (StartCurX),a

	call ShowStartBar

	jp DoStartMain

CurXDown:
	ScanKey(control)
	jp z,CheckDownValues

	ScanKey(Shift)
	jp z,CheckDownValues

	ld a,(StartCurX)
	or a
	jp z,DoStartMain

	dec a
	ld (StartCurX),a

	call ShowStartBar

	jp DoStartMain

CurYUp:
	ScanKey(control)
	jp z,CheckDownValues

	ScanKey(Shift)
	jp z,CheckDownValues

	ld a,(StartCurY)
	cp 4
	jp z,DoStartMain

	inc a
	ld (StartCurY),a

	jp CurYChangeDone

CurYDown:
	ScanKey(control)
	jp z,CheckUpValues

	ScanKey(Shift)
	jp z,CheckUpValues

	ld a,(StartCurY)
	or a
	jp z,DoStartMain

	dec a
	ld (StartCurY),a

	jp CurYChangeDone

CurYChangeDone:
	call OutStartIns
	call ShowStartBar

	jp DoStartMain

CheckUpValues:
	ld a,SngBnk
	out ($fe),a

	ld a,(StartCurX)
	or a
	jp z,StartInsUp

	dec a
	jp z,StartVolumeUp

	dec a
	jp z,AutoSlideUp

DetuneUp:
	ld hl,DetuneSettings

	ld a,(StartCurY)
	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 255
	jp z,UpDownValuesDone

	inc a
	ld (hl),a

UpDownValuesDone:
	ld a,InsBnk
	out ($fe),a

	call ShowAllStart

	jp DoStartMain


StartInsUp:
	ld hl,StartInstruments

	ld a,(StartCurY)
	cp 4
	jp z,UpDownValuesDone

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 206
	jp z,UpDownValuesDone

	inc a
	ld (hl),a

	call OutStartIns

	jp UpDownValuesDone

StartVolumeUp:
	ld hl,StartVolumes

	ld a,(StartCurY)

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 15
	jp z,UpDownValuesDone

	inc a
	ld (hl),a

	jp UpDownValuesDone

AutoSlideUp:
	ld hl,VolumeSlideSettings

	ld a,(StartCurY)

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 31
	jp z,UpDownValuesDone

	inc a
	ld (hl),a

	jp UpDownValuesDone

CheckDownValues:
	ld a,SngBnk
	out ($fe),a

	ld a,(StartCurX)
	or a
	jp z,StartInsDown

	dec a
	jp z,StartVolumeDown

	dec a
	jp z,AutoSlideDown

DetuneDown:
	ld hl,DetuneSettings

	ld a,(StartCurY)
	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 1
	jp z,UpDownValuesDone

	dec a
	ld (hl),a

	jp UpDownValuesDone

StartInsDown:
	ld hl,StartInstruments

	ld a,(StartCurY)
	cp 4
	jp z,UpDownValuesDone

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	or a
	jp z,UpDownValuesDone

	dec a
	ld (hl),a

	call OutStartIns

	jp UpDownValuesDone

StartVolumeDown:
	ld hl,StartVolumes

	ld a,(StartCurY)

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	or a
	jp z,UpDownValuesDone

	dec a
	ld (hl),a

	jp UpDownValuesDone

AutoSlideDown:
	ld hl,VolumeSlideSettings

	ld a,(StartCurY)

	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	cp 1
	jp z,UpDownValuesDone

	dec a
	ld (hl),a

	jp UpDownValuesDone

EndStartEdit:
	call ShowAllIns
	call ShowInsBar

	jp main.init

OutStartIns:
	ld hl,InsDataStorage
	ld de,InsDataStorage+1
	ld bc,31
	ld (hl),0
	ldir

	ld a,SngBnk
	out ($fe),a

	ld a,(StartCurY)
	cp 4
	jp z,OutInsToChn5

	ld e,a
	ld d,0
	ld hl,StartInstruments

	add hl,de

	ld a,(hl)

	ld b,a

	ld a,InsBnk
	out ($fe),a

	inc b

	ld hl,$8000-32
	ld de,40
OutStartIns.1:
	add hl,de

	djnz OutStartIns.1

	ld de,InsDataStorage
	ld bc,32
	ldir

OutInsToChn5:
	ld a,InsBnk
	out ($fe),a

	call SetSCC

	ld b,4
	ld de,$9800
OutStartIns.2
	push bc
	ld hl,InsDataStorage
	ld bc,32
	ldir
	pop bc

	djnz OutStartIns.2

	call ResetSCC

	ret

ShowStartBar:
	call ClearBlink

	ld a,(StartCurX)
	add a,104
	call DoShowHint

	ld a,(StartCurX)
	sla a
	ld e,a
	ld d,0
	ld hl,StartXOffsets
	add hl,de

	ld d,(hl)

	inc hl

	ld a,(StartCurY)
	add a,17
	ld e,a

	ld a,(hl)

	call DrawBar

	ld a,(StartCurY)

	add a,17
	ld e,a

	ld d,14

	ld a,54

	call DrawBar

	ret

StartXOffsets:
; x offsets done as follows:
;
; byte 1: X offset
; byte 2: length

	.db 27,10,41,4,51,5,61,6

StartCurX:
	.db 0
StartCurY:
	.db 0

ShowAllStart:
	ld hl,80*16+27
	ld (SaveVramAdr),hl


	ld hl,StartInstruments
	ld b,4
ShowAllStart.1:
	push hl

	ld hl,(SaveVramAdr)

	xor a
	call SetVramWrite

	pop hl

	push hl
	push bc

	ld a,SngBnk
	out ($fe),a

	ld a,(hl)
	inc a
	ld b,a

	ld a,InsBnk
	out ($fe),a

	ld hl,$8000-40
	ld de,40
ShowAllStart.2
	add hl,de

	djnz ShowAllStart.2

	ld bc,$0898
	otir

	pop bc

	ld hl,(SaveVramAdr)
	ld de,80
	add hl,de
	ld (SaveVramAdr),hl

	pop hl

	inc hl

	djnz ShowAllStart.1

	ld a,SngBnk
	out ($fe),a

	ld hl,80*16+41
	ld (SaveVramAdr),hl

	ld hl,StartVolumes
	ld b,5
ShowAllStart.3:
	push hl

	ld hl,(SaveVramAdr)

	xor a
	call SetVramWrite

	pop hl

	push hl
	push bc

	ld a,(hl)
	sla a

	ld hl,VolumeTextData
	ld e,a
	ld d,0
	add hl,de

	ld bc,$0298
	otir

	pop bc

	ld hl,(SaveVramAdr)
	ld de,80
	add hl,de
	ld (SaveVramAdr),hl
	
	pop hl

	inc hl

	djnz ShowAllStart.3


	ld hl,80*16+61
	ld (SaveVramAdr),hl

	ld hl,DetuneSettings
	ld b,5
ShowAllStart.4:
	push hl

	ld hl,(SaveVramAdr)

	xor a
	call SetVramWrite

	pop hl

	push hl
	push bc

	ld c,43

	ld a,(hl)
	bit 7,a
	jp nz,DetuneIsPlus

	cpl

	inc a

	ld c,45
DetuneIsPlus:
	and %01111111

	push bc
	call Calc8Dec
	pop bc

	ld a,c
	out ($98),a

	ld hl,Decimal
	ld bc,$0398
	otir

	pop bc

	ld hl,(SaveVramAdr)
	ld de,80
	add hl,de
	ld (SaveVramAdr),hl
	
	pop hl

	inc hl

	djnz ShowAllStart.4


	ld hl,80*16+51
	ld (SaveVramAdr),hl

	ld hl,VolumeSlideSettings
	ld b,5
ShowAllStart.5:
	push hl

	ld hl,(SaveVramAdr)

	xor a
	call SetVramWrite

	pop hl

	push hl
	push bc

	ld a,(hl)
	sla a
	sla a

	ld hl,AutoSlideTextData
	ld e,a
	ld d,0
	add hl,de

	ld bc,$0498
	otir

	pop bc

	ld hl,(SaveVramAdr)
	ld de,80
	add hl,de
	ld (SaveVramAdr),hl
	
	pop hl

	inc hl

	djnz ShowAllStart.5

	ld a,InsBnk
	out ($fe),a

	ei
	halt
	halt

	ret

SaveVramAdr:
	.dw 0

OutToScreen:
;            123456789abcd
	.text "123: 12345678"

OutToScreenEmpty:
	.text "             "


CurOct:
	.db 4

CurrentOctaves:
	.db "  1-2-3-4-5-6-7-8  "
	;    0 1 2 3 4 5 6 7 8 


InitInsSel:
	ld a,1
	ld (ChanOutAllowed),a

;	ld a,b
;	ld (InsOffset),a

	ld a,c
	ld (scc),a

	call SetSCC
	ld a,15
	ld ($988a),a
	ld ($988b),a
	ld ($988c),a
	ld ($988d),a
	ld ($988e),a
	call ResetSCC

;	xor a
;	ld (CurIns),a

	ld a,InsBnk
	out ($fe),a

	ShowPic(4)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a
	
	call ShowAllIns
	call ShowInsBar

	call ShowAllStart

	ShowCurOct
	ShowCurKeyb

	ret

InitInsSel.2:
	ld a,1
	ld (ChanOutAllowed),a

	call SetSCC
	ld a,15
	ld ($988a),a
	ld ($988b),a
	ld ($988c),a
	ld ($988d),a
	ld ($988e),a
	call ResetSCC

	ld a,InsBnk
	out ($fe),a

	ShowPic(4)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a
	
	call ShowAllIns
	call ShowInsBar

	call ShowAllStart

	ShowCurOct

	ret

InitInsSel.3:
	ld a,1
	ld (ChanOutAllowed),a

	call SetSCC
	ld a,15
	ld ($988a),a
	ld ($988b),a
	ld ($988c),a
	ld ($988d),a
	ld ($988e),a
	call ResetSCC

	ld a,InsBnk
	out ($fe),a

	ShowPic(4)

	call ShowAllIns
	call ShowInsBar

	call ShowAllStart

	ShowCurOct

	ret

DeInitInsSel:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call ClearBlink

	ld a,(CurOct)
	ld (RepData),a

	ld a,(CurIns)
	ld b,a
	ld a,(InsOffset)
	add a,b

	ld b,a

	ret

NewInt:
	ld a,(ChanOutAllowed)
	or a
	jp nz,OldInt

	ld a,1
	ld (CurChannel),a

	xor a
	ld (OutToChans),a
	ld (ChansUsed),a

	ld hl,$9880
	ld (CurFreqAdr),hl

	call SetSCC

	ld a,(CurKeyb)

	cp 1
	jp z,ChkToshiba

	cp 2
	jp z,ChkPhilips

	ld c,1

	ScanKey(key_q)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_2)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_w)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_3)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_e)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_r)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_5)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_t)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_6)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_y)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_7)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_u)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_z)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_s)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_x)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_d)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_c)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_v)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_g)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_b)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_h)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_n)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_j)
	call z,Note1KeyChosen

	inc c

	ScanKey(key_m)
	call z,Note1KeyChosen

	jp AllChansDone
	
Note1KeyChosen:
	ld a,(ChansUsed)
	cp 5
	ret z

 	ld a,(CurOct)

	sla a							; a=a*2
	sla a							; a=a*4

	ld e,a						; e=a

	add a,e						; a=a*8
	add a,e						; a=a*12

	sub 12
	add a,c

	cp 97
	ret nc

	ld b,a

	ld a,(ChansUsed)
	ld e,a
	ld d,0
	ld hl,LastNotes
	add hl,de

	ld a,b

	cp (hl)
	jp z,NoFreqOut

	ld (hl),a

	dec a

	sla a

	ld hl,FreqData
	ld e,a
	ld d,0
	add hl,de

	ld ix,(CurFreqAdr)

	ld a,(hl)
	ld (ix+0),a

	inc hl

	ld a,(hl)
	ld (ix+1),a

NoFreqOut:
	ld hl,(CurFreqAdr)
	inc hl
	inc hl
	ld (CurFreqAdr),hl

	ld a,(CurChannel)
	ld b,a
	sla a
	ld (CurChannel),a

	ld a,(OutToChans)
	or b
	ld (OutToChans),a

	ld a,(ChansUsed)
	inc a
	ld (ChansUsed),a

	ret

AllChansDone:
	ld a,(OutToChans)
	ld ($988f),a

	call ResetSCC

	ld a,(ShowChannelWay)
	or a
	jp nz,gfx.ShowChannels

	di
	StatReg(2)
AllChansDone.2:
	in a,($99)
	bit 0,a
	jp nz,AllChansDone.2

	StatReg(0)

	SetVW(0,80*23+69)

	ld a,(ChansUsed)
	add a,48
	out ($98),a

	ei
OldInt:
	.ds 5

gfx.ShowChannels:
	ld a,(ChansUsed)
	add a,16
	sla a
	sla a
	ld (ActChn.Sx),a

	ld hl,ActChnData
	call DoCopy2

	jp oldint

ActChnData:
ActChn.SX:
	.db 0					; source x
	.db 0					; source x - extra bit for screen 7

	.db 212				; source y
	.db 3					; source page

	.db 35				; destination x
	.db 0					; destination x - extra bit for screen 7

	.db 129				; destination y
	.db 3					; destination page

	.db 4					; length x
	.db 0					; length x - extra bit for screen 7 (and scr, 5 - 256 pxls.)

	.db 5					; length y
	.db 0					; length y - extra bit for screen 5 - 256 pxls.

	.db 0					; color
	.db 0					; other settings (see vdp)

	.db $d0				; high: command, low: logic operation


KeyboardInDone:
	xor a
	ld (ChansUsed),a

	ld hl,NowNotes
	ld de,NowNotes+1
	ld bc,4
	ld (hl),0
	ldir

	ld ix,NowNotes
	ld iy,KeyB_NewBuf
	ld hl,AndData
	ld c,8
	ld e,0

	ld b,6
CheckNoteLoop:
	ld a,(hl)
	ld d,a
	ld a,(iy+0)

	and d

	jp z,KeyNotPressed

	push bc

	ld a,(CurOct)
	sla a
	sla a

	ld b,a

	add a,b
	add a,b

	pop bc

	sub 12
	add a,e

	cp 97
	jp nc,KeyNotPressed

	ld (ix+0),a

	inc ix

	ld a,(ChansUsed)
	cp 5
	jp z,DoOutNotes

	inc a
	ld (ChansUsed),a

	ld a,(CurChannel)
	ld d,a
	sla a
	ld (CurChannel),a

	ld a,(OutToChans)
	or d
	ld (OutToChans),a

KeyNotPressed:
	inc e
	dec c

	jp nz,ContReadKeyB

	ld c,8
	inc iy
	ld hl,AndData

	djnz CheckNoteLoop

	;---
	;OUT ROUTINE
	;---

DoOutNotes:
	ld a,(ChansUsed)
	or a
	jp z,AllChansDone

	ld hl,NowNotes
	ld iy,LastNotes
	ld ix,$9880

	ld b,a
OutChannelsLoop:
	ld a,(iy)
	cp (hl)
	jp z,NextChannel
	
	ld a,(hl)
	ld (iy),a

	push hl

	ld hl,FreqData

	sla a
	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	ld (ix+0),a
	inc hl
	ld a,(hl)
	ld (ix+1),a

	pop hl

NextChannel:
	inc ix
	inc ix

	inc iy

	inc hl

	djnz OutChannelsLoop

	jp AllChansDone

ContReadKeyB:
	inc hl

	jp CheckNoteLoop

AndData:
	.db %00000001
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00100000
	.db %01000000
	.db %10000000

AudioOut:
; routine : Out to Audio cartridge
; in      : a - Value, c - Register
; out     : none.
; cmnt    : none.

	ex af,af'

	ld a,c
	out ($C0),a

	ex af,af'
	out ($C1),a

	ret

AudioIn:
; routine : In from Audio cartridge
; in      : c - Register
; out     : none.
; cmnt    : none.

	ld a,c
	out ($C0),a
	in a,($C1)

	ret

;
;---------------------------------------------------------------------
;--- Check Philips Music Module toetsenbord voor ingedrukte toetsen --
;---------------------------------------------------------------------
;
ChkPhilips:
	ld b,8
	ld h,1
	ld de,KeyB_newbuf
ChkPhil_Loop:
	ld a,h
	ld c,6
	call AudioOut
	ld c,5
	call AudioIn
	cpl
	ld (de),a
	inc de
	sla h
	djnz ChkPhil_Loop

	jp KeyBoardInDone

;
;---------------------------------------------------------------------
;--- Check Toshiba Music Module toetsenbord voor ingedrukte toetsen --
;---------------------------------------------------------------------
;

ChkToshiba:
	ld b,8
	ld h,1
	ld de,KeyB_toshbuf
ChkTosh_Loop:
	ld a,h
	ld c,6
	call AudioOut
	ld c,5
	call AudioIn
	cpl
	ld (de),a
	inc de
	sla h
	djnz ChkTosh_Loop

;Convert Toshiba keyboard-layout to Philips layout...

	ld ix,KeyB_toshbuf
	ld iy,KeyB_newbuf
	ld b,7
	ld c,6
	ld l,0
	ld d,0
	ld e,(ix+0)
	rl e
	rr d
	rr e
CnvTosh_loop:
	rr e
	dec c
	rr d

	djnz CnvTosh_cnt1
	ld (iy+0),d
	inc iy
	ld d,0
	ld b,8
	inc l
	ld a,l
	cp 6
	jp z,CnvTosh_end
CnvTosh_cnt1:
	ld a,c
	cp 3
	jp nz,CnvTosh_cnt2
	rr e
	jp CnvTosh_loop
CnvTosh_cnt2:
	and a
	jp nz,CnvTosh_loop
	inc ix
	ld e,(ix+0)
	ld c,6
	jp CnvTosh_loop

CnvTosh_end:
	ld a,e
	and 1
	ld (KeyB_newbuf+6),a
	xor a
	ld (KeyB_newbuf+7),a

	jp KeyBoardInDone

KeyB_ToshBuf:
	.ds 8
KeyB_NewBuf:
	.ds 8

NowNotes:
	.db 0,0,0,0,0
LastNotes:
	.db 0,0,0,0,0

Keyboards:
	.text "MSX     "
	.text "Toshiba "
	.text "Philips "

CurChannel:
	.db 0
OutToChans:
	.db 0
CurFreqAdr:
	.dw 0

ChanOutAllowed:
	.db 0

VolumeTextData:
	.text "00010203040506070809101112131415"

AutoSlideTextData:
	.text "-16 -15 -14 -13 -12 -11 -10 -09 -08 -07 -06 -05 -04 -03 -02 -01 "
	.text "OFF "
	.text "+01 +02 +03 +04 +05 +06 +07 +08 +09 +10 +11 +12 +13 +14 +15 "

SetSCC:
; routine : Set SCC port on page 2
; in      : none
; out     : (OldPrimair) - original page settings
; cmnt    : none

	in a,($a8)							; Get primair selections
	ld (OldPrimair),a						; save 'em

	and %11001111						; Trash page 2

	ld b,a							; save that

	ld a,(scc)							; Get SCC slot selection in it
	or b								;

	out ($a8),a							; Set SCC.

	ld a,$3f							; Initialise SCC
	ld ($9000),a						;

	xor a								; Has to be 0, else it fucks up all sounds
	ld ($98e0),a						;

	ret

ResetSCC:
	ld a,(OldPrimair)
	out ($a8),a

	ret

OldPrimair:
	.db 0

ChansUsed:
	.db 0

scc:
	.db 0


; Data for frequency of notes:
; stored as follows: c 1  c#1  d 1  e 1  f 1  f#1  g 1  g#1  a 1  a#1  b 1
;                    c 2  c#2  d 2  e 2  f 2  f#2  g 2  g#2  a 2  a#2  b 2
; aso (and so on) (till c 8/b 8)

FreqData:
        .dw 3421,3228,3047,2876,2715,2562,2419,2283,2155,2034,1920,1812
        .dw 1711,1614,1524,1438,1358,1281,1210,1142,1078,1017,0960,0906
        .dw 0855,0807,0762,0719,0679,0641,0605,0569,0539,0509,0480,0453
        .dw 0428,0404,0381,0360,0339,0320,0302,0285,0269,0254,0240,0227
        .dw 0214,0202,0190,0180,0170,0160,0151,0143,0135,0127,0120,0113
        .dw 0107,0101,0095,0090,0085,0080,0076,0071,0067,0064,0060,0057
        .dw 0053,0050,0048,0045,0042,0040,0038,0036,0034,0032,0030,0028
        .dw 0027,0025,0024,0022,0021,0020,0019,0018,0017,0016,0015,0014

#include "sb2-inse.asm"					; Instrument editor!
#include "sb2rmain.asm"


.end

; einde
