; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Instrument Editor
; Code: d-fader^TwZ.
; Date: 27 (almost 28) August 1999
;
; cmnt: Last file of the blaffer itself!!
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

WaveHor:		.equ 98

InstrumentEditor:
	call kilbuf

	call InitialiseInsEdit

IE.Main:
	call kilbuf

	xor a
	ld (ChanOutAllowed),a

	call chget
	ld (CursorSave),a

	ld a,1
	ld (ChanOutAllowed),a

	Scan2Keys(control,delete)
	jp z,DeleteInstrument_e

	Scan2Keys(control,up)
	jp z,Ins_e.up4

	Scan2Keys(control,right)
	jp z,Ins_e.up1

	Scan2Keys(control,down)
	jp z,Ins_e.down4

	Scan2Keys(control,left)
	jp z,Ins_e.down1

	ScanKey(left_brk)
	jp z,OctaveDown

	ScanKey(right_brk)
	jp z,OctaveUp

	ScanKey(home)
	jp z,RestoreInstrument

	ScanKey(escape)
	jp z,EndInstrumentEdit

	ld a,(CursorSave)

	cp $1c
	jp z,EditPosUp1

	cp $1d
	jp z,EditPosDown1

	cp $1e
	jp z,EditWaveUp1

	cp $1f
	jp z,EditWaveDown1

	jp IE.Main

CursorSave:
	.db 0

DeleteInstrument_e:
	ld hl,DefaultName
	ld de,InsName
	ld bc,8
	ldir

	ld hl,InsData
	ld de,InsData+1
	ld bc,31
	ld (hl),0
	ldir

	ld a,(Ins_e)
	call NewInstrument

	jp IE.Main

Ins_e.up4:
	ld a,(Ins_e)
	cp 206
	jp z,IE.Main

	add a,4

	cp 207
	jp c,Ins_e.up4.ok

	ld a,206
Ins_e.up4.ok
	call NewInstrument.1

	jp IE.Main

Ins_e.down4:
	ld a,(Ins_e)
	or a
	jp z,IE.Main

	sub 4
	jp nc,Ins_e.down4.ok

	xor a
Ins_e.down4.ok
	call NewInstrument.1

	jp IE.Main

Ins_e.up1:
	ld a,(Ins_e)
	cp 206
	jp z,IE.Main

	inc a

	call NewInstrument.1

	jp IE.Main

Ins_e.down1:
	ld a,(Ins_e)
	or a
	jp z,IE.Main

	dec a

	call NewInstrument.1

	jp IE.Main

NewInstrument.1:
	push af

	inc a
	ld b,a

	ld hl,$8000-40
	ld de,40
NewIns.loop1:
	add hl,de

	djnz NewIns.loop1	

	ld de,InsName
	ld bc,40
	ldir

	call SetSCC

	ld b,4
	ld de,$9800
ChangeInsDone.2.1
	push bc
	ld hl,InsData
	ld bc,32
	ldir
	pop bc

	djnz ChangeInsDone.2.1

	call ResetSCC

	pop af
NewInstrument:
	ld (ins_e),a

	copy(box.data)	

	call ShowInsName
	call ShowWholeWave
	call ShowSprite

	ret

RestoreInstrument:
	call gfx.ShowAllData
	call ShowSprite

	jp IE.Main

EditPosUp1:
	ld a,(SpritePos)
	cp 31
	jp z,IE.Main

	inc a
	ld (SpritePos),a

	call ShowSprite

	jp IE.Main

EditPosDown1:
	ld a,(SpritePos)
	or a
	jp z,IE.Main

	dec a
	ld (SpritePos),a

	call ShowSprite

	jp IE.Main

EditWaveUp1:
	ld a,(SpritePos)
	ld e,a
	ld d,0
	ld hl,InsData
	add hl,de

	ld a,($fbeb)
	bit 0,a
	jp z,EditWaveShiftUp

	ld a,(hl)
	cp $7f
	jp z,EditWaveUp.2

	inc a

EditWaveUp.1:
	ld (hl),a

	ld a,(SpritePos)
	call ChangeWave

	ld a,(SpritePos)
	call ShowSprite

	ld a,(SpritePos)
	call Show1InsData

	call OutValToSCC

EditWaveUp.2:
	ei
	halt

	ScanKey(up)
	jp z,EditWaveUp1

	call ShowWholeWave

	jp IE.Main

EditWaveShiftUp:
	ld a,(hl)

	ld b,10
EWSU.1:
	cp $7f
	jp z,EWSU.1.Done

	inc a

	djnz EWSU.1

EWSU.1.Done:
	jp EditWaveUp.1

EditWaveShiftDown:
	ld a,(hl)

	ld b,10
EWSD.1:
	cp $80
	jp z,EWSD.1.Done

	dec a

	djnz EWSD.1

EWSD.1.Done:
	jp EditWaveDown.1

EditWaveDown1:
	ld a,(SpritePos)
	ld e,a
	ld d,0
	ld hl,InsData
	add hl,de

	ld a,($fbeb)
	bit 0,a
	jp z,EditWaveShiftDown

	ld a,(hl)
	cp $80
	jp z,EditWaveDown.2

	dec a

EditWaveDown.1:
	ld (hl),a

	ld a,(SpritePos)
	call ChangeWave

	ld a,(SpritePos)
	call ShowSprite

	ld a,(SpritePos)
	call Show1InsData

	call OutValToSCC

EditWaveDown.2:
	ei
	halt

	ScanKey(down)
	jp z,EditWaveDown1

	call ShowWholeWave

	jp IE.Main

OutValToSCC:
	ld a,1
	ld (ChanOutAllowed),a

	call SetSCC

	ld a,(SpritePos)	
	ld e,a
	ld d,0

	ld hl,InsData
	add hl,de
	ld a,(hl)

	ld c,a

	ld hl,$9800
	add hl,de

	ld b,4
	ld de,32
OutValToSCC.1:
	ld (hl),c

	add hl,de

	djnz OutValToSCC.1

	call ResetSCC

	xor a
	ld (ChanOutAllowed),a

	ret


OutNewIns:
	ld a,(Ins_e)
	inc a
	ld b,a

	ld hl,$8000-40
	ld de,40
OutNewIns.Loop:
	add hl,de

	djnz OutNewIns.Loop	

	ex de,hl

	ld hl,InsName
	ld bc,40
	ldir

	ret

EndInstrumentEdit:
	ld a,1
	ld (ChanOutAllowed),a

	call OutNewIns

	xor a
	call chgmod

	call disscr

	call LoadCharacterSet

	ld hl,set_fg1.1
	ld de,FGColor1
	ld bc,8
	ldir

	ld a,(FGColor1)						; change foreground color 1 itensity
	ld b,a							;
	ld a,(FGColor1+1)						;
	ld c,a							;
	ld a,12							; number 12
	call ColorChg						;

	ld a,(BGColor1)						; change background color 1 itensity
	ld b,a							;
	ld a,(BGColor1+1)						;
	ld c,a							;
	ld a,13							; number 13
	call ColorChg						;


	ld a,(FGColor2)						; change foreground color 2 itensity
	ld b,a							;
	ld a,(FGColor2+1)						;
	ld c,a							;
	ld a,14							; number 14
	call ColorChg						;

	ld a,(BGColor2)						; change background color 1 itensity
	ld b,a							;
	ld a,(BGColor2+1)						;
	ld c,a							;
	ld a,15							; number 15
	call ColorChg						;

	Color(12,13,0)						; same as in Basic

	ld a,$ef							; Set blink to color 14,15
	vdp(12)							;

	ld a,$10							; 1/5 seconds on, 0 seconds off
	vdp(13)							;

	call clearblink

	ei
	halt
	halt
	halt
	halt

	call enascr

	ei
	halt

	ret

InitialiseInsEdit:
	ld a,1
	ld (ChanOutAllowed),a

	ld a,(NowIns)
	ld (Ins_e),a

	ld a,InsBnk
	out ($fe),a

	ld a,5
	call chgmod

	call disscr

	ld a,%01111111				; page 3
	vdp(2)					;

	call ClrSpr

	ld hl,SpritePat
	ld de,$7800
	ld bc,8
	call LdirVM					; yeah, yeah, i'm a lazy S.O.B.!

	ld hl,SpriteNam
	ld de,$7600
	ld bc,4
	call LdirVM

	ld hl,SpriteCol
	ld de,$7400
	ld bc,16
	call LdirVM


	call ShowCurOct_gfx

	SetPalette(InsPalette)			; set right palette

	call gfx.ShowAllData
	call ShowSprite

	call enascr

	ret

Ins_e:
	.db 0

SpritePat:
	.db %01000000
	.db %11100000
	.db %01000000
	.db 0,0,0,0,0

SpriteNam:
	.db 0,0,0,0

SpriteCol:
	.db 14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14

SpritePos:
	.db 0


ShowSprite:
	ld a,(SpritePos)
	inc a

	ld b,a

	ld a,97-5
ShowSprite.1:
	add a,5

	djnz ShowSprite.1

	ld (SpriteNam+1),a

	ld a,(SpritePos)
	ld e,a
	ld d,0
	ld hl,InsLineData
	add hl,de
	ld a,(hl)
	dec a
	dec a
	ld (SpriteNam),a

	ld hl,SpriteNam
	ld de,$7600
	ld bc,4
	call LdirVM

	ret	

gfx.ShowAllData:
	copy(box.data)				; Clear instrument data.

	ld a,(Ins_e)
	inc a
	ld b,a

	ld hl,$8000-40
	ld de,40
gfx.sad.1:
	add hl,de

	djnz gfx.sad.1	

	ld de,InsName
	ld bc,40
	ldir

	call ShowInsName
	call ShowWholeWave

	ret

ChangeWave:
; routine : Change wave (with cursor keys)
; in      : a - offset of wave
; out     : none.
; cmnt    : none.

	ld e,a
	ld d,0
	ld hl,InsLineData
	add hl,de

	dec hl
	dec hl

	ld (InsDataOfs.r),hl

	ld hl,InsLineData.b
	add hl,de

	dec hl
	dec hl

	ld (InsDataOfs.b),hl

	sub 2
	ld (WaveOfs),a

	ld hl,InsLineData
	ld de,InsLineData.b
	ld bc,32
	ldir

	call CalculateYPoints

	ld a,(WaveOfs)
	inc a
	ld b,a
	ld a,WaveHor-5
CalcWaveOfs:
	add a,5

	djnz CalcWaveOfs

	ld (ChangeWave.data),a

	add a,4

	ld (ChangeWave.data+2),a

	ld hl,(InsDataOfs.b)
	ex de,hl
	ld hl,(InsDataOfs.r)
	ld ix,LineColors


	ld b,4
ChangeWave.loop1:
	push bc

	ld a,(WaveOfs)
	cp 31
	jp nc,NoLineDraw1

	ld a,(ix+0)
	ld (ChangeWave.data+4),a

	ld a,(de)
	ld (ChangeWave.data+1),a

	inc de

	ld a,(de)
	ld (ChangeWave.data+3),a

	dec de

	call ChangeWave.line


	ld a,(ix+1)
	ld (ChangeWave.data+4),a

	ld a,(hl)
	ld (ChangeWave.data+1),a

	inc hl

	ld a,(hl)
	ld (ChangeWave.data+3),a

	dec hl

	call ChangeWave.line


NoLineDraw1:
	ld a,(WaveOfs)
	inc a
	ld (WaveOfs),a

	ld a,(ChangeWave.data)
	add a,5
	ld (ChangeWave.data),a

	ld a,(ChangeWave.data+2)
	add a,5
	ld (ChangeWave.data+2),a

	inc hl
	inc de
	inc ix
	inc ix

	pop bc

	djnz ChangeWave.loop1

	ret


ChangeWave.line:
	push hl
	push de
	push bc

	ld hl,ChangeWave.data
	call DrawLine

	pop bc
	pop de
	pop hl

	ret

ChangeWave.data:
	.db 0,0,0,0,$f0,3


LineColors:
	.db $f0,$f0,$00,$e0,$00,$e0,$f0,$f0

InsLineData.b:
	.ds 32

WaveOfs:
	.db 0
InsDataOfs.r:
	.dw 0
InsDataOfs.b:
	.dw 0

ShowWholeWave:
	call CalculateYPoints

	ld a,WaveHor
	ld (ShowWholeWave.data+0),a

	add a,4
	ld (ShowWholeWave.data+2),a

	ld hl,InsLineData

	ld b,31
ShowWholeWave.1:
	ld a,(hl)
	ld (ShowWholeWave.data+1),a

	inc hl

	ld a,(hl)
	ld (ShowWholeWave.data+3),a

	push bc
	push hl

	ld hl,ShowWholeWave.data
	call DrawLine

	pop hl
	pop bc

	push hl
	push bc

	ld a,31
	sub b
	call Show1InsData

	pop bc
	pop hl

	ld a,(ShowWholeWave.data+0)
	add a,5
	ld (ShowWholeWave.data+0),a

	ld a,(ShowWholeWave.data+2)
	add a,5
	ld (ShowWholeWave.data+2),a

	djnz ShowWholeWave.1

	ld a,31
	call Show1InsData

	ret

Show1InsData:
; in: a - data offset

	push af

	ld b,a

	and %00000011

	sla a
	sla a
	sla a
	sla a

	ld (Char.DX),a

	ld a,b

	srl a
	srl a

	ld hl,Show1InsYOffs
	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)
	ld (Char.DY),a

	pop af

	ld hl,InsData
	ld e,a
	ld d,0
	add hl,de

	ld a,(hl)

	call Calc8Dec

	ld hl,Decimal
	ld b,3
Show1Ins.loop:
	ld a,(hl)
	sub 32
	sla a
	sla a
	ld (Char.SX),a

	push hl
	push bc

	copy(CharData)

	pop bc
	pop hl

	inc hl

	ld a,(Char.DX)
	add a,4
	ld (Char.DX),a

	djnz Show1Ins.Loop

	ret

Show1InsYOffs:
	.db 69,75,81,87,93,99,105,111

ShowWholeWave.data:
	.db 0,0,0,0,$f0,3

CalculateYPoints:
	ld hl,InsData
	ld de,InsLineData
	ld b,32
CYP.loop1:
	ld a,(hl)
	bit 7,a
	jp z,Cyp.Up

	cpl
	srl a
	inc a

	add a,111
CYP.Done:
	ld (de),a

	inc de
	inc hl

	djnz CYP.loop1

	ret

CYP.Up:
	inc a
	srl a

	ld c,a
	ld a,111
	sub c

	jp CYP.Done



ShowInsName:
	ld a,44
	ld (Char.DX),a

	ld a,45
	ld (Char.DY),a

	ld a,(Ins_e)
	call Calc8Dec

	ld hl,Decimal
	ld b,3
ShowInsName.loop1:
	ld a,(hl)
	sub 32
	sla a
	sla a
	ld (Char.SX),a

	push hl
	push bc

	copy(CharData)

	pop bc
	pop hl

	inc hl

	ld a,(Char.DX)
	add a,4
	ld (Char.DX),a

	djnz ShowInsName.Loop1

	ld a,44
	ld (Char.DX),a

	ld a,51
	ld (Char.DY),a

	ld hl,InsName
	ld b,8
ShowInsName.1:
	push hl
	push bc

	ld a,(hl)	
	cp 97
	jp c,NoNameAdjust

	sub 32
NoNameAdjust:
	sub 32

	sla a
	sla a

	ld (Char.SX),a

	copy(CharData)

	pop bc
	pop hl

	ld a,(Char.DX)
	add a,4
	ld (Char.DX),a

	inc hl

	djnz ShowInsName.1

	ret

ShowCurOct_gfx:
	ld a,(CurOct)
	sla a
	sla a
	sla a
	ld (Octave.Sx),a

	copy(OctaveData)

	ret

; keep these behind eachother in this order!

DefaultName:			; name of default instrument (used when deleting an instrument)
	.text "Default "
InsName:				; name of the instrument
	.ds 8
InsData:				; current Instrument data
	.ds 32
InsLineData:			; all y points
	.ds 32

; ----- till here -----


DrawLine:
; routine : Draw a line from point 1 to point 2.
; in      : hl - pointer to 5 byte large data block
; out     : none.
; cmnt    : none.

	ld de,LineData
	ld bc,6
	ldir

	ld hl,LineData.2
	ld de,LineData.2+1
	ld bc,14
	ld (hl),0
	ldir

	ld a,(LineData+5)
	ld (LineData.Page),a

	ld a,(LineData+4)
	srl a
	srl a
	srl a
	srl a
	ld (LineData.Color),a

	ld a,(LineData+4)
	and $0f
	or %01110000
	ld (LineData.Cmd),a

; --- calculate x and y size and switch them + set maj/min if neccessary...

	ld a,(LineData)
	ld b,a
	ld a,(LineData+2)
	cp b
	jp nc,NoXSwap

	ld b,a

	ld a,(LineData.Opt)
	set 2,a
	ld (LineData.Opt),a

	ld a,(LineData)
NoXSwap:
	sub b
	inc a
	ld (LineData.NX),a

	ld a,(LineData+1)
	ld b,a
	ld a,(LineData+3)
	cp b
	jp nc,NoYSwap

	ld b,a

	ld a,(LineData.Opt)
	set 3,a
	ld (LineData.Opt),a

	ld a,(LineData+1)
NoYSwap:
	sub b
	ld (LineData.NY),a
	
	ld b,a
	ld a,(LineData.NX)
	cp b
	jp nc,NoMajMin

	ld (LineData.NY),a

	ld a,b
	ld (LineData.NX),a

	ld a,(LineData.Opt)
	set 0,a
	ld (LineData.Opt),a

NoMajMin:
	ld a,(LineData)
	ld (LineData.DX),a

	ld a,(LineData+1)
	ld (LineData.DY),a

	copy(LineData.2)

	ret

LineData:
; Line data stored as follows:
;
; byte 1: source x
; byte 2: source y
; byte 3: destination x
; byte 4: destination y
; byte 5: high nibble: color
;         low  nibble: logic operation

	.db 0,0,0,0,$00,0

LineData.2:
	.db 0					; source x
	.db 0					; source x - extra bit for screen 7

	.db 0					; source y
	.db 0					; source page

LineData.DX:
	.db 0					; destination x
	.db 0					; destination x - extra bit for screen 7

LineData.DY:
	.db 0					; destination y
LineData.Page:
	.db 0					; destination page

LineData.NX:
	.db 0					; length x
	.db 0					; length x - extra bit for screen 7 (and scr, 5 - 256 pxls.)

LineData.NY:
	.db 0					; length y
	.db 0					; length y - extra bit for screen 5 - 256 pxls.

LineData.Color:
	.db 0					; color
LineData.Opt:
	.db 0					; other settings (see vdp)

LineData.Cmd:
	.db %01110000			; high: command, low: logic operation

DoCopy:
; routine : copy VRAM -> VRAM
; in      : HL - pointer to 15 bytes long data block
; out     : none
; cmnt    : also used for lines and stuph.

	di

	StatReg(2)

CopyChkCE:
	in a,($99)
	rra
	jr c,CopyChkCe

	StatReg(0)

	ld a,32
	vdp(17)

	ld bc,$0f9b
	otir	

	ei

	ret

DoCopy2:
; routine : copy VRAM -> VRAM
; in      : HL - pointer to 15 bytes long data block
; out     : none
; cmnt    : also used for lines and stuph.

	di

	StatReg(2)

CopyChkCE2:
	in a,($99)
	rra
	jr c,CopyChkCe2

	StatReg(0)

	ld a,32
	vdp(17)

	ld bc,$0f9b
	otir	

	ei

	ret

Box.data:
	.db 0					; source x
	.db 0					; source x - extra bit for screen 7

	.db 0					; source y
	.db 0					; source page

	.db WaveHor				; destination x
	.db 0					; destination x - extra bit for screen 7

	.db 47				; destination y
	.db 3					; destination page

	.db 156				; length x
	.db 0					; length x - extra bit for screen 7 (and scr, 5 - 256 pxls.)

	.db 129				; length y
	.db 0					; length y - extra bit for screen 5 - 256 pxls.

	.db 0					; color
	.db 0					; other settings (see vdp)

	.db $80				; box (low)
	

CharData:
Char.SX:
	.db 0					; source x
	.db 0					; source x - extra bit for screen 7

	.db 212				; source y
	.db 3					; source page

Char.DX:
	.db 0					; destination x
	.db 0					; destination x - extra bit for screen 7

Char.DY:
	.db 0					; destination y
	.db 3					; destination page

	.db 4					; length x
	.db 0					; length x - extra bit for screen 7 (and scr, 5 - 256 pxls.)

	.db 5					; length y
	.db 0					; length y - extra bit for screen 5 - 256 pxls.

	.db 0					; color
	.db 0					; other settings (see vdp)

	.db $d0				; high: command, low: logic operation

OctaveData:
Octave.SX:
	.db 0					; source x
	.db 0					; source x - extra bit for screen 7

	.db 212+5				; source y
	.db 3					; source page

	.db 35				; destination x
	.db 0					; destination x - extra bit for screen 7

	.db 123				; destination y
	.db 3					; destination page

	.db 4*3				; length x
	.db 0					; length x - extra bit for screen 7 (and scr, 5 - 256 pxls.)

	.db 5					; length y
	.db 0					; length y - extra bit for screen 5 - 256 pxls.

	.db 0					; color
	.db 0					; other settings (see vdp)

	.db $d0				; high: command, low: logic operation


LoadCharacterSet:
	ld hl,$3800
	ld (VramSource),hl

	ld hl,$1000
	ld (VramDest),hl

	ld b,8
LoadChrSet.1:
	push bc

	ld a,2
	ld hl,(VramSource)
	call SetVramRead

	ld hl,ChrSetData
	ld bc,$0098
	inir

	xor a
	ld hl,(VramDest)
	call SetVramWrite

	ld hl,ChrSetData
	ld bc,$0098
	otir

	pop bc

	ld hl,(VramSource)
	ld de,256
	add hl,de
	ld (VramSource),hl

	ld hl,(VramDest)
	add hl,de
	ld (VramDest),hl

	djnz LoadChrSet.1

	ret

VramSource:
	.dw 0
VramDest:
	.dw 0

ChrSetData:
	.ds 256


InsPalette:
        .dw $0000,$0114,$0117,$0224,$0227,$0445,$0447,$0557
        .dw $0771,$0777,$0000,$0000,$0000,$0000,$0707,$0777

.end

; einde
