; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Info/Settings menu.    
; Code: d-fader^TwZ.
; Date: August 16, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#define	ShowCurKeyb					  SetVW(0,80*10+69)
#defcont							\ 
#defcont							\ ld hl,Keyboards
#defcont							\ ld a,(set_keybtype)
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ sla a
#defcont							\ ld e,a
#defcont							\ ld d,0
#defcont							\ add hl,de
#defcont							\ 
#defcont							\ ld bc,$0798
#defcont							\ otir

SaveSettings.Adr		.equ $d200


InfoSettingsMenu:
	ld a,1
	ld (ShowRomsAllowed),a

	ShowPic(5)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	call ShowAllSettings

	call kilbuf

	ShowCurKeyb

IS.MainInit:
	call ShowMainBar

IS.Main:
	Locate(1,25)

	xor a
	ld (ShowRomsAllowed),a

	call chget
	ld (CursorSave),a

	ld a,1
	ld (ShowRomsAllowed),a

	Scan2Keys(control,key_h)
	jp z,InfsHelp1

	ScanKey(escape)
	jp z,IS.End

	ld a,(CursorSave)

	cp $1e
	jp z,MainBarUp

	cp $1f
	jp z,MainBarDown

	cp 13
	jp z,MainChoiceMade

	cp 32
	jp z,MainChoiceMade

	jp IS.Main

InfsHelp1:
	ld hl,InfSMenuLine
	call InfsHelp.Continue

	jp IS.MainInit


InfsHelp2:
	ld hl,ColorLine
	call InfsHelp.Continue

	jp EditColors


InfsHelp3:
	ld hl,PredSetLine
	call InfsHelp.Continue

	jp EditPredSet

InfsHelp.Continue:
	ld (RepData),hl

	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call ActiveHelp

	ld a,1
	ld (ShowRomsAllowed),a

	ShowPic(5)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	call ShowAllSettings

	call kilbuf

	ret

CursorSave:
	.db 0

MainBarUp:
	ld a,(MainBarY)
	or a
	jp z,IS.Main

	dec a

	ld (MainBarY),a

	call ShowMainBar

	jp IS.Main

MainBarDown:
	ld a,(MainBarY)
	cp 3
	jp z,IS.Main

	inc a

	ld (MainBarY),a

	call ShowMainBar

	jp IS.Main

ShowMainBar:
	call ClearBlink

	ld a,(MainBarY)
	add a,2
	ld e,a

	ld d,58

	ld a,22

	call DrawBar

	ld a,(MainBarY)
	add a,158
	call DoShowHint


	ret

MainBarY:
	.db 0

MainChoiceMade:
	ld a,(MainBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,MainJumps

	add hl,de

	ld e,(hl)
	inc hl
	ld d,(hl)
	ex de,hl

	ld de,ChoiceMade.1
	push de

	jp (hl)

ChoiceMade.1
	call ShowMainBar

	jp IS.MainInit

MainJumps:
	.dw EditColors
	.dw EditPredSet
	.dw SaveSettings
	.dw IS.End.2

IS.End.2:
	pop de

IS.End:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	call ClearBlink

	ret

ShowAllSettings:
	call ShowColors
	call ShowIntFreq
	call ShowSetScan
	call ShowNoteAud
	call ShowEqType
	call ShowCursorMode
	call ShowEditMode
	call ShowCurOct

	ret

ShowColors:
	SetVW(0,80*8+16)

	ld hl,set_fg1.1
	call ShowColor

	SetVW(0,80*9+16)

	ld hl,set_bg1.1
	call ShowColor
	
	SetVW(0,80*11+16)

	ld hl,set_fg2.1
	call ShowColor

	SetVW(0,80*12+16)

	ld hl,set_bg2.1
	call ShowColor

	ret

ShowColor:
	ld ix,ShowColor.d1

	ld a,(hl)
	and $f0
	srl a
	srl a
	srl a
	srl a
	add a,48

	ld (ix+0),a

	ld a,(hl)
	and $0f
	add a,48
	ld (ix+4),a

	inc hl

	ld a,(hl)
	and $0f
	add a,48
	ld (ix+2),a

	ld hl,ShowColor.d1
	ld bc,$0598
	otir

	ret

ShowIntFreq:
	SetVW(0,8*80+46)

	ld a,(set_intfreq)
	add a,53
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ret

ShowSetScan:
	SetVW(0,80*9+46)

	ld a,(set_setscan)

	jp DoOnOffText

ShowNoteAud:
	SetVW(0,80*10+46)

	ld a,(set_noteaud)
	xor 1

	jp DoOnOffText

ShowEqType:
	SetVW(0,80*11+46)
	ld a,(set_eqtype)

	sla a
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,TextEqType

	add hl,de

	ld bc,$0698
	otir

	ret

ShowCursorMode:
	SetVW(0,80*12+46)

	ld a,(set_curmode)
	xor 1

	sla a
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,TextCurMode

	add hl,de

	ld bc,$0898
	otir

	ret

ShowEditMode:
	SetVW(0,80*8+69)

	ld a,(set_editmode)

	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,TextEditMode

	add hl,de

	ld bc,$0498
	otir

	ret

ShowCurOct:
	SetVW(0,80*9+69)

	ld a,(set_editoct)

	sla a
	ld e,a
	ld d,0
	ld hl,TextCurOct

	add hl,de

	ld bc,$0398
	otir

	ret

DoOnOffText:
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,TextOnOff

	add hl,de

	ld bc,$0398
	otir

	ret


ShowColor.d1:
	.db "0 0 0"

TextOnOFF:
	.db "OFF ON "
TextEqType:
	.db "Normal  Volume"

TextCurMode:
	.db "Normal  Switched"

TextEditMode:
	.db "Type1Key"
TextCurOct:
	.db "  1-2-3-4-5-6-7-8  "


EditColors:
	ShowHint(162)

	xor a
	ld (ColorBarY),a

	call ShowColorBar

EC.Main:
	xor a
	ld (ShowRomsAllowed),a

	call kilbuf
	call chget
	ld (CursorSave),a

	ld a,1
	ld (ShowRomsAllowed),a

	Scan2Keys(control,key_h)
	jp z,InfsHelp2

	ScanKey(escape)
	ret z

	xor a
	ld (ColorChanged),a

	ScanKey(shift)
	jp nz,Noshift

	ld c,0

	ScanKey(key_1)
	jp z,ChangePredCol

	inc c

	ScanKey(key_2)
	jp z,ChangePredCol

	inc c

	ScanKey(key_3)
	jp z,ChangePredCol

	inc c

	ScanKey(key_4)
	jp z,ChangePredCol

	inc c

	ScanKey(key_5)
	jp z,ChangePredCol

	inc c

	ScanKey(key_6)
	jp z,ChangePredCol

	inc c

	ScanKey(key_7)
	jp z,ChangePredCol

NoShift:
	ld c,0

	ScanKey(key_a)
	call z,RedChange

	ScanKey(key_s)
	call z,GreenChange

	ScanKey(key_d)
	call z,BlueChange

	ld c,1

	ScanKey(key_z)
	call z,RedChange

	ScanKey(key_x)
	call z,GreenChange

	ScanKey(key_c)
	call z,BlueChange

	ld a,(ColorChanged)
	or a
	jp z,EC.Main.1

	call OutColors

	call ShowColors

	jp EC.Main

ChangePredCol:
	ld a,c
	sla a
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,Predefined

	add hl,de

	ld de,PredSettings
	ld bc,8
	ldir

	call outcolors
	call ShowColors

	jp EC.Main


EC.Main.1:
	ld a,(CursorSave)

	cp $1e
	jp z,EC.BarUp

	cp $1f
	jp z,EC.BarDown

	jp EC.Main

EC.BarUp:
	ld a,(ColorBarY)
	or a
	jp z,EC.Main

	dec a
	
	ld (ColorBarY),a

	call ShowColorBar

	jp EC.Main

EC.BarDown:
	ld a,(ColorBarY)
	cp 3
	jp z,EC.Main

	inc a
	
	ld (ColorBarY),a

	call ShowColorBar

	jp EC.Main

RedChange:
	ld a,1
	ld (ColorChanged),a

	ld a,c
	or a
	jp z,EC.RedUp

	jp EC.RedDown

GreenChange:
	ld a,1
	ld (ColorChanged),a

	ld a,c
	or a
	jp z,EC.GreenUp

	jp EC.GreenDown


BlueChange:
	ld a,1
	ld (ColorChanged),a

	ld a,c
	or a
	jp z,EC.BlueUp

	jp EC.BlueDown

EC.RedUp:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1
	add hl,de

	ld a,(hl)
	srl a
	srl a
	srl a
	srl a

	cp 7
	ret z

	inc a

	sla a
	sla a
	sla a
	sla a

	ld b,a

	ld a,(hl)
	and $0f
	or b

	ld (hl),a

	ret

EC.RedDown:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1
	add hl,de

	ld a,(hl)
	srl a
	srl a
	srl a
	srl a

	or a
	ret z

	dec a

	sla a
	sla a
	sla a
	sla a

	ld b,a

	ld a,(hl)
	and $0f
	or b

	ld (hl),a

	ret

EC.BlueUp:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1
	add hl,de

	ld a,(hl)
	and $0f

	cp 7
	ret z

	inc a

	ld b,a

	ld a,(hl)
	and $f0
	or b

	ld (hl),a

	ret

EC.BlueDown:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1
	add hl,de

	ld a,(hl)
	and $0f

	or a
	ret z

	dec a

	ld b,a

	ld a,(hl)
	and $f0
	or b

	ld (hl),a

	ret

EC.GreenUp:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1+1
	add hl,de

	ld a,(hl)
	and $0f

	cp 7
	ret z

	inc a

	ld (hl),a

	ret

EC.GreenDown:
	ld a,(ColorBarY)
	sla a
	ld e,a
	ld d,0
	ld hl,set_fg1.1+1
	add hl,de

	ld a,(hl)
	and $0f

	or a
	ret z

	dec a

	ld (hl),a

	ret

OutColors:
	ld a,(set_fg1.1)						; change foreground color 1 itensity
	ld b,a							;
	ld a,(set_fg1.2)						;
	ld c,a							;
	ld a,12							; number 12
	call ColorChg						;

	ld a,(set_bg1.1)						; change background color 1 itensity
	ld b,a							;
	ld a,(set_bg1.2)						;
	ld c,a							;
	ld a,13							; number 13
	call ColorChg						;


	ld a,(set_fg2.1)						; change foreground color 2 itensity
	ld b,a							;
	ld a,(set_fg2.2)						;
	ld c,a							;
	ld a,14							; number 14
	call ColorChg						;

	ld a,(set_bg2.1)						; change background color 1 itensity
	ld b,a							;
	ld a,(set_bg2.2)						;
	ld c,a							;
	ld a,15							; number 15
	call ColorChg						;

	ret


ShowColorBar:
	call ClearBlink

	ld a,(ColorBarY)
	add a,9
	cp 11
	jp c,ShowColorBar.1

	inc a

ShowColorBar.1
	ld e,a
	ld d,2
	ld a,21
	call DrawBar

	ret

Predefined:
	.db $77,$07				; Factory settings
	.db $00,$00
	.db $70,$07
	.db $30,$03
	
	.db $04,$04				; Midnight tracking
	.db $01,$00
	.db $07,$07
	.db $02,$02

	.db $40,$04				; Gold
	.db $00,$00
	.db $70,$07
	.db $30,$03

	.db $77,$07				; Red
	.db $00,$00
	.db $70,$00
	.db $20,$00

	.db $77,$07				; Green
	.db $00,$00
	.db $00,$07
	.db $00,$02

	.db $77,$07				; Blue
	.db $00,$00
	.db $07,$00
	.db $02,$00

	.db $00,$07				; I'm a pig!
	.db $01,$00
	.db $70,$00
	.db $22,$00


ColorBarY:
	.db 0
ColorChanged:
	.db 0

NewInt:
	ld a,(ShowRomsAllowed)
	or a
	jp nz,OldInt

	call ShowRoms
OldInt:
	.ds 5

ShowRomsAllowed:
	.db 0

ShowRoms:
	ld hl,EmptySlot
	ld de,SlotText
	ld bc,43
	ldir

	ld a,1
	call $cd00
	call z,SearchRCName

	SetVW(0,3*80+13)

	ld hl,SlotText
	ld bc,$2b98
	otir

CheckSlot2:
	ld hl,EmptySlot
	ld de,SlotText
	ld bc,43
	ldir

	ld a,2
	call $cd00
	call z,SearchRCName


	SetVW(0,4*80+13)

	ld hl,SlotText
	ld bc,$2b98
	otir

	ret

SearchRCname:
	ld hl,Unknown
	ld de,SlotText
	ld bc,43
	ldir

	ld a,(RCData+3)
	and $0f
	add a,48
	ld (SlotText+2),a

	ld a,(RCData+3)
	srl a
	srl a
	srl a
	srl a
	add a,48
	ld (SlotText+1),a

	ld a,(RCData+2)
	cp 7
	ret nz

	ld a,(RCData+3)
	ld d,a

	ld hl,RCNumbers
	ld c,123
	ld b,RCNumbersEnd-RCNumbers
GetNameLoop:
	inc c

	ld a,(hl)
	cp d
	jp z,NameFound

	inc hl

	djnz GetNameLoop

	ret

NameFound:
	inc c
	ld b,c

	ld hl,-78
	ld de,80
NameFoundLoop1:
	add hl,de

	djnz NameFoundLoop1

	ld a,2
	call SetVramRead

	ld hl,SlotText
	ld bc,$2b98
	inir

	ret

SaveSettings:
	ld a,$c9
	ld ($fd9f),a

	ld hl,oldint+4
	ld de,$fd9f+4
	ld bc,5
	lddr

	ShowHint(152)

	bdos(get_ddn)
	ld (SaveDName),a

	ld e,0
	bdos(sel_dsk)

	call SaveSettings.Adr

	ld a,(SaveDName)
	ld e,a
	bdos(sel_dsk)

	ld hl,$fd9f
	ld de,oldint
	ld bc,5
	ldir

	ld a,$c9
	ld ($fd9f),a

	ld hl,NewInt
	ld ($fd9f+1),hl

	ld a,$c3
	ld ($fd9f),a

	ret

SaveDName:
	.db 0

EditPredSet:
	call ShowSetBar

EPS.Main:
	xor a
	ld (ShowRomsAllowed),a

	call chget
	ld (CursorSave),a

	ld a,1
	ld (ShowRomsAllowed),a

	Scan2Keys(control,key_h)
	jp z,InfsHelp3

	ScanKey(escape)
	ret z

	ld a,(SetBar)
	cp 6
	jp z,CheckLRBrk

	ScanKey(space)
	jp z,EPS.ChoiceMade

	jp NoLRBrk

CheckLRBrk:
	ScanKey(left_brk)
	jp z,EPS.ChoiceMade

	ScanKey(right_brk)
	jp z,EPS.ChoiceMade

NoLRBrk:
	ld a,(CursorSave)

	cp $1c
	jp z,EPS.Add5

	cp $1d
	jp z,EPS.Sub5

	cp $1e
	jp z,EPS.Sub1

	cp $1f
	jp z,EPS.Add1

	jp EPS.Main

EPS.Add5:
	ld a,(SetBar)
	cp 3
	jp nc,EPS.Main

	add a,5

	ld (SetBar),a

	call ShowSetBar

	jp EPS.Main

EPS.Sub5:
	ld a,(SetBar)
	cp 6
	jp c,EPS.Main

	sub 5

	ld (SetBar),a

	call ShowSetBar

	jp EPS.Main

EPS.Sub1:
	ld a,(SetBar)
	or a
	jp z,EPS.Main

	dec a

	ld (SetBar),a

	call ShowSetBar

	jp EPS.Main

EPS.Add1:
	ld a,(SetBar)
	cp 7
	jp z,EPS.Main

	inc a

	ld (SetBar),a

	call ShowSetBar

	jp EPS.Main

EPS.ChoiceMade:
	ld a,(SetBar)
	sla a
	ld e,a
	ld d,0
	ld hl,EPS.JumpTable

	add hl,de

	ld e,(hl)
	inc hl
	ld d,(hl)

	ex de,hl

	ld de,EPS.ChoiceDone

	push de
	jp (hl)

EPS.ChoiceDone:
	jp EPS.Main	

EPS.JumpTable:
	.dw SwitchFreq
	.dw SwitchScan
	.dw SwitchNote
	.dw SwitchEqType
	.dw SwitchCurMode
	.dw SwitchEditMode
	.dw EditOctaves
	.dw EditKeyb

SwitchFreq:
	ld a,(set_intfreq)
	xor 1
	ld (set_intfreq),a

	call ShowIntFreq

	ret

SwitchScan:
	ld a,(set_setscan)
	xor 1
	ld (set_setscan),a

	call ShowSetScan

	ret

SwitchNote:
	ld a,(set_noteaud)
	xor 1
	ld (set_noteaud),a

	call ShowNoteAud

	ret

SwitchEqType:
	ld a,(set_EqType)
	xor 1
	ld (set_EqType),a

	call ShowEqType

	ret

SwitchCurMode:
	ld a,(set_curmode)
	xor 1
	ld (set_curmode),a

	call ShowCursorMode

	ret

SwitchEditMode:
	ld a,(set_editmode)
	xor 1
	ld (set_editmode),a

	call ShowEditMode

	ret

EditOctaves:
	ScanKey(left_brk)
	jp z,EditOctaves.d

	ld a,(set_editoct)
	cp 8
	ret z

	inc a
	ld (set_editoct),a

	call ShowCurOct

	ret

EditOctaves.d:
	ld a,(set_editoct)
	or a
	ret z

	dec a
	ld (set_editoct),a

	call ShowCurOct

	ret

EditKeyB:
	ld a,(set_keybtype)
	inc a

	cp 3
	jp c,NoKeyBReset

	xor a
NoKeyBReset:
	ld (set_keybtype),a

	ShowCurKeyb

	call KilBuf

	ret

ShowSetBar:
	call ClearBlink

	ld a,(SetBar)
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,SetBarPos
	add hl,de

	ld a,(hl)
	ld d,a

	inc hl

	ld a,(hl)
	ld e,a

	inc hl

	ld a,(hl)

	call DrawBar

	ld a,(SetBar)
	add a,163
	call DoShowHint

	ret

SetBar:
	.db 0

SetBarPos:
	.db 24,9,32,0
	.db 24,10,32,0
	.db 24,11,32,0
	.db 24,12,32,0
	.db 24,13,32,0
	.db 57,9,23,0
	.db 57,10,23,0
	.db 57,11,23,0

Unknown:
	.text "7   - Unknown RC number...             "
	.db 22
	.text "???"

EmptySlot:
	.text "??? - No RC number found...            "
	.db 22
	.text "No "

;			    1         2         3         4  4
	;      1234567890123456789012345678901234567890123
SlotText:
	.text "                                           "

RCNumbers:
	.db $32
	.db $34
	.db $36
	.db $37
	.db $39
	.db $40
	.db $42
	.db $43
	.db $45
	.db $46
	.db $48
	.db $49
	.db $50
	.db $51
	.db $52
	.db $53
	.db $54
	.db $57
	.db $58
	.db $59
	.db $60
	.db $61
	.db $62
	.db $64
	.db $66
	.db $67
	.db $68
	.db $69
RCNumbersEnd:

Keyboards:
	.text "MSX     "
	.text "Toshiba "
	.text "Philips "


.end


; eind
