; TeddyWareZ MSX Z80 source file.
;
; Prog: SCC Blaffer NT - Disk Menu
; Code: d-fader^TwZ.
; Date: june 28, 1999
;
; cmnt: none.  
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

InitBytesDiskMenu:
	jp DiskMenu

	.ds 16-3

	.text "                "
	.text " SCC BLAFFER NT "
	.text "  (C) 1999 TwZ  "
	.text "                "
	.text "   Disk Menu!   "
	.text "                "

DiskMenu:
	call InitDiskMenu

DiskMenuMain:
	Locate(1,25)						; Hide the cursor

	call ShowMenuHint

	call kilbuf
	call chget

	ld (KeyPressed),a

	Scan2Keys(control,key_a)
	jp z,MainSelAll

	Scan2Keys(control,key_f)
	jp z,ChangeFilterName

	Scan2Keys(control,key_h)
	jp z,DiskHelp

	ld a,($fbe7)
	cpl
	and %11000000
	jp nz,ChangeDrive

	ld a,($fbe8)
	cp 255
	jp nz,ChangeDrive

	ld a,($fbe9)
	xor 255
	and %00111111
	jp nz,ChangeDrive


	ScanKey(f5)
	jp z,DiskMenuInsKit

	ScanKey(escape)
	jp z,DeInitDiskMenu

	ld a,(KeyPressed)

	cp $1c
	jp z,DiskMenuUp3

	cp $1d
	jp z,DiskMenuDown3

	cp $1e
	jp z,DiskMenuUp1

	cp $1f
	jp z,DiskMenuDown1

	cp 32
	jp z,ChoiceMade

	cp 13
	jp z,ChoiceMade

	jp DiskMenuMain

DiskHelp:
	ld hl,DiskMenuLine
	ld (RepData),hl

	ld a,9
	ld (RepCommand),a

	ld a,4
	call DoMenu

	call InitDiskMenu2

	jp DiskMenuMain

DiskMenuInsKit:
	ld a,(WhatMenu)
	cp 2
	jp z,DiskMenuMain

	call DeInitDiskMenu

	ld a,2
	ld (WhichDiskMenu),a

	jp DiskMenu


ChangeDrive:
	call DoChangeDrive

	call nc,DoShowFiles

	call Nokey
	call kilbuf

	jp DiskMenuMain

DoChangeDrive:
	ld c,0

	ScanKey(key_a)
	jp z,ChangeDone

	inc c

	ScanKey(key_b)
	jp z,ChangeDone

	inc c

	ScanKey(key_c)
	jp z,ChangeDone

	inc c

	ScanKey(key_d)
	jp z,ChangeDone

	inc c

	ScanKey(key_e)
	jp z,ChangeDone

	inc c

	ScanKey(key_f)
	jp z,ChangeDone

	inc c

	ScanKey(key_g)
	jp z,ChangeDone

	inc c

	ScanKey(key_h)
	jp z,ChangeDone

	inc c

	ScanKey(key_i)
	jp z,ChangeDone

	inc c

	ScanKey(key_j)
	jp z,ChangeDone

	inc c

	ScanKey(key_k)
	jp z,ChangeDone

	inc c

	ScanKey(key_l)
	jp z,ChangeDone

	inc c

	ScanKey(key_m)
	jp z,ChangeDone

	inc c

	ScanKey(key_n)
	jp z,ChangeDone

	inc c

	ScanKey(key_o)
	jp z,ChangeDone

	inc c

ChangeDone:
; C now has the right drive..
	push bc

	bdos(24)						; get connected drives

	ld a,h
	cpl
	ld h,a

	ld a,l
	cpl
	ld l,a

	pop bc

	ld b,l

	ld a,c
	cp 8
	jp c,ChangeDone2

	sub 8

	ld b,h

ChangeDone2:
	ld e,a
	ld d,0
	ld hl,DrivesList
	add hl,de

	ld a,b
	and (hl)

	jp nz,DriveNotAvail

	ld e,c
	bdos(14)

	call ShowDrive

	or a
	ret

DriveNotAvail:
	ShowHint(22)

	call kilbuf
	call chget

	scf
	ret

DrivesList:
	.db %00000001
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00100000
	.db %01000000
	.db %10000000



MainSelAll:
	ld hl,AllFilesFilter
	ld de,NowFilter
	ld bc,11
	ldir

	xor a
	ld (FilesOnScreen),a

	call ShowNowFilter

	jp DiskMenuMain

ChoiceMade:
	ld a,(NowMenu)
	or a
	jp z,LoadFile
	cp 1
	jp z,SaveFile
	cp 2
	jp z,ShowFiles
	cp 3
	jp z,DeleteFile
	cp 4
	jp z,FormatDisk


	jp DiskMenuMain

SaveFile:
	ld a,1
	ld (FileSave),a

	call SelectFile

	push af

	xor a
	ld (FileSave),a

	pop af

	jp c,DiskMenuMain

	ld a,(WhatMenu)
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,FileExtensions
	add hl,de

	ld de,FileExt
	ld a,3
	call CompareStrings

	jp z,SaveNormalExt

	ShowHint(33)

	call YesOrNo

	Locate(1,25)
	jp nz,DiskMenuMain

SaveNormalExt:
	ShowHint(40)

	ld de,fcb
	ld c,22
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,TooManyBadFile

	ld hl,1
	ld (RecSize),hl

	ld a,(WhatMenu)
	sla a
	sla a
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,FileHeaders
	add hl,de
	ld de,SaveFileHeader
	ld bc,16
	ldir

	ld de,SaveFileHeader
	bdos(26)

	ShowHint(35)

	ld de,fcb
	ld hl,16
	ld c,38
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,FileNotSaved
	
	ld a,(WhatMenu)
	add a,36
	call DoShowHint

	ld a,(WhatMenu)
	or a
	jp z,SavePSGIns

	cp 1
	jp z,SaveSCCIns

	cp 2
	jp z,SaveInsKit

	cp 3
	jp z,SaveSong

	jp DiskMenuMain

SavePSGIns:
	ld a,InsBnk
	out ($fe),a

	ld hl,(SaveInsAddress)

	ex de,hl
	bdos(26)

	ld hl,184
	ld de,fcb
	ld c,38
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,FileNotSaved

	jp SaveFileDone

SaveSCCIns:
	ld a,InsBnk
	out ($fe),a

	ld hl,(SaveInsAddress)

	ex de,hl
	bdos(26)

	ld hl,40
	ld de,fcb
	ld c,38
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,FileNotSaved

	jp SaveFileDone

SaveInsKit:
	ld a,InsBnk
	out ($fe),a

	ld de,$8000
	bdos(26)

	ld hl,16384
	ld de,fcb
	ld c,38
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,FileNotSaved

	jp SaveFileDone
	
SaveSong:
	ld a,SngBnk
	out ($fe),a

	ld hl,SongPatterns
	ld de,SongPatterns+1
	ld bc,82
	ld (hl),0
	ldir

	ld a,(LastPos)
	inc a
	ld b,a

	ld c,0

	ld hl,Patterns
	ld ix,SongPatAdr
SaveSong.1:
	push hl

	ld a,(hl)

	ld e,a
	ld d,0
	ld hl,SongPatterns

	add hl,de

	ld a,(hl)
	or a
	jp nz,SaveSong.11

	inc a
	ld (hl),a

	inc c

	push bc

	ld b,e
	inc b

	ld hl,PatternData-192
	ld de,192
SaveSong.12:
	add hl,de

	djnz SaveSong.12

	pop bc

	ld (ix+0),l
	ld (ix+1),h

	inc ix
	inc ix

SaveSong.11:
	pop hl

	inc hl

	djnz SaveSong.1

	ld a,c
	ld (SongPatsToSave),a

	ld hl,LoadedInsKit
	ld de,InsKitName
	ld bc,11
	ldir

	ld de,MusicAddress
	bdos(26)

	ld hl,448							; write init stuff to file
	call WriteFile


	ld de,SongPatsToSave					; write number of pats saved
	bdos(26)

	ld hl,1
	call WriteFile

	ld a,(SongPatsToSave)
	ld b,a

	ld ix,SongPatAdr
SaveSong.21:
	ld a,b
	ld (SaveNowPat),a

	ld (SaveNowPatAdr),ix

	ld e,(ix+0)
	ld d,(ix+1)

	ld hl,SongPatAdrToSave
	ld (hl),e
	inc hl
	ld (hl),d

	ld de,SongPatAdrToSave
	bdos(26)

	ld hl,2
	call WriteFile
	
	ld ix,(SaveNowPatAdr)
	ld e,(ix+0)
	ld d,(ix+1)
	bdos(26)

	ld hl,192
	call WriteFile

	ld ix,(SaveNowPatAdr)
	ld a,(SaveNowPat)

	ld b,a

	inc ix
	inc ix

	djnz SaveSong.21

	jp SaveFileDone

SaveNowPat:
	.db 0

SaveNowPatAdr:
	.dw 0

SongPatterns:
	.ds 83

SongPatAdr:
	.ds 83*2

WriteFile:
	ld de,fcb
	ld c,38
	call DoBdos

	pop bc

	jp c,SaveFileError
	or a
	jp nz,FileNotSaved

	push bc

	ret


SaveFileDone:
	ld de,fcb
	ld c,16
	call DoBdos
	jp c,SaveFileError
	or a
	jp nz,FileNotSaved

	ShowHint(Empty)

	ld a,7
	out ($fe),a

	call DoShowFiles

	jp DiskMenuMain

SaveFileError:
	ld a,7
	out ($fe),a

	call ClearFiles

	ld a,($f414)

	jp DiskWriteError

TooManyBadFile:
	ShowHint(34)
	
	call kilbuf
	call chget

	jp DiskMenuMain

FileNotSaved:
	ShowHint(42)
	
	call kilbuf
	call chget

	ld a,7
	out ($fe),a

	jp DiskMenuMain


DeleteFile:
	call SelectFile
	jp c,DiskMenuMain

	ShowHint(28)

	SetVW(0,22*80+43)

	ld hl,FullFileName
	ld bc,$0c98
	otir

	call YesOrNo

	jp nz,DiskMenuMain

	ShowHint(29)

	SetVW(0,22*80+20)

	ld hl,FullFileName
	ld bc,$0c98
	otir

	ld de,fcb
	ld c,19
	call DoBdos
	jp c,DeleteFileError

	or a
	jp z,DeleteComplete

	ShowHint(30)

	call kilbuf
	call chget

	call ClearFiles

	jp DiskMenuMain

DeleteComplete:
	call DoShowFiles

	jp DiskMenuMain

DeleteFileError:
	ld a,($f414)

	jp DiskWriteError

FormatDisk:
	ShowHint(23)

	SetVW(0,22*80+51)

	ld a,(CurDrive)
	add a,65
	out ($98),a

	call YesOrNo
	jp nz,DiskMenuMain

GetDiskSizeLoop:
	ShowHint(24)
	call kilbuf
	call ChGet

	ld c,1
	ScanKey(key_s)
	jp z,DoFormat

	ld c,2
	ScanKey(key_d)
	jp z,DoFormat

	jp GetDiskSizeLoop

DoFormat:
	push bc

	call ClearFiles

	ShowHint(25)

	pop bc

	ld a,($fb22)
	ld (FormatPage),a

	ld a,(CurDrive)
	ld d,a						; in d Drive to Format

	ld a,c						; in a Single or Double Sided (1 or 2)

	ld hl,$8000						; Start of Data block (for format)
	ld bc,$4000						; Length of Data block

	rst 30h
FormatPage:
	.db 0
	.dw $401c

	jp c,DiskWriteError

	ShowHint(27)
	call kilbuf
	call chget

	jp DiskMenuMain

DiskWriteError:
	ld c,17
	cp Err_DiskOffline
	jp z,DiskWriteErrorFound

	ld c,18
	cp Err_DiskIOError
	jp z,DiskWriteErrorFound

	ld c,26
DiskWriteErrorFound:
	ld a,c
	call DoShowHint

	call kilbuf
	call chget

	jp DiskMenuMain

DiskMenuUp3:
	ld a,(NowMenu)
	cp 2
	jp nc,DiskMenuMain

	add a,3
	call ShowMenu

	jp DiskMenuMain

DiskMenuDown3:
	ld a,(NowMenu)
	cp 3
	jp c,DiskMenuMain
	
	sub 3
	call ShowMenu

	jp DiskMenuMain

DiskMenuUp1:
	ld a,(NowMenu)
	or a
	jp z,DiskMenuMain

	dec a
	call ShowMenu

	jp DiskMenuMain

DiskMenuDown1:
	ld a,(NowMenu)
	cp 4
	jp z,DiskMenuMain

	inc a
	call ShowMenu

	jp DiskMenuMain

InitDiskMenu:
; routine : Initialise disk menu
; in      : (WhichDiskMenu) - 0 - PSG Ins, 1 - SCC Ins, 2 - Ins. Kit, 3 - Song
; out     : none.
; cmnt    : none.

	ld a,(WhichDiskMenu)
	ld (WhatMenu),a

	push af

	ld a,7
	out ($fe),a

	ld hl,ErrorHandler
	ld de,ErrorHandlerAdr+2
	ld bc,EndErrorHandler-ErrorHandler
	ldir

	ld hl,ErrorHandlerAdr+2
	ld (ErrorHandlerAdr+0),hl

	ld hl,($f323)					; Address to get address to jump to when an
	ld (OriginalErrHand),hl

	ld hl,ErrorHandlerAdr+0
	ld ($f323),hl

	ld hl,InsertHandler
	ld de,InsertDisk
	ld bc,EndInsertHandler-InsertHandler
	ldir

	ld hl,$f24f
	ld de,OriginalInsertHand
	ld bc,3
	ldir

	ld a,$c3
	ld ($f24f),a

	ld hl,InsertDisk
	ld ($f24f+1),hl

InitDiskMenu3:
	xor a
	ld (FilesOnScreen),a

	call ClearBlink

	ShowPic(2)

	pop bc

	inc b
	ld hl,NrmFileFilters-31
	ld de,31
InitDiskMenuLoop1:
	add hl,de

	djnz InitDiskMenuLoop1
	
	push hl

	SetVW(0,18*80+1)

	pop hl
	
	ld bc,$1498							; Show File Type description
	otir								;

	ld de,NowFilter						; Copy right filter to now filter
	ld bc,11							;
	ldir								;

	call ShowDrive						; Show current drive on screen.

	call ShowNowFilter					; Show filter name

	call ShowAvailableDrives

	xor a
	ld (NowMenu),a
	call ShowMenu1

	ld a,(WhatMenu)
	or a
	jp z,ShowPSGInstrument
	dec a
	jp z,ShowSCCInstrument

	ret

InitDiskMenu2:
	call ClearBlink

	ShowPic(2)

	ld a,(WhatMenu)

	push af

	call kilbuf

	jp InitDiskMenu3

ShowPSGInstrument:
	ld a,(NowInstrument)					; calculate 8-bits number
	call Calc8Dec						; (of pattern)

	SetVW(0,80*18+17)						; set VRAM ready

	ld hl,decimal+1						; write number on screen
	ld bc,$0298							;
	otir								;

	ret

ShowSCCInstrument:
	ld a,(NowInstrument)					; calculate 8-bits number
	call Calc8Dec						; (of pattern)

	SetVW(0,80*18+17)						; set VRAM ready

	ld hl,decimal						; write number on screen
	ld bc,$0398							;
	otir								;

	ret


DeInitDiskMenu:
	call ClearBlink

	ld hl,OriginalInsertHand
	ld de,$f24f
	ld bc,3
	ldir

	ld hl,(OriginalErrHand)
	ld ($f323),hl

	ld a,insbnk
	out ($fe),a

	ret

ShowFiles:
	call DoShowFiles

	jp DiskMenuMain

LoadFile:
	call SelectFile
	jp c,DiskMenuMain

	ld a,(WhatMenu)
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,FileExtensions
	add hl,de

	ld de,FileExt
	ld a,3
	call CompareStrings

	jp z,LoadNormalExt

	ShowHint(41)

	call YesOrNo

	Locate(1,25)
	jp nz,DiskMenuMain

LoadNormalExt:
	ShowHint(40)

	ld de,fcb
	ld c,15
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileNotFound

	ld hl,1
	ld (RecSize),hl

	ld de,SaveFileHeader
	bdos(26)

	ld de,fcb
	ld hl,16
	ld c,39
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect

	ld a,(WhatMenu)
	sla a
	sla a
	sla a
	sla a

	ld e,a
	ld d,0
	ld hl,FileHeaders
	add hl,de
	ld de,SaveFileHeader

	ld a,16
	call CompareStrings

	jp z,LoadFileOk

	ld a,(WhatMenu)
	add a,44
	call DoShowHint

	call kilbuf
	call chget

	jp DiskMenuMain

LoadFileOk:
	ld a,(WhatMenu)
	add a,49
	call DoShowHint

	ld a,(WhatMenu)
	or a
	jp z,LoadPSGIns

	cp 1
	jp z,LoadSCCIns

	cp 2
	jp z,LoadInsKit

	cp 3
	jp z,LoadSong

	jp DiskMenuMain

LoadPSGIns:
	ld a,InsBnk
	out ($fe),a

	ld hl,(SaveInsAddress)

	ex de,hl
	bdos(26)

	ld hl,184
	ld de,fcb
	ld c,39
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect

	jp LoadFileDone

LoadSCCIns:
	ld a,InsBnk
	out ($fe),a

	ld hl,(SaveInsAddress)

	ex de,hl
	bdos(26)

	ld hl,40
	ld de,fcb
	ld c,39
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect

	jp LoadFileDone

LoadInsKit:
	ld hl,FileName
	ld de,LoadedInsKit
	ld bc,11
	ldir

	ld a,InsBnk
	out ($fe),a

	ld hl,$8000

	ex de,hl
	bdos(26)

	ld hl,16384
	ld de,fcb
	ld c,39
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect

	jp LoadFileDone

LoadSong:
	ld a,SngBnk
	out ($fe),a

	ld hl,PatternData						; Clear Song data (only pattern data)
	ld de,PatternData+1
	ld bc,83*192-1
	ld (hl),0
	ldir

	ld de,$8000
	bdos(26)

	ld hl,448
	call ReadFile						; Load Init Bytes of song.

	ld de,SongPatsToSave
	bdos(26)

	ld hl,1
	call ReadFile						; Number of patterns to load		

	ld a,(SongPatsToSave)
	ld b,a
LoadSong.1:
	ld a,b
	ld (SongPatsToSave),a

	ld de,SongPatAdrToSave
	bdos(26)

	ld hl,2
	call ReadFile						; Get address to store pattern data in

	ld a,(SongPatAdrToSave)
	ld e,a
	ld a,(SongPatAdrToSave+1)
	ld d,a
	bdos(26)							; Set Read address to pattern data.

	ld hl,192
	call ReadFile						; Read Pattern

	ld a,(SongPatsToSave)
	ld b,a

	djnz LoadSong.1						; Repeat until song is loaded.

	jp LoadFileDone

LoadFileDone:
	ld de,fcb
	ld c,16
	call DoBdos
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect

	ShowHint(Empty)

	ld a,7
	out ($fe),a

	jp DiskMenuMain

LoadFileNotFound:
	ShowHint(43)

	call kilbuf
	call chget

	call ClearFiles

	jp DiskMenuMain

LoadFileError:
	ld a,7
	out ($fe),a

	call ClearFiles

	call DiskError

	jp DiskMenuMain

LoadFileIncorrect:
	ld a,7
	out ($fe),a

	ShowHint(48)

	call kilbuf
	call chget

	jp DiskMenuMain	

ReadFile:
	ld de,fcb
	ld c,39
	call DoBdos

	pop bc
	jp c,LoadFileError
	or a
	jp nz,LoadFileIncorrect
	push bc

	ret

SelectFile:
	ld a,(FilesOnScreen)
	or a
	call z,DoShowFiles

	ret c

	ld b,21

	ld a,(FileSave)
	or a
	jp z,OnlyLoad

	ld b,31

	ld a,(FoundSave)
	or a
	jp z,SelectFileTypeIn
	
OnlyLoad:
	ld a,b

	call DoShowHint

	ld a,2
	ld (select_x),a
	ld (select_y),a

	xor a
	ld (SelectedFile),a

	ld hl,1*80+1
	ld (SelectVramAdr),hl

	ld d,2
	ld e,2
	ld a,8
	call DrawBar

	ld d,2
	ld e,2
	call NewFile

SelectFileMain:
	call kilbuf
	call chget

	ld (keyPressed),a

	ld b,a

;	ScanKey(shift)
;	jp z,SelectFileNoSave

	ld a,(FileSave)
	or a
	jp z,SelectFileNoSave

	ld a,b
	cp 33
	jp c,SelectFileNoSave
	cp 127
	jp nc,SelectFileNoSave

	ld a,b
	jp SelectFileTypeInSel

SelectFileNoSave:
	Scan2Keys(control,key_a)
	jp z,SelSelAll

	Scan2Keys(control,key_r)
	jp z,SelectReload

	Scan2Keys(control,key_f)
	jp z,SelectInputFilter

	ld a,($fbe7)
	cpl
	and %11000000
	jp nz,ChangeDriveSel

	ld a,($fbe8)
	cp 255
	jp nz,ChangeDriveSel

	ld a,($fbe9)
	xor 255
	and %00111111
	jp nz,ChangeDriveSel

NoDriveChange:
	ld a,(KeyPressed)

	cp $1c
	jp z,SelFileUp1

	cp $1d
	jp z,SelFileDown1

	cp $1e
	jp z,SelFileUp8

	cp $1f
	jp z,SelFileDown8

	cp 13
	jp z,FileSelected

	cp 32
	jp z,FileSelected

	cp 27
	jp z,SelectCancel	

	jp SelectFileMain

ChangeDriveSel:
	call DoChangeDrive

	Locate(1,25)

	jp SelectReload

SelSelAll:
	ld hl,AllFilesFilter
	ld de,NowFilter
	ld bc,11
	ldir

	call ShowNowFilter

	jp SelectReload

SelectInputFilter:
	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,8
	call DrawBar

	call ChangeFilter	

	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,8
	call DrawBar

	Locate(1,25)

SelectReload:
	call ClearAllSelectData

	xor a
	ld (FilesOnScreen),a

	jp SelectFile

FileSelected:
	call ClearAllSelectData

	ClearFCB

	ld hl,FullFileName				; Copy filename to FileName ($da01)
	ld de,FileName					;
	ld bc,8						;
	ldir							;

	inc hl						; Skip the dot ('.')

	ld bc,3						; Copy extension to Filename+8
	ldir							;

	or a							; Reset carry flag
	ret

SelectCancel:
	call ClearAllSelectData

	scf							; Set carry flag
	ret

SelectFileTypeInSel:
	push af

	call ClearAllSelectData

	pop af

SelectFileTypeIn:
	ClearFCB

	ld hl,FileName
	ld de,FileName+1
	ld bc,10
	ld (hl),32
	ldir

	or a
	jp z,NotFromSelect

	ld (FileName),a

	ShowHint(32)

	SetVW(0,80*22+21)

	ld hl,FileName
	ld bc,$0898
	otir

	jp TooFromSelect

NotFromSelect:
	ShowHint(32)

TooFromSelect:
	SetVW(0,80*22+30)

	ld a,(WhatMenu)
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,FileExtensions
	add hl,de

	push hl
	ld de,FileExt
	ld bc,3
	ldir
	pop hl

	ld bc,$0398
	otir

	ld d,30
	ld e,23
	ld a,4
	call DrawBar

	ld hl,FileSave_data
	call Input_Text

	ld d,30
	ld e,23
	ld a,4
	call DrawBar

	ShowHint(Empty)

	ret

ClearAllSelectData:
	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,8
	call DrawBar

	SetVW(0,16*80+67)
	ld hl,ClearData
	ld bc,$0c98
	otir

	SetVW(0,18*80+49)
	ld hl,ClearData
	ld bc,$1e98
	otir

	ret

ClearData:
	.text "                              "



SelFileDown8:
	ld hl,(SelectVramAdr)
	ld de,80
	add hl,de

	push hl

	xor a
	call SetVramRead

	in a,($98)
	cp 32

	pop hl

	jp z,SelectFileMain

	ld a,(select_y)
	cp 15
	jp z,SelectFileMain

	ld (SelectVramAdr),hl

	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	inc a
	ld e,a

	ld a,(SelectedFile)
	add a,8
	ld (SelectedFile),a

	call NewFile

	jp SelectFileMain

SelFileUp8:
	ld hl,(SelectVramAdr)
	ld de,-80
	add hl,de

	push hl

	xor a
	call SetVramRead

	in a,($98)
	cp 32

	pop hl

	jp z,SelectFileMain

	ld a,(select_y)
	cp 2
	jp z,SelectFileMain

	ld (SelectVramAdr),hl

	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	dec a
	ld e,a

	ld a,(SelectedFile)
	sub 8
	ld (SelectedFile),a

	call NewFile

	jp SelectFileMain

SelFileUp1:
	ld hl,(SelectVramAdr)
	ld de,10
	add hl,de

	push hl

	xor a
	call SetVramRead

	in a,($98)
	cp 32

	pop hl

	jp z,SelectFileMain

	ld a,(select_x)
	cp 72
	jp z,SelectFileMain

	ld (SelectVramAdr),hl

	ld a,(select_x)
	add a,10
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,(SelectedFile)
	inc a
	ld (SelectedFile),a

	call NewFile

	jp SelectFileMain

SelFileDown1:
	ld hl,(SelectVramAdr)
	ld de,-10
	add hl,de

	push hl

	xor a
	call SetVramRead

	in a,($98)
	cp 32

	pop hl

	jp z,SelectFileMain

	ld a,(select_x)
	cp 2
	jp z,SelectFileMain

	ld (SelectVramAdr),hl

	ld a,(select_x)
	sub 10
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,(SelectedFile)
	dec a
	ld (SelectedFile),a

	call NewFile

	jp SelectFileMain

NewFile:
; routine : select new file.
; in      : d - new x, e - new y pos
; out     : none.
; cmnt    : none.

	push de

	ld a,(select_x)
	ld d,a

	ld a,(select_y)
	ld e,a

	ld a,8
	call DrawBar

	pop de

	ld a,d
	ld (select_x),a
	ld a,e
	ld (select_y),a

	ld a,8
	call DrawBar

	ld hl,$9000-5
	ld de,5

	ld a,(SelectedFile)
	inc a
	ld b,a
NewFileLoop1:
	add hl,de

	djnz NewFileLoop1

	ld (Extension),hl

	ld de,FullFileName+9
	ld bc,3
	ldir



	ld hl,$8000-10
	ld de,10

	ld a,(SelectedFile)
	inc a
	ld b,a
NewFileLoop11:
	add hl,de

	djnz NewFileLoop11

	ld de,FullFileName
	ld bc,8
	ldir

	SetVW(0,16*80+67)

	ld hl,FullFileName
	ld bc,$0c98
	otir

;	ld e,(hl)
;	inc hl
;	ld d,(hl)
;
;	ex de,hl
;
;	call Calc16Dec
;
;	SetVW(0,16*80+66)
;
;	ld hl,decimal+2
;	ld bc,$0398
;	otir

	SetVW(0,18*80+49)

	ld hl,FileTypes

NewFileLoop2:
	push hl

	ld hl,(Extension)
	ex de,hl

	pop hl

	ld bc,$0300

NewFileLoop3:
	ld a,(de)

	cp (hl)
	jp nz,NewFileLoop3Done

	inc c

NewFileLoop3Done:
	inc de
	inc hl

	djnz NewFileLoop3

	ld a,c
	cp 3
	jp z,TypeFound

	ld de,30
	add hl,de

	ld a,(hl)
	or a
	jp z,EmptyDesc

	jp NewFileLoop2

EmptyDesc:
	ld hl,EmptyTypeText
TypeFound:
	ld bc,$1e98
	otir

	ret

FullFileName:
	.ds 8
	.text "."
	.ds 3

EmptyTypeText:
	.db "Unregistered filetype         "

Extension:
	.dw 0

select_x:
	.db 0
select_y:
	.db 0

SelectedFile:
	.db 0

SelectVramAdr:
	.dw 0



DoShowFiles:
	ld a,1
	ld (FoundSave),a

	ShowHint(19)

	call ClearFiles
	call ShowThem

	ClearFCB

	call MakeRightFcb

	ld de,$a000
	ld c,26
	call DoBdos

	ld de,fcb
	ld c,17
	call DoBdos

	jp c,DiskError

	or a
	jp nz,FileNotFound

	ld hl,$8000
	ld (NowRam),hl

	ld hl,$9000
	ld (NowInfo),hl

ShowFilesLoop1:
	ld hl,(NowRam)
	ex de,hl

	ld hl,$a000+1
	ld bc,8
	ldir

	ld hl,(NowInfo)
	ex de,hl

	ld hl,$a000+1+8
	ld bc,3
	ldir

	ex de,hl

	ld (hl),e
	inc hl
	ld (hl),d
	inc hl

	ld (NowInfo),hl

	ld hl,(NowRam)
	ld de,10
	add hl,de
	ld (NowRam),hl

	ShowHint(20)

	ld de,fcb
	ld c,18
	call DoBdos

	jp c,DiskError

	or a
	jp z,ShowFilesLoop1

	call ShowThem

	ld a,1
	ld (FilesOnScreen),a

	or a
	ret

DiskError:
	ld a,($f414)

	ld b,17
	cp Err_DiskOffline
	jp z,DiskErrorDone

	ld b,18
	cp Err_DiskIOError
	jp z,DiskErrorDone

	ld b,15
DiskErrorDone:
	ld a,b
	call DoShowHint

	call kilbuf
	call chget

	ShowHint(empty)

	scf
	ret

FileNotFound:
	ld a,(FileSave)
	or a
	jp nz,SaveFileNotFound

	ShowHint(16)

	call kilbuf
	call chget

	ShowHint(empty)

	xor a
	ld (FilesOnScreen),a

	scf
	ret

SaveFileNotFound:
	xor a
	ld (FoundSave),a

	or a
	ret

FileSave:
	.db 0
FoundSave:
	.db 0

FilesOnScreen:
	.db 0

ChangeFilterName:
	call ChangeFilter

	jp DiskMenuMain

ChangeFilter:
	ShowHint(54)

	ld d,18
	ld e,17
	ld a,4
	call DrawBar

	ld a,1
	ld (input_dotstop),a

	ld hl,FileName_data
	call Input_text

	ld d,18
	ld e,17
	ld a,4
	call DrawBar

	ld d,10
	ld e,17
	ld a,9
	call DrawBar

	xor a
	ld (input_dotstop),a

	ld hl,FileExt_data
	call Input_text

	ld d,10
	ld e,17
	ld a,9
	call DrawBar

	xor a
	ld (FilesOnScreen),a

	ld hl,NowFilter
	ld b,11
ChangeFilterLoop1:
	ld a,(hl)
	cp 32
	ret nz

	inc hl

	djnz ChangeFilterLoop1

	jp ChangeFilter

NowInfo:
	.dw 0

ErrorHandler:
	ld a,c
	and %00001110

	ld ($f414),a

	ld a,(PrimairPageSave)
	out ($a8),a
	ld a,(SecondarePageSave)
	ld ($ffff),a

	ld sp,(StackSave)

	scf
	ret
EndErrorHandler:

InsertHandler:
	push af

	xor a
	ld hl,22*80+1
	call InsSetVram-InsertHandler+InsertDisk
	
	ld hl,InsText-InsertHandler+InsertDisk
	ld bc,$3898
	otir

	xor a
	ld hl,22*80+23
	call InsSetVram-InsertHandler+InsertDisk

	pop af

	out ($98),a

	call chget

	xor a
	ld hl,22*80+1
	call InsSetVram-InsertHandler+InsertDisk
	
	ld hl,AnaText-InsertHandler+InsertDisk
	ld bc,$3898
	otir

	pop af

	ret

InsSetVram:
	out ($99),a					; out page to register #14 of the VDP
	ld a,14+128					;
	out ($99),a					;

	ld a,l					; Get LSB of offset
	out ($99),a					; out to VDP

	ld a,h					; Get MSB of offset

	and $3f					; clear last two bits
	or $40					; set bit 6 (write)

	out ($99),a					; iut to VDP

	ret

InsText:
;	       12345678901234567890123456789012345678901234567890123456
	.text "Insert disk for drive x: and press any key when ready..."
AnaText:
	.text "Analysing drive...                                      "

EndInsertHandler:	




DoBdos:
	in a,($a8)
	ld (PrimairPageSave),a

	ld a,($ffff)
	cpl
	ld (SecondarePageSave),a

	ld (StackSave),sp
	call bdos_call

	or a
	ret

OriginalErrHand:
	.dw 0
OriginalInsertHand:
	.ds 3

MakeRightFCB:
	ld hl,NowFilter
	ld de,FileName
	ld b,8
MakeFCBLoop1:
	ld a,(hl)
	cp 42
	jp z,MultipleNameFound

	ld (de),a

	inc hl
	inc de

	djnz MakeFCBLoop1

	jp MakeExtension

MultipleNameFound:
	ld a,63
	ld (de),a
	inc de

	djnz MultipleNameFound

MakeExtension:
	ld hl,NowFilter+8
	ld de,FileName+8
	ld b,3
MakeFCBLoop2:
	ld a,(hl)
	cp 42
	jp z,MultipleExtFound

	ld (de),a

	inc hl
	inc de

	djnz MakeFCBLoop2

	jp MakeNameDone

MultipleExtFound:
	ld a,63
	ld (de),a
	inc de

	djnz MultipleExtFound

MakeNameDone:
	ret


ClearFiles:
	xor a
	ld (FilesOnScreen),a

	ld b,112
	ld hl,$8000
ClearFilesLoop1:
	push bc

	push hl
	pop de

	inc de
	ld bc,9
	ld (hl),32
	ldir

	pop bc

	inc hl

	djnz ClearFilesLoop1

	ret

ShowThem:
	ld hl,1*80+1
	ld (NowVram),hl

	ld hl,$8000
	ld (NowRam),hl

	ld b,14
ShowThemLoop1:
	push bc

	xor a
	ld hl,(NowVram)
	call SetVramWrite

	ld hl,(NowRam)
	ld bc,$4e98
	otir

	ld hl,(NowRam)
	ld de,80
	add hl,de
	ld (NowRam),hl

	ld hl,(NowVram)
	ld de,80
	add hl,de
	ld (NowVram),hl

	pop bc

	djnz ShowThemLoop1
	
	ret

NowVram:
	.dw 0
NowRam:
	.dw 0

ShowMenu1:
	sla a
	sla a

	ld e,a
	ld d,0
	ld hl,MenuOpt
	add hl,de

	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)

	call DrawBar

	jp ShowMenuDone

ShowMenu:
; routine : New Menu option
; in      : a - new menu option
; out     : none.
; cmnt    : none.


	push af

	ld a,(NowMenu)

	sla a
	sla a

	ld e,a
	ld d,0
	ld hl,MenuOpt
	add hl,de

	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)

	call DrawBar

	pop af

	ld (NowMenu),a

	sla a
	sla a

	ld e,a
	ld d,0
	ld hl,MenuOpt
	add hl,de

	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)

	call DrawBar

ShowMenuDone:
	call ShowMenuHint

	ret

ShowMenuHint:
	ld a,(NowMenu)
	cp 2
	jp nc,ShowMenuPart2

	ld a,(WhatMenu)
	sla a
	add a,4
	ld b,a

	ld a,(NowMenu)
	add a,b

	jp DoShowHint


ShowMenuPart2:
	add a,10

	jp DoShowHint


ShowAvailableDrives:
	bdos(24)							; Get all available drives in HL

	ld d,48							; Start of available drives (on screen)
	ld e,21							;

	push hl

	ld a,l
	call ShowDrives						; Show first 8 drives

	pop hl

	ld a,h							; Show last 8 drives
ShowDrives:
	ld h,1
	ld l,a

	ld b,8
ShowDrivesLoop1:
	ld a,l
	and h
	jp z,ShowDrivesLoop1Done

	push hl
	push de
	push bc

	ld a,1
	call DrawBar

	pop bc
	pop de
	pop hl

ShowDrivesLoop1Done:
	sla h

	inc d

	djnz ShowDrivesLoop1

	ret		

ShowDrive:								; Show current drive on screen.
	SetVW(0,20*80+24)

	ld a,(CurDrive)
	add a,65
	out ($98),a

	ret

ShowNowFilter:
	SetVW(0,16*80+9)

	ld hl,NowFilter						; Show filter name
	ld bc,$0898							;
	otir								;

	ex (sp),hl
	ex (sp),hl

	ld a,46							; character '.'
	out ($98),a

	ex (sp),hl
	ex (sp),hl

	ld bc,$0398							; Show filter extension
	otir								;

	ret

NowMenu:
	.db 0
WhatMenu:
	.db 0								; What kind of disk menu?

MenuOpt:
; menu options build as follows:
;
; byte 1: y-pos of option
; byte 2: x-pos of option
; byte 3: length of option
; byte 4: empty

	.db 17,23,14,0						; Load file
	.db 18,23,14,0						; Save file
	.db 19,23,14,0						; Show files
	.db 17,38,11,0						; Delete file
	.db 18,38,11,0						; Format disk

FileExtensions:
	.text "SBP"							; Scc Blaffer nt Psg instrument
	.db 0
	.text "SBS"							; Scc Blaffer nt Scc instrument
	.db 0
	.text "SBK"							; Scc Blaffer nt instrument Kit
	.db 0
	.text "SBM"							; Scc Blaffer nt Music

FileHeaders:
;	       1234567890123456
	.text "Blaf NT PSG Ins "
	.text "Blaf NT SCC Ins "
	.text "Blaf NT Ins Kit "
	.text "Blaf NT Song    "

NrmFileFilters:
	;      12345678123 
PSGInsFilter:
	.text "PSG Instrument:     "
	.text "*       SBP"
SCCInsFilter:
	.text "SCC Instrument:     "
	.text "*       SBS"
InsKitFilter:
	.text "Instrument Kits     "
	.text "*       SBK"
SongFilter:
	.text "Songs               "
	.text "*       SBM"

AllFilesFilter:
	.text "*       *  "

NowFilter:
	.ds 11

FileName_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	.db 10,17
	.db 8
	.dw NowFilter
	.db 32,126
	.text "\"\\,./:;"
	.db 0

FileExt_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	.db 19,17
	.db 3
	.dw NowFilter+8
	.db 32,126
	.text "\"\\,./:;"
	.db 0

FileSave_data:
;		byte    1       : x-pos
;		byte    2       : y-pos
;		byte    3       : maximum length of input
;		byte 4..5       : pointer to text
;		byte    6       : minimum value of each ascii char.
;		byte    7       : maximum value of each ascii char.
;		byte 8..end - 1 : illegal characters
;		byte    end     : 0 (terminate char)

	.db 22,23
	.db 8
	.dw FileName
	.db 32,126
	.text "\"\\,./:;"
	.db 0

; registered file types:
; build as follows:
; byte 1..3  : extension
; byte 4..33 : description 

FileTypes:
	;      123123456789012345678901234567890
	.text "SBMSCC Blaffer NT Song           "
	.text "SBKSCC Blaffer NT Instrument Kit "
	.text "SBPSCC Blaffer NT PSG Instrument "
	.text "SBSSCC Blaffer NT SCC Instrument "
	.text "TSMSCC Blaffer 1.0 Song          "
	.text "TSKSCC Blaffer 1.0 Instrument Kit"
	.text "TSISCC Blaffer 1.0 Instrument    "
	.text "SNGTyfoon's SCC-MUSIXX Song      "
	.text "MUSFac SountTracker Song         "
	.text "SM1Fac SoundTracker Sample Kit(1)"
	.text "SM2Fac SoundTracker Sample Kit(2)"
	.text "MBMMoonBlaster 1.xx Song         "
	.text "MBKMoonBlaster 1.xx Sample Kit   "
	.text "MBVMoonBlaster 1.xx Instrument   "
	.text "MFMMB for MoonSound FM Song      "
	.text "MWMMB for MoonSound Wave Song    "
	.text "MWKMB for MoonSound Wave Kit     "
	.text "MWVMB for MoonSound Wave         "
	.text "XM Fasttracker 2 Module          "
	.text "IT Impulse Tracker Module        "
	.text "MODProTracker Module             "
	.text "MIDInstrument based music file   "
	.text "WAVRaw Audio file                "
	.text "S3MScream Tracker 3 Module       "
	.text "SR5Graph Saurus screen 5 picture "
	.text "SR7Graph Saurus screen 7 picture "
	.text "SR8Graph Saurus screen 8 picture "
	.text "GL5Graph Saurus screen 5 library "
	.text "GL7Graph Saurus screen 7 library "
	.text "GL8Graph Saurus screen 8 library "
	.text "PL5Graph Saurus screen 5 palette "
	.text "PL7Graph Saurus screen 7 palette "
	.text "GE5DD-Graph Picture              "
	.text "BMPWindows Bitmap image          "
	.text "PSDPhotoShop Image               "
	.text "PCXZSoft Paintbrush image        "
	.text "GIFCompuServe image              "
	.text "JPGJPEG compressed image         "
	.text "ASCASCII text file               "
	.text "TXTASCII text file               "
	.text "DOCDocument (MS Word or ASCII)   "
	.text "HTMInternet Document             "
	.text "ASMAssembler source file         "
	.text "PASPascal Source file            "
	.text "C  C Source file                 "
	.text "BASBASIC Source file             "
	.text "OBJObject file                   "
	.text "BINCompiled file                 "
	.text "COMMSX-DOS Executeable           "
	.text "EXEMS-DOS or Win '9x Executeable "
	.text "BATBatch file                    "
	.text "SYSSystem file                   "
	.text "DATData File                     "
	.text "LIBLibrary                       "
	.text "DSKDisk Image                    "
	.text "BAKBackup file                   "
	.text "PMAPmext archive file            "
	.text "LZHLHArchive file                "
	.text "ZIPZIP archive file              "
	.text "ARJARJ archive file              "
	.text "INCInclude file                  "
	.text "CFGConfiguration file            "
	.text "SEESEE (Fuzsy Logic) vX.XX file  "  
	.text "GENGEN80 source file             "

	.db 0

.end

; einde
