;z80
;TITLE 'Fast CHPUT'
;for Hi-Tech C 3.09 for MSXDOS
;........................................................................


	psect text


		linl40	equ	0f3aeh
		cursav	equ	0fbcch
		wherex	equ	0f3ddh
		wherey	equ	0f3dch
		crtcnt	equ	0f3b1h
		getpnt	equ	0f3f8h
		putpnt	equ	0f3fah
		grpflg	equ	0fca6h
		scrmod	equ	0fcafh
		cstyle	equ	0fcaah
		escflg	equ	0fca7h
		cswtch	equ	0fca9h


; void chput(c);

_chput:
	push	ix
	push	iy
	ld	a,l
	pop	iy
	pop	ix
	ret


; hoofdroutine print (kar. in A).......................................

fchput:		cp	32
		jp	c,ctrlchar	; kleiner dan spatie
		push	af
		ld	a,(escflg)	; is de esc vlag geset?
		or	a
		jp	nz,eschandle	; esc code
		ld	a,(grpflg)	; is het een graphics karakter?
		or	a
		jp	nz,grphandle	; dan verwerk dat
		call	calpos		; bereken cursorpositie
		ld	a,(invflg)	; is het inverse?
		or	a		; nee=0
		jr	z,fcnorm	; dan print normaal
		pop	af
		set	7,a		; inverse -> set bit 7
		push	af
fcnorm:		pop	af
fcprt0:		out	(98h),a		; print letter
		call	updxy		; update X en Y
		jp	exit		; klaar

; update X en Y........................................................

updxy:		ld	a,(wherex)
		inc	a
		cp	81
		jr	z,nexty		; X>80 dus volgende regel
		ld	(wherex),a	; anders gewoon invullen
		ret
nexty:		ld	a,1
		ld	(wherex),a	; x positie wordt dan 1
updy:		ld	a,(wherey)
		cp	24		; y gelijk aan aantal regels?
		jr	z,scroll	; ja, scroll up
		inc	a		; anders verhoog
filly:		ld	(wherey),a
		ret			; klaar

; scroll...............................................................

scroll:		ld	hl,80		; begin bij regel 2
		ld	a,24		; haal aantal regels
		dec	a		; -1
		ld	b,a		; zet in B (teller)
		call	scr0lp		; scroll omhoog
		jp	exit		; klaar


; scroll B regels vanaf HL omhoog......................................

scr0lp:		push	bc		; bewaar regelteller
		push	hl		; bewaar adrespointer
		ld	de,msxall	; wijst naar linebuffer
		call	setread		; stel VDP in op lezen adres HL
		ld	b,80		; lengte van 1 regel
scr1lp:		in	a,(98h)		; lees byte uit VRAM
		ld	(de),a		; plaats in buffer
		inc	de		; volgende DE
		djnz	scr1lp		; 80 keer
		pop	hl		; herstel adrespointer
		push	hl		; en sla hem weer op
		ld	bc,-80		; B=-80
		add	hl,bc		; adres = adres - regellengte
		ld	de,msxall	; wijst naar linebuffer
		call	setwrt		; stel VDP in op schrijven adres HL
		ld	b,80		; lengte van 1 regel
scr2lp:		ld	a,(de)		; lees byte uit buffer
		out	(98h),a		; schrijf naar VRAM
		inc	de		; verhoog bufferpointer
		djnz	scr2lp		; 80 keer
		pop	hl		; herstel adrespointer
		ld	bc,80		; B=+80
		add	hl,bc		; voor volgende regel
		pop	bc		; herstel regelteller
		djnz	scr0lp		; regelloop
delast:		ld	a,1		; naar begin regel
		ld	(wherex),a	; invullen
		ld	a,24		; laatste regel
		ld	(wherey),a	; invullen
		call	wisline		; wis laatste regel
		ret

; vermenigvuldig HL met 80.............................................

mult80:		add	hl,hl		; *2
		add	hl,hl		; *4
		add	hl,hl		; *8
		add	hl,hl		; *16
		ld	d,h		; DE = HL
		ld	e,l
		add	hl,hl		; *32
		add	hl,hl		; *64
		add	hl,de		; *80
		ret			; klaar

; bereken cursor positie = 80*pred(wherey)+pred(wherex.................

calpos:		ld	hl,(wherey)
		ld	h,0
		dec	hl
		call	mult80		; HL = HL * 80
		ex	de,hl		; in DE
		ld	hl,(wherex)	; HL = X
		ld	h,0
		dec	hl		; HL=Pred(X)
		add	hl,de		; plus 80 * Pred(Y)

; set write, input cursor positie in HL................................

setwrt:		xor	a
		di
		out	(99h),a
		ld	a,8eh
		out	(99h),a
		ld	a,l
		out	(99h),a
		ld	a,h
		and	3fh
		or	40h
		out	(99h),a
		ei
		ret

; set read, input positie in HL........................................

setread:	xor	a
		di
		out	(99h),a
		ld	a,8eh
		out	(99h),a
		ld	a,l
		out	(99h),a
		ld	a,h
		out	(99h),a
		and	3fh
		out	(99h),a
		ei
		ret

; verwerk control karakter.............................................

ctrlchar:	cp 1
		jr z,graphics
		cp 7
		jr z,beep
		cp 8
		jr z,backspace
		cp 9
		jr z,tabchar
		cp 10
		jp z,linefeed
		cp 11
		jp z,home
		cp 12
		jp z,cls
		cp 13
		jp z,carriage
		cp 27
		jp z,setescape
		cp 28
		jp z,right
		cp 29
		jp z,left
		cp 30
		jp z,up
		cp 31
		jp z,down
		jp ready

; graphics.............................................................

graphics:	ld	a,1
		ld	(grpflg),a
		jp	exit

; beep.................................................................

beep:		call	biep
		jp	ready
biep:		ld	iy,(0fcc0h)
		ld	ix,00c0h
		call	001ch
		ret

; backspace............................................................

backspace:	ld	a,(wherex)
		cp	1
		jp	z,ready
		dec	a
		ld	(wherex),a
		call	calpos
		ld	a,32
		out	(098h),a
		jp	ready

; tab..................................................................

tabchar:	ld	a,(wherex)	; haal X positie
		ld	b,a		; bewaar even in B
		dec	a		; min 1
		and	0f8h		; bereken tab kolom (and 248)
		add	a,9		; plus 9 (tabs v.a. 1,9,17 etc.)
		cp	80		; vergelijk met 80
		jr	c,tabcont	; kleiner, ga door
		ld	a,1		; anders carriage return
		ld	(wherex),a	; invullen
		jr	linefeed	; en volgende regel
tabcont:	push	af		; bewaar tabstop
		ld	a,b		; haal X terug
tabloop:	call	calpos		; bereken positie
		ld	a,32		; spatie
		out	(098h),a	; print
		call	updxy		; bijwerken X en Y
		pop	bc		; haal tab positie (was AF)
		ld	(wherex),a	; haal X
		cp	b		; vergelijk met B
		jp	z,ready		; als gelijk dan klaar
		push	bc		; sla tabstop weer op
		jr	tabloop		; volgende

; linefeed.............................................................

linefeed:	call	updy		; ga Y verhogen
		jp	ready

; home.................................................................

home:		ld	a,1
		ld	(wherex),a
		ld	(wherey),a
		jp	ready

; cls..................................................................

cls:		ld	iy,(0fcc0h)
		ld	ix,00c3h
		call	001ch
		jp	ready

; carriage.............................................................

carriage:	ld	a,1
		ld	(wherex),a
		jp	ready

; escape...............................................................

setescape:	ld	a,1
		ld	(escflg),a
		jp	exit

; right................................................................

right:		ld	b,80
		ld	a,(wherex)
		cp	b
		jp	z,ready		; we staan al rechts
		inc	a
		jr	fillef

; left.................................................................

left:		ld	a,(wherex)
		cp	1
		jp	z,ready		; we staan al links
		dec	a
fillef:		ld	(wherex),a
		jp	ready

; up...................................................................

up:		ld	a,(wherey)
		cp	1
		jp	z,ready		; we staan al boven
		dec	a
		jr	fildwn

; down.................................................................

down:		ld	a,(wherey)
		cp	24
		jp	z,ready		; we staan al onderaan
		inc	a
fildwn:		ld	(wherey),a
		jp	ready

; graphics handler.....................................................

grphandle:	pop	af		; haal letter
		cp	65		; vergelijk A
		jp	c,ready		; waarde te klein
		cp	95+1		; vergelijk '
		jp	nc,ready	; waarde te groot
		sub	64		; maak er een grafisch teken van
		push	af		; bewaar
		call	calpos		; bereken cursorpositie
		pop af			; herstel
		out	(98h),a		; print letter
		call	updxy		; update X en Y
		jp	ready		; klaar

; escape handler.......................................................

eschandle:	ld	a,(bytexp)
		cp	2
		jr	z,exptwo     ; x4,x5,y4,y5
		cp	3
		jp	z,expthree   ; Y-ROW-COLUMN
		pop	af
		cp	'x'
		jr	z,initwx
		cp	'y'
		jr	z,initwy
		cp	'Y'
		jr	z,inithree
		cp	'A'
		jr	z,up
		cp	'B'
		jr	z,down
		cp	'C'
		jr	z,right
		cp	'D'
		jr	z,left
		cp	'H'
		jp	z,home
		cp	'j'
		jp	z,cls
		cp	'E'
		jp	z,cls
		cp	'K'
		jp	z,clreol
		cp	'J'
		jp	z,clreos
		cp	'L'
		jp	z,insline
		cp	'l'
		jp	z,delline
		cp	'M'
		jp	z,del2line
		cp	'p'
		jr	z,initinv
		cp	'q'
		jr	z,exitinv
		jp	ready		     ; foute escape code

; initialiseer x4,x5,y4,y5.............................................

initwy:		ld	a,1
		jr	fbytxy
initwx:		xor	a
fbytxy:		ld	(csrflg),a
		ld	a,2
		ld	(bytexp),a
		jp	exit

; initialiseer locate..................................................

inithree:	ld	a,3
		ld	(bytexp),a
		jp	exit

; initialiseer/exit inverse............................................

initinv:	ld	a,(invmod)
		jr	filiinv
exitinv:	xor	a
filiinv:	ld	(invflg),a	; zet inverse flag aan/uit
		jp	ready

; verwacht 2-lettercode (x4,x5,y4,y5)..................................


exptwo:		pop	af
		cp	'5'
		jr	z,handl5
		cp	'4'
		jp	nz,ready	     ; niet toegestaan karakter
		ld	a,(csrflg)
		or	a
		jr	z,cx4
		ld	a,1		; esc-y4
		jr	cx41
cx4:		xor	a
cx41:		ld	(cstyle),a	; esc-x4
		jp	ready
handl5:		ld	a,(csrflg)
		or	a
		jr	z,cx5
		ld	a,1		; esc-y5
		jr	cx51
cx5:		xor	a		; esc-x5
cx51:		ld	(cswtch),a
		jp	ready

; cursor positionering ................................................

expthree:	ld	a,(thrcnt)	; bekijk teller
		or	a		; 0?
		jr	nz,column	; nee, kolom
		ld	a,(crtcnt)	; haal aantal regels
		inc	a		; plus 1
		ld	b,a		; in B
		pop	af		; herstel Y waarde
		sub	31		; trek offset van waarde af
		cp	b		; vergelijk crtcnt
		jp	nc,ready	; Y >= crtcnt+1 = fout
		ld	(tempy),a	; anders sla op
		ld	a,1		; zet teller op 1
		ld	(thrcnt),a	; bewaar
		jp	exit		; einde
column:		pop	af		; herstel X waarde
		sub	31		; trek offset er van af
		cp	81		; vergelijk aantal kolommen+1
		jp	nc,ready	; X >= kolommen+1, fout
		ld	(wherex),a	; anders invullen
		ld	a,(tempy)	; haal Y waarde
		ld	(wherey),a	; invullen
		jp	ready		; klaar

; clear to end of line.................................................

clreol:		call	wisline		; ga regel wissen
		jp	ready		; klaar
wisline:	ld	a,(wherex)	; huidige X positie
		ld	b,a		; in B
		ld	a,80		; schermbreedte
		sub	b		; min X
		ld	b,a		; lengte in B zetten
		inc	b		; plus 1
		call	calpos		; bereken positie
		ld	a,32		; spatie
eoloop:		out	(098h),a	; wis rest regel
		djnz	eoloop
		ret			; return

; delete line..........................................................

delline:	ld	a,1
		ld	(wherex),a
		call	wisline
		jp	ready

; delete line 2........................................................

del2line:	ld	a,(wherey)	; haal Y
		push	af		; bewaar
		ld	b,a		; ook in B
		ld	a,24		; haal schermlengte
		sub	b		; min B
		ld	b,a		; B bevat nu aantal regels
		pop	af		; haal Y
		push	af		; en bewaar weer
		ld	l,a		; zet in HL
		ld	h,0
		call	mult80		; bereken adres
		call	scr0lp		; scroll omhoog
					; (aantal regels in BC, lengte in HL)
		pop	af		; haal Y positie terug
		ld	(wherey),a	; vul in
		jp	ready		; klaar

; clear to end of screen...............................................

clreos:		ld	hl,(wherey)	; bewaar X en Y
		ld	(tempx),hl
		call	wisline		; wis huidige regel
		ld	a,1
		ld	(wherex),a	; naar begin regel
		ld	a,24		; haal aantal regels
		inc	a		; plus 1
		ld	b,a		; bewaar in B
clesloop:	ld	a,(wherey)	; haal Y positie
		inc	a		; verhoog
		cp	b		; hoger dan CRTCNT?
		jr	z,clesend	; dan klaar
		ld	(wherey),a	; anders invullen
		push	bc		; bewaar crtcnt+1
		call	wisline		; en wis regel
		pop	bc		; herstel B
		jr	clesloop	; volgende
clesend:	ld	hl,(tempx)	; haal X en Y terug
		ld	(wherey),hl	; en vul ze in.
		jp	ready		; klaar

; insert line..........................................................

insline:	ld	a,(wherey)	; haal Y positie
		push	af		; bewaar
		ld	b,a		; ook in B
		ld	a,24		; A = laatste regel
		dec	a		; min 1
		ld	l,a		; zet in HL
		ld	h,0
		sub	b		; aantal regels
		add	a,3		; plus 3
		ld	b,a		; zet in B
		push	bc		; bewaar in BC
		call	mult80		; HL - adres voorlaatste
		pop	bc		; herstel aantal regels
		call	scr0dn		; scroll B maal omlaag vanaf HL
		pop	af		; herstel wherey
		inc	a		; plus 1
		ld	a,1		; naar begin regel
		ld	(wherex),a	; invullen
		call	wisline		; wis regel
		jp	ready		; klaar

; scroll omlaag (insert line)..........................................

scr0dn:		push	bc		; bewaar aantal regels
		push	hl		; bewaar adrespointer
		ld	de,msxall	; wijst naar linebuffer
		call	setread		; stel VDP in op lezen adres HL
		ld	b,80		; lengte van 1 regel
scr1dn:		in	a,(98h)		; lees byte uit VRAM
		ld	(de),a		; plaats in buffer
		inc	de		; volgende DE
		djnz	scr1dn		; 80 keer
		pop	hl		; herstel adrespointer
		push	hl		; en bewaar weer
		ld	bc,80		; B=80
		add	hl,bc		; adres = adres + 1 regellengte
		ld	de,msxall	; wijst naar linebuffer
		call	setwrt		; stel VDP in op schrijven adres HL
		ld	b,80		; lengte van 1 regel
scr2dn:		ld	a,(de)		; lees byte uit buffer
		out	(98h),a		; schrijf naar VRAM
		inc	de		; verhoog bufferpointer
		djnz	scr2dn		; 80 keer
		pop	hl		; herstel adrespointer
		ld	bc,-80		; B=-80
		add	hl,bc		; voor voorgaande regel
		pop	bc		; herstel regelteller
		djnz	scr0dn		; regelloop
		ret

; show cursor (kopieer kar. in CURSAV).................................

shocur:		call	calpos
		ld	a,(invmod)	; inverse mode?
		or	a
		jr	nz,shoinv	;
		ld	a,(cstyle)	; stijl?
		ld	b,a		; in B
		ld	a,219		; blok cursor
		add	a,b		; indien CSTYLE=1 streep
		jr	putcur		; zet op scherm
shoinv:		ld	a,160		; cursor=spatie invers
putcur:		out	(98h),a
		ret

; kill cursor (destructief)............................................

kilcur:		call	calpos
		xor	a
		out	(98h),a
		ret

; ready (klaar of fout karakter).......................................

ready:		xor a
		ld	(grpflg),a
		ld	(csrflg),a
		ld	(escflg),a
		ld	(bytexp),a
		ld	(thrcnt),a
		ld	(tempx),a

; einde (en controle op ^S, ^Q)........................................

exit:		call	chksns
		ret	z		; geen toetsdruk=klaar
		ld	a,(hl)		; haal karakter
		cp	'S'-40h		; check ^S
		jr	z,pause		; pauzeer
		cp	'C'-40h		; check ^C
		jp	z,0		; boot
		jr	ckybuf		; anders einde via clear buffer

pause:		call	shocur		; anders toon cursor
pausel:		call	ckybuf		; wis toetsenbord buffer
		call	chksns		; controleer buffer
		jr	z,pausel	; indien leeg herhaal
		ld	a,(hl)
		cp	'Q'-40h		; check ^Q
		jr	z,pausex	; verder
		call	biep		; verkeerde toets
		jr	pausel		; naar pause loop
pausex:		call	kilcur		; wis cursor

; wis keyboard buffer..................................................

ckybuf:		ld	hl,(getpnt)	; zet bufferpointers
		ld	(putpnt),hl	; gelijk aan elkaar
		ret

; controleer op toetsdruk..............................................

chksns:		ld	hl,(putpnt)	; putpnt
		ld	a,(getpnt)	; getpnt
		sub	l		; compare
		ret

; interne variabelen...................................................

csrflg: 	defb	0	; hulpvariabele voor x4,y4,x5,y5
bytexp: 	defb	0	; aantal te verwachten bytes
thrcnt: 	defb	0	; positie in locate string
tempx:		defb	0	; tijdelijke opslag X-positie
tempy:		defb	0	; tijdelijke opslag Y-positie
invflg: 	defb	0	; inverse staat aan/uit
invmod: 	defb	0	; inverse wel/niet geinitialiseerd
msxall: 	defs	80

		end

;...(c)Pierre Gielen aug-sept/91..........................................


                                             