program msxcnv12 (input,output) ;
  {

    V1.0 Hans Otten

    first edit  23 may 1999

    last update 28 may 1999

    compile using Turbo Pascal V6

  }
  uses

    Dos, Crt, Graph;

  const

    maxrec       = 20 ;
    bufferlen    = maxrec*1024 ;
    picture_byte = $FE ;                { identification of file BSAVEd }
    maxline      = 212 ;                { 212 scanline                  }
    maxrow       = 256 ;                { 256 pixels on a line          }

  type

    filename       = string[255] ;
    buffertype     = array[1..bufferlen] of byte ;
    pixelline_type = array[1..maxrow] of byte ;

  var

   { PCX info }

    manuf,
    version,
    encoding,
    bits,
    pcx_col,
    pcx_row,
    stp_col,
    xl, yl,
    xh,yh,
    hdpi,
    vdpi,
    nr_of_planes,
    bytes_per_line : integer ;

    red_pixelline,
    green_pixelline,
    blue_pixelline  : pixelline_type ;


    r1,r2,r3,r4,
    g1,g2,g3,g4,
    b1,b2,b3,b4,
    rs,gs,bs,
    y1,y2,y3,y4,
    j,k           : integer ;    { used for conversion          }
    view          : boolean ;    { true if display on screen    }
    pcx_file,                    { output PCX 24 bit file       }
    msx_file      : file ;       { input MSX picture file       }
    pcx_name,
    msx_name      : filename ;   { MS(X)-DOS filename of picture}

    pcxbuffer : buffertype ;
    pcxrecsread,                 { actual nr of records read     }
    pcxcurrentrec : integer ;    { nr of records processed       }
    pcxbufferpos  : integer ;    { position in pcx buffer        }


    msxbuffer : buffertype ;
    msxcurrentrec,                {  nr of records processed     }
    msxbufferpos  : integer ;     { position in line             }

    line_count,
    row_count     : integer ;

procedure OpenGraph ;

  type

    ColorValue     = record
                       Rv, Gv, Bv: byte;
                     end;
    VGAPaletteType = array[0..256] of ColorValue;



  var

    r, g, b,
    vr, vg, vb  : integer ;
    color_nr : integer ;

    S: PathStr;
    Dir  : DirStr;
    Name : NameStr;
    Ext  : ExtStr;

    P : VGAPalettetype ;
    AutoDetectPointer : pointer;
    Driver, Mode : integer;
    ErrorCode : integer;

  {$F+}
  function DetectVGA256 : integer;

    var

      DetectedDriver : integer;
      SuggestedMode  : integer;

    begin
      DetectGraph(DetectedDriver, SuggestedMode);
      if (DetectedDriver = VGA) or
         (DetectedDriver = MCGA)
        then
          DetectVGA256 := 0        { Default video mode = 0 }
        else
          begin
            writeln ;
            writeln('VGA of MCGA display required') ;
            halt(1) ;
          end ;

    end; { DetectVGA256 }
    {$F-}

    procedure VGASetAllPalette (var P : VGAPaletteType) ;

      var

        Regs : Registers;

      begin

        with Regs do
          begin
            AX := $1012 ; { INT 10 subfunction 12 : fill Video DAC registers }
            BX := 0;
            CX := 256;
            ES := Seg(P);
            DX := Ofs(P);
          end;
        Intr($10, Regs);

      end ; { VGASetAllPalette }

  begin

    { try to locate VGA256.BGI on the path }
    S := FSearch('sVGA256.BGI',GetEnv('PATH'));
    if S = ''
      then
        begin
          CloseGraph ;
          WriteLn('File VGA256.BGI notr found on PATH') ;
          halt(1) ;
        end
      else
        { split filespec into directory path info for InitGraph }
        Fsplit(FExpand(S),Dir,Name,Ext) ;

    ClrScr;
    DirectVideo := false;
    AutoDetectPointer := @DetectVGA256; { Point to detection routine }
    Driver := InstallUserDriver(Name, AutoDetectPointer);
    Driver := Detect;
    InitGraph(Driver, Mode, Dir);
    ErrorCode := GraphResult;
    if ErrorCode <> grOK then
      begin
        CloseGraph ;
        Writeln('Fatal error in initialise graphics ', GraphErrorMsg(ErrorCode));
        Halt(1);
     end;

    { fill palette with gray values }
    for color_nr := 0 to 63 do
      begin
        p[color_nr].rv := color_nr ;
        p[color_nr].gv := color_nr ;
        p[color_nr].bv := color_nr ;
      end ;
    VGASetAllPalette(P);

  end ; { OpenGraph }

procedure Wait ;

  { wait until keypressed }

  var

    ch : char;
    count : word ;

  begin

    write(chr(7)) ;
    repeat
    until KeyPressed ;
    ch := ReadKey;
    if ch = #0
      then
        ch := ReadKey
    else if ch = chr(27)
      then
        begin
          CloseGraph ;
          writeln ;
          writeln('MSXCNV12 V1.0 (c) Hans Otten 1999') ;
          halt(0) ;
        end ;

  end ;  { wait }


  procedure CheckParameters ;

    { command line syntax:
         MSX12CNV pcx-file msxfile   }


  procedure ShowHelp ;

    {
      show of argument is help a screen full of information
    }

    begin

      writeln('V1.0 (c) Hans Otten 1999') ;
      writeln('') ;
      writeln('Command syntax:') ;
      writeln('') ;
      writeln('  MSXCNV12 pcx-file [msx-file]') ;
      writeln('') ;
      writeln('outputfile is MSX screen 12 full coler') ;
      writeln('') ;
      writeln('if no outputfile specified') ;
      writeln('then show pcx file in grey only') ;
      writeln('') ;
      writeln('PCX file must be 24 bit color 256x212, one plane');
      writeln('MSX12CNV help : show help') ;
      writeln('') ;

    end ; { ShowHelp }


  begin

    { say hello }
    writeln ;

    { see if help wanted }
    if (paramcount = 1) and
       ( (paramstr(1) = 'help') or (paramstr(1) = 'HELP'))
      then
        begin
          ShowHelp ;
          halt(1) ;
        end ;

    { no help, so check correct nr of arguments }
    if paramcount < 1
      then
        begin
          writeln('PCX file spec required, type MSXCNV12 help') ;
          halt(1) ;
        end
      else
        begin
          pcx_name   := paramstr(1) ;
        end ;

      view := (paramcount < 2) ;
      if not view
        then
          msx_name := paramstr(2) ;

  end ; { CheckParameters }


  procedure PutMSXByte(b : byte) ;

    begin

      if msxbufferpos = bufferlen + 1
        then
          begin
            blockwrite(msx_file,msxbuffer,bufferlen) ;
            msxbufferpos := 1 ;
          end ;

      msxbuffer[msxbufferpos] := b ;
      inc(msxbufferpos) ;

    end ; { PutMSXByte }


procedure OpenFiles ;

  {
    Turbo pascal V5 style: record size = 1
  }

  begin

    assign(pcx_file, pcx_name ) ;
    {$I-}
    reset(pcx_file,1) ;
    {$I+}
    if IOresult <> 0
    then
      begin
        if view
          then
            CloseGraph ;
        writeln ;
        writeln('File ',pcx_name, 'open error' ) ;
        halt(1) ;
      end ;
    { force buffered reading }
    pcxbufferpos := 1;
    pcxrecsread  := 0 ;

    if not view
      then
        begin
          assign(msx_file, msx_name ) ;
          {$I-}
          rewrite(msx_file,1) ;
          {$I+}
          if IOresult <> 0
            then
              begin
                writeln ;
                writeln('File ', msx_name, ' could not be created') ;
              end ;
          msxbufferpos := 1 ;
        end
      else
        OpenGraph ;

  end ; { OpenFiles }


procedure CloseFiles ;

  begin

    close(pcx_file) ;
    if not view
      then
        begin
          if msxbufferpos > 1
            then
              blockwrite(msx_file, msxbuffer, msxbufferpos -1) ;
         close(msx_file) ;
        end
      else
        CloseGraph ;

  end ; { CloseFiles }

procedure Show_statistics ;

    begin

      writeln ;
      writeln('PCX informatie ', pcx_name) ;
      writeln('') ;
      writeln('Manufacturer : ', manuf:3) ;
      writeln('Versie       : ', version:3) ;
      writeln('Encoding     : ', encoding:3) ;
      writeln('Bits/plane   : ', bits:3) ;
      writeln('Aantal rijen : ', yh:3) ;
      writeln('Aantal kol   : ', xh:3) ;
      writeln('HDPI         : ', HDPI:3) ;
      writeln('VDPI         : ', VDPI:3) ;
      writeln('Aantal planes: ', nr_of_planes:3) ;
      writeln('Bytes/line   : ', bytes_per_line:3) ;


  end ; { Show_statistics }


function Get_PCX_byte : byte ;

  { returns next char from pcx file }

  procedure get_buffer ;

    { reads next buffer from pcx file }

    begin

      pcxbufferpos := 1 ;
      pcxrecsread := 0 ;
      blockread (pcx_file, pcxbuffer, bufferlen, pcxrecsread) ;

      { was there anything left in file? }
      if pcxrecsread = 0
        then
          begin
            writeln('Unexpected end of PCX file') ;
            halt(1);
          end ;
    end ; { get_buffer }

  begin

    { anything left in current record ? }
    if pcxbufferpos > pcxrecsread
      then
        get_buffer ;
    Get_PCX_byte := pcxbuffer[pcxbufferpos] ;
    pcxbufferpos := pcxbufferpos + 1 ;

  end ; { Get_PCX_byte}


 procedure Get_PCX_header  ;

  var

    b        : byte ;
    count    : integer ;

  begin

    { read info from PCX header }
    manuf := Get_PCX_byte ;     { manufacturer  }

    version := Get_PCX_byte ;   { version       }
    encoding := Get_PCX_byte ;  { encoding      }

    bits := Get_PCX_byte ;      { bits per pixel}

    { window }
    xl := Get_PCX_byte ;
    xl := xl + (Get_PCX_byte * 256) ;
    yl := Get_PCX_byte ;
    yl := yl + Get_PCX_byte * 256 ;
    xh := Get_PCX_byte ;
    xh := xh + Get_PCX_byte * 256  ;
    yh := Get_PCX_byte ;
    yh := yh + Get_PCX_byte * 256 ;

    { HDPI en VDPI }
    hdpi := Get_PCX_byte ;
    hdpi := hdpi + (Get_PCX_byte * 256) ;
    vdpi := Get_PCX_byte ;
    vdpi := vdpi + Get_PCX_byte * 256 ;

    { skip colormap }
    for count := 1 to 48 do
      b := Get_PCX_byte ;

    { skip reserved byte }
    b := Get_PCX_byte ;

    { get nr of planes }
    nr_of_planes := Get_PCX_byte ;

    { get bytes per line }
    bytes_per_line := Get_PCX_byte ;
    bytes_per_line := bytes_per_line + 256 * Get_PCX_byte ;

    { skip rest of header }
    for count := 1 to 60 do
      b := Get_PCX_byte ;

    { check for  non-PCX or invalid PCX parameters }
    if (bits <> 8)          or
       (nr_of_planes <> 3)  or
       (manuf <> $0A)       or
       (version <> 5)       or
       (xh <> maxrow - 1)   or
       (yh <> maxline - 1)
      then
        begin
          if view
            then
              Closegraph ;
          writeln ('Invalid PCX file') ;
          Show_Statistics ;
          halt(1) ;
        end ;

  end ; { Get_PCX_HEader }


  procedure GetPCXpixelline(var pixelline : pixelline_type) ;

    { return plane line of color  }

  var

    c : byte ;
    repeat_count,
    count,
    row_counter   : integer ;

  begin { main GetPCXpixelline }

    { fill pixellines with color values }

    row_counter := 0 ;
    while row_counter < maxrow  do
      begin
        c := Get_PCX_Byte ;
        { check for repeat count: 2 msb bits set }
        if (c and $C0) = $C0
          then
            begin
            { mask off 2 msb bits }
              repeat_count := c and $3F ;
              c := Get_PCX_Byte ;
            end
          else
            repeat_count := 1 ;
         count := 1 ;
         repeat
           count := count + 1 ;
           row_counter := row_counter + 1 ;
           pixelline[row_counter] := c
         until count > repeat_count ;
      end ;

  end ; { GetPCXPixelline }


 procedure Init_MSX ;

    { write BSAVE header to MSX screen 12 file }

    begin { main Init_MSX }


      { write BSAVE-ID byte }
      putMSXbyte($FE) ;
      { write begin address }
      putMSXbyte(0) ;
      putMSXbyte(0) ;
      { write end-address }
      putMSXbyte($FF) ;
      putMSXbyte($D3) ;
      { write start address }
      putMSXbyte(0) ;
      putMSXbyte(0) ;

    end ; { Init_MSX }

  procedure GetPixellines ;

    { fill r,g,b, pixellines }

    begin

      GetPCXPixelline(red_pixelline) ;
      GetPCXPixelline(green_pixelline) ;
      GetPCXPixelline(blue_pixelline) ;

    end ; { GetPixellines }

procedure GetRGBPixel (var r,g,b : integer; row : integer) ;

  { return rgb value from current row position }

  begin

    r := red_pixelline[row]   ;
    r := r div 8 ;
    g := green_pixelline[row] ;
    g := g div 8 ;
    b := blue_pixelline[row]  ;
    b := b div 8 ;

  end ; { GetRGBPixel }

  procedure DoRGBtoYJK ;

    { return quadruple yjk values
      or display on screen }


    procedure add_video (r,g,b, row : integer ) ;

    begin
      {$R-}
      MEM[$A000:(word(line_count - 1) * 320 +
                      (row - 1 ))]  :=
                      round(0.58 * r + 1.2 * g  + 0.22 * b)
      {$R+}
    end ; { add_video }

    begin  { main DoRGBtoYJK }

      { read 4 times rgb values from pcx file div 8 }
      GetRGBpixel(r1,g1,b1, row_count    ) ;
      GetRGBpixel(r2,g2,b2, row_count + 1) ;
      GetRGBpixel(r3,g3,b3, row_count + 2) ;
      GetRGBpixel(r4,g4,b4, row_count + 3) ;

      { calculate average color }

        RS := R1 + R2 + R3 + R4  ;
        GS := G1 + G2 + G3 + G4  ;
        BS := B1 + B2 + B3 + B4  ;


      { calculate j and k }
        J := (6 * RS - GS - 4 * BS) div 32 ;
        IF J < -32
          THEN
            J := -32
          ELSE
            IF J > 31
              THEN J := 31 ;
        K := (-2 * RS + 7 * GS - 4 * BS) div 32 ;
        IF K < -32
          THEN
            K := -32
          ELSE
            IF K > 31
              THEN K := 31 ;

        { calculate Y1 .. Y4 }
        Y1 := (-6 * J - 11 * K + 16 * R1 + 16 * G1 + 20 * B1) div 57 ;
        IF Y1 < 0 THEN Y1 := 0 ELSE IF Y1 > 31 THEN Y1 := 31 ;
        Y2 := (-6 * J - 11 * K + 16 * R2 + 16 * G2 + 20 * B2) div 57 ;
        IF Y2 < 0 THEN Y2 := 0 ELSE IF Y2 > 31 THEN Y2 := 31 ;
        Y3 := (-6 * J - 11 * K + 16 * R3 + 16 * G3 + 20 * B3) div 57 ;
        IF Y3 < 0 THEN Y3 := 0 ELSE IF Y3 > 31 THEN Y3 := 31 ;
        Y4 := (-6 * J - 11 * K + 16 * R4 + 16 * G4 + 20 * B4) div 57 ;
        IF Y4 < 0 THEN Y4 := 0 ELSE IF Y4 > 31 THEN Y4 := 31 ;

        { make j and k two's complement }
        IF J < 0 THEN J := J + 64 ;
        IF K < 0 THEN K := K + 64 ;

        if view
          then
            begin
              if line_count < 201
                then
                  begin
                    add_video(r1,g1,b1,row_count    ) ;
                    add_video(r2,g2,b2,row_count + 1) ;
                    add_video(r3,g3,b3,row_count + 2) ;
                    add_video(r4,g4,b4,row_count + 3) ;
                  end
            end
          else
            { add to MSX file }
            begin
              { write 4 bytes with yjk values }
              PutMSXByte((y1 * 8) + (k and 7)) ;
              PutMSXByte((y2 * 8) + (k div 8)  ) ;
              PutMSXByte((y3 * 8) + (j and 7)) ;
              PutMSXByte((y4 * 8) + (j div 8)  ) ;
            end ;

    end ; { DoRGBtoJK }

procedure ConvertPicture ;

  begin

    OpenFiles ;
    Get_PCX_header ;
    if not view
      then
        Init_MSX ;

    for line_count := 1 to maxline do
      begin
        { get RGB pixellines }
        GetPixellines ;
        row_count := 1 ;
        while row_count < maxrow do
          begin
            { convert group of 4 pixels }
            DoRGBtoYJK ;
            row_count := row_count + 4 ;
          end ;
      end ;
    if view
      then
        wait 
      else
        writeln ('Ready') ;
    CloseFiles ;

  end ;  { ConvertPicture }


begin { main MSXCNV12 }

  writeln('MSXCNV12 V1.0 (c) Hans Otten 1999') ;
  writeln(' (type MSX12CNV HELP )') ;
  CheckParameters ;
  ConvertPicture ;

end.