
/*
	(C) Copyright by ASCII Corporation, 1989
		All rights Reserved.

	File: string.c		String Manipulate Functions

	Includes following functions
		toupper	tolower	strcat	strcmp	strcpy
		strlen	strchr	strupr	strlwr	strncat
		strncmp	strncpy
*/
#pragma	nonrec
#include <string.h>
#include <ctype.h>

char    toupper(c)
char    c;
{
    return (islower(c) ? c - 'a' + 'A' : c);
}

char    tolower(c)
char    c;
{
    return (isupper(c) ? c - 'A' + 'a' : c);
}

char    *strcat(d, s)
char    *d, *s;
{
    char    *head = d;
    while (*d)
	d++;
    while (*d++ = *s++)
	;
    return (head);
}


int     strcmp(s, t)
char    *s, *t;
{
    for (; *s == *t; s++, t++)
	if (*s == '\0')
	    return (0);
    return ((int)*s - (int)*t);
}


char    *strcpy(d, s)
char    *d, *s;
{
    char    *head = d;
    while (*d++ = *s++)
	;
    return (head);
}


size_t  strlen(s)
char    *s;
{
    char    *head = s;
    while (*s)
	s++;
    return (s - head);
}

char	*strchr(s, c)
char	*s, c;
{
	char	ch;

	while(ch = *s) {
		if(ch == c)
			return(s);
		s++;
	}
	if(c == '\0')
		return(s);
	return(NULL);
}


char	*strlwr(s)
char	*s;
{
	char	*head = s;
	while(*s = tolower(*s))
		s++;
	return(head);
}


char	*strupr(s)
char	*s;
{
	char	*head = s;
	while(*s = toupper(*s))
		s++;
	return(head);
}


char    *strncat(d, s, n)
char    *d, *s;
unsigned n;
{
	char    *head = d;
	while (*d)
		d++;
	while (n && (*d++ = *s++)) {
		n--;
	}
	return (head);
}


int     strncmp(s, t, n)
char    *s, *t;
unsigned n;
{
	while (n && (*s == *t)) {
		if (*s == '\0')
			return (0);
		n--;
		s++;
		t++;
	}
	if (n == 0)
		return (0);
	return ((int)*s - (int)*t);
}

char	*strncpy(d, s, n)
char	*d, *s;
unsigned n;
{
	char	*head = d;

	while (n && *s) {
		n--;
		*d++ = *s++;
	}
	while (n) {
		n--;
		*d++ = '\0';
	}
	return (head);
}

