/*
	(C) Copyright by ASCII Corporation, 1989
		All rights Reserved.

	File: process.c		Process Control Functions

	Includes following functions
		exit	execl	execv	_main
*/
#pragma	nonrec
#include <stdio.h>
#include <bdosfunc.h>

#define LOAD_FLAG	(*(char *)0x37)	/* valid env PROGRAM, PARAMETERS */
#define DEFFCB          0x5c		/* default FCB */
#define COMLEN          (*(char *)0x80)	/* command length */
#define COMLIN          ((char *)0x81)	/* command line */
#define TPA             0x0100
#define sizeofLOADER    45		/* size of _chai() */

#define MAXARGS         64
#define MAXCOM          128

#define	PATH_FIRST	(TINY)0	/*  set pathtop		      in _setprog() */
#define PATH_NEXT	(TINY)1	/*  get 1 path & return tail  in _setprog() */
#define	_EXT	0x10		/*  file extension specified  in _setprog() */

extern	STATUS	_whlpath();		/*  move to direct.c  */
extern	char	*_cutpath();		/*  move to stdlib.c  */

/* exit to system */
VOID    exit(code)
int     code;
{
	FILE	*fp;

	for (fp = stdin; fp < stdin + _NFILES; fp++)	/* close all file   */
		if (fp->mode)
			fclose(fp);
	_exit(code);
}


/* skip leading blanks */
char    *_skipsp(s)
char    *s;
{
	char    c;

	while ((c = *s) == ' ' || c == '\t')
		s++;
	return (s);
}


/* set an argument string to command line (for exec) */
VOID    _setarg(s)
char    *s;
{
	char *d;

	d = COMLIN + COMLEN;
	if (d < TPA && COMLEN != 0)
		*d++ = ' ';
	while (d < TPA && (*d = *s)) {
		d++;
		s++;
	}
	COMLEN = d - COMLIN;
}

/* search prog and set fullpath name in whole (for exec) */
STATUS	_setprog(prog, whole, checkp)
char	*prog;
char	whole[];	/*  ptr to 67 byte space  */
BOOL	checkp;		/*  look at PATH  */
{
	extern	char	*_p_path();

	char	fn[64];
	char	*path, *p, *term;
	TINY	flag, f1;

/*  get terminater & extension flag; make basename  */
	strcpy(fn, prog);
/* get flag & terminate point */
	*(term = _p_path(fn, &term, &flag)) = '\0';
	if (!(flag & _EXT))			/* if no ext, ext is 'COM'  */
		strcpy(term, ".com");		/*  ext not exist */
/*  File exists ?  */
	if(_whlpath(whole, fn) == OK)		/*  fn is found  */
		return(OK);
/*  serch in PATH directory  */
	if (checkp) {
		if((path = getenv("PATH")) == NULL)
			return(ERROR);
		_cutpath(PATH_FIRST, path);

		prog = fn;	/* filename with .ext */
		while (1) {
			strcpy(whole, prog);	/*  save filename.ext  */
			if ((p = _cutpath(PATH_NEXT, fn)) == NULL)
				break;		 /*  no more path directory  */
			/*  one PATH is in fn, p points tail of fn  */
			_p_path(fn, &term, &flag);   /*  get flag about '\'  */
			if ((f1 = flag & 0x1b) != 0 && f1 != 3)
				*p++ = '\\';/* if last char of path is not \  */
			/* path+filename  append filename.ext */
			prog = strcpy(p, whole);  /* prog points in fn[64] */
			if(_whlpath(whole, fn) == OK) {
				free(path);	/*  free environment PATH  */
				return(OK);
			}
		}
		free(path);	/*  free environment PATH  */
	}
	return(ERROR);
}

/* set up default FCB area for the program to be exec'ed */
char	*_deffcb(fn, fcb)
char	*fn;
char	*fcb;
{
	extern	char    *_parsefn();	/* functions in clibmac.mac */
	char	dummy;

	memset(fcb, '\0', 16);
	return (_parsefn(_skipsp(fn), fcb, &dummy));
}


/* execute! */
char    _execgo(progname, lflag)
char    *progname;
char	lflag;
{
	VOID	_chai();

	auto	char	Loader[sizeofLOADER];	/* on stack */
	FD	fd;

	if ((fd = open(progname, O_RDONLY)) == ERROR) {
		fputs("Cannot exec: ", stderr);
		fputs(progname, stderr);
		putc('\n', stderr);
	} else {
		/* relocate _chai() */
		memcpy(Loader, _chai, sizeofLOADER);
		/* let's go */
		LOAD_FLAG = lflag;
		(*(VOID (*)())Loader)(Loader, fd);
	}
}


/* prepare to call _execgo */
VOID    _exec(progname, nargs, param, checkp)
int     nargs;
char    *progname, **param;
BOOL	checkp;		/* look at PATH  */
{
	static	char    _wholepath[67] = {};/* name of program to execute */

	char	*env;
	char	lflag;

	if (_setprog(progname, _wholepath, checkp) == ERROR) {
		fputs("Cannot exec: ", stderr);
		fputs(progname, stderr);
		putc('\n', stderr);
		return;
	}
	/* set up command line arguments */
	for (COMLEN = 0; nargs; nargs--)
		_setarg(*param++);
	*(COMLIN + COMLEN) = '\0';
	lflag = '\0';
	/*  same as dos2 environment  */
	if((env = alloc(256)) != NULL) {
		strcat(strcpy(env, "PROGRAM="), _wholepath);
		putenv(env);
		strcat(strcpy(env, "PARAMETERS="), COMLIN);
		putenv(env);
		free(env);
		lflag = (char)0xff;
	}
	/* set first and second defalut FCB */
	_deffcb(_deffcb(COMLIN, DEFFCB), DEFFCB+16);
	/* flush all dirty buffers (high level I/O) */
	flushall();
	_execgo(_wholepath, lflag);
}


VOID    execl(nargs, progname, args)
int     nargs;
char    *progname, *args;
{
	if (nargs == 0) {
		fputs("execl: progname is missing", stderr);
		return;
	}
	_exec(progname, nargs - 1, &args, (BOOL)NO);
}


VOID    execlp(nargs, progname, args)
int     nargs;
char    *progname, *args;
{
	if (nargs == 0) {
		fputs("execl: progname is missing", stderr);
		return;
	}
	_exec(progname, nargs - 1, &args, (BOOL)YES);
}


VOID    execv(progname, argv)
char    *progname, **argv;
{
	int	nargs;
	char	**p;

	/* count number of arguments */
	for (p = argv, nargs = 0; *p++; nargs++)
		;
	_exec(progname, nargs, argv, (BOOL)NO);
}


VOID    execvp(progname, argv)
char    *progname, **argv;
{
	int	nargs;
	char	**p;

	/* count number of arguments */
	for (p = argv, nargs = 0; *p++; nargs++)
		;
	_exec(progname, nargs, argv, (BOOL)YES);
}


VOID    _unquote(s)
char    *s;
{
	char	*d;
	BOOL	quote;

	/* unquote quoted string in-place */
	d = s;
	if (*s == '"') {
		s++;
		quote = YES;
		while (*s) {
			switch (*s) {
				case '"':
					if (quote = !quote) /* paired quote */
						*d++ = *s;
					s++;
					break;
				case '\\':
					switch (*++s) {
						case '\0':
							break;
						case 'N':
						case 'n':
							*d++ = '\n';
							s++;
							break;
						case 'R':
						case 'r':
							*d++ = '\r';
							s++;
							break;
						defalut:
							*d++ = *s++;
							break;
					}
					break;
				default:
					*d++ = *s++;
					break;
			}
		}
		*d = '\0';
	}
}

VOID	_stdenv(fp)
FILE	*fp;
{
	BOOL	dev;
	TINY	tmode;

	fp->serial = dev = isatty(fileno(fp));
	tmode = _IOLBF;		/*  when std{in,out,prn}, Line bufferring  */
	if (fp == stderr || fp == stdaux)
		tmode = _IONBF;	/*  when std{err,aux}, No bufferring  */
	setvbuf(fp, NULL,(int)(dev? tmode:_IOFBF),(dev? SERIBUF:BUFSIZ));
}

VOID    _main()		/*  called by xmain in ck.rel  */
{
	extern	VOID	main();
	extern	VOID	_chkversion();

	int	argc;
	char	**argv;
	char	c, *d, *s, *head;
	BOOL	quoted;

	c = LOAD_FLAG;
	_chkversion();
/* set up argc and argv for main() */
	argc = 0;
	argv = (char **)alloc(sizeof(char *) * MAXARGS);
	if(c) {	/*  executed by DOS2 program  */
		argv[argc++] = getenv("PROGRAM");
		d = s = getenv("PARAMETERS");
	} else {
		argv[argc++] = "";
		d = s = alloc((int)(COMLEN + 1));
		strcpy(s, COMLIN);
	}
	while (*(s = _skipsp(s))) {
		argv[argc++] = d;
		quoted = NO;
		head = d;
		do {    /* get token */
			c = *d++ = *s++;
			if (c == '"')
				quoted = ~quoted;
		} while ((c = *s) && (quoted || (c != ' ' && c != '\t')));
		if (c)
			s++;
		*d++ = '\0';
		_unquote(head);
	}
	argv[argc] = NULL;
/* set up buffer information for std{in,out,err,aux,prn} */
	{
		FILE	*fp;
		for (fp = stdin; fp <= stdprn; fp++)
			_stdenv(fp);
	}
	main(argc, argv);
	exit(0);
}

