/*
	(C) Copyright by ASCII Corporation, 1989
		All rights Reserved.

	File: malloc.c		Storage Management Functions

	Includes following functions
		sbrk	rsvstk	free	alloc
*/
#pragma	nonrec
#include <malloc.h>

size_t  _torelance = 1000;      /* default size of stack space */

char    *sbrk(n)
size_t  n;
{
    extern  char    _endx[];    /* end of data segment's address */

    static  char    *memtop = _endx;
    char    stack[0];
    char    *temp;

    if (stack - memtop - _torelance < n)
	return (ERROR);
    temp = memtop;
    memtop += n;
    return (temp);
}

VOID    rsvstk(n)
size_t  n;
{
    _torelance = n;
}


typedef char    ALIGN;

typedef union header {
	    struct  {
		union header    *ptr;
		unsigned        size;
	    }   s;

	    ALIGN   x;
	}   HEADER;

HEADER  _base;
HEADER  *_allocp = NULL;

VOID    free(ap)
char    *ap;
{
    HEADER  *p, *q;

    p = (HEADER *)ap - 1;
    for (q = _allocp; !(q < p && p < q->s.ptr); q = q->s.ptr)
	if (q >= q->s.ptr && (q < p || p < q->s.ptr))
	    break;
    if (p + p->s.size == q->s.ptr) {
	p->s.size += q->s.ptr->s.size;
	p->s.ptr = q->s.ptr->s.ptr;
    }
    else
	p->s.ptr = q->s.ptr;
    if (q + q->s.size == p) {
	q->s.size += p->s.size;
	q->s.ptr = p->s.ptr;
    }
    else
	q->s.ptr = p;
    _allocp = q;
}

char    *alloc(nbytes)
size_t  nbytes;
{
    HEADER  *p, *q, *cp;
    int     nunits;

    nunits = 1 + (nbytes + sizeof(HEADER) - 1) / sizeof(HEADER);
    if ((q = _allocp) == NULL) {
	_base.s.ptr = _allocp = q = &_base;
	_base.s.size = 0;
    }
    for (p = q->s.ptr; ; q = p, p = p->s.ptr) {
	if (p->s.size >= nunits) {
	    if (p->s.size == nunits)
		q->s.ptr = p->s.ptr;
	    else {
		p->s.size -= nunits;
		p += p->s.size;
		p->s.size = nunits;
	    }
	    _allocp = q;
	    return ((char *)(p + 1));
	}
	if (p == _allocp) {
	    if ((cp = (HEADER *)sbrk(nunits * sizeof(HEADER))) == ERROR)
		return (NULL);
	    cp->s.size = nunits;
	    free(cp + 1);
	    p = _allocp;
	}
    }
}

