/*
	(C) Copyright by ASCII Corporation, 1989
		All rights Reserved.

	File: io.c		Low Level Input/Output Functions

	Includes following functions
		eof	isatty	getch	getche	kbhit
		sensebrk
*/
#pragma	nonrec
#include <io.h>
#include <conio.h>
#include <bdosfunc.h>

#define DUMMY	0
#define	_FDASC	0x20		/*  ascii/binary- mode		*/
#define _FDEOF	0x40		/*  ioctl  end of file bit	*/
#define	_FDDEV	0x80		/*  ioctl  device bit		*/
#define GETFDST	(TINY)0		/*  get file status		*/
#define RAWMODE	(TINY)1		/*  set ascii/binary(raw) mode	*/
#define CHKRDYI	(TINY)2		/*  check ready for input	*/
#define CHKRDYO	(TINY)3		/*  check ready for output	*/
#define GETSSIZ	(TINY)4		/*  get screen size		*/

unsigned _ioctl(fd, subfunc, stat)
FD	fd;
TINY	subfunc;
unsigned stat;
{
	XREG	r;

	r.de = stat;
	r.bc = ((unsigned)fd * 256 + (unsigned)_IOCTL);
	r.af = (unsigned)subfunc * 256;
	callxx(BDOS, &r);
	if (r.af >> 8)
		return(ERROR);
	return(r.de);	/*  see DOS2 reference manual p.197  */
}

TINY	eof(fd)
FD	fd;
{
	unsigned s;
	if ((s = _ioctl(fd, GETFDST, DUMMY)) == ERROR)
		return(ERROR);
	return((s & _FDEOF) != 0);
}

BOOL	isatty(fd)
FD	fd;
{
	unsigned s;
	if ((s = _ioctl(fd, GETFDST, DUMMY)) == ERROR)
		return(NO);
	return((s & _FDDEV) != 0);
}

#define COOKED	(TINY)0
#define RAW	(TINY)1

TINY	_rawmode(fd, mode)
FD	fd;
TINY	mode;		/*  0: cooked mode  1:raw mode  */
{
	unsigned stat;

	if ((stat = _ioctl(fd, GETFDST, DUMMY)) == ERROR || !(stat & _FDDEV))
		return(ERROR);
	if (_ioctl(fd, RAWMODE, mode ? 0 : _FDASC) == ERROR)
		return(ERROR);
	return ((stat & _FDASC) == 0);	/*  0: cooked mode  1:raw mode  */
}

TINY	_raw(fd)
FD	fd;
{
	return (_rawmode(fd, RAW));
}

TINY	_noraw(fd)
FD	fd;
{
	return (_rawmode(fd, COOKED));
}


/********************************************************/
/*                                                      */
/*              Console I/O functions                   */
/*                                                      */
/********************************************************/

char	getch()			/*  keyboard(STDIN) input		*/
{				/*  flush write buffer by yourself	*/
	return(bdos(_DIRIN));
}


char	getche()		/*  keyboard(STDIN) input with echo	*/
{				/*  flush write buffer by yourself	*/
	return(bdos(_CONIN));
}


BOOL	kbhit()
{
	return (bdos(_CONST) != 0);
}


VOID	sensebrk()
{
	bdos(_CONST);
}

