
(* GRAFISCH TESTPROGRAMMA
   Demonstreert alle grafische MSX2-mogelijkheden van MDL-LIB
   Alleen voor MSX-2   /   (C) 1988 MDL-Soft
   Laatste verbetering: 24/2/1989

   Deze ENORME procedure bestaat uit TWEE bestanden, genaamd
   GRAPTST1.PAS en GRAPTST2.PAS. Beide moeten precies achter elkaar
   geincludeerd worden. Het hoofdprogramma staat in GRAPTST2.PAS.

   Zie voor de procedure-declaratie het bestand MDLTEST.PAS, i.v.m. andere
   bibliotheekfiles die nog geincludeerd moesten worden (in een include-
   file mogen namelijk niet nog meer include-opdrachten staan). *)



var  i     : integer;
     keuze : byte;
     stop  : boolean;
     lst   : text;    { om te printen op een MSX }



Procedure Toets;
{ Procedure wacht op een toets. Als er een toets in het buffer staat,
  wordt er, om tijd te winnen, geen melding afgedrukt. Bij ^C of ^STOP
  wordt het programma afgebroken. }

Var  dummy : char;

Begin
  If not keyPressed then
    gwrite(10,204,'toets >'+#$C8 {cursor} );
  Read(KBD,Dummy);   { KBD = standaardfile KeyBoarD }
  If dummy=^C then   { ^C of ^STOP }
  Begin
    TextMode; Color(15,1,1); Beep;
    WriteLn('Grafisch programma gestopt!');
    crtExit;
    {***} HALT {***}
  End;
  FillBox(10,204, 59,211, 1); { haal melding weer weg }
End;



Procedure RandomRedefine;
{ Procedure herdefinieert alle kleuren random. }

Var i:integer;

Begin
  For i:=1 to 15 do
    DefColor(i, random(7)+1,random(7)+1,random(7)+1);
End;



(* Hier beginnen de echte demonstratie-procedures! *)


Overlay procedure Perspec_Driehoeken;
{ Deze demo tekent een serie driehoeken, in perspectief. }

  Procedure Driehoeken (kleur:integer); { binnen Perspec_Driehoeken }
  Var   j,k   : integer;  { lustellers }
        x     : array[0..3] of integer;
        y     : array[0..3] of integer;
  Const sx    : array[1..3] of integer = (6,20,12);
        sy    : array[1..3] of integer = (12,9,-6);
  Begin
    x[0]:=0; y[0]:=72;
    for k:=0 to 20 do
    Begin
      for j:=1 to 3 do
      Begin
        x[j] := (x[0]+k*sx[j])div 2 + 20 ;
        y[j] := (y[0]+k*sy[j])div 2 + 40
      End;
      Draw (x[1],y[1], x[2],y[2], kleur);
      DrawTo (x[3],y[3], kleur);
      DrawTo (x[1],y[1], kleur);
    End;
  End;

Begin  { Perspec_Driehoeken }
  ScrMode(5);
  WriteLn; WriteLn(' Driehoeken in perspectief'); WriteLn(' 256 x 212');
  For i:=1 to 20 do
    Driehoeken(random(14)+2);
  KillBuffer; Toets;
End;



Overlay procedure RandomTek;
{ Deze procedure tekent twee random sinusoiden, die onderling verbonden worden
  met een serie lijnen. }

Var f1,f2,f3    : real;
    v1,v2       : real;
    i           : real;
    x1,y1,x2,y2 : real;
    stap        : real;
    kleur       : integer;

Begin
  ScrMode(6);
  DefColor(3, 7,7,7); { wit }
  DefColor(2, random(2)+5,random(2)+5,random(2)+5);
  Color(3,1,1); ClrScr;
  Gwrite(256,204,'Random tekening   512 x 212');
  f1:=random; f2:=random; f3:=random; v1:=random; v2:=random;
  stap:=0.07+random/10; i:=0;
  While i<=12.6 do
  Begin
    x1:=40*i; y1:=(sin(2*i*f1)+1)*92*v1;
    x2:=(cos(2*i*f2+6.3*f3)+1)*256*v2; y2:=16*i;
    Draw (round(x1),round(y1), round(x2),round(y2), 2);
    i:=i+stap;
    If KeyPressed then i:=13
  End;
  Toets;
End;




Overlay procedure Ruiten;
{ Deze procedure tekent willekeurig ruiten op scherm 8. }

Var  x, y, straal, kleur1, kleur2 : integer;

Begin
  ScrMode(8); Color(255,1,1); ClrScr;
  Gwrite(100,204,'Random ruiten  256 x 212');
  stop:=false;
  While not keyPressed do
  Begin
    x:=random(256); y:=random(203); straal:=random(50);
    kleur1:=random(256); kleur2:=random(256);
    While (x-straal<0) or (x+straal>255) or (y-straal<0) or (y+straal>202) do
      straal:=straal-1;  { zorg dat de ruit niet buiten het scherm valt }
    { Teken nu de ruit }
    Draw (x-straal,y, x,y-straal, kleur1); { van links tot boven }
    DrawTo (x+straal,y, kleur1); { naar rechts }
    DrawTo (x,y+straal, kleur1); { naar onder }
    DrawTo (x-straal,y, kleur1); { naar links }
    FillShape (x,y,kleur2,kleur1); { kleur de ruit in }
  End;
  Toets;  { haal toets van keyPressed uit buffer }
End;



Overlay procedure XorTest;
{ Test het nut van de XOR logische operatie bij grafisch gebruik }

Const  geen_op = 0;
       xor_op  = 3;
Var    tabel   : array [0..250,0..4] of integer;
       i, j    : integer;  { tellers }

Begin
  { Stel een tabel met random-getallen samen, want straks moeten precies
    dezelfde getallen weer gebruikt worden }
  For i:=0 to 250 do
  Begin
    tabel [i,0]:=random(256); tabel [i,1]:=random(212);
    tabel [i,2]:=random(256); tabel [i,3]:=random(212);
    tabel [i,4]:=random(256); { kleurkode: 0..255!! }
  End;
  { Stel schermmode in en bouw scherm op }
  ScrMode(8); Color(255,0,0); GotoXY(1,1); Logical(geen_op);
  LeftTextPos:=15; { laat tekst beginnen op X-positie 15 }
  writeln;
  writeln('*** XOR-TEST ***    256 x 212');
  writeln; writeln; writeln;
  writeln('Deze afbeelding zal straks weer');
  writeln('hersteld zijn door tweemaal dezelfde');
  writeln('rechthoeken met dezelfde kleuren met');
  writeln('de XOR-operatie over elkaar heen te');
  writeln('tekenen.'); writeln; writeln;
  writeln('Als deze tekst door de war gegooid');
  writeln('is, druk dan op een toets om hem weer');
  writeln('te herstellen.');
  { Teken een leuk figuurtje }
  i:=15;
  While i<240 do
  Begin
    j:=15;
    While j<240 do
    Begin
      Draw(i,140,j,200,random(256));
      j:=j+30
    End;
    i:=i+30;
  End;
  KillBuffer; Toets; { wacht op het 'vernietigen' }
  Logical(xor_op); { xor_op is een constante met waarde 3 }
  For j:=1 to 2 do { teken 2x: 1x vernietigen, 1x tevoorschijn halen }
  Begin
    For i:=0 to 250 do
      FillBox (tabel[i,0],tabel[i,1], tabel[i,2],tabel[i,3], tabel[i,4]);
    Logical(geen_op); KillBuffer; toets; logical(xor_op);
  End;
End;


Overlay procedure Mouse_test;
 {Test in het gebruik van een muis of joystick.
  Linkerknop = continu 'Hallo!' afdrukken,
  rechterknop = van kleur veranderen.}

Const      { De definitie van het pijltje in hexadecimale vorm }
  sprite   : array[0..7] of byte = ($FE,$FC,$F8,$F8,$FC,$CE,$87,$03);

Var
  x,y      : byte;    { dit mogen geen integers zijn! Zie handleiding }
  dummy    : byte;
  tabel    : integer;
  kleur    : integer;
  muis     : boolean; { muis aanwezig? }
  snelheid : real;    { snelheid bij joystick }

Begin
  ClrScr;
  WriteLn('TEST MET DE MUIS OF DE JOYSTICK');
  WriteLn;
  WriteLn('Dit is een test in het gebruik van zowel een muis als een joystick. Sluit een');
  WriteLn('muis of een joystick aan op poort 1. Als u op een toets gedrukt hebt, komt er');
  WriteLn('een pijltje op het midden van het scherm. Dit pijltje volgt feilloos de');
  WriteLn('bewegingen van de muis en de joystick.Houdt u knop 1 ingedrukt, dan wordt op');
  WriteLn('de plaats van het pijltje continu ''Hallo!'' afgedrukt.  Beweegt u de muis');
  WriteLn('of de joystick eens terwijl u de knop ingedrukt houdt, dan geeft dat een heel');
  WriteLn('mooi effect. Als u knop 2 indrukt, wordt de kleur waarmee de tekst afgedrukt');
  WriteLn('veranderd. Probeert u ook eens, om beide knoppen tegelijkertijd ingedrukt te');
  WriteLn('houden...');      (* scroll --> *)
  WriteLn; Write('RETURN>'); ReadLn;
  { stel scherm in }
  SpriteSize(0); Color(15,1,1); ScrMode(5);
  { definieer het pijltjes-patroon }
  For dummy:=0 to 7 do
    WriteVram(PattTable+dummy,sprite[dummy]);
  { maak het pijtle afwisselend donker- en lichtblauw }
  For dummy:=0 to 3 do
    Begin
      WriteVram(ColorTable+2*dummy,5);
      WriteVram(ColorTable+2*dummy+1,7)
    End;
  x:=128; y:=106; kleur:=15; snelheid:=0;
  WriteVram(TranspTable+2,0);

  (* Test of er een muis aanwezig is *)
  { eerst een eerste keer afvragen, dan pas testen }
  dummy:=pad(12); dummy:=pad(13); dummy:=pad(14); { evt. oude bewegingen weg }
  dummy:=pad(12);
  { nu testen! als Pad(13) en Pad(14) allebei 1 zijn, dan geen muis aanwezig }
  if (pad(13)=1) and (pad(14)=1) then muis:=false else muis:=true;

  (* Beweeg de pijl met de muis of joystick *)
  Repeat
    WriteVram(TranspTable,y);   (* Zet Y-coordinaat sprite *)
    WriteVram(TranspTable+1,x); (* Zet X-coordinaat sprite *)
    If strig(1) then gWrite(x,y,'Hallo!'); { Strig() = Boolean-functie }
    If strig(3) then { verander de kleur }
      begin
        kleur:=kleur+1; if kleur>15 then kleur:=1;
        color(kleur,1,1);
      end;
    If muis then
      begin dummy:=pad(12); x:=x+pad(13); y:=y+pad(14) end
    else { geen muis: }
      if stick(1)>0 then
        begin
          dummy:=round(snelheid);
          case stick(1) of
            1: y:=y-dummy;
            2: begin x:=x+dummy; y:=y-dummy end;
            3: x:=x+dummy;
            4: begin x:=x+dummy; y:=y+dummy end;
            5: y:=y+dummy;
            6: begin x:=x-dummy; y:=y+dummy end;
            7: x:=x-dummy;
            8: begin x:=x-dummy; y:=y-dummy end
          end;
          { voer zolang er bewogen wordt de snelheid geleidelijk op }
          if snelheid<15 then snelheid:=snelheid+0.1;
        end
      else snelheid:=0;
    WaitForInt  { voor vloeiende beweging! }
  until keyPressed;  { toets ingedrukt? stoppen! }
  toets; TextMode; color(15,1,1)
end;



Overlay procedure TurtleGrafiek;
{ Tekent een turtle-grafiek. }

var zijde,groei,hoek : integer;

  { onderstaande (sub-)procedure is ook goed los te gebruiken... }
  Procedure Turtle(zijde,groei,hoek:integer);
  Begin
    While zijde<=100 do
      Begin
        ForWd(zijde); TurnLeft(hoek);
        Zijde := zijde + groei
      End;
  End;

begin
  ClrScr;
  WriteLn('TURTLE-GRAFIEK m.b.v. de LOGO-routines');
  WriteLn;
  WriteLn('Beantwoord de vragen, druk na elke vraag steeds op RETURN.');
  WriteLn
('Vervolgens zal de figuur getekend worden volgens de gegevens die u ingevoerd');
  WriteLn('hebt.'); WriteLn;
  Write('Stapgrootte begin         (ZIJDE) : '); readln(zijde);
  Write('Vergroting zijde per stap (GROEI) : '); readln(groei);
  Write('Hoek linksom per stap     (HOEK)  : '); readln(hoek);
  (* Teken de grafiek *)
  ScrMode(5); InitLogo; ShowTurtle;
  Turtle (zijde,groei,hoek);
  KillBuffer; toets; TextMode
end;


Overlay procedure VierkantSpiraal;
{ Tekent een vierkantspiraal m.b.v. de Logo-routines. }

type string80 = string[80];
var zijde,stap,hoek,tijd:integer;
    plotten,punt,tshow:boolean;
    JN:char;
    vergroting:byte;

  { een sub-procedure binnen VierkantSpiraal }
  Procedure Vierkant(zijde:integer);
  Var i    :integer;
      xpos :integer absolute $FCB3; { bevat huidige X-coordinaat (geen Logo) }
      ypos :integer absolute $FCB5; { bevat huidige Y-coordinaat (geen Logo) }

  Begin
    For i:=1 to 4 do
    Begin
      ForWd(zijde); TurnRight(90);
      If plotten=TRUE then { plotten de hap! }
      begin
        If punt=TRUE then begin write(lst,'M'); punt:=FALSE end
        else write(lst,'D');
        WriteLn(lst,vergroting*xpos, ',', -vergroting*ypos); { plot lijn }
      End;   { van 'if plotten=true' }
    End;   { for }
  End;  { sub-procedure }

  { nog een subprocedure binnen VierkantSpiraal }
  Procedure Vierkant_spiraal(zijde,stap,hoek:integer);
  Var i:integer;
  Begin
    punt:=true;
    Repeat
      Vierkant(zijde);
      TurnLeft(hoek);
      Zijde:=zijde+stap;
    Until zijde>80
  End;

  { een subfunktie binnen VierkantSpiraal }
  Function VraagJn(tekst:string80) : boolean;
  Begin
    WriteLn (tekst);
    Write ('Toets J of N: ');
    Read (KBD,jn); WriteLn(jn);
    VraagJn := (jn in ['J','j'])  { als jn='J' of 'j': VraagJn:=True }
  End;

Begin { procedure VierkantSpiraal (zonder streepje) }
  TextMode; ClrScr;
  WriteLn ('VIERKANTSPIRAAL');
  WriteLn ('---------------');
  WriteLn;
  Write ('Beginzijde: '); ReadLn(zijde);
  Write ('Zijdevergroting per vierkant: '); ReadLn(stap);
  Write ('Hoek links per vierkant: '); ReadLn(hoek);
  tijd:=0;
  If vraagJn('Moet de turtle even wachten tussen iedere stap die hij doet?')
    = true then
  Begin
    Write('Geef de wachttijd: (in milliseconden) ');
    ReadLn(tijd)
  end;
  tshow:=vraagJn('Moet de turtle zichtbaar zijn?');
  plotten:=vraagJn(
    'Wilt u de figuur uitplotten? (alleen Sony PRN-C41 of Toshiba HX-P570!)');
  If plotten=true then
  begin
    while not onLine do { printer niet gereed?! }
    begin
      Beep; Write('De printer is niet gereed!');
      For i:=1 to 25 do WaitForInt; { wacht een halve seconde }
      DelLine; { wis de regel }
      if keyPressed then exit; {om hang-ups te voorkomen...}
    end;
    rewrite(lst);  { open de printer-file }
    WriteLn(lst,char(27),'#');  { Grafische mode instellen }
    Write ('Vergrotingsfactor: (1-5) '); ReadLn(vergroting)
  end;

  (*** TEKEN DE VIERKANTSPIRAAL m.b.v. de subprocedures ***)
  Color(11,1,1); ScrMode(5); InitLogo; TurtleDelay(tijd);
  If tshow then ShowTurtle;
  Vierkant_spiraal(zijde,stap,hoek);
  If plotten then
  begin
    WriteLn(lst,'A');  { terug naar text-mode }
    close(lst)         { LST weer sluiten om alles te plotten }
  end;
  KillBuffer; Toets; ScrMode(0); Color(15,1,1);
End;


Overlay procedure Staafdiagram;
{ Tekent een prachtig 3D staafdiagram op uw scherm. }

Var gegevens  : array [1..30] of byte;
    clr : byte;
    i,x,y : integer;
    istr : string[3];
    max_waarde, aantal, balk_breedte : byte;
    een_stap : real; { byte niet nauwkeurig genoeg }
    JN : char;

Begin
  ClrScr;
  WriteLn('STAAFDIAGRAM');
  WriteLn;
  WriteLn('Met dit onderdeel kunt U een mooie drie-dimensionale staafdiagram op het scherm');
  WriteLn('zetten.');
  WriteLn('Eerst wordt u gevraagd een maximale waarde in te geven, en dan hoeveel getallen');
  WriteLn('u precies in het diagram wilt verwerken (max. 30). Daarna kunt u de getallen');
  WriteLn('gaan ingeven, waarna het diagram getekend wordt.');
  WriteLn; max_waarde:=0;                              (* scroll rechts! ==> *)
  {$I-} { I/O controle uit }
  Repeat
    Write('Maximale waarde: (6<max_waarde<141) ');
    ReadLn(max_waarde);
  Until (max_waarde<141) and (max_waarde>6) and (IOResult=0);
  aantal:=0;
  Repeat
    Write('Hoeveel getallen wilt u in het diagram verwerken?');
    ReadLn(aantal)
  Until (aantal<31) and (aantal>0) and (IOResult=0);
  WriteLn; WriteLn('INVOEREN GETALLEN'); WriteLn; WriteLn;
  For i:=1 to aantal do
  Begin
    Repeat
      Write(#30,^M, { cursor omhoog, CR } 'Geef getal ',i:2,' in: '); ClrEol;
      ReadLn(gegevens[i]);
      x:=IoResult;
      if (x<>0) or (gegevens[i]>max_waarde) then
        write(^G,'Verkeerde ingave!') else ClrEol;
    Until (x=0) and (gegevens[i]<=max_waarde)
  End;
  {$I+} { na invoeren I/O controle weer aan }
  { stel scherm in }
  ScrMode(7);
  { teken assenstelsel }
  Draw (20,10, 30,10, 15); DrawTo (30,150, 15); DrawTo (20,150, 15);
  Draw (30,150, 30,155, 15); Draw (30,150, 492,150, 15); DrawTo (492,155, 15);
  { bereken de breedte per balk }
  balk_breedte := 462 div aantal - 8;
  { bereken de hoogte per stap }
  een_stap := 140/max_waarde;
  y:=150; i:=0;
  Color(7,1,1);  { Gwrite in blauw }
  { Teken de cijfers naast de verticale as }
  While i<max_waarde do
  Begin
    Str(i:3,istr); Gwrite (0,y-3, istr);
    Draw (25,y, 35,y, 15);
    i:=i+round(max_waarde/7); y:=y-20
  End;
  { Teken de cijfers onder de horizontale as }
  For i:=0 to aantal-1 do
  Begin
    x:=30+i*(balk_breedte+8)+(balk_breedte+8) div 2 - 3;
    Str(i+1,istr); istr:=concat(istr,' ');
    Gwrite(x,157, copy(istr,1,1));
    Gwrite(x,165, copy(istr,2,1));
    Draw (x+2,148, x+2,153, 15);
  End;
  { Teken de balken }
  x:=31; DefColor (14,7,7,7); { maak kleur 14 ook wit }
  { Er wordt met twee kleurnummers gewerkt (14 en 15), omdat dat anders
    problemen geeft met FillShape, i.v.m. de randkleur-herkenning. }
  For i:=1 to aantal do
  Begin
    if clr=15 then clr:=14 else clr:=15; { wissel kleurnr., voor FillShape }
    y:=round(150-een_stap*gegevens[i]); { reken getal om naar Y-coordinaat }
    Box (x,150, x+balk_breedte,y, clr);
    FillBox (x+1,149, x+balk_breedte-1,y+1, 9);
    Draw (x,y, x+15,y-5, clr);
    DrawTo (x+15+balk_breedte, y-5, clr);
    DrawTo (x+balk_breedte,y, clr);
    Draw (x+15+balk_breedte, y-5, x+15+balk_breedte, 145, clr);
    DrawTo (x+balk_breedte, 150, clr);
    FillShape (x+balk_breedte-2,y-1, 6,clr);
    FillShape (x+balk_breedte+2,y+1, 8,clr);
    x:=x+balk_breedte+8;
  End;
  KillBuffer; Toets
End;


(* Einde bestand GRAPTST1.PAS. Voor vervolg moet u GRAPTST2.PAS
   inladen. *)
