(*

   GRAP1.PAS

   De MSX1 grafische test
   behorende bij MDLTEST.PAS

   Behoort bij MDL-LIB v2.0
   - COPYRIGHT 1989 BY MDL-SOFT -

*)


Overlay Procedure Graphic_Test_1;

var keuze:integer;
    stop:boolean;

{ Een handige hulp-procedure, ook goed
  los bruikbaar }
Procedure RamToVram
  (RAMadr,VRAMadr,lengte:integer);
Var prt:byte;
Begin
  prt:=WriteVramPort;
  WriteVram(VRAMadr,mem[RAMadr]);
  For vramadr:=1 to lengte-1 do
    Port[prt] := mem[RAMadr+vramadr];
End;

{ Nog eentje: laat alles op ScrMode(2)
  'vervlieden' (karakter-mode of niet,
  dat maakt niet uit) }
Procedure Vervlied_2;
Var i,j : integer;
Begin
  For i:=0 to 7 do
    Begin
      j:=base[11]; { kleurtabel! }
      repeat
        WriteVram(i+j,0); { op 0 zetten! }
        j:=j+8 { per beeldlijn per kar. }
      until j>base[11]+6143;
    end
end;

{ De echte demo-procedures binnen
  Graphic_Test_1 }
Procedure KleurKarakters;
var adres:integer;
    data,poort:byte;
begin
  ScrMode(2); poort:=WriteVramPort;
  { COPIEER EERST DE STANDAARDD ASCII-
    SET VAN DE BIOS NAAR VRAM, EN
    GEBRUIK EEN TEKSTBREEDTE VAN 30 }
  InitCharMode(30, 32,126);
  { VUL KLEUR-TABEL }
  WriteVram($1FFF,ReadVram($1FFF));
    { noodzakelijke eerste byte voor PORT[] }
  adres:=$2000;
  While adres<$3800 do
    begin
      Port[poort]:=$4C; { donkerbl./donkergroen }
      Port[poort]:=$42; { donkerbl./groen }
      Port[poort]:=$43; { donkerbl./lichtgroen }
      Port[poort]:=$47; { donkerbl./cyaan }
      Port[poort]:=$5D; { blauw/paars }
      Port[poort]:=$59; { blauw/lichtrood }
      Port[poort]:=$58; { blauw/rood }
      Port[poort]:=$56; { blauw/donkerrood }
      adres:=adres+8;
    end;
  WriteLn('TITEL:');
  WriteLn('-----');
  WriteLn('HOE MAAK IK EEN STUK TEKST ZO');
  WriteLn('ONLEESBAAR MOGELIJK???');
  WriteLn('-----------------------------');
  WriteLn;
  WriteLn('Als het goed is, zijn dit');
  WriteLn('nogal kleurige karakters...');
  WriteLn;
  WriteLn('En nou maar hopen dat het ook');
  WriteLn('nog een beetje leesbaar is...');
  WriteLn;
  WriteLn('Druk op RETURN');
  ReadLn;
  Vervlied_2;
  TextMode;
End;


Procedure Doolhofje;

Type sprite8 = array[0..7] of byte;
     chars   = array[0..55] of byte;

Const karakters : chars =
  ($FE,$FE,$EF,$EF,$FE,$FE,$EF,$EF,
   $18,$3C,$EC,$EC,$78,$38,$8B,$FF,
   $EE,$EE,$00,$BB,$BB,$00,$EE,$EE,
   $01,$07,$1F,$1F,$3F,$3F,$1F,$1F,
   $07,$05,$03,$01,$01,$01,$07,$0F,
   $80,$E0,$F8,$F8,$FC,$FC,$F8,$F8,
   $E0,$80,$80,$80,$80,$80,$E0,$F0);
      kleuren : chars =
  ($61,$61,$41,$41,$A1,$A1,$C1,$C1,
   $A1,$A1,$A1,$A1,$A1,$A1,$C1,$C1,
   $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,
   $C1,$C1,$C1,$C1,$C1,$C1,$C1,$C1,
   $C1,$A1,$A1,$A1,$A1,$A1,$A1,$A1,
   $C1,$C1,$C1,$C1,$C1,$C1,$C1,$C1,
   $C1,$A1,$A1,$A1,$A1,$A1,$A1,$A1);

Var i,j:integer;

  Procedure InitScreen {subprocedure!}
  (letters,clrs:chars);
  Var poort:byte;
  Begin
   InitCharMode(28, 32,126);

   { definieer nieuwe karakters }
   RamToVram(addr(letters),
     8*ord('a'),55); { 1e kar.set }
   RamToVram(addr(letters),
     2048+8*ord('a'),55); {2e kar.set}
   RamToVram(addr(letters),
     4096+8*ord('a'),55); {3e kar.set}

   RamToVram(addr(clrs),
     $2000+8*ord('a'),55);{1e klr.set}
   RamToVram(addr(clrs),
     $2000+2048+8*ord('a'),55);
   RamToVram(addr(clrs),
     $2000+4096+8*ord('a'),55);

   { maak de hoofdletters vet }
   For i:=264 to 768 do
    Begin
     j:=ReadVram(i);
     j:=j or (j shr 1);
     WriteVram(i,j);
     WriteVram(i+2048,j);
     WriteVram(i+4096,j);
    end;

    { maak de letters wit-op-blauw }
    poort:=ReadVramPort;
    For i:=0 to 2 do
     Begin
      WriteVram
      (base[11]+2048*i+264,$F4);
      For j:=265 to 768 do
        port[poort]:=$F4
     end;
  End;

Begin { doolhofje binnen Graphic_Test_1 }
 InitScreen(karakters,kleuren);
 KillBuffer;
 Writeln('"DOOLHOFJE"  VAN KARAKTERS');
 Writeln;
 Writeln(' b  |  b b   bb    b   b');
 Writeln('ccc V cccccccccccccccccccc');
 Writeln('c cb                 a   c');
 Writeln('c cccc  ccccccccccc cccc c');
 Writeln('cb          a     a a    c');
 Writeln('ccccc ccccc a cccca a  aaa');
 Writeln('a   c c df  a c     a     ');
 Writeln('a aaa c eg  a c cca a  aaa');
 Writeln('a c   ccccc a ccc a a    a');
 Writeln('a c c c           a a    a');
 Writeln('a a c ccccccccccccc cccc a');
 Writeln('a                        a');
 Writeln('cccccccccccccccccccccccccc');
 Writeln('           a');
 Writeln(' df     df aa        df df');
 Writeln(' eg  b  eg aa b  b   eg eg');
 Writeln('cccccccccccccccccccccccccc');
 Writeln;
 Writeln;
 Writeln('DRUK OP RETURN');
 ReadLn;
 Vervlied_2;
End;


Procedure Verschil_Wv_Port;
Var poort:byte;
    i,j  :integer;
    kleur:byte;

  Procedure Wait(time:integer);
  Begin
    For i:=1 to time do WaitForInt
  End;

Begin
  Color(7,1,1); ScrMode(2);
  GotoXY(3,5); WriteLn('TEST HET SNELHEIDSVERSCHIL TUSSEN');
  Write('  WRITEVRAM EN PORT[]');
  GotoXY(1,10); Color(9,1,1);
  WriteLn('Dit grafische scherm gaat straks op twee');
  WriteLn('manieren volgezet worden:met WriteVram en');
  WriteLn('met een combinatie van WriteVramPort en');
  WriteLn('het standaardarray Port[]. U zult het');
  WriteLn('verschil wel merken...');
  WriteLn; Write('RETURN>'); ReadLn;
  Color(10,1,1); ClrScr; GotoXY(10,10);
  Write('Nu eerst met WRITEVRAM:');
  Wait(50);
  GotoXY(10,12); Write('Daar gaat-ie!');
  For j:=1 to 10 do
  Begin
    kleur:=random(256);
    For i:=base[11] to base[11]+6144 do WriteVram(i,kleur);
  End;
  Wait(100); ClrScr;
  GotoXY(8,10); Write('En nu met PORT! Let op!');
  Wait(100);
  poort:=WriteVramPort;
  For j:=1 to 25 do { dit kan nu wel wat meer keer... }
  Begin
    kleur:=random(256);
    WriteVram(base[11],kleur); { eerste byte }
    For i:=1 to 6143 do port[poort]:=kleur;
  End;
  GotoXY(8,12); Write('En, was dat snel genoeg?');
  Wait(100); TextMode
end;


Procedure Parabool;

var x,y : integer;
    x1,x2 : integer;
    waarde : real;

begin
  color(15,1,1); scrmode(2);
  draw(0,95, 255,95, 3);
  for y:=-92 to 95 do
    begin
      waarde:=sqrt(sqr(25.4)-0.4*(1520-y));
      x1:=trunc((25.4+waarde)/0.2);
      x2:=trunc((25.4-waarde)/0.2);
      plot(x1,95-y, 15);
      plot(x2,95-y, 15)
    end;
  for x:=120 to 135 do
    begin
      y:=trunc(0.1*sqr(x)-25.4*x+1520);
      plot(x,95-y, 15)
    end;
  gwrite(10,40,'Parabool');
  gwrite(10,50,'RETURN>'); readln
end;


Procedure LogoTest;

var i:integer;

  Procedure Toets;
  var c:char;
  begin
    gotoxy(1,24); write('toets>');
    read(kbd,c)
  end;


  Procedure Vierkant(zijde:integer);

  var i:integer;

  Begin
    For i:=1 to 4 do
      begin
        forwd(zijde);
        turnright(90)
      end;
  end;


Begin  { van LogoTest }
  ScrMode(2); InitLogo; correction:=1.3; ShowTurtle;
  { 'correction=1.3' zorgt ervoor dat het scherm zodanig 'uitgerekt'
    wordt, dat een lijn van b.v. 45 graden ook werkelijk 45 graden
    heeft. Normaal is dat niet zo, omdat de beeldschermpuntjes breder
    zijn dan ze hoog zijn }

  { fig. 1: een ster }
  SetPosition(0,50); { 0,0 = middelpunt! }
  For i:=1 to 36 do
    Begin
      Forwd(70);
      TurnLeft(175)
    end;
  toets; clearscreen;

  { fig. 2: een vierkantspiraal }
  For i:=1 to 50 do
    Begin
      vierkant(i);
      turnleft(10)
    end;
  toets; clearscreen;

  { fig. 3: een vierkantpatroon }
  For i:=1 to 8 do
    Begin
      forwd(20);
      turnleft(45);
      vierkant(35)
    end;
  toets; clearscreen;

  { fig. 4: een spiraal }
  for i:=1 to 100 do
    begin
      forwd(i div 5);
      turnleft(20)
    end;
  toets
end { van LogoTest };

procedure PlayWithTurtle;
{               TURTLEGRAPHICS DEMO PROGRAM  Version 1.00A

                Translated from PC to MSX by MDL-soft 1989

        This program demonstrates the use of Turtlegraphics with
        TURBO PASCAL Version 3.0 in combination with MDL-LIB.
        NOTE:  You must have an MSX computer to use this program.

        PSEUDO CODE

        1.  Initialize program variables.
        2.  Play with the turtle routines.
            a.  Start with high resolution graphics (ScrMode(2)).
            b.  Read a character and manipulate the turtle until
                the user pressed <ESC> of ^C.
        3.  Reset screen to text mode and quit.

        Here is a list of the commands that this program uses:

          Function Keys:
            F1               Turns turtle to the left.
            F2               Turns turtle to the right.

          Cursor Keys:

            They point the turtle:
              Up arrow,    north
              Down arrow,  south
              Right arrow, east
              Left arrow,  west
              F6           northwest
              F7           northeast
              F8           southeast
              F9           southwest

          Alpha keys:
            0 thru 9:    Set the magnitude for speed.
                         (i.e. 0 is stop, 1 is slow, 9 is fast)
            H:           Sets video mode to High resolution (ScrMode(2)).
            M:           Sets video mode to Medium resolution (ScrMode(3)).
            P:           TOGGLE: PenUp / PenDown.
            T:           TOGGLE: Hide / show the turtle.
            C:           Changes the color (or intensity) of the lines.
            +:           Homes the turtle.
            <ESC>:       Quits the turtle demo.
}

 const
   TurtleSpeed = 100;

 type
   ToggleCommands = (PenOn, TurtleOn);

 var
   ToggleRay   : array[PenOn..TurtleOn] of boolean;
   Magnitude,              { Sets speed: 0 = stopped, 9 = fast }
   pColor,                 { Sets current palette color }
   CurentPalette: Integer; { Current Palette }

 Procedure Init;
 var  Toggle: ToggleCommands;
      i     : Integer;

 begin
   For i:=1 to 10 do
     DefKey(i,chr(27)+chr(48+i)); { define function keys }
   Magnitude := 0;  { Stopped }
   pColor    := 0;
   for Toggle := PenOn to TurtleOn do
     ToggleRay[Toggle]  := true;      { Start with all commands toggled on }
 end;

 Procedure PlayWithTurtle;

 var
   Inkey:     Char;
   FunctionKey:  Boolean;    { TRUE if a function key was pressed }

   procedure NewScreen(SetRes : char);

     procedure HiResOn;
     const
       CharHeight = 20;
     begin
       Color(15,1,1); ScrMode(2); InitLogo; Correction:=1.3;
       Box(0, 0, 255, 191-CharHeight, 15);
     end; { HiResOn }

     procedure MediumResOn;
     const
       CharHeight = 0;
     begin
       Color(15,1,1); ScrMode(3); InitLogo; Correction:=1.3;
       Box(0, 0, 255, 191-CharHeight, 15);
     end; { MediumResOn }

  begin
    case SetRes of
      'M'   : begin
                MediumResOn;
              end;
      'H'   : begin
                HiResOn;
                GoToXY(1,23);
                writeln(' SPEED: 0-9    TOGGLES: Pen,Turtle,Color');
                write  ('  TURN: F1,F2  HOME: +  RES: Hi,Med');
              end;
    end; (* case *)
    gotoxy(1,1);
    Showturtle;
    home;
    Magnitude := 0;
  end; { NewScreen }

  Function GetKey(var FunctionKey: Boolean): char;
  var ch: char;
  begin
    read(kbd,Ch);
    if (Ch = #27) AND KeyPressed Then  { it must be a function key }
    begin
      read(kbd,Ch);
      FunctionKey := true;
    end
    else FunctionKey := false;
    GetKey := Ch;
  end;


  Procedure TurtleDo(InKey : char; FunctionKey : boolean);
  const
    NorthEast = 45;
    SouthEast = 135;
    SouthWest = 225;
    NorthWest = 315;

    procedure DoFunctionCommand(FunctionKey: char);
    begin
      case FunctionKey of
        '1': TurnLeft(5);            { F1 }
        '2': TurnRight(5);           { F2 }
        '6': SetHeading(northwest);
        '7': SetHeading(northeast);
        '8': SetHeading(southeast);
        '9': SetHeading(southwest)
      end
    end { Do function command };

  begin
    If FunctionKey then DoFunctionCommand(Upcase(Inkey))
    else
    case upcase(Inkey) of
      'P': begin
             ToggleRay[PenOn] := NOT ToggleRay[PenOn];
             case ToggleRay[PenOn] of
               true  : PenDown;
               false : PenUp;
             end; (* case *)
           end;
      'T': begin
             ToggleRay[TurtleOn] := NOT ToggleRay[TurtleOn];
             case ToggleRay[TurtleOn] of
               true  : ShowTurtle;
               false : HideTurtle;
             end; (* case *)
           end;
      '+': Home;
      'C': begin
             pColor := succ(pcolor) mod 16;
             SetPenColor(pcolor);
           end;
      '0'..'9': Magnitude := Sqr(ord(inkey) - ord('0'));
      'M': NewScreen('M');       { medium resolution graphics }
      'H': NewScreen('H');       { HiRes graphics }
      #30: SetHeading(North);    { Up arrow Key    }
      #31: SetHeading(South);    { Down arrow Key  }
      #29: SetHeading(West);     { Left arrow Key  }
      #28: SetHeading(East);     { Right arrow Key }
      ^W : SetHeading(NorthEast);
      ^S : SetHeading(SouthEast);
      ^Q : SetHeading(NorthWest);
      ^A : SetHeading(SouthWest);
    end;   { case }
  end; (* TurtleDo *)

begin
  NewScreen('H');    { start with high resolution graphics }
  repeat
    TurtleDelay(TurtleSpeed);
    repeat
      if Magnitude <> 0 then forwd(Magnitude);
    until KeyPressed;
    InKey := GetKey(FunctionKey);
    TurtleDo(Inkey, FunctionKey);
  until UpCase(Inkey) in [#27, ^C];
end;  { PlayWithTurtle }


begin
  Init;
  PlayWithTurtle;
  TextMode; Color(15,1,1);
  bios($003E); { reset function keys }
end; { PlayWithTurtle }



Procedure Sounds;

(*
{$I MDLLIB.LIB}
{$I SOUNDS.LIB}
{$I VRAM2.LIB}
{$I GRAPMSX2.LIB}
*)

Var i,j:integer;


procedure delay(i:integer);
begin
  for i:=i downto 0 do waitforint
end;


begin
  ScrMode(2);
  write('Voor griezelfilms!');
  For i:=1 to 50 do
    Arc(128,170,135-random(270),random(100)+20,random(14)+2);

  resetpsg;
  tone(0,440);
  tone(1,660);
  tone(2,880);
  noise(30);
  switchsound([0,1,2],[1]);
  volume(1,7);
  effect([0,2],14,20000);
  delay(700);

  resetpsg;
  delay(50);
  tone(0,1500); noise(5);
  switchsound([0],[1,2]);
  volume(0,15); effect([1],12,5000);
  volume(2,11);
  delay(150);

  resetpsg;
  volume(0,15);
  for i:=1 to 3 do
  begin
    tone(0,1000); waitforint;
    tone(0, 500); waitforint;
    tone(0,2000); waitforint
  end;
  resetpsg;
  delay(100);
  volume(0,15); volume(1,15); volume(2,15);
  switchsound([0,1,2],[0]);
  for i:=700 downto 30 do
    begin
      color(15,1,random(14)+2);
      tone(0,i);
      tone(2,365-i shr 1);
      tone(1,730-i);
      tone(2,365+i shr 1);
      noise(i mod 32)
    end;

  resetpsg;
  delay(100);
  effect([0,1,2],0,$FFFF); {laat heen en weer-gaande toon langzaam vervlieden}
  for i:=1 to 7 do
    begin
      for j:=-4 to 4 do
        begin
          tone(0,300+j); tone(1,400+j); tone(2,600+j); delay(3)
        end;
      for j:=4 downto -4 do
        begin
          tone(0,300+j); tone(1,400+j); tone(2,600+j); delay(3)
        end
    end;
  textmode
end; {.}


begin { Graphic_Test_1 "hoofd-procedure" }
  stop:=false; sys_width0:=40; ScrMode(0);
  while stop=false do
  begin
    If sys_scrmod<>0 then scrmode(0);
    Color(15,1,1);
    WriteLn('    GRAFISCHE TEST voor MSX1 en MSX2');
    WriteLn('       Copyright 1989 by MDL-soft');
    For keuze:=1 to 40 do write('-');
    Gotoxy(7,5); Write('1. KARAKTERS MET KLEUREN...');
    Gotoxy(7,7); Write('2. DOOLHOFJE VAN KARAKTERS');
    Gotoxy(7,9); Write('3. TEST SNELHEIDSVERSCHIL VAN');
    Gotoxy(10,10); Write('WRITEVRAM EN PORT[]');
    Gotoxy(7,12); Write('4. MOOIE LOGO-FIGUREN');
    Gotoxy(7,14); Write('5. WAT LEUKE GELUIDEN');
    Gotoxy(7,16); Write('6. EEN PARABOOL');
    Gotoxy(7,18); Write('7. PLAY WITH TURTLE (PC!!)');
    Gotoxy(7,20); Write('8. EINDE PROGRAMMA');
    Gotoxy(5,23); Write('Maak a.u.b. uw keuze:');
    repeat
      keuze:=0;
      Gotoxy(26,23); ClrEol; {$I-} ReadLn(keuze) {$I+}
    until (keuze>0) or (keuze<9);
    Case keuze of
      1: Kleurkarakters;
      2: Doolhofje;
      3: Verschil_Wv_Port;
      4: LogoTest;
      5: Sounds;
      6: Parabool;
      7: PlayWithTurtle;
      8: Stop:=true;
    end;
  end; { while stop=false }
end;
