/*
   JDUMP.C
   Drukt een ANSI-tekstfile af, via het interactieadres van JANSI.TSR
*/

#include <stdio.h>
#include <memman.h>

#pragma nonrec

#define O_RDONLY 0

#define BUFSIZE 0x0800

/* #define buf(n) ((*(TINY *))0xBC00+n);  TINY *buf[BUFSIZE] */

char	tNoMemMan[] = "MemMan version 2.2 not installed\n";
char	tNoTsr[] = "JANSI.TSR not installed\n";
char	tNoFile[] = "Missing filename\nUsage: JDUMP name1 name2 ... namex\n";
char	tNotFound[] = "File not found\n";
char	tMemErr[] = "Not enough memory to allocate file buffer\n";
char	tWrongPage[] = "Data address below &H8000\n";
char	tsrName[] = "JvdM JANSI  ";

TINY	curArg = 1;

REGS	tsrReg,
	*regPnt = &tsrReg;

NAT	tsrID;


/*
   prtErr

   Print error message and exit
*/

VOID prtErr(tError)
char tError[];

{
   puts(tError);
   exit(1);
}


/*
   dumpFile

   Dump file "fileName" to JANSI
*/

VOID dumpFile(fileName)
char *fileName;

{
   FD	ansiFile;
   char *buf;
   unsigned bufLen;

   buf = 0xB800;

   if (ansiFile = open(fileName,O_RDONLY) == ERROR) prtErr(tNotFound);

   while (bufLen = read(ansiFile,buf,BUFSIZE));
      {
	 tsrReg.a  = 1;
	 tsrReg.hl = (NAT)buf;
	 tsrReg.de = (NAT)bufLen;
	 tsrCall(tsrID,regPnt);
      }
   fclose(ansiFile);
}


VOID main(argc,argv)
int argc;
char *argv[];

{
   if (argc == 1) prtErr(tNoFile);

   if (!iniChk()) prtErr(tNoMemMan);
   if (!(tsrID = getTsrID(tsrName))) prtErr(tNoTsr);

   for (curArg = 1; curArg < argc; curArg++)
      dumpFile(argv[curArg]);

   puts("Done\n");
}
