  {
    Module     : INDVMS.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : operating system dependent procedures/functions VMS

    Creation   : 5-jan-1989

    Update     : 10-jan-1989
    Update     : 08-sep-1989

    Data       : 
                 variables for QIO VMS 
                  termchan  : word_int ;
                  rstatus    : integer ;


    Procedures : 
                 Turbo Pascal emulation

                   copy(inputstring: varying[u1] of char ;
                     fieldpos, fieldLen: integer ): lstring; 
                     copies substring from fielpos with length fieldlen
                     into function result

                   ClrScr 
                     clear screen

                   GotoXY(column,row: integer 
                     positions cursor at row,column

                   Position(searchstring, targetstring) : integer
                     performs Turbo Pascal POS function

                   Upcase (char)
                     converts lowercase char to uppercase

                   val ( countstr   : string2 ; 
                         var count  : integer ;
                         var result : integer  ) ;
                     converts numeric string in countstr 
                     to integer count 
 

                 Operating system dependent

                   Get_Char ;
                     returns single character from terminal without echo

                   Space : real ;
                      returns free heap space (only for CP/M?)

                   Room : boolean 
                     returns true if enough memory available

                   GetDirectory (directory : fileptr;
                                 disk      : diskptr);
                     returns directory from diskette in
                     linked list pointed at by fileptr,
                     updates disk info in cell pointed at with diskptr

                   WriteIndexDirectory 
                     show directory of index files 

                   ResetDisks
                     resets disk system

                   Open_read(file_ident,filespec,io_result)
                     opens disk file for read, combination
                     of assign and reset. 
                     io_result = 0 if success

                   Open_write(file_ident,filespec,io_result)
                     opens disk file for write, combination
                     of assign and reset. 
                     io_result = 0 if success

                   Close_file (file_ident) ;
                     closes file, no error reporting

                   Erase(file_ident,filespec,io_result)
                     erases diskfile
                     Expects file to be open.

                   Check_Parameter
                     checks for index file specification in command line

                   Translate_Date (date1,date2: byte;
                            var day,month, year : integer ) ;
  
                     translates MS-DOS encoded date info in (date2, date1)
                     DD-MMM-YYYY format in day,month,year
                     if day = 0 then no valid date   

                   write_filerec_fail(filespec    : filespec_type ;
                                      size        : integer ;
                                      date1,date2 : byte ) : boolean ;

                      writes disk record to index database,
                      returns true if write failed   

                   write_diskrec_fail(diskname   : string3 ;
                                      totalsize  : integer ;
                            count      : integer ;
                            diskdescr  : string40 ) : boolean ;

                     writes disk record to index database,
                     returns true if write failed 



                   write_header_fail(TotalDisks : integer ) : boolean ;

                     writes header records to index database, 
                     returns true if write failed 

  }

  { variables for QIO VMS }
  termchan  : word_int ;
  rstatus   : integer ;


{ Turbo Pascal emulation }

procedure ClrScr ;

  { 
    VAX Pascal equivalent of Turbo Pascal ClrScr
    Clear screen 
  }

  begin

    write (chr(27),'[;H',chr(27),'[2J') ;

  end ; { ClrScr }

function copy(inputstring: varying[u1] of char ;
              fieldpos, fieldLen: integer ): lstring; 

 {
   emulates Turbo Pascal copy function
 }

  begin

    if fieldPos > length(inputstring) 
      then
	copy := ''
      else
        copy := substr( inputstring, fieldpos, 
			min( fieldLen, length(inputstring)-fieldpos+1 ) );
  end; { copy }

procedure GotoXY ( column,row : integer ) ;

  { 
    position cursor at row,column 
    VAX Pascal equivalent of Turbo Pascal GotoXY
  }

  begin

    write ( chr(27),'[',row:1,';',column:1,'H') ;

  end ;


function position(searchstring : varying[u1] of char ;
                  targetstring : varying[u2] of char ) : integer ;

  {
    performs Turbo Pascal POS function
    searches for first occurrance of search string in targetstring
    and returns position as function result
  }

  begin

    position := index (targetstring, searchstring) ;

  end ; { position }
  

function Upcase(lowercase: char) : char ;

  { changes character to upper case,
    build in Turbo Pascal            }

  begin

    if lowercase in ['a'..'z']
      then
        Upcase := chr( ord(lowercase) - ( ord('a') -ord('A') ) )
      else
        Upcase := lowercase ;

  end ; { Upcase }

procedure val(countstr : string2 ;
              var count,result : integer ) ;

  { 
    converts numeric string in countstr to integer in count,
    result set to 3 
  }

  begin

    count := 10 * ( ord(countstr[1]) - ord('0') ) +
                  ( ord(countstr[2]) - ord('0') ) ;
    result := 3 ;

  end ; { val }


{ operating system dependent procedures/functions }

function Get_char : char ;

  {
    Get_Char ;
    returns single character from terminal without echo
  }

  var

    result : integer ; 
    ch     : char ;

  begin

    result := $QIOW ( chan   := termchan,
                      func   := (IO$_TTYREADALL + IO$M_NOECHO) ,  
                      p1     := ch,
                      p2     := 1) ;
    get_char := ch ;

  end ; { Get_Char }

procedure Show_line(line : varying[u1] of char ) ;

  var 

    result : integer ;

  begin

    result := $QIOW ( chan   := termchan,
                      func := IO$_WRITEVBLK ,
                      p1   := line.body ,
                      p2   := line.length ) ;

  end ; { Show_line }

procedure Open_read(var file_ident : text ;
                    filespec       : filename ;
                    var io_result  : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    open (file_variable := file_ident,
          file_name     := filespec,
          organization  := sequential,
          history       := old,
          error         := continue    ) ;

    io_result := status(file_ident) ;
    if io_result = 0
      then
        begin
          reset(file_ident, error := continue) ; 
          io_result := status(file_ident) ;
        end ;

  end ; { Open_read }

procedure Open_write(var file_ident   : text ;
                     filespec     : filename ;
                     var io_result : integer ) ;
  {
    opens disk file for read, combination
    io_result = 0 if success
  }

  begin

    open (file_variable := file_ident,
          file_name     := filespec,
          organization  := sequential,
          history       := new,
          error         := continue    ) ;

    io_result := status(file_ident) ;
    if io_result = 0
      then
        begin
          rewrite(file_ident, error := continue) ; 
          io_result := status(file_ident) ;
          if io_result <= 0 
            then io_result := 0 ;
        end ;

  end ; { Open_write }

procedure Close_file(var file_ident : text ) ;
  {
    closes diskfile,
    no error reporting
  }

  begin

    close(file_ident, error := continue) ;

  end ; { Close_file }

procedure Erase_file(var file_ident : text ;
                     filespec       : filename ) ;
  {
    erases diskfile
    Expects file to be open.
  }

  begin

    close_file(file_ident) ;
    filespec := filespec + ';0' ;
    delete_file(filespec) ;

  end ; { Erase_file }

function Space : real ;

  { returns free heap space }

  begin

   space := 0.0

 end ; { Space }

function Room : boolean ;

  {
    returns true if enough memory available 
    to insert new directory information
    For VMS always true
  }

  begin

    room := true ;

 end ; { Room }

procedure ResetDisks ;

  { reset disk system, no function for VMS }

  begin

  end ; { ResetDisks }

procedure GetDirectory (directory : fileptr;
                        disk      : diskptr) ;

  {  
    returns directory from diskette in
    linked list pointed at by fileptr,
    updates disk info in cell pointed at with diskptr
    no function for VMS
  }

  begin


    with disk^ do
      begin
        totalsize := 0 ;
        count := 0  ;        
        writeln(count,ind_msg_files,ind_msg_total,totalsize,ind_msg_kbytes) ;
      end ;

  end ; { GetDirectory }

procedure WriteIndexDirectory ;

  { 
    shows directory of files with specification in name
  }

  var 

    context,
    rstatus : integer ;
    result_spec   : varying[255] of char ;

  function lib$find_file ( file_spec   : varying[u1] of char ;
                           var result_spec : varying[u2] of char ;
                           var context     : integer  ) : integer ; extern ;

  function lib$find_file_end (var context     : integer  ) : integer ; extern ;
                           

  begin

    context := 0 ;
    repeat
      rstatus := lib$find_file(ind_msg_defind,result_spec,context) ;
      if (rstatus = rms$_normal)
        then
          writeln(result_spec) 
    until (rstatus = rms$_nmf) ;
    rstatus := lib$find_file_end (context) ;

  end ; { WriteIndexDirectory }

procedure Get_commandline(var name : string20) ;

  { looks for commandline, returns in name, empty string if none }

  var

    io_result,
    status  : integer ;

  function lib$get_foreign 
    (var command : varying[u1] of char) : integer; extern ;

  begin

    status := lib$get_foreign(name) ;

  end ; { Get_Commandline }

 
procedure Translate_Date (date1,date2: byte;
                          var day,month, year : integer ) ;

  { translates MS-DOS encoded date info in (date2, date1)
    (YYYYYYYM, MMMDDDDD)
    DD-MMM-YYYY format in day,month,year
    if day = 0 then no valid date                         }
    
  var

    count : integer ;

  begin


    year  := (date2 div 2) + 1980 ;
    if odd(date2)
      then
        count := 1
      else
        count := 0 ;
    month := (date1 div 32 ) + 8 * (count) ;
    while date1 > 32 do
      date1 := date1 - 32 ;
    day := date1 ;

  end ; { Translate_date }

function write_filerec_fail(filespec    : filespec_type ;
                            size        : integer ;
                            date1,date2 : byte ) : boolean ;
  
   { writes file record to index database,
     returns true if write failed      }

  begin

    writeln(indexf,filespec,' ',size:1,
            ' ',date1:1,' ',date2:1,
            error := continue);
    write_filerec_fail := (status(indexf) > 0) ;

  end ; { write_filerec_fail }


function write_diskrec_fail(diskname   : string3 ;
                            totalsize  : integer ;
                            count      : integer ;
                            diskdescr  : string40 ) : boolean ;

   { writes disk record to index database,
     returns true if write failed      }

  begin

    writeln(indexf,diskname,totalsize:4,count:4,' ',diskdescr,
            error := continue);
    write_diskrec_fail := (status(indexf) > 0) ;

  end ; { write_diskrec_fail }


function write_header_fail(TotalDisks : integer ) : boolean ;

   { writes header records to index database,
     returns true if write failed      }


  begin

    writeln(indexf,ind_msg_progname,ind_msg_version,
            error := continue) ;
    if status(indexf) > 0
      then
        write_header_fail := true
      else
        begin
          writeln(indexf,TotalDisks:1, 
                  error := continue) ;
          write_header_fail := (status(indexf) > 0) ;
        end ;
    {$I+}

  end ; { write_header_fail }

{ end INDVMS.INC }

