  {

    Module     : INDSRCH.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : menu options new, merge, write index file

    Creation   : 5-jan-1989

    Update     :  9-jan-1989 V2.0
    Update     : 23-aug-1989 V2.1 print date
    Update     : 28-aug-1989 V2.1 print date , newline
    Update     : 11-sep-1989 V2.1 merged of INDPRNT and INDSRCH

    Data       : n.a.

    Procedures :

                 ValidFilespec ( var filespec : filename ) : boolean ;
                   read from terminal filespec DDD:name.type,
                   expand wildcards * to
                   multiple ?, allow ?
                   return false if invalid filespec
                   return true if valid or if empty answer given,
                   caller must check
                   for nonzero filespec length

                 Match(filespec : filename ; file : fileptr ) : boolean ;
                   check if filespec and file pointed at by fileptr
                   match according wildcard rules

                 SearchFile ;
                   menu option Search on File and Print on File
                   ValidFilespec
                   for all files in file list
                     if file match
                       display file

                 MatchDisk(filespec : filename ; disk : diskptr ) : boolean ;
                   check if filespec and disk pointed at by diskptr
                   match according wildcard rules

                 SearchDisk ;
                   menu option Search on Disk and Print on Disk
                   ValidFilespec
                   for all disks in list
                     if disk matches
                       for all files in file list
                         if file match
                           display file
  }

function ValidFilespec ( var filespec : filename ) : boolean ;

  {
    read from terminal filespec DDD:name.type, expand wildcards * to
    multiple ?, allow ?
    return false if invalid filespec
    return true if valid or if empty answer given, caller must check
    for nonzero filespec length
   }

  var

    last,
    wildcard,
    colon,
    dot         : integer ;
    error       : boolean ;
    diskspec,
    namespec,
    typespec    : filename ;

  begin

    writeln ;
    write(ind_msg_promptspec) ;
    readln(filespec) ;
    if length(filespec) > 0
      then
        begin
          for last := 1 to length(filespec) do
            filespec[last] := Upcase(filespec[last]);
          colon := position(ind_msg_colon,filespec) ;
          error := false ;
          if colon = 0
            then
              diskspec := ind_msg_exptype
          else if colon > length_diskname + 1
            then
              error := true
          else
            begin
              diskspec := copy(filespec,1,colon-1) ;
              filespec := copy(filespec,colon+1,length(filespec) - colon) ;
              if length(filespec) = 0
                then
                  filespec := ind_msg_multwild + ind_msg_dot +
                              ind_msg_multwild    ;
              wildcard := position(ind_msg_multwild    ,diskspec) ;
              if wildcard = length(diskspec)
                then
                  begin
                    diskspec[wildcard] := ind_msg_snglwild    ;
                    while length(diskspec) < length_diskname do
                       diskspec := diskspec + ind_msg_snglwild
                  end
              else
                if wildcard <> 0
                  then
                    error := true
              else
                while length(diskspec) < length_diskname do
                  diskspec := diskspec + ' '
            end ;

          if not error then
            begin
              dot := position(ind_msg_dot ,filespec) ;
              if dot = 0
                then
                  error := true
              else if dot > 9
                then
                  error := true
              else
                begin
                  namespec := copy(filespec,1,dot-1) ;
                  typespec := copy(filespec,dot+1,length(filespec)-dot) ;
                  if length(typespec) = 0
                    then
                      typespec := ind_msg_multwild ;
                  wildcard := position(ind_msg_multwild ,namespec) ;
                  if wildcard = length(namespec)
                    then
                      begin
                        namespec[wildcard] := ind_msg_snglwild  ;
                        while length(namespec) < length_filename do
                          namespec := namespec + ind_msg_snglwild
                      end
                    else
                      if wildcard <> 0
                        then
                          error := true
                    else
                      while length(namespec) < length_filename do
                        namespec := namespec + ' '
                end ;
            end ;

          if not error then
            begin
              last := length(typespec) ;
              if last = 0
                then
                  error := true
              else if last > length_filetype
                then
                  error := true
              else
                begin
                  wildcard := position(ind_msg_multwild ,typespec) ;
                  if wildcard = last
                    then
                      begin
                        typespec[wildcard] := ind_msg_snglwild  ;
                        while length(typespec) < length_filetype do
                          typespec := typespec + ind_msg_snglwild
                      end
                   else if wildcard <> 0
                      then
                        error := true
                   else
                     while length(typespec) < length_filetype do
                       typespec := typespec + ' '
                end ;
            end ;
          ValidFilespec := not error ;

          if not error
            then
              filespec := namespec + typespec + diskspec ;
        end
      else
        ValidFilespec := true ;

  end ; { ValidFileSpec }

function Match(filespec : filename ; matchfile : fileptr ) : boolean ;

  {
    check if filespec and file pointed at by fileptr
    match according wildcard rules
  }

  var

    equal : boolean ;
    count : integer ;

  begin

    equal := true ;
    count := 1    ;
    repeat
      if filespec[count] <> ind_msg_snglwild
        then
          equal := (filespec[count] = matchfile^.filespec[count]) ;
      count := count + 1
    until (not equal) or (count = length_filespec + 1) ;

    Match := equal

  end ; { Match }


procedure NewLine (var outfile  : text ;
                   printer      : boolean ;
                   var doorgaan : char ) ;

  { check for end of page,
    if not printer inquire continue : doorgaan = 'E' to exit }

  begin

    if printer
      then
        begin
          if linecount >= MaxLine
            then
              begin
                write(outfile,chr(FF)) ;
                writeln(outfile) ; 
                linecount := 4 ;
                page := page + 1 ;
                writeln(outfile) ;
                write(outfile,ind_msg_printhead) ;
                write(outfile,' ':52) ;
                writeln(outfile,ind_msg_printpage,page:2) ;
                writeln(outfile) ;
                writeln(outfile) ;
              end
            else
              linecount := linecount + 1
          end
        else
          begin
            if linecount >= maxscreen
              then
                begin
                  Prompt_Continue(doorgaan) ;
                  linecount := 1 ;
                end 
              else
                linecount := linecount + 1 ;
          end ;

  end ; { NewLine }


procedure Printfile(var outfile : text ; printer : boolean)  ;

  {
    menu option Search on File and Print on File
    ValidFilespec
    for all files in list
      if file match
        display file
  }

  var

    day,month,year,
    size,
    filecount : integer  ;
    f         : fileptr  ;
    filespec  : filename ;
    doorgaan  : char     ;


  begin

    repeat
      if validFilespec(filespec) and (length(filespec) > 0)
        then
          begin
            filecount := 0 ;
            if printer
              then
                linecount := Maxline
              else
                linecount := 1 ;
            doorgaan := ' ' ;
            page := 0 ;
            f := rootfile^.nextfile ; { skip dummy header }
            while (f <> filesentinel) and (doorgaan <> ind_msg_opt_exit) do
              begin
                if Match(filespec,f)
                  then
                    with f^ do
                      begin
                        Newline(outfile,printer,doorgaan) ;
                        if doorgaan <> ind_msg_opt_exit
                          then
                            begin
                              filecount := filecount + 1 ;
                              write(outfile,diskname,ind_msg_colon,
                                            filename,ind_msg_dot,filetype,
                                            '  ',size:3,ind_msg_kbytes) ;
                              if date1 > 0
                                then
                                  begin
                                    Translate_date(date1,date2,day,month,year) ;
                                    write(outfile,'  ',day:2,'-',
                                                  montht[month],'-',year:4)
                                  end ;
                              writeln(outfile) ;
                            end
                      end ;
                    f := f^.nextfile ;
              end ;
            if doorgaan <> ind_msg_opt_exit
              then
                begin
                  Newline(outfile,printer,doorgaan) ;
                  writeln(outfile) ;
                  Newline(outfile,printer,doorgaan) ;
                  writeln(outfile,ind_msg_total,ind_msg_files,filecount:4)
                end
          end
        else if length(filespec) > 0
          then
            begin
              writeln ;
              writeln(ind_msg_invspec) ;
            end ;
    until length(filespec) = 0 ;

  end ; { PrintFile }

procedure SearchFile ;

  { menu option  Search on File }

  begin

    ClrScr ;
    PrintFile(output,false) ;

  end ; { SearchFile }

function MatchDisk(filespec : filename ; disk : diskptr ) : boolean ;

  {
    check if filespec and disk pointed at by diskptr
    match according wildcard rules
  }

  var

    equal : boolean ;
    count : integer ;

  begin

    equal := true ;
    count := 1    ;
    repeat
      if filespec[count + length_filename + length_filetype] <> ind_msg_snglwild
        then
          equal := (filespec[count + length_filename + length_filetype] =
                           disk^.diskname[count]) ;
      count := count + 1
    until (not equal) or (count = length_diskname + 1) ;

    MatchDisk := equal ;

  end ; { MatchDisk }


procedure PrintDisk (var outfile : text ;
                     printer : boolean ) ;

  {
    menu option Search on Disk and Print on Disk
    ValidFilespec
    for all disks in list
      if disk matches
        for all files in file list
           if file match
             display file
  }

label 1000 ;

var d         : diskptr ;
    f         : fileptr ;
    filespec,
    diskspec  : filename ;
    totalcount,
    filecount : integer  ;
    doorgaan  : char     ;
    found     : boolean  ;
    maxonline : integer  ;

  begin


    repeat
      if not ValidFileSpec(filespec)
        then
          begin
            writeln ;
            writeln(ind_msg_invspec     ) ;
          end
      else if length(filespec) > 0
        then
          begin
            page := 0 ;
            totalcount := 0 ;
            if printer
              then
                begin
                  linecount := MaxLine ;
                  MaxOnLine := 4 ; 
                end
              else
                begin
                  linecount := 1 ;
                  MaxOnLine := MaxFilesLine ;
                end ;
            doorgaan := ' ' ;
            d := rootdisk^.nextdisk ; { skip dummy header }
            while d <> disksentinel  do
              begin
                if MatchDisk(filespec,d)
                  then
                    begin
                      with d^ do
                        begin
                          if printer and 
                             ((maxline - linecount) < ((count div 4) + 5))
                            then
                              linecount := maxline ;
                          NewLine(outfile,printer,doorgaan) ;
                          if (doorgaan = ind_msg_opt_exit) then goto 1000 ;
                          writeln(outfile,ind_msg_diskprompt,diskname,
                                  ind_msg_total,totalsize:3,ind_msg_kbytes,
                                                ' ',count:3,ind_msg_files);
                          NewLine(outfile,printer,doorgaan) ;
                          if (doorgaan = ind_msg_opt_exit) then goto 1000 ;
                          writeln(outfile,diskdescr) ;
                          NewLine(outfile,printer,doorgaan) ;
                          if (doorgaan = ind_msg_opt_exit) then goto 1000 ;
                          writeln(outfile) ;
                          diskspec := copy(filespec,1,
                                           length_filename + length_filetype) +
                                           diskname ;
                        end ;
                      f := rootfile^.nextfile ;
                      filecount := 0 ;
                      if doorgaan = ind_msg_opt_exit then goto 1000 ;
                      found := false ;
                      while f  <> filesentinel do
                        begin
                          with f^ do
                            begin
                              if Match(diskspec,f)
                                then
                                  begin
                                    found := true ;
                                    if filecount = 0
                                      then
                                        begin
                                          NewLine(outfile,printer,doorgaan) ;
                                          if doorgaan = ind_msg_opt_exit
                                            then goto 1000 ;
                                        end ;
                                    totalcount := totalcount + 1;
                                    if filecount > 0
                                      then
                                        write(outfile,' ',ind_msg_dirsep,' ');
                                    filecount := filecount + 1 ;
                                    write(outfile,filename,ind_msg_dot,
                                          filetype,' ',size:3,ind_msg_kbytes) ;
                                    if (filecount = MaxOnLine)
                                      then
                                        begin
                                          writeln(outfile) ;
                                          filecount := 0 ;
                                       end ;
                                  end ;
                            end ;
                          f := f^.nextfile ;
                        end ;
                      if filecount > 0
                        then
                           writeln(outfile) ;
                       if found
                         then
                           begin
                             NewLine(outfile,printer,doorgaan) ;
                             if doorgaan = ind_msg_opt_exit then goto 1000 ;
                             writeln(outfile) ;
                           end ;
                    end ;
                d := d^.nextdisk ;
              end ;
             NewLine(outfile,printer,doorgaan) ;
            if doorgaan = ind_msg_opt_exit then goto 1000 ;
            writeln(outfile,ind_msg_total,ind_msg_files,totalcount:4);
          end ;
1000:
   until length(filespec) = 0 ;

  end ; { PrintDisk }


procedure SearchDisk ;

  { menu option print disk }

  begin

    ClrScr ;
    PrintDisk(output,false) ;

  end ; { SearchDisk }

{ end INDSRCH.INC }
