  {

    Module     : INDFILE.INC

    Facility   : INDEX V2.1

    Author     : H.J.C. Otten

    Purpose    : menu options new, merge, write index file

    Creation   :  5-jan-1989

    Update     :  3-feb-1989
    Update     : 18-aug-1989 new record format, date
    Update     : 29-aug-1989 cleanup, read_disk/filerecord

    Data       : n.a.

    Procedures :
                  file_error
                    report file access problem 

                  AskFilename (var name : filename)
                    prompts for a filespec of an index file
                    appends type .ind if no type specified
                    shows a directory listing of index files present

                  WriteIndex
                    menu option Write index to file
                    askfilename
                    check if exist, overwrite if so requested
                    dump memory index to file and report

                  CleanIndex
                    delete whole disk and file lists
                    used by NewIndex and MergeIndex

                  Check_room
                    if not enough room report and clean index
 
                  Read_DiskRecord (d : diskptr) ;
                    reads disk record to cell pointed at by d 

                  Read_FileRecord (f : fileptr) ;
                    reads file  record to cell pointed at by f 

                  MergeFile
                    merges index file to index already in memory
                    used by MergeIndex and NewIndex
                    expects index file to be opened and positioned
                    at beginning of file
                    Check_room

                  MergeIndex
                    merges index file to index already in memory
                    askfilename
                    open file
                    mergefile
                    if not memory enough clean index
                 NewIndexFile ;
                   read new index file into memory
                   cleanindex
                   mergefile
                   read file info

                 NewIndex ;
                   menu option New index file
                   askfilename
                   newindexfile

                 HelpIndex ;
                   type paged contents of INDEX.HLP

   }


procedure open_error ;

  { report file access problem }

  begin

    writeln ;
    writeln(ind_msg_openerror) ;
   
  end ;



procedure AskFilename (var name : filename) ;

  {
   prompts for a filespec of an index file
   appends type .ind if no type specified
   shows a directory listing of index files present
  }

  var

    dot, count : integer ;

  begin

    ClrScr ;
    IndexDiskInDrive ;
    repeat
      write(ind_msg_promptindex,ind_msg_dirprompt) ;
      readln(name) ;
      if name = ind_msg_multwild
        then
          begin
            writeln ;
            writeln(ind_msg_indpresent );
            WriteIndexDirectory ;
          end
     until ( (length(name) = 0) or (name <> ind_msg_multwild) ) ;
     for count := 1 to length(name) do
       name[count] := Upcase(name[count]);
     dot := position(ind_msg_dot,name) ;
     if (length(name) > 0) and (dot = 0)
       then
         name := name + ind_msg_dot + ind_msg_indtype ;

  end ; { AskFilename }

procedure WriteIndex ;

  {
    menu option Write index to file
    askfilename
    check if exist, overwrite if so requested
    dump memory index to file and report
  }

  label 

    999,
    1000 ;
    

  var

    d          : diskptr  ;
    f          : fileptr  ;
    YesOrNo    : char     ;
    name       : filename ;
    present    : boolean  ;
    io_result,
    filecount,
    diskcount  : integer  ;

  begin

    AskFilename(name) ;
    if length(name) > 0
      then
        begin
          open_read(indexf,name,io_result) ;
          present := (io_result = 0) ;
          if present
            then
              begin
                prompt_YesOrNo(ind_msg_exfile,YesOrNo);
                if YesOrNo = ind_msg_YesChar
                  then
                    begin
                      close_file(indexf);
                      erase_file(indexf,name);
                      present := false ;
                    end
              end ;
          if present
            then
              writeln(ind_msg_notoverw)
            else
              begin
                close_file(indexf) ;
                open_write(indexf,name,io_result) ;
                if io_result <> 0
                  then
                    open_error
                   else
                     begin
                       if write_header_fail(TotalDisks)
                          then
                            goto 999 ;
                       diskcount := 0 ;
                       d := rootdisk^.nextdisk ; { skip dummy header }
                       while d <> disksentinel do
                         begin
                           diskcount := diskcount + 1 ;
                           with d^ do
                             if write_diskrec_fail(diskname,totalsize,count,
                                                   diskdescr)
                               then 
                                 goto 999 ;
                           d := d^.nextdisk ;
                         end ;
                       filecount := 0 ;
                       f := rootfile^.nextfile ;
                       while f  <> filesentinel do
                         begin
                           with f^ do
                             begin
                               filecount := filecount + 1 ;
                               if write_filerec_fail(filespec,size,date1,date2)
                                 then 
                                    goto 999 ;
                             end ;
                           f := f^.nextfile ;
                         end ;
                       writeln(ind_msg_filewrite) ;
                       saved := true ;
                     end
              end ;
          close_file(indexf) ;
          ResetDisks ;

        end ;
    goto 1000 ;     
 
999: 
    open_error ;
    close_file(indexf);
    erase_file(indexf,name);

1000:  
    ReturnToMenu ;

  end ; { WriteIndex }


procedure CleanIndex ;

  {
    delete whole disk and file lists
    used by NewIndex and MergeIndex
  }

  var

    d1,d2 : diskptr ;
    f1,f2 : fileptr ;

  begin

    d1 := rootdisk^.nextdisk ; { skip dummy header }
    while d1 <> disksentinel do
      begin
        d2 := d1^.nextdisk ;
        dispose(d1);
        d1 := d2
      end ;
    rootdisk^.nextdisk := disksentinel ;
    f1 := rootfile^.nextfile ;
    while f1 <> filesentinel do
      begin
        f2 := f1^.nextfile ;
        dispose(f1);
        f1 := f2
      end ;
    rootfile^.nextfile := filesentinel ;
    TotalDisks := 0 ;
    TotalFiles := 0 ;
    saved := true ;

  end ; { CleanIndex }


procedure Check_room ;

  { checks if room was available after inserting new info
    Reports and cleans index if not                       }


  begin

    writeln ;
    if room
      then
        begin
          writeln(ind_msg_fileread) ;
        end
      else
        begin
          writeln(ind_msg_noroom) ;
          CleanIndex ;
        end ;

  end ; { Check_room }

procedure Read_DiskRecord (d : diskptr) ;

  { reads disk record to cell pointed at by d }

  var

    dummy : char ;

  begin

    with d^ do
      begin
        readln(indexf,diskname,totalsize,count,dummy,diskdescr);
        write(ind_msg_diskprompt,diskname,ind_msg_total,' ',totalsize:1);
        writeln(ind_msg_kbytes,' ',count:1,ind_msg_files) ;
        writeln(diskdescr) ;
      end ;

  end ; { Read_DiskRecord }


procedure MergeFile ;

  {
    merges index file to index already in memory
    used by MergeIndex
    expects index file to be opened and positioned
    at beginning of file
  }

  var

    d         : diskptr ;
    f,f1,f2   : fileptr ;
    found     : boolean ;
    count,
    diskcount : integer ;

  begin

    { skip ident line }
    readln(indexf) ;
    { get nr of disk records }
    readln(indexf,diskcount) ;
    TotalDisks := TotalDisks + diskcount ;
    while (diskcount > 0) and room do
      begin
        new(d) ;
        Read_DiskRecord(d) ;
        InsertDiskInList(d,found) ;
        if found
          then
            begin
              writeln(ind_msg_overwr) ;
              DeleteWholeDisk(d,found) ;
              InsertDiskInlist(d,found)
            end ;
        diskcount := diskcount - 1
      end ;
    f2 := rootfile ;
    f1 := f2^.nextfile ;
    while not eof(indexf) and room do
      begin
        new(f) ;
        with f^ do
          begin
            for count := 1 to length_filespec do
              read(indexf,filespec[count]) ;
            readln(indexf,size,date1,date2) ;
          end ;
        TotalFiles := TotalFiles + 1 ;
        Insert_in_List(f,f1,f2) ;
      end ;
    Check_Room ; 

  end ; { MergeFile }


procedure MergeIndex ;

  {
    merges index file to index already in memory
    askfilename
    open file
    mergefile
    if not memory enough
      clean index
  }

  var

    name      : filename ;
    io_result : integer ;

  begin

    AskFilename(name) ;
    if length(name) > 0
      then
        begin
          open_read(indexf,name,io_result) ;
          if io_result = 0
            then
              begin
                writeln ;
                MergeFile ;
                mainfile := name ;
              end
            else
              open_error ;
          close_file(indexf) ;
          ReturnToMenu ;
        end ;

  end ; { MergeIndex }


procedure NewIndex ;

  {
    menu option New index file
    askfilename
    newindexfile
  }

  var

    name       : filename ;
    io_result  : integer ;

  begin

    CleanIndex ;
    MergeIndex ;
    saved := true ;
    
  end ; { NewIndex }

procedure HelpIndex ;

  {
    type paged contents of INDEX.HLP
  }

  var

    line      : string80   ;
    io_result,
    linecount,
    teller    : integer    ;
    doorgaan  : char       ;
    helpfile  : text       ;

  begin

    ClrScr ;
    doorgaan := ' ';
    linecount := 1 ;
    IndexDiskInDrive ;
    ClrScr ;
    open_read(helpfile,ind_msg_namehelpf,io_result) ;
    if io_result <> 0
      then
        begin
          open_error ;
          ReturnToMenu ;
        end
      else
        while not eof(helpfile) and (doorgaan <> ind_msg_opt_exit) do
          begin
            readln(helpfile,line);
            if length(line) > 0
              then
                begin
                  if (line[1] = chr(FF)) or (eof(helpfile))
                    then
                      begin
                        for teller := linecount to maxscreen do
                          writeln ;
                        linecount := maxscreen
                      end
                   else
                    writeln(line);
                 end
              else
                writeln ;
            linecount := linecount + 1 ;
            if linecount > maxscreen
              then
                begin
                  prompt_continue(doorgaan) ;
                  ClrScr ;
                  linecount := 1
                end
          end ;

    close_file(helpfile) ;
    
  end ; { HelpIndex }
