{ lingraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }


procedure Draw_Line(x1,y1,x2,y2: integer ;
                   lcolor : colortype) ;
                   
  { draws line between (x1,y1) and (x2,y2) in color }

  var

    i,x,y,dx,dy    : integer ;
    sx, sy, error  : integer ;
    interchange    : boolean ;

  procedure PutPoint ;

    { set pixel x,y in attribute color on screen }

    begin

      inline (
              { position at x,y of start pixel of line } 
                $ED/$4B/x/               {       LD   BC,(x)        }
                $ED/$5B/y/               {       LD   DE,(y)        }
                $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT) }
                $DD/$21/$11/$01/         {       LD   IX,MAPXYC     }
                $CD/$1C/$00/             {       CALL CALSLT        }
              { set current pixel to attribute color } 
                $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT) }
                $DD/$21/$20/$01/         {       LD   IX,SETC       }
                $CD/$1C/$00              {       CALL CALSLT        }
             ) ;

    end ;

  procedure determine_sign (var d, s : integer ) ;
  
    { s = -1, 0, 1 if d < 0, = 0, > 0 
      d made positive                 }
      
    begin
     
      if d > 0  
        then
          s := 1
      else if d = 0
        then
          s := 0
      else if d < 0
        then
          begin
            s := -1 ;
            d := - d 
          end ;
          
    end ; { determine_sign }

  begin { main line }

    { set attribute color }
    SetColor(lcolor) ;

    dx := x2 - x1 ;
    dy := y2 - y1 ;

    { make sure only pixels on screen are used }
    scale(x1,y1) ;
    scale(x2,y2) ;
    x := x1 ;
    y := y1 ;

    { horizontal lines }
    if dy = 0
      then
        begin
          y := y1 ;
          if dx < 0
            then
              swap_int(x1,x2) ;
          for x := x1 to x2 do
            PutPoint ;
        end
    { vertical lines }
    else if dx = 0
      then
        begin
          x := x1 ;
          if dy < 0
            then
              swap_int(y1,y2) ;
          for y := y1 to y2 do
            PutPoint ;
        end
    { general line }
    else
      begin
        determine_sign(dx,sx) ;
        determine_sign(dy,sy) ;
        { check if slope > 45 degrees, step by y then }
        interchange := ( dy > dx ) ;
        if interchange
          then
            swap_int(dx,dy) ;
        { initialize error term }
        error := 2*dy - dx ;
        for i := 1 to dx do
          begin
            PutPoint ;
            while (error >= 0) do
              begin
                if interchange
                  then
                    x := x + sx
                  else
                    y := y + sy ;
                error := error - 2*dx
              end ;
            if interchange
              then
                y := y + sy
              else
                x := x + sx ;
            error := error + 2*dy
          end ;
      end ;

  end ; { DrawLine }
