{ XXXXXXXX.inc, zie graphics.doc voor informatie  }
{ Graphic library voor MSX-2                      }
{ Auteur : Hans Otten 1-SEP-1989 V1.0             }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }

const

  pi    = 3.14159265  ; { for goniometric functions           }
  graphic_screen = 7  ; { MSX-2 uses graphic screen 2         }
  max_vram = $FFFF    ; { highest vram location               }
  graphic_length = 64 ; { nr of characters that fit on line   }
  char_width    = 8   ; { width of character of nr of pixels  }
  char_heigth   = 8   ; { heigth of character of nr of pixels }
  max_gx   =  511     ; { maximum values for screen 7         }
  max_gy   =  211     ;
  fill   = true       ;
  nofill = false      ;

  { logical operations  }
  lop_PSET    =  0 ;  { IMP  }
  lop_AND     =  1 ;  { AND  }
  lop_OR      =  2 ;  { OR   }
  lop_XOR     =  3 ;  { EOR  }
  lop_PRESET  =  4 ;  { NOT  }
  lop_TPSET   =  8 ;  { TIMP }
  lop_TAND    =  9 ;  { TAND }
  lop_TOR     = 10 ;  { TOR  }
  lop_TXOR    = 11 ;  { TEOR }
  lop_TPRESET = 12 ;  { TNOT }


type

  colortype = (transparant, black, medium_green, light_green,
               dark_blue, light_blue, dark_red, cyan,
               medium_red, light_red, dark_yellow, light_yellow,
               dark_green, magenta, gray, white ) ;

  grstring = string[255] ;


  sprite_size    = (sprite8, sprite16 ) ;
  sprite_magnify = (normal, double) ;

  sprite8_layout  = array[0..7] of byte ;
  sprite16_layout = array[0..31] of byte ;


var

  { used by Draw_string }
  bold     : boolean ;
  inverse  : boolean ;
  preblank : boolean ;


procedure read_vram ( address : integer ;
                      data    : byte  ) ;

  { reads data from location address in vram }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$4A/$00/         {       LD   IX,RDVRM    }
              $2A/address/             {       LD   HL,(address)}
              $3A/data/                {       LD   A,(data)    }
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { read_vram }


procedure write_vram( address : integer ;
                      data    : byte  ) ;

  { writes data to location address in vram }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$4D/$00/         {       LD   IX,WRTVRM   }
              $2A/address/             {       LD   HL,(address)}
              $3A/data/                {       LD   A,(data)    }
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { write_vram }


procedure readblock_vram(nr_bytes     : integer ;
                         address      : integer ;
                         vram_address : integer  ) ;

  { writes block of data to ram adress from location vram_address in vram }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$59/$00/         {       LD   IX,LDIRMV   }
              $ED/$4B/nr_bytes/        {       LD   BC,(nr_bytes}
              $2A/vram_address/        {       LD   HL,(vram_ad)}
              $ED/$5B/address/         {       LD   DE,(address)}
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { readblock_vram }


procedure writeblock_vram(nr_bytes     : integer ;
                          address      : integer ;
                          vram_address : integer  ) ;

  { writes block of data from ram adress to location vram_address in vram }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$5C/$00/         {       LD   IX,LDIRVM   }
              $ED/$4B/nr_bytes/        {       LD   BC,(nr_bytes}
              $2A/address/             {       LD   HL,(address)}
              $ED/$5B/vram_address/    {       LD   DE,(vram-ad)}
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { writeblock_vram }


procedure write_vdp ( vdp_data,
                      vdp_register : byte ) ;

    { write vdp_data register to vdp-register }

  begin

    inline (
              $FD/$2A/$FA/$F7/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$2D/$01/         {       LD   IX,WRTVDP    }
              $3A/vdp_data/            {       LD   A,(vdp_data) }
              $47/                     {       LD   B,A          }
              $3A/vdp_register/        {       LD   A,(vdp_reg)  }
              $4F/                     {       LD   C,A          }
              $CD/$1C/$00              {       CALL CALSLT       }
           ) ;

  end ; { write_vdp }


procedure Screen_On ;

  { makes videoram information visible on screen }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPTBL  }
              $DD/$21/$44/$00/         {       LD   IX,ENASCR   }
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { Screen_On }


procedure Screen_Off ;

  { makes videoram information not visible on screen }

  begin

    inline (
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$41/$00/         {       LD   IX,DISSCR   }
              $CD/$1C/$00              {       CALL CALSLT      }
           ) ;

  end ; { Screen_On }


procedure Setcolor (scolor : colortype ) ;

  { set color for SETC }


  begin

    inline (
            { set attribute color }
              $3A/scolor/              {       LD   A,(scolor)}
              $FD/$2A/$C1/$FC/         {       LD   IY,(EXPT) }
              $DD/$21/$1A/$01/         {       LD   IX,SETATR }
              $CD/$1C/$00              {       CALL CALSLT    }
           ) ;
  end ; { SetColor }


procedure Clear_screen ;

  {  clears screen in Text and Graph mode }

  begin

    inline (
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1) }
              $DD/$21/$15/$10/         {       LD   IX,CLS        }
            { set (undocumented carry }
              $97/                     {       SUB  A             }
              $CD/$1C/$00              {       CALL CALSLT        }
           ) ;

  end ; { Clear_Screen }


function Get_Screen: integer ;

  { returns value of current screen [0..8] }

  VAR val: byte;

  begin

    inline (
            { load system variable CRMOD }
              $3A/$AF/$FC/             {       LD   A,(SCRMOD)}
              $32/val                  {       LD   (val),A   }
           ) ;
    get_screen:=val;

  end ; { get_screen }


procedure Set_Screen (screen_nr : byte) ;

   { changes display mode to value specified in nr.        }

  begin

    inline (
            { load system variable SCRMOD }
              $3A/screen_nr/           {       LD   A,(nr)       }
              $32/$AF/$FC/             {       LD   (SCRMOD),A   }
            { change current screen to screen in SCRMOD }
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$D1/$00/         {       LD   IX,CHGMOD    }
              $CD/$1C/$00);            {       CALL CALSLT       }

  end ; { set_screen }


procedure Color (foreground : colortype) ;

  { changes foreground color }

  begin

    inline (
            { load system variable FORCLR (foreground color) }
              $21/$E9/$F3/             {       LD   HL,FORCLR    }
              $3A/foreground/          {       LD   A,(fore)     }
              $77/                     {       LD   (HL),A       }
            { change current colors to system variables }
              $3A/$AF/$FC/             {       LD   A,(SCRMOD)   }
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$11/$01/         {       LD   IX,CHGCLR    }
              $CD/$1C/$00              {       CALL CALSLT       }
           ) ;

  end ; { Color }


procedure BackgroundColor(background : colortype) ;

  { changes colors background and border }

  begin

    inline (
            { load system variable BAKCLR (background color) }
              $21/$EA/$F3/             {       LD   HL,BAKCLR }
              $3A/background/          {       LD   A,(back)  }
              $77/                     {       LD   (HL),A    }
            { load system variable BRDCLR (border color) }
              $23/                     {       INC  HL        }
              $77/                     {       LD   (HL),A    }
            { change current colors to system variables }
              $3A/$AF/$FC/             {       LD   A,(SCRMOD)}
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$11/$01/         {       LD   IX,CHGCLR    }
              $CD/$1C/$00              {       CALL CALSLT    }
           ) ;

  end ; { BackGroundColor }


procedure Textmode(width: byte) ;

  { sets screen mode 0, width columns }

  begin

    { set system variable screenwidth to requested color }
    Mem[$F3AE] := width ;
    { change to screen 0 }
    set_screen(0) ;

  end ; { TextMode }


function GetTextWidth : integer ;

  { function returns current nr of characters
    that fit on line  }

  begin

    if get_screen = graphic_screen
      then
        GetTextWidth := graphic_length
    else if get_screen = 0
      then
        GetTextWidth := Mem[$F3AE]       { LINLEN }
    else if get_screen = 1
      then
        getTextWidth := Mem[$F3AF]

  end ; { GetTextWidth }


procedure Error_handler ;

  { to be called if fatal error to restore to text screen,
    white on black. Also called by Init_graphics to be used
    by Pascal if fatal error occur }

  begin

    Screen_On ;
    Color(white) ;
    BackgroundColor(black) ;
    TextMode(80) ;
    writeln('Fatal graphic runtime error') ;

  end ; { Error_Handler }


procedure Init_graphics ;

  { to be called of any program using procedures or functions
    from the graphics package
    Sets fatal error entry point of Turbo Pascal to Error_handler }

  begin


    errorptr := addr(Error_Handler) ;
    bold := false ;
    preblank := false ;
    inverse := false ;


  end ; { Init_graphics }


procedure Report_not_graphics(proc_name : grstring) ;

  { aborts program after setting to textmode
    with error_handler and then reports
    offending procedure/function called
    in wrong mode }

  begin

    error_handler ;
    writeln('Graphic routine ',proc_name) ;
    writeln( 'called in textmode') ;
    halt ;

  end ; { Report_not_graphics }


function GetColor : colortype ;

  { returns current foreground color }

  var

    color : colortype ;

  begin

    INLINE($21/$E9/$F3/                  { LD   HL,FORCLR   }
           $7E/                          { LD   A,(HL)      }
           $32/color ) ;                 { LD   (color),A    }

    GetColor := color ;

  end ; { GetColor }


function Get_BackgroundColor : colortype ;
  { returns current background color }

  var

    color : colortype ;

  begin

    INLINE($21/$EA/$F3/                  { LD   HL,FORCLR   }
           $7E/                          { LD   A,(HL)      }
           $32/color ) ;                 { LD   (color),A    }

    Get_BackGroundColor := color ;

  end ; { GetBackgroundColor }


procedure GraphMode ;

  { set screen to graphic screen }

  begin

    set_screen(graphic_screen) ;

  end ; { GraphMode }


procedure Draw_Point(x,y    : integer ;
                     pcolor : colortype) ;

  { change pixel on screen position x,y to color,
    no action if outside screen boundaries        }

  begin

    if get_screen <> graphic_screen
      then
        Report_not_graphics('Draw_point'); ;

    SetColor(pcolor) ;
    inline (
            { if not position inside screen boundaries }
              $ED/$4B/x/               {       LD   BC,(x)    }
              $ED/$5B/y/               {       LD   DE,(y)    }
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$8D/$00/         {       LD   IX,SCALXY }
              $CD/$1C/$00/             {       CALL CALSLT    }
            {   then return
              $D2/*+24/                        JP   NC,out    }
            {   else current pixel to x,y }
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$91/$00/         {       LD   IX,MAPXYC }
              $CD/$1C/$00/             {       CALL CALSLT    }
            {     set current pixel to attribute color }
              $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
              $DD/$21/$9D/$00/         {       LD   IX,SETC   }
              $CD/$1C/$00              {       CALL CALSLT    }
                                       { out   EQU  *         }
          )  ;

  end ; { Draw_Point }


function Pixel_Color (x,y : integer) : colortype ;

  { returns color of pixel on position x,y }

  var

    pcolor : colortype ;

  begin

    if get_screen <> graphic_screen
      then
        Report_not_graphics('Pixel_Color'); ;

          inline (
                  { position current pixel at x,y }
                    $ED/$4B/x/               {       LD   BC,(x)    }
                    $ED/$5B/y/               {       LD   DE,(y)    }
                    $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
                    $DD/$21/$91/$00/         {       LD   IX,MAPXYC }
                    $CD/$1C/$00/             {       CALL CALSLT    }
                  { get attribute color of current pixel }
                    $FD/$2A/$F7/$FA/         {       LD   IY,(EXBRSA-1)}
                    $DD/$21/$95/$00/         {       LD   IX,READC  }
                    $CD/$1C/$00/             {       CALL CALSLT    }
                    $32/pcolor               {       LD   (pcolor),A}
                 ) ;
          Pixel_Color := pcolor ;

  end ; { Pixel_Color }


procedure Swap_Int (var i,j : integer) ;

   { values of integers i and j are swapped }

  var

    temp : integer ;

  begin

    temp := i ;
    i := j ;
    j := temp ;

  end ; { swap_int }


procedure scale(var x,y : integer) ;

  { coordinates x and y are scaled in current screen }

  var

   screen_nr : integer ;

  begin

     if x < 0
       then
         x := 0 ;
     if y < 0
       then
         y := 0 ;
    screen_nr := Get_screen ;
    if (screen_nr = graphic_screen)
      then
        begin
          if x > max_gx
            then
              x := max_gx ;
          if y > max_gy
            then
              y := max_gy ;
        end
    else
      begin
        if x > GetTextwidth
          then
            x := GetTextWidth ;
        if y > Mem[$F3B2]
          then
            y := Mem[$F3B2] ;
      end ;

  end ; { scale }

