{ filgraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }


procedure Draw_Fill (x,y         : integer ;
                    bordercolor : colortype ) ;

  { fills area surrounded by bordercolor with bordercolor
    based upon scanline seed fill algorithm               }

  const

    max_pixelstack = 50 ;
    above = true ;
    below = false ;

  type

    seedpixel = record
                  x_pixel,
                  y_pixel  : integer ;
                end ;

  var

    pixelstack      : array[1..max_pixelstack] of seedpixel ;
    pixelpointer    : integer ;
    save_x, save_y  : integer ;
    x_left, x_right : integer ;
    xy_color        : colortype ;

  procedure PushPixel(x,y : integer) ;

    { pushes pixel x,y onto pixelstack }

    begin

      if pixelpointer = max_pixelstack
        then
          begin
            color(white) ;
            backgroundcolor(black) ;
            Textmode(40) ;
            writeln('DrawFill stack overflow in Drawfill') ;
            halt ;
          end
        else
          begin
            pixelpointer := pixelpointer + 1 ;
            pixelstack[pixelpointer].x_pixel := x ;
            pixelstack[pixelpointer].y_pixel := y ;
          end ;
    end ;  { PushPixel }

  procedure PopPixel(var x,y : integer) ;
    begin
      if pixelpointer = 1
        then
          begin
            Error_handler ;
            writeln('DrawFill stack underflow in Drawfill') ;
            halt ;
          end
        else
          begin
            x := pixelstack[pixelpointer].x_pixel  ;
            y := pixelstack[pixelpointer].y_pixel  ;
            pixelpointer := pixelpointer - 1 ;
          end ;
    end ; { PopPixel }

  procedure Check_scan_line (x,y : integer) ;

    begin

      xy_color := Pixel_Color(x,y) ;
      while x < x_right do
        begin
          { scan for begin of unfilled span }
          while (xy_color = bordercolor) and
                (  x < x_right                ) do
            begin
              inline (
                      { position pixel to right }
                        $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)     }
                        $DD/$21/$FC/$00/         {       LD   IX,RIGHTC     }
                        $CD/$1C/$00/             {       CALL CALSLT        }
                      { Get color of current pixel }
                        $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)     }
                        $DD/$21/$1D/$01/         {       LD   IX,READC      }
                        $CD/$1C/$00/             {       CALL CALSLT        }
                        $32/xy_color             {       LD   (xy_color),A  }
                     ) ;
              x := x + 1 ;
            end ;
          { if unfilled span }
          if x < x_right
            then
              begin
                { find the end of this span }
                while (xy_color <> bordercolor) and
                      (x < x_right)             do
                  begin
                    x := x + 1 ;
                    { position pixel to right }
              inline (
                      { position pixel to right }
                        $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)     }
                        $DD/$21/$FC/$00/         {       LD   IX,RIGHTC     }
                        $CD/$1C/$00/             {       CALL CALSLT        }
                      { Get color of current pixel }
                        $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)     }
                        $DD/$21/$1D/$01/         {       LD   IX,READC      }
                        $CD/$1C/$00/             {       CALL CALSLT        }
                        $32/xy_color             {       LD   (xy_color),A  }
                     ) ;
                  end ;
                { push extreme right of this span }
                PushPixel(x-1,y) ;
              end ;
        end ;

    end ; { Check_Scan_line }


  begin

    if (x < 0) or (x > max_gx) or (y < 0) or (y > max_gy)
      then
        begin
          Error_handler ;
          writeln('DrawFill coordinates') ;
          halt ;
        end
      else
        begin
          SetColor(bordercolor) ;
          { initialize stack }
          pixelpointer := 1 ;
          PushPixel(x,y) ;
          while pixelpointer > 1 do
            begin
              { get the seed pixel and set it to new value }
              PopPixel(x,y) ;
              Draw_Point(x,y,bordercolor) ;
              { fill the span to the right of the seed pixel }
              save_x := x ;
              x := x + 1 ;
              xy_color := Pixel_Color(x,y) ;
              while (xy_color <> bordercolor) and
                    (x < max_gx)  do
                begin
                  inline (
                          { set current pixel to bordercolor }
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$20/$01/         {       LD   IX,SETC     }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                          { position current pixel to right }
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$FC/$00/         {       LD   IX,RIGHTC   }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                          { get color of current pixel }
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$1D/$01/         {       LD   IX,READC    }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                            $32/xy_color             {       LD   (xy_color),A}
                         ) ;
                  x := x + 1 ;
                end ;
              { save extreme right pixel }
              x_right := x - 1 ;
              x := save_x ;
              { fill the span to the left of the seed pixel }
              save_x := x ;
              x := x - 1 ;
              xy_color := Pixel_Color(x,y) ;
              while (xy_color <> bordercolor) and
                    (x > 0)  do
                begin
                  inline (
                          { set current pixel to bordercolor }
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$20/$01/         {       LD   IX,SETC     }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                          { position current pixel to left }                  
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$FF/$00/         {       LD   IX,LEFTC    }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                          { get color of curent pixel }
                            $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
                            $DD/$21/$1D/$01/         {       LD   IX,READC    }
                            $CD/$1C/$00/             {       CALL CALSLT      }
                            $32/xy_color             {       LD   (xy_color),A}
                       ) ;
                x := x - 1 ;
                end ;
              { save extreme left pixel }
              x_left := x + 1 ;
              x := save_x ;
              { check the scan line above }
              if y < max_gy
                then
                  Check_Scan_Line(x_left,y + 1) ;
              { check the scan line below }
              if y > 0
                then
                  Check_Scan_Line(x_left,y - 1) ;
            end ;
        end ;

  end ; { Draw_Fill }
