program demo_graphics ;

  { demonstration how to use the
    graphics library  }



{ first include the graphics library
  with basic definitions always }

{ always include first basic routines }
{$I graphics.inc }

{ to use Draw_Line }
{$I lingraph.inc }

{ to use Draw_Box }
{$I boxgraph.inc }

{ to use Draw_Circle, Draw_Arc }
{$I cirgraph.inc }

{ to use Draw_Fill }
{$I filgraph.inc }

{ to use Draw_Pie }
{$I piegraph.inc }

{ to use Read_String, Draw_String }
{$I chgraph.inc  }

{ to use sprites Def_sprite, Draw_Sprite }
{$I sprgraph.inc }

{ to use Read_Screen, Write_screen }
{$I dskgraph.inc }

  const

    man  : sprite8_layout  =
            ($3C,$3C,$18,$7E,$BD,$24,$24,$66) ;
    dman : sprite16_layout =
            ($3C,$3C,$18,$7E,$BD,$24,$24,$66,
             $3C,$3C,$18,$7E,$BD,$24,$24,$66,
             $3C,$3C,$18,$7E,$BD,$24,$24,$66,
             $3C,$3C,$18,$7E,$BD,$24,$24,$66) ;


  var

    x,y,x1,y1 : integer ;
    c         : real ;
    pcolor    : colortype ;
    chstring  : grstring ;

begin


  { initialize graphics package }
  Init_graphics ;
  Color(white) ;
  BackgroundColor(black) ;

  Graphmode ;
  Draw_Box(5,5,250,187,white,false) ;
  Draw_Box(50,50,200,150,light_blue,true) ;
  Draw_Circle(128,95,40,Dark_red,false) ;
  Draw_Circle(128,95,10,light_green,true) ;
  for x := 1 to 23 do
    begin
      Draw_Line(128,95,x*5,5,dark_blue) ;
      Draw_Line(128,95,x*5,187,dark_red) ;
    end ;
  Draw_Circle(200,50,30,white,true) ;
  Draw_Circle(200,150,30,white,true) ;
  Position_Cursor(188,47) ;
  Color(dark_blue) ;
  Draw_char('M') ;
  Color(dark_red) ;
  Draw_char('S') ;
  Color(dark_green) ;
  Draw_char('X') ;
  Position_Cursor(176,152) ;
  Color(light_green) ;
  Draw_char('P') ;
  Draw_char('A') ;
  Draw_char('S') ;
  Draw_char('C') ;
  Draw_char('A') ;
  Draw_char('L') ;
  Position_Cursor(180,140) ;
  Color(black) ;
  Draw_char('T') ;
  Draw_char('U') ;
  Draw_char('R') ;
  Draw_char('B') ;
  Draw_char('O') ;
  Write_screen ('main.scr',0,max_vram,x) ;
  if x <> 0
    then
      begin
        Error_Handler ;
        writeln('fata file error') ;
      end ;

  color(black) ;
  backgroundcolor(light_green) ;
  graphmode ;
  clear_screen ;
  position_cursor(10,80) ;
  Draw_char('!') ;
  color(white) ;
  position_cursor(10,100) ;
  preblank := true ;
  bold := true ;
  Draw_string('graphic screen print ') ;
  color(dark_blue) ;
  position_cursor(10,110) ;
  inverse := true ;
  Draw_string('graphic screen print ') ;
  color(white) ;
  position_cursor(10,180) ;
  bold := false ;
  inverse := false ;
  Draw_String('Press RETURN to continue') ;
  readln ;
  color(white) ;
  position_cursor(10,120) ;
  Draw_string('Te lange regel hier dus te lang voor hier') ;

  position_cursor(10,180) ;
  color(dark_red) ;

  preblank := false ;
  Draw_String('Press return to continue') ;
  readln ;
  preblank := true ;
  clear_screen ;
  color(black) ;

  position_cursor(10,100) ;
  Draw_string('Naam ? ') ;
  Read_string(chstring,10) ;
  position_cursor(10,50) ;
  Draw_string(chstring) ;
  position_cursor(10,110) ;
  Draw_string('Adres ? ') ;
  inverse := true ;
  Read_string(chstring,40) ;
  position_cursor(10,50) ;
  inverse := false ;
  Draw_string(chstring) ;


  delay(2500) ;
  backgroundcolor(black) ;
  color(white) ;
  clear_screen ;
  Draw_Circle(100,100,50,dark_green,false) ;
  Draw_Circle(100,10,50,dark_blue,false) ;
  Draw_Circle(10,100,50,dark_red,false) ;
  Delay(3000) ;
  clear_screen ;

  screen_off ;
  for x := 1 to 20 do
    Draw_Circle(100,100,x*5-4,white,false) ;
  screen_on ;
  delay(2000) ;

  clear_screen ;
  Draw_Circle(100,100,50,dark_green,true) ;
  Draw_Circle(100,10,50,dark_blue,true) ;
  Draw_Circle(10,100,50,dark_red,true) ;
  Delay(3000) ;

  Clear_Screen ;
  pcolor := medium_green ;

  for x := 1 to 20 do
    begin
      color(pcolor) ;
      if pcolor = white
        then
          pcolor := medium_green
        else
          pcolor := succ(pcolor) ;
      Draw_Circle(100,100,x*5-4,pcolor,true) ;
    end ;
  delay(2000) ;
  Clear_Screen ;
  Draw_Box(10,10,100,100,white,false) ;
  Draw_Box(30,30,80,80,white,false) ;
  Draw_Box(40,80,50,90,white,false) ;
  Draw_Fill(15,25,white) ;

  Delay(3000) ;
  Clear_Screen ;
  c := 1.0 ;
  while c < 20.0 do
    begin
      x := trunc(32*cos(c)) + 128 ;
      y := trunc(96*cos(c)) + 96 ;
      x1 := trunc(96*sin(c)) + 128 ;
      Y1 := trunc(72*SIN(C/3)) + 96 ;
      Draw_Line(x,y,x1,y1,white) ;
      c := c + 0.1 ;
    end ;
  delay(2500) ;
  clear_screen ;
  Draw_Arc(100,100,20,white,0.1*pi,0.4*pi) ;
  Draw_Arc(100,100,30,white,0.6*pi,0.9*pi) ;
  Draw_Arc(100,100,40,white,1.1*pi,1.4*pi) ;
  Draw_Arc(100,100,50,white,1.6*pi,1.9*pi) ;
  Draw_Arc(100,100,60,white,0.1*pi,1.9*pi) ;
  Draw_Arc(100,100,60,white,0,2*pi-0.1) ;
  Draw_ARc(100,100,45,white,-0.25*pi,0.25*pi) ;
  Draw_Arc(120,100,30,white,0.25*pi,1.75*pi) ;

  Delay(3000) ;
  Clear_Screen ;
  { try pie with gap from circle }
  x := round(30 * cos(0.25*pi)) ;
  y := round(30 * sin(0.25*pi)) ;
  Draw_Circle(50,100,30,white,true) ;

  Draw_Line(50,100,50+x,100+y,black) ;
  Draw_Line(50,100,50+x,100-y,black) ;
  Draw_Arc(50,100,30,black,-0.25*pi,0.25*pi);
  Draw_Fill(60,100,black) ;

  Draw_Pie(120,100,30,white,0.25*pi,1.75*pi) ;
  delay(2000) ;

  init_sprite(sprite8,normal) ;
  define_sprite8(man,0) ;
  draw_sprite(0,100,100,0,light_green) ;
  for x := 10 to 150 do
    begin
      draw_sprite(1,x,x,0,white) ;
      draw_sprite(2,160-x,x,0,light_green) ;
    end ;
  delay(1000) ;
  init_sprite(sprite8,double) ;
  define_sprite8(man,0) ;
  draw_sprite(0,100,100,0,light_green) ;
  for x := 10 to 150 do
    begin
      draw_sprite(1,x,x,0,white) ;
      draw_sprite(2,160-x,x,0,light_green) ;
    end ;
  delay(1000) ;
  init_sprite(sprite16,normal) ;
  define_sprite16(dman,0) ;
  draw_sprite(0,100,100,0,light_green) ;
  for x := 10 to 150 do
    begin
      draw_sprite(1,x,x,0,white) ;
      draw_sprite(2,160-x,x,0,light_green) ;
    end ;
  delay(1000) ;
  init_sprite(sprite16,double) ;
  define_sprite16(dman,0) ;
  draw_sprite(0,100,100,0,light_green) ;
  for x := 10 to 150 do
    begin
      draw_sprite(1,x,x,0,white) ;
      draw_sprite(2,160-x,x,0,light_green) ;
    end ;


  draw_sprite(0,-16,100,0,light_green) ;

  delay(2000) ;

  screen_off ;
  Read_screen('main.scr',x) ;
  screen_on ;
  delay(2000) ;

  Color(white) ;
  BackgroundColor(black) ;
  TextMode(40) ;
end.