{ cirgraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }

procedure DrawArcCircle ( x1, y1 , radius : integer ;
                    ccolor : colortype ;
                    fill : boolean ;
                    begin_angle,end_angle : real;
                    circle : boolean ) ;


  { general purpose routine to draw circle or arc on screen,
    based upon the Bresenham circle algorhitm               }

  var

    x,y,delta,limit : integer ;
    xb,yb,xe,ye     : integer ;
    begin_quadrant,
     end_quadrant   : integer ;
    used_quadrant   : array[1..4] of boolean ;
    yb_quadrant     : array[1..4] of integer ;
    ye_quadrant     : array[1..4] of integer ;
    angle           : real ;

  procedure PutScaledPoint (x,y :integer) ;

    { places point x1,y1 scaled on screen }

    begin

      inline (
              { if not position inside screen boundaries }
                $ED/$4B/x/               {         LD   BC,(x)    }
                $ED/$5B/y/               {         LD   DE,(y)    }
                $FD/$2A/$C0/$FC/         {         LD   IY,(EXPT) }
                $DD/$21/$0E/$01/         {         LD   IX,SCALXY }
                $CD/$1C/$00/             {         CALL CALSLT    }
              {   then return }
                $D2/*+24/                {         JP   NC,outside}
              {   else set current pixel to position x,y }
                $FD/$2A/$C0/$FC/         {         LD   IY,(EXPT) }
                $DD/$21/$11/$01/         {         LD   IX,MAPXYC }
                $CD/$1C/$00/             {         CALL CALSLT    }
              {     set current pixel to attribute color }
                $FD/$2A/$C0/$FC/         {         LD   IY,(EXPT) }
                $DD/$21/$20/$01/         {         LD   IX,SETC   }
                $CD/$1C/$00              {         CALL CALSLT    }
                                         { outside EQU $          }
             ) ;

    end ; { PutScaledPoint }

  function determine_quadrant (x,y : integer ) : integer ;

    { determine quadrant of position x,y : 1,2,3,4 }

    begin

      if x >= 0
        then
          begin
            if y >= 0
              then
                determine_quadrant := 1
              else
                determine_quadrant := 4
          end
        else
          begin
            if y >= 0
              then
                determine_quadrant := 2
              else
                determine_quadrant := 3
          end ;

     end ; { determine_quadrant }


  procedure PutLine (x, y, dx : integer ) ;

    { draws horizontal line from x, y with length dx }

    begin

      { check for valid position and length of line }
      if (y >= 0) and (y <= max_gy)
        then
          begin
            if x < 0
              then
                begin
                  dx := dx + x ;
                  x := 0
                end
            else if x > max_gx
              then
                begin
                  dx := dx - (x - max_gx) ;
                  x := max_gx
                end ;
            if dx < 0
              then
                dx := - dx ;
            if dx > max_gx
              then
                dx := max_gx ;

            inline (
                    { set current pixel to position x,y }
                      $ED/$4B/x/               {       LD   BC,(x)    }
                      $ED/$5B/y/               {       LD   DE,(y)    }
                      $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT) }
                      $DD/$21/$11/$01/         {       LD   IX,MAPXYC }
                      $CD/$1C/$00/             {       CALL CALSLT    }
                    { draw horizontal line from current pixel length dx }
                      $2A/dx/                  {       LD   HL,(dx)   }
                      $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT) }
                      $DD/$21/$23/$01/         {       LD   IX,NSETCX }
                      $CD/$1C/$00              {       CALL CALSLT    }
                   ) ;
           end ;
    end ;

  procedure move_md ;

    begin
      x := x + 1 ;
      y := y - 1 ;
      delta := delta + 2*x - 2*y + 2 ;
    end ;

  procedure move_mh ;

    begin
      x := x + 1 ;
      delta := delta + 2*x + 1 ;
    end ;

  procedure move_mv ;

    begin
      y := y - 1 ;
      delta := delta - 2*y + 1 ;
    end ;

  procedure circle_arc_point (circle : boolean ) ;

    { place pixel (x,y) on screen for circle and arc }

    procedure arc_point_quadrant( quadrant, x, y : integer ) ;

       { place pixel on screen for arc }
        
      begin

        if used_quadrant[quadrant]
          then
            if (abs(y) >= yb_quadrant[quadrant]) and
               (abs(y) <= ye_quadrant[quadrant])
              then
                PutScaledPoint(x1 + x, y1 + y) ;

      end ; { arc_point_quadrant }

    begin

      if circle
        then
          begin
            if fill
              then
                begin
                  PutLine(x1 - x, y1 + y, 2 * x + 1 ) ;
                  PutLine(x1 - x, y1 - y, 2 * x + 1 ) ;
                end
              else
                { for circle mirror for all four quadrants }
                begin
                  PutScaledPoint(x1 + x, y1 + y) ;
                  PutScaledPoint(x1 - x, y1 + y) ;
                  PutScaledPoint(x1 + x, y1 - y) ;
                  PutScaledPoint(x1 - x, y1 - y) ;
                end
          end
        else { arc }
          begin
            { first quadrant }
            arc_point_quadrant(1,x,y) ; 
            { second qudrant }
            arc_point_quadrant(2,-x,y) ;
            { third quadrant }
            arc_point_quadrant(3,-x,-y) ;
            { fourth quadrant }
            arc_point_quadrant(4,x,-y) ;
          end ;   

    end ; { circle_arc_point }

  begin
  
    { set attribute color } 
    SetColor(ccolor) ;
    
    if not circle
      then
        { determine for all quadrants parts to draw }
        begin
          { always draw arc from low to higher angle }
          if begin_angle > end_angle
            then
              begin
                angle := begin_angle ;
                end_angle := begin_angle ;
                begin_angle := angle
              end ;

          { determine coordinates of begin and end of arc }
          xb := round(radius * cos(begin_angle)) ;
          yb := round(radius * sin(begin_angle)) ;
          xe := round(radius * cos(end_angle)) ;
          ye := round(radius * sin(end_angle)) ;

          { set all quadrants to unused and full arc }
          for x := 1 to 4 do
            begin
              used_quadrant[x] := false ;
              yb_quadrant[x] := 0 ;
              ye_quadrant[x] := radius ;
            end ;

          begin_quadrant := determine_quadrant(xb,yb) ;
          end_quadrant := determine_quadrant(xe,ye) ;

          { set all quadrants between begin-quadrant and end-quadrant used }
          if end_quadrant < begin_quadrant
            then
              y := end_quadrant + 4
            else
              y := end_quadrant ;
          for x := begin_quadrant to y do
            if x > 4
              then
                used_quadrant[x-4] := true
              else
                used_quadrant[x] := true ;

          if odd(begin_quadrant)
            then
              yb_quadrant[begin_quadrant] := abs(yb)
            else
              ye_quadrant[begin_quadrant] := abs(yb) ;
          if odd(end_quadrant)
            then
              ye_quadrant[end_quadrant  ] := abs(ye)
            else
              yb_quadrant[end_quadrant  ] := abs(ye) ;

        end ;  

    x := 0 ;
    y := radius ;
    delta := 2*(1-radius) ;
    limit := 0 ;
    repeat
      circle_arc_point(circle) ;
      if delta < 0
        then
          begin
            if (2*delta + 2*y - 1) <= 0
              then
                move_mh
              else
                move_md ;
          end
      else if delta > 0
        then
          begin
            if (2*delta - 2*x - 1) <= 0
              then
                move_md
              else
                move_mv
          end
      else  { delta = 0 }
        move_md
    until y < limit ;

  end ; { Draw_Arc_Circle }

procedure Draw_Arc (x1,y1,radius : integer ;
                    acolor : colortype ;
                    begin_angle,end_angle : real ) ;

  { draws arc around center x,y with radius
    between begin-angle and end-angle in acolor
    begin_angle < end_angle                     }

  begin

    DrawArcCircle ( x1, y1 , radius,
                    acolor,
                    false,
                    begin_angle,end_angle,
                    false ) ;

  end ; { Draw_Arc }


procedure Draw_Circle ( x1, y1 , radius : integer ;
                        ccolor : colortype ;
                        fill : boolean ) ;

  { draws circle in color
    if fill true filled with color
    otherwise only contour         }

  begin

    DrawArcCircle ( x1, y1 , radius,
                    ccolor,
                    fill,
                    0,0,
                    true ) ;

  end ; { Draw_Circle }
