{ chgraph.inc, zie graphics.doc voor informatie  }
{ Auteur : Hans Otten 1-juli-1988 V1.0            }
{ Alleen gebruik voor niet-commerciele doeleinden }
{ toegestaan zonder toestemming van de auteur     }


procedure Position_Cursor (x,y : integer);

  { positions cursor for text output or graphic output }

  begin

    inline (
            { if not text screen  }
              $3A/$AF/$FC/             {       LD   A,(SCRMOD)  }
              $DD/$2A/x/               {       LD   IX,(x)      }
              $FD/$2A/y/               {       LD   IY,(y)      }
              $FE/graphic_screen/      {       CP   graphic_scrn}
              $DA/*+13/                {       JP   C,text      }
            {   then position graphic cursor }
              $DD/$22/$B7/$FC/         {       LD   (GRPACX),IX }
              $FD/$22/$B9/$FC/         {       LD   (GRPACY),IY }
              $C3/*+21/                {       JP   crs         }
            {   else position on text screen }
              $DD/$E5/                 { text  PUSH IX          }
              $E1/                     {       POP  HL          }
              $65/                     {       LD   H,L         }
              $FD/$E5/                 {       PUSH IY          }
              $D1/                     {       POP  DE          }
              $6B/                     {       LD   L,E         }
              $FD/$2A/$C0/$FC/         {       LD   IY,(EXPT)   }
              $DD/$21/$C6/$00/         {       LD   IX,POSIT    }
              $CD/$1C/$00              {       CALL CALSLT      }
                                       { crs   EQU $            }
           ) ;

  end ;  { position_cursor }


procedure Draw_Char (ch: char) ;

  { prints character to screen at current position in all screen modes }

  begin

    inline (
            { if text screen }
              $3A/$AF/$FC/              {       LD   A,(SCRMOD)  }
              $FE/graphic_screen/       {       CP   graphic_scrn}
              $DA/*+19/                 {       JP   C,scrn      }
            {   then print character on text screen }
              $3A/ch/                   {       LD   A,(ch)      }
              $FD/$2A/$C0/$FC/          {       LD   IY,(EXPT)   }
              $DD/$21/$8D/$00/          {       LD   IX,CHPUT    }
              $CD/$1C/$00/              {       CALL CALSLT      }
              $C3/*+16/                 {       JP   prcrs       }
            {   else print character on graphic screen }
              $3A/ch/                   { scrn  LD   A,(ch)      }
              $FD/$2A/$C0/$FC/          {       LD   IY,(EXPT)   }
              $DD/$21/$A2/$00/          {       LD   IX,GRPPRT   }
              $CD/$1C/$00               {       CALL CALSLT      }
                                        { prcrs EQU $            }
           ) ;

  end ; { Draw_char }


procedure Get_Cursor_position (var x,y : integer)  ;

  { returns cursor position X- and y-coordinate }

  begin

    if get_screen <> graphic_screen
      then
        begin
          x := Mem[$F3DD] ;   {system variable CSRX }
          y := Mem[$F3DC]     {system variable CSRY }
        end
      else
        begin
          { graphic cursor X }
          x := Mem[$FCB7] + 256 * Mem[$FCB8] ;
          { graphic cursor Y }
          y := Mem[$FCB9] + 256 * Mem[$FCBA] ;
        end ;

  end ; { Get_cursor_position }


procedure Draw_String ( chstring : grstring ) ;

  { draws string on screen, limit to one line }

  var

    x,y,pos, width : integer ;
    save_color : colortype ;

  begin

    if get_screen <> graphic_screen
      then
        report_not_graphics('Draw_string') ;

    { determine nr of chracters left on line }
    Get_cursor_position(x,y) ;
    { nr of pixels in string }
    width := length(chstring) * char_width ;
    { nr of pixels left on line }
    pos := (gettextwidth * char_width - x) + 1 ;
    if width > pos
      then
        width := pos div char_width
      else
        width := width div char_width ;

    if inverse
      then
        begin
          draw_box(x,y,
                  (x + width * char_width + 1),(y + char_heigth),
                   getcolor,
                   true) ;
          save_color := getcolor ;
          color(get_backgroundcolor) ;
        end
    else if preblank
      then
        draw_box(x,y,
                 (x + width * char_width + 1),(y + char_heigth),
                 get_backgroundcolor,
                 true) ;

    for pos := 1 to width do
      draw_char(chstring[pos]) ;
    if bold
      then
        begin
          position_cursor(x+1,y) ;
          for pos := 1 to width do
            draw_char(chstring[pos]) ;
        end ;
    if inverse
      then
        color(save_color) ;

  end ;


procedure Read_string ( var chstring : grstring ;
                        char_count   : integer) ;


  { reads string from graphics screen in chstring
    exit if return or char_count characters
    entered , backspace and delete accepted }

  const

    CR  = 13  ;
    BS  = 8   ;
    DEL = 127 ;

  var

   x,y, width,pos : integer ;
   ch : char ;
   fore_color,
   back_color : colortype ;

  procedure cursor_on ;

    { draws box in foreground color at current text position }

    var

      x,y : integer ;

    begin

      Get_cursor_position(x,y) ;
      if x < max_gx
        then
          Draw_box(x,y,
                   x + char_width,y + char_heigth,
                   fore_color,
                   true ) ;

    end ; { cursor_on }


  procedure cursor_off ;

    { draws box in background color at current text position }

    var

      x,y : integer ;

    begin

      Get_cursor_position(x,y) ;
      Draw_box(x,y,
               x + char_width,y + char_heigth,
               back_color,
               true ) ;

    end ; { cursor_on }

  procedure backup_cursor ;

    { places cursor one text position back }

    var

      x,y : integer ;

    begin

      cursor_off ;
      Get_cursor_position(x,y) ;
      if x > char_width
        then
          Position_cursor(x - char_width,y) ;
      cursor_on ;

    end ;


  begin

    if get_screen <> graphic_screen
      then
        report_not_graphics('Read_String') ;
    chstring := '' ;


    if inverse
      then
        begin
          back_color := getcolor ;
          fore_color := get_backgroundcolor ;
        end
      else
        begin
          back_color := get_backgroundcolor ;
          fore_color := getcolor ;
        end ;
    color(fore_color) ;

    { determine nr of chracters left on line }
    Get_cursor_position(x,y) ;
    { nr of pixels in string }
    width := char_count * char_width ;
    { nr of pixels left on line, leave space for cursor }
    pos := ((gettextwidth - 1) * char_width) - x + 1;
    if width > pos
      then
        char_count := pos div char_width ;

    { clear input line }
    draw_box(x,y,
             x + (char_count + 1) * char_width,
             y + char_heigth,
             back_color,
             true ) ;

    pos := 0 ;
    repeat
      cursor_on ;
      read(kbd,ch) ;
      if (ord(ch) = BS) or (ord(ch) = DEL)
        then
          begin
            if pos > 0
              then
                begin
                  chstring[pos] := ' ' ;
                  pos := pos - 1 ;
                  backup_cursor ;
              end
          end
      else if (pos < char_count) and
              (ch > ' ')
        then
          begin
            cursor_off ;
            Draw_char(ch) ;
            cursor_on ;
            pos := pos + 1 ;
            chstring[pos] := ch ;
           end ;
  until (ord(ch) = CR) ;
  if inverse
    then
      color(back_color) ;

  cursor_off ;
  { fill in length of entered text string }
  chstring[0] := chr(pos) ;

  end ;