program Unix2DOS ;

{
  program to convert a Unix like text file
  to an MS(X)-DOS/Windows compatible file

  Text file on PC: stream of char's with CRLF, last char in file is eof

  Text file on Unix: stream of char's with LF,

  Version 1.0 9 september 2000
  Hans Otten
  Freeware

  Compiled with Borland Pascal 5.0 on MS-DOS
  Also runs on MSX with Turbo Pascal 3.3f
}
const

  LF = $0A ;
  CR = $0D ;
  SPACE = 32 ;


var
  cnt     : integer ;
  bytecnt : integer ;
  ch, ch1 : byte ;
  infile, outfile, oldfile : file of byte ;
  filename : string[255] ;

begin

  if paramstr(1) = ''
    then
      begin
        writeln('UX2DOS V1.0 C2000 Hans Otten') ;
        writeln('Commandline UX2DOS <filename>');
        writeln('where filename is Unix text file to convert to DOS') ;
        halt ;
      end
    else
      begin
        filename := paramstr(1) ;
        {$I-}
        Assign(infile, fileName);
        Reset(infile) ;
        {$I+}
        if (IOResult <> 0)
          then
            begin
              writeln('Error opening file ',filename) ;
              halt ;
            end;
        assign(outfile, 'UXTEMP.$$$') ;
        {$I-}
        rewrite(outfile) ;
        {$I+}

        ch1 := SPACE ;
        while not eof(infile) do
          begin
            read(infile, ch) ;
            if ch = LF
              then
                if ch1 <> CR
                  then
                    begin
                      ch1 := CR ;
                      write(outfile, ch1) ;
                    end;
            write(outfile,ch) ;
            ch1 := ch ;
          end ;
        close(infile) ;
        {$i-}
        assign(oldfile,'before.ux') ;
        erase(oldfile) ;
        rename(infile,'before.ux') ;
        close(outfile) ;
        rename(outfile,filename) ;
      end ;
end.


