program DosToCPM ;

{
  program to convert a text file created on MS-DOS/Windows
  to a CPM Turbo Pascal compatible file

  Text file on PC: stream of char's with CRLF, last char in file is eof

  Text file on CPM, like Turbo Pascal 3 : stream of char's with CRLF,
  eof char is 1A, file padded to multiple of 128
  TABS not allowd (replaced by blanks here)

  Version 1.0 9 september 2000
  Hans Otten
  Freeware

  Source compiled on MS-DOS with Turbo Pascal 5

  Also runs on Turbo Pascal 3.3f on MSX

}
const

  CPMEOF = $1A ;
  TAB    = $09 ;
  SPACE  = $20 ;

var
  cnt     : integer ;
  bytecnt : integer ;
  ch      : byte ;
  infile, outfile, oldfile : file of byte ;
  filename : string[255] ;

begin

  if paramstr(1) = ''
    then
      begin
        writeln('DOS2CPM V1.0 C2000 Hans Otten') ;
        writeln('Commandline DOS2CPM <filename>');
        writeln('where filename is DOS text file to convert to CP/M Turbo Pascal 3 format') ;
        halt ;
      end
    else
      begin
        filename := paramstr(1) ;
        {$I-}
        Assign(infile, fileName);
        Reset(infile) ;
        {$I+}
        if (IOResult <> 0)
          then
            begin
              writeln('Error opening file ',filename) ;
              halt ;
            end;
        assign(outfile, 'CPMTEMP.$$$') ;
        {$I-}
        rewrite(outfile) ;
        {$I+}
        ch := SPACE ;
        bytecnt := 0 ;
        while not eof(infile) and (ch <> CPMEOF)  do
          begin
            read(infile, ch) ;
          
            if ch = TAB
              then
                ch := SPACE ;
            if ch <> CPMEOF
              then
                begin
                  bytecnt := bytecnt + 1 ;
                  if bytecnt = 128 then bytecnt := 0 ;
                  write(outfile, ch) ;
                end ;
          end ;
        ch := CPMEOF ;
        write(outfile, ch) ;
        bytecnt := bytecnt + 1 ;
        if bytecnt mod 128 <> 0
          then
            begin
              ch := CPMEOF ;
              for cnt := 1 to (128 - (bytecnt mod 128)) do
              write(outfile, ch)  ;
            end ;
        close(infile) ;
        {$i-}
        assign(oldfile,'before.cpm') ;
        erase(oldfile) ;
        rename(infile,'before.cpm') ;
        close(outfile) ;
        rename(outfile,filename) ;
      end ;
end.

