program MSXToDos ;

{
  program to convert a text file created on MSX Turbo Pascal
  to an MS-DOS/Windows compatible file

  Text file on PC: stream of char's with CRLF, last char in file is eof

  Text file on MSX for Turbo Pascal: stream of char's with CRLF,
  eof char is 1A, file padded to multiple of 128
  TABS not allowd (replaced by blanks here)

  Version 1.0 9 september 2000
  Hans Otten
  Freeware

  Compile on MS-DOS with Turbo Pascal 5.0
  Also runs on MSX with Turbo Pascal 3.3f


}
const

  CPMEOF = $1A ;
  TAB    = $09 ;
  SPACE  = $20 ;

var
  cnt     : integer ;
  bytecnt : integer ;
  ch : byte ;
  infile, outfile, oldfile : file of byte ;
  filename : string[255] ;

begin

  if paramstr(1) = ''
    then
      begin
        writeln('MSX2DOS V1.0 C2000 Hans Otten') ;
        writeln('Commandline MSX2DOS <filename>');
        writeln('where filename is text file MSX Turbo Pascal text format to convert to DOS') ;
        halt ;
      end
    else
      begin
        filename := paramstr(1) ;
        {$I-}
        Assign(infile, fileName);
        Reset(infile) ;
        {$I+}
        if (IOResult <> 0)
          then
            begin
              writeln('Error opening file ',filename) ;
              halt ;
            end;
        assign(outfile, 'MSXTEMP.$$$') ;
        {$I-}
        rewrite(outfile) ;
        {$I+}

        ch := 0 ;
        while not eof(infile) and (ch <> CPMEOF) do
          begin
            read(infile, ch) ;
            if ch <> CPMEOF
              then
                write(outfile, ch) ;
          end ;
        close(infile) ;
        {$i-}
        assign(oldfile,'before.dos') ;
        erase(oldfile) ;
        rename(infile,'before.dos') ;
        close(outfile) ;
        rename(outfile,filename) ;
      end ;
end.


