{test programma snelheid graphische routines in Turbo-Pascal}
{(C) 1988 Dorissen Raoul}

program testgraphics;

var  rega,regbc,regde,reghl,regf,regix,regiy: integer;
     teller,bytecounter,addr: integer;

procedure msxbios(entry: integer);
 begin
   inline
   ($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5/          { push alle registers}
    $3a/rega/                                 { ld   a,(rega)}
    $ed/$4b/regbc/                            { ld   bc,(regbc)}
    $ed/$5b/regde/                            { ld   de,(regde)}
    $2a/reghl/                                { ld   hl,(reghl)}
    $dd/$2a/entry/                            { ld   ix,(entry)}
    $fd/$2a/$c0/$fc/                          { ld   iy,exptbl}
    $cd/$1c/$00/                              { call calslt}
    $32/rega/                                 { ld   (rega),a}
    $ed/$43/regbc/                            { ld   (regbc),bc}
    $ed/$53/regde/                            { ld   (regde),de}
    $22/reghl/                                { ld   (reghl),hl}
    $dd/$22/regix/                            { ld   (regix),ix}
    $fd/$22/regiy/                            { ld   (regiy),iy}
    $f5/                                      { push af}
    $e1/                                      { pop  hl}
    $22/regf/                                 { ld   (regf),hl}
    $af/                                      { xor  a}
    $fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1/          { pop  alle registers}
    $fb)                                      { ei}
 end;

{lees een adres in videoram via de bios}
function rdvrm(addr: integer): integer;
   begin
      reghl:=addr;
      msxbios($4a);
      rdvrm:=rega;
   end;

{schrijf naar een adres in videoram via de bios}
procedure wrtvrm(addr, data : integer);
   begin
      reghl:=addr;
      rega:=data;
      msxbios($4d);
   end;

{zet de schermmode via de bios}
procedure chgmod(mode:integer);
   begin
      rega:=mode;
      msxbios($5f);
   end;

{zet de vdp klaar om te scrijven, adres moet naar register hl, ZONDER BIOS}
procedure setwrite(vidadres: integer);
   var h,l: byte;
   begin
     h:=vidadres div 256;
     l:=vidadres mod 256;
     inline( $f3/              { di             }
             $3a/l/            { ld   a,(l)     }
             $d3/$99/          { out  (#99),a   }
             $3a/h/            { ld   a,(h)     }
             $e6/$3f/          { and  #3f       }
             $f6/$40/          { or   #40       }
             $d3/$99/          { out  (#99),a   }
             $fb)              { ei             }
   end;

{schrijf naar videoram, let wel eerst moet setwrite aangeroepen zijn om de}
{adres latch te zetten, ZONDER BIOS!}
procedure wrtvrm2(data: byte);
   begin
     inline( $f3/              { di              }
             $3a/data/         { ld   a,(data)   }
             $d3/$98/          { out  (#98),a    }
             $fb)              { ei              }
   end;

procedure wachtlus;
   begin
    teller:=0;
    repeat teller:=teller+1 until teller=20000;
   end;

{Hoofdprogramma}
begin
   chgmod(0);
   gotoxy(5,4);
   write('test pascal via bios');
   wachtlus;
   chgmod(1);
   bytecounter:=24*32;
   addr:=6144;
   for teller:=1 to bytecounter
       do
         begin
           wrtvrm(addr,65);
           addr:=addr+1;
         end;
   wachtlus;
   clrscr;
   gotoxy(5,4);
   chgmod(0);
   write('test gewone pascal');
   wachtlus;
   clrscr;
   chgmod(1);
   for teller:=1 to 24*29
        do
           write('A');
   wachtlus;
   clrscr;
   chgmod(0);
   gotoxy(5,4);
   write('test bastaard pascal');
   wachtlus;
   chgmod(1);
   clrscr;
   setwrite(6144);
   for teller:=1 to bytecounter
     do
      wrtvrm2(65);
   wachtlus;
   chgmod(0)
end.
