{* file tbext.pas from 881206 *}

PROGRAM tbext ;

{*********
*
* The function of this program is to change the default file
* extension of the TURBO PASCAL compiler.
* This default extension is used by the compiler or editor when
* you specify a file name without point.
* The standard default file extension is 'PAS'.
* Changing 'PAS' to another string is usefull when the TURBO
* PASCAL editor is used as a general purpose editor.
*
* How to use :
*   - compile this program to disk
*   - quit compiler
*   - type TBEXT at the DOS command level
*   - the current default extension is displayed
*   - enter exactly 3 characters to define the new default extension
*   - enter nothing (=only cr key) to exit from the program
*
* Warning :
*   - this program will change the TURBO.COM file, keep a copy
*     of the original file on another disk
*   - this program is only suited to handle the TURBO 3.0 CPM VERSION
*   - to use it for the release 2.00 version, replace constants with
*     values indicated in comments like 2.00 ==> 86
*   - when the current extension is not 'PAS' the first time, then
*     something is wrong (typo error, bad TURBO version, ...), exit the
*     program and investigate the problem
*   - spaces are also considered as legal characters for the extension,
*     do not use however leading spaces in the extension
*
**********}

{$r+} {$c+}

CONST
  crlf = #13#10 ;

TYPE
  ext_str = STRING[3] ;

CONST
  turbo_file_name = 'TURBO.COM' ;
  turbo_record = 88 ; { address $2DXX when loaded in tpa }
      { 2.0 ==> record 86 , addr 2cxx }
TYPE
  turbo_image_rec = RECORD
    dummy_1 : array[0..$2a] of BYTE ;                      {2.0 ==> 0..$4b}
    char_1  : CHAR ; { address $2d2b when loaded in tpa }  {2.0 ==> 2c4c}
    dummy_2 : BYTE ;
    char_2,          { address $2d2d when loaded in tpa }  {2.0 ==> 2c4e}
    char_3  : CHAR ; { address $2d2e when loaded in tpa }  {2.0 ==> 2c4f}
    dummy_4 : array[$2f..$7f] of BYTE ;                    {2.0 ==> $50..$7f}
  END ;

VAR
  turbo_file : FILE ;
  turbo_image : turbo_image_rec ;

FUNCTION fetch_extension : ext_str ;

BEGIN
  ASSIGN(turbo_file, turbo_file_name ) ;
  RESET(turbo_file ) ;
  SEEK(turbo_file, turbo_record ) ;
  BLOCKREAD(turbo_file, turbo_image, 1 ) ;
  WITH turbo_image DO
    fetch_extension := char_1 + char_2 + char_3 ;
  CLOSE(turbo_file ) ;
END ;

PROCEDURE update_extension(ext : ext_str ) ;

BEGIN
  ASSIGN(turbo_file, turbo_file_name ) ;
  RESET(turbo_file ) ;
  SEEK(turbo_file, turbo_record ) ;
  WITH turbo_image DO BEGIN
    char_1 := UPCASE(ext[1] ) ;
    char_2 := UPCASE(ext[2] ) ;
    char_3 := UPCASE(ext[3] ) ;
  END ;
  BLOCKWRITE(turbo_file, turbo_image, 1 ) ;
  CLOSE(turbo_file ) ;
END ;

VAR
  extension : ext_str ;
  done : BOOLEAN ;

BEGIN {main}
  WRITELN(crlf, crlf, '*** MODIFY TURBO DEFAULT EXTENSION ***', crlf,
                crlf, '[ FOR TURBO 3.0 CPM VERSION ONLY ] ') ;
  done := FALSE ;
  REPEAT
    extension := fetch_extension ;
    WRITE(crlf, 'CURRENT EXTENSION = ', extension, crlf, crlf,
          'ENTER EXACTLY 3 CHARACTERS TO CHANGE', crlf,
          'OR PRESS CR KEY TO EXIT', crlf,
          '      ==> ' ) ;
    BUFLEN := 3 ;
    READLN(extension ) ;
    CASE length(extension) OF
      0 :
        done := TRUE ;
      3 :
        update_extension(extension ) ;
      ELSE
        WRITELN(crlf, '### WRONG LENGTH' ) ;
    END ;
  UNTIL done ;
END .
