(*

   MDLTEST

   Een demonstratie-programma van
   de Pascal-bibliotheek MDL-LIB v2.0

   - COPYRIGHT 1990 BY MDL-SOFT -

   Dit programma is GEEN public-
   domain! De versie 1.0 van MDL-LIB
   en toebehoren is wel public-
   domain.

*)


{$C-}
Program MDL_test;

Type
  {$I MDLLIB.TYP}
  {$I SOUNDS.TYP}
  {$I GRAPMSX1.TYP}

Const
  {$I LOGOROUT.CON}
  on  = true;
  off = false; { voor procedures Key en Screen }
  fnaam:array[1..11] of char = 'MDLTEST 000'; { voor SearchFirst }

Var
  {$I MDLLIB.VAR}
  {$I VRAM1.VAR}
  {$I LOGOROUT.VAR}
  {$I DISKTOOL.VAR}
  keuze,i : byte;
  stop    : boolean;
  bestand : text;
  fcb     : array[0..36] of char;  {    voor     }
  info    : array[0..31] of char;  { SearchFirst }


{$I MDLLIB.LIB}    (* de header: moet altijd als eerste *)
{$I SOUNDS.LIB}    (* wat geluiden-routines             *)
{$I VRAM1.LIB}     (* VRAM-routines voor MSX-1          *)
{$I GRAPMSX1.LIB}  (* grafische routines voor MSX-1     *)
{$I LOGOROUT.LIB}  (* de LOGO-routines voor MSX-1 en -2 *)
{$I GAMEIO.LIB}    (* joystick, paddle, muis(MSX-2) etc *)
{$I DATA.LIB}      (* de VarSwap en Sort procedures     *)
{$I MISC.LIB}      (* van alles en nog wat              *)
{$I DISKTOOL.LIB}  (* wat diskette-procedures           *)


Procedure Vraag_om_schijf;

Var c : char;

Begin
  sys_width0:=40; ScrMode(0); Color(15,1,1); Beep;
  WriteLn('Het bestand MDLTEST.000 staat niet op');
  WriteLn('deze schijf!');
  WriteLn;
  WriteLn('Doe de goede schijf in de default drive');
  WriteLn('en druk op een toets, of druk op [ESC]');
  WriteLn('om terug te gaan naar DOS:');
  Read(kbd,c);
  If c=#27 then
    begin
      if msxversion>1 then ResetScreen else ClrScr;
      key(off); halt
    end
end;


{$I MDLINTRO.PAS}
  { Bevat MDLTEST introductie }


Overlay procedure Hoofdmenu(var keuze:byte);

Begin
  Color(15,1,1); ScrMode(2);
  FillBox(56,0, 200,17, 5);
  Box(56,0, 200,17, 15);
  Box(58,2, 198,15, 15);
  Gwrite(65,5,'Demoprogramma MDL-LIB');
  Color(10,1,1); Gotoxy(3,6);
  Write('MDL-LIB v2.0 / (C) 1990 by MDL-soft');
  FillBox(48,58,208,157,6);
  Box(48,58,208,157,15);
  Box(50,60,206,155,15);
  Color(10,1,1);
  Gwrite(58, 68,'1. INTRODUCTIE');
  Gwrite(58, 82,'2. MSX-1 GRAFISCHE TEST');
  Gwrite(58, 96,'3. MSX-2 GRAFISCHE TEST');
  Gwrite(58,110,'4. DIVERSEN');
  Gwrite(58,124,'5. PRINT DE HANDLEIDING');
  Gwrite(58,138,'6. STOP HET PROGRAMMA');
  Color(7,1,1);
  Gotoxy(3,22); Write('Uw keuze a.u.b.:');
  keuze:=0; {$I-}
  While (keuze<1) or (keuze>6) do
    Begin
      Color(2,1,1); FillBox(114,168,255,176,1); { wis }
      Gotoxy(20,22); Read(keuze);
      If IoResult<>0 then keuze:=0
    End; {$I+}
  FillBox(0,168,255,176,1); { wis }
  Color(9,1,1);
  Write(#13'  Even wachten a.u.b.');
End;


(*** De MSX-1 grafische test ***)

{$I GRAP1.PAS}


(*** Het enorme MSX-2 grafische testprogramma! ***)

Overlay procedure Graphic_Test_2;

Type
  {$I GRAPMSX2.TYP}

Const
  {$I LOGOROUT.CON}

{$I VRAM2.LIB}     { Deze library-procedures gelden }
{$I GRAPMSX2.LIB}  { alleen BINNEN Graphic_Test_2 ! }
{$I LOGOROUT.LIB}
 { LOGOROUT moet hier nog eens geincludeerd worden, omdat degene
   uit het hoofdprogramma met VRAM1 samenwerkt, die op de MSX2
   schermen niet werkt. Daarom moet hij hier nog eens gecompileerd
   worden, samen met VRAM2. }

{$I GRAPTST1.PAS}  { Bevatten procedure }
{$I GRAPTST2.PAS}  { Graphic_Test_2     }
{ einde procedure in GRAPTST2.PAS aangegeven }


(*** De diversen-testjes ***)

Overlay procedure Diversen;
  {$I DIVERSEN.PAS}
{ einde procedure in DIVERSEN.PAS aangegeven }


(*** De handleiding-printer ***)

{$I PRTHANDL.PAS}


(*** Hoofdprogramma ***)
Begin
  Write(#27'x5'); { cursor uit op tekstscherm }
  fcb[0]:=chr(0); { default drive in FCB }
  for i:=1 to 11 do fcb[i]:=fnaam[i];
    { vul het FCB voor SearchFirst }
  for i:=12 to 36 do fcb[i]:=#0;
  While SearchFirst(fcb,info)=false do { overlayfile niet gevonden? }
    Vraag_om_schijf;
  Introductie;
  stop:=false;
  While stop=false do
    Begin
      While SearchFirst(fcb,info)=false do { overlayfile niet gevonden? }
        Vraag_om_schijf;
      Hoofdmenu(keuze);
      While SearchFirst(fcb,info)=false do { overlayfile niet gevonden? }
        Vraag_om_schijf;
      Case keuze of
        1: introductie;
        2: graphic_test_1;
        3: graphic_test_2;
        4: diversen;
        5: print_de_handleiding;
        6: stop:=true;
      end
    end;
  { herstel standaard-scherm... }
  if MSXversion=1 then
    begin
      sys_width0:=40; ScrMode(0); Color(15,4,4)
    end
  else ResetScreen; { op MSX-2 de SET SCREEN instelling gebruiken }
  ClrScr; Key(off)
End.
