		.title coptap
; Copy Tape
;
; Prog:	COPTAP
;
; Date:	6 oktober 2001
;
; cmnt:	V1.1 HJC 2001 (V1.0 1985)
;
.nolist

.list

	.org $D000 - 7

	.db $fe
	.dw startProgram,endProgram,startProgram

					; flags
display	.equ	$d1f9		; flag 0 if no display of read bytes
header	.equ	$d1fb		; short header if 0

					; primary slot register	for ROM/RAM
rombnk	.equ	$d1fa		; rom/ram slot register	(Basic)
rambnk	.equ	$d1ff	  	; 64K RAM

status	.equ	$d1fe	    	; return status to calling program

memo		.equ	$d1fc		; nr of bytes read (word)

hbuf		.equ	$d200		; header buffer

slot		.equ	$a8		; primary slotregister switch i/o port

buffer	.equ	$0000		; buffer 32K in lower ram
buffert	.equ	$7FFF		; last location in buffer


					; read block from tape
					; end of block is not detected, user must press control-stop
startProgram
readtp	di			; dont want interrupts
		ld de,buffer	; store tape contents in lower ram starting at 0
		exx
		call tapion		; tape input on
		exx
		jr c, error1	; return error 0 = control-stop	pressed
loop		exx			; while not control-stop pressed
		call gettp		;   get char from tape
		exx
		jr c, error0	;   return error 0 = control-stop pressed
	      push af
	      ld a,(rambnk)	;
	      out (slot),a	;   map in ram
	      pop af
	      ld (de),a		;   store byte in ram
	      push af
	      ld a,(rombnk)
	      out (slot),a	;   restore rom mapping
	      pop af
	      ld hl, buffert	;   max ram size
	      sbc hl, de		;   is buffer full?
	      jr z, error2	;   return error 2 = buffer full
		inc de		;   next position in buffer
		jr loop		; end while

error2	ld a,$02
		jr errort
error1	ld a, $01
		jr errort
error0	ld a, $00
errort	ld (status),a	; store	status for calling program
		ld a,(rambnk)	; switch page 0	and 1 to ram
		out (slot),a	;
		ld (memo),de
		ld de, hbuf		; move header bytes to buffer
		ld hl, buffer
		ld bc, $0020
		ldir
		ld a,(rombnk)	; restore basic rom/ram layout
		out (slot),a
		call tapiof		; stop tape
		ei
		ret

					; write block to tape

writetp	ld de,$0000
		ld a, (header)
		exx
		call tapoon
		di
		exx
		jr c, error1	; if error return error	1
loopw		push af
		ld a,(rambnk)	; memory
		out (slot),a	; set ram
		pop af
		ld a,(de)		; get byte from ram buffer
		push af
		ld a,(rombnk)	; restore rom layout
		out (slot),a
		pop af
		exx
		call tapout		; write byte to tape
		di
		exx
		jr c, error1	; if control-stop return error 1
		ld hl,(memo)	; keep writing until finished
		sbc hl,de
		jr z, error0	; return error 0 if finished
		inc de
		jr loopw
		ret nz

		; subroutine get char form tape and show on screen

gettp	call tapin			; get char from tape
		jr c, nodisp	; control-stop, so dont bother to display
		push af
		ld a,(display)
		cp 0
		jr z, nodisp
		ld a,$94		; set vdp for write
		out ($99),a
		ld a,$43		; location
		out ($99),a		; vram
		pop af		;
		out ($98),a		; show char
nodisp	ret

endProgram

.end
